/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.oauth.OAuthAccessTokenHolder;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.oauth.AbstractAuthorizationUI;
import org.openstreetmap.josm.gui.oauth.AuthorizationProcedure;
import org.openstreetmap.josm.gui.oauth.AuthorizationProcedureComboBox;
import org.openstreetmap.josm.gui.oauth.FullyAutomaticAuthorizationUI;
import org.openstreetmap.josm.gui.oauth.ManualAuthorizationUI;
import org.openstreetmap.josm.gui.oauth.SemiAutomaticAuthorizationUI;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.UserCancelException;
import org.openstreetmap.josm.tools.Utils;

public class OAuthAuthorizationWizard
extends JDialog {
    private boolean canceled;
    private final String apiUrl;
    private final AuthorizationProcedureComboBox cbAuthorisationProcedure = new AuthorizationProcedureComboBox();
    private FullyAutomaticAuthorizationUI pnlFullyAutomaticAuthorisationUI;
    private SemiAutomaticAuthorizationUI pnlSemiAutomaticAuthorisationUI;
    private ManualAuthorizationUI pnlManualAuthorisationUI;
    private JScrollPane spAuthorisationProcedureUI;
    private final transient Executor executor;

    public void showDialog() throws UserCancelException {
        this.setVisible(true);
        if (this.isCanceled()) {
            throw new UserCancelException();
        }
        OAuthAccessTokenHolder holder = OAuthAccessTokenHolder.getInstance();
        holder.setAccessToken(this.getAccessToken());
        holder.setSaveToPreferences(this.isSaveAccessTokenToPreferences());
    }

    protected JPanel buildButtonRow() {
        JPanel pnl = new JPanel(new FlowLayout(1));
        AcceptAccessTokenAction actAcceptAccessToken = new AcceptAccessTokenAction();
        this.pnlFullyAutomaticAuthorisationUI.addPropertyChangeListener(actAcceptAccessToken);
        this.pnlSemiAutomaticAuthorisationUI.addPropertyChangeListener(actAcceptAccessToken);
        this.pnlManualAuthorisationUI.addPropertyChangeListener(actAcceptAccessToken);
        pnl.add(new JButton(actAcceptAccessToken));
        pnl.add(new JButton(new CancelAction()));
        pnl.add(new JButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/OAuthAuthorisationWizard"))));
        return pnl;
    }

    protected JPanel buildHeaderInfoPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.gridwidth = 2;
        ImageProvider logoProv = new ImageProvider("oauth", "oauth-logo").setMaxHeight(100);
        JLabel lbl = new JLabel(logoProv.get());
        lbl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        lbl.setOpaque(true);
        pnl.add((Component)lbl, gc);
        gc.gridy = 1;
        gc.insets = new Insets(5, 0, 0, 5);
        HtmlPanel pnlMessage = new HtmlPanel();
        pnlMessage.setText("<html><body>" + I18n.tr("With OAuth you grant JOSM the right to upload map data and GPS tracks on your behalf (<a href=\"{0}\">more info...</a>).", "http://oauth.net/") + "</body></html>");
        pnlMessage.getEditorPane().addHyperlinkListener(new ExternalBrowserLauncher());
        pnl.add((Component)pnlMessage, gc);
        gc.gridy = 2;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        lbl = new JLabel(I18n.tr("Please select an authorization procedure: ", new Object[0]));
        lbl.setFont(lbl.getFont().deriveFont(0));
        pnl.add((Component)lbl, gc);
        gc.gridx = 1;
        gc.gridwidth = 1;
        gc.weightx = 1.0;
        pnl.add((Component)this.cbAuthorisationProcedure, gc);
        this.cbAuthorisationProcedure.addItemListener(new AuthorisationProcedureChangeListener());
        lbl.setLabelFor(this.cbAuthorisationProcedure);
        if (!"https://api.openstreetmap.org/api".equals(this.apiUrl)) {
            gc.gridy = 3;
            gc.gridwidth = 2;
            gc.gridx = 0;
            HtmlPanel pnlWarning = new HtmlPanel();
            HTMLEditorKit kit = (HTMLEditorKit)pnlWarning.getEditorPane().getEditorKit();
            kit.getStyleSheet().addRule(".warning-body {background-color:rgb(253,255,221);padding: 10pt; border-color:rgb(128,128,128);border-style: solid;border-width: 1px;}");
            kit.getStyleSheet().addRule("ol {margin-left: 1cm}");
            pnlWarning.setText("<html><body><p class=\"warning-body\">" + I18n.tr("<strong>Warning:</strong> Since you are using not the default OSM API, make sure to set an OAuth consumer key and secret in the <i>Advanced OAuth parameters</i>.", new Object[0]) + "</p></body></html>");
            pnl.add((Component)pnlWarning, gc);
        }
        return pnl;
    }

    protected void refreshAuthorisationProcedurePanel() {
        AuthorizationProcedure procedure = (AuthorizationProcedure)((Object)this.cbAuthorisationProcedure.getSelectedItem());
        switch (procedure) {
            case FULLY_AUTOMATIC: {
                this.spAuthorisationProcedureUI.getViewport().setView(this.pnlFullyAutomaticAuthorisationUI);
                this.pnlFullyAutomaticAuthorisationUI.revalidate();
                break;
            }
            case SEMI_AUTOMATIC: {
                this.spAuthorisationProcedureUI.getViewport().setView(this.pnlSemiAutomaticAuthorisationUI);
                this.pnlSemiAutomaticAuthorisationUI.revalidate();
                break;
            }
            case MANUALLY: {
                this.spAuthorisationProcedureUI.getViewport().setView(this.pnlManualAuthorisationUI);
                this.pnlManualAuthorisationUI.revalidate();
            }
        }
        this.validate();
        this.repaint();
    }

    protected final void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buildHeaderInfoPanel(), "North");
        this.setTitle(I18n.tr("Get an Access Token for ''{0}''", this.apiUrl));
        this.setMinimumSize(new Dimension(600, 420));
        this.pnlFullyAutomaticAuthorisationUI = new FullyAutomaticAuthorizationUI(this.apiUrl, this.executor);
        this.pnlSemiAutomaticAuthorisationUI = new SemiAutomaticAuthorizationUI(this.apiUrl, this.executor);
        this.pnlManualAuthorisationUI = new ManualAuthorizationUI(this.apiUrl, this.executor);
        this.spAuthorisationProcedureUI = GuiHelper.embedInVerticalScrollPane(new JPanel());
        this.spAuthorisationProcedureUI.getVerticalScrollBar().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                OAuthAuthorizationWizard.this.spAuthorisationProcedureUI.setBorder(UIManager.getBorder("ScrollPane.border"));
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                OAuthAuthorizationWizard.this.spAuthorisationProcedureUI.setBorder(null);
            }
        });
        this.getContentPane().add((Component)this.spAuthorisationProcedureUI, "Center");
        this.getContentPane().add((Component)this.buildButtonRow(), "South");
        this.addWindowListener(new WindowEventHandler());
        InputMapUtils.addEscapeAction(this.getRootPane(), new CancelAction());
        this.refreshAuthorisationProcedurePanel();
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Dialog/OAuthAuthorisationWizard"));
    }

    public OAuthAuthorizationWizard(Component parent, String apiUrl, Executor executor) {
        super((Window)GuiHelper.getFrameForComponent(parent), Dialog.ModalityType.DOCUMENT_MODAL);
        CheckParameterUtil.ensureParameterNotNull(apiUrl, "apiUrl");
        this.apiUrl = apiUrl;
        this.executor = executor;
        this.build();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected AbstractAuthorizationUI getCurrentAuthorisationUI() {
        switch ((AuthorizationProcedure)((Object)this.cbAuthorisationProcedure.getSelectedItem())) {
            case FULLY_AUTOMATIC: {
                return this.pnlFullyAutomaticAuthorisationUI;
            }
            case MANUALLY: {
                return this.pnlManualAuthorisationUI;
            }
            case SEMI_AUTOMATIC: {
                return this.pnlSemiAutomaticAuthorisationUI;
            }
        }
        return null;
    }

    public OAuthToken getAccessToken() {
        return this.getCurrentAuthorisationUI().getAccessToken();
    }

    public OAuthParameters getOAuthParameters() {
        return this.getCurrentAuthorisationUI().getOAuthParameters();
    }

    public boolean isSaveAccessTokenToPreferences() {
        return this.getCurrentAuthorisationUI().isSaveAccessTokenToPreferences();
    }

    public void initFromPreferences() {
        Preferences copyPref = new Preferences(Main.pref);
        copyPref.put("osm-server.url", this.apiUrl);
        this.pnlFullyAutomaticAuthorisationUI.initFromPreferences(copyPref);
        this.pnlSemiAutomaticAuthorisationUI.initFromPreferences(copyPref);
        this.pnlManualAuthorisationUI.initFromPreferences(copyPref);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(450, 540))).applySafe(this);
            this.initFromPreferences();
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public static void obtainAccessToken(URL serverUrl) throws InvocationTargetException, InterruptedException {
        FutureTask<OAuthAuthorizationWizard> authTask = new FutureTask<OAuthAuthorizationWizard>(() -> {
            OAuthAuthorizationWizard wizard = new OAuthAuthorizationWizard(Main.parent, serverUrl.toExternalForm(), Utils.newDirectExecutor());
            wizard.showDialog();
            return wizard;
        });
        if (SwingUtilities.isEventDispatchThread()) {
            authTask.run();
        } else {
            SwingUtilities.invokeAndWait(authTask);
        }
    }

    static class ExternalBrowserLauncher
    implements HyperlinkListener {
        ExternalBrowserLauncher() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                OpenBrowser.displayUrl(e.getDescription());
            }
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            new CancelAction().cancel();
        }
    }

    class AcceptAccessTokenAction
    extends AbstractAction
    implements PropertyChangeListener {
        AcceptAccessTokenAction() {
            this.putValue("Name", I18n.tr("Accept Access Token", new Object[0]));
            new ImageProvider("ok").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Close the dialog and accept the Access Token", new Object[0]));
            this.updateEnabledState(null);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            OAuthAuthorizationWizard.this.setCanceled(false);
            OAuthAuthorizationWizard.this.setVisible(false);
        }

        public final void updateEnabledState(OAuthToken token) {
            this.setEnabled(token != null);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals(AbstractAuthorizationUI.ACCESS_TOKEN_PROP)) {
                return;
            }
            this.updateEnabledState((OAuthToken)evt.getNewValue());
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            new ImageProvider("cancel").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Close the dialog and cancel authorization", new Object[0]));
        }

        public void cancel() {
            OAuthAuthorizationWizard.this.setCanceled(true);
            OAuthAuthorizationWizard.this.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.cancel();
        }
    }

    class AuthorisationProcedureChangeListener
    implements ItemListener {
        AuthorisationProcedureChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            OAuthAuthorizationWizard.this.refreshAuthorisationProcedurePanel();
        }
    }
}

