/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.gui.MapScaler;
import org.openstreetmap.josm.gui.MapStatus;
import org.openstreetmap.josm.gui.conflict.ConflictColors;
import org.openstreetmap.josm.gui.dialogs.ConflictDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.gpx.GpxDrawHelper;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class ColorPreference
implements SubPreferenceSetting {
    private DefaultTableModel tableModel;
    private JTable colors;
    private final List<String> del = new ArrayList<String>();
    private JButton colorEdit;
    private JButton defaultSet;
    private JButton remove;

    public void setColorModel(Map<String, String> colorMap) {
        if (this.tableModel == null) {
            this.tableModel = new DefaultTableModel();
            this.tableModel.addColumn(I18n.tr("Name", new Object[0]));
            this.tableModel.addColumn(I18n.tr("Color", new Object[0]));
        }
        while (this.tableModel.getRowCount() > 0) {
            this.tableModel.removeRow(0);
        }
        TreeMap<String, String> colorKeyList = new TreeMap<String, String>();
        TreeMap<String, String> colorKeyListMappaint = new TreeMap<String, String>();
        TreeMap<String, String> colorKeyListLayer = new TreeMap<String, String>();
        for (String key : colorMap.keySet()) {
            if (key.startsWith("layer ")) {
                colorKeyListLayer.put(ColorPreference.getName(key), key);
                continue;
            }
            if (key.startsWith("mappaint.")) {
                colorKeyListMappaint.put(ColorPreference.getName(key) + key, key);
                continue;
            }
            colorKeyList.put(ColorPreference.getName(key), key);
        }
        this.addColorRows(colorMap, colorKeyList);
        this.addColorRows(colorMap, colorKeyListMappaint);
        this.addColorRows(colorMap, colorKeyListLayer);
        if (this.colors != null) {
            this.colors.repaint();
        }
    }

    private void addColorRows(Map<String, String> colorMap, Map<String, String> keyMap) {
        for (String value : keyMap.values()) {
            Vector<Object> row = new Vector<Object>(2);
            String html = colorMap.get(value);
            Color color = ColorHelper.html2color(html);
            if (color == null) {
                Logging.warn("Unable to get color from '" + html + "' for color preference '" + value + '\'');
            }
            row.add(value);
            row.add(color);
            this.tableModel.addRow(row);
        }
    }

    public Map<String, String> getColorModel() {
        HashMap<String, String> colorMap = new HashMap<String, String>();
        for (int row = 0; row < this.tableModel.getRowCount(); ++row) {
            String key = (String)this.tableModel.getValueAt(row, 0);
            String value = ColorHelper.color2html((Color)this.tableModel.getValueAt(row, 1));
            colorMap.put(key, value);
        }
        return colorMap;
    }

    private static String getName(String o) {
        return Main.pref.getColorName(o);
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        ColorPreference.fixColorPrefixes();
        this.setColorModel(Main.pref.getAllColors());
        this.colorEdit = new JButton(I18n.tr("Choose", new Object[0]));
        this.colorEdit.addActionListener(e -> {
            int sel = this.colors.getSelectedRow();
            JColorChooser chooser = new JColorChooser((Color)this.colors.getValueAt(sel, 1));
            int answer = JOptionPane.showConfirmDialog(gui, chooser, I18n.tr("Choose a color for {0}", ColorPreference.getName((String)this.colors.getValueAt(sel, 0))), 2, -1);
            if (answer == 0) {
                this.colors.setValueAt(chooser.getColor(), sel, 1);
            }
        });
        this.defaultSet = new JButton(I18n.tr("Set to default", new Object[0]));
        this.defaultSet.addActionListener(e -> {
            int sel = this.colors.getSelectedRow();
            String name = (String)this.colors.getValueAt(sel, 0);
            Color c = Main.pref.getDefaultColor(name);
            if (c != null) {
                this.colors.setValueAt(c, sel, 1);
            }
        });
        JButton defaultAll = new JButton(I18n.tr("Set all to default", new Object[0]));
        defaultAll.addActionListener(e -> {
            for (int i = 0; i < this.colors.getRowCount(); ++i) {
                String name = (String)this.colors.getValueAt(i, 0);
                Color c = Main.pref.getDefaultColor(name);
                if (c == null) continue;
                this.colors.setValueAt(c, i, 1);
            }
        });
        this.remove = new JButton(I18n.tr("Remove", new Object[0]));
        this.remove.addActionListener(e -> {
            int sel = this.colors.getSelectedRow();
            this.del.add((String)this.colors.getValueAt(sel, 0));
            this.tableModel.removeRow(sel);
        });
        this.remove.setEnabled(false);
        this.colorEdit.setEnabled(false);
        this.defaultSet.setEnabled(false);
        this.colors = new JTable(this.tableModel){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                int sel = this.getSelectedRow();
                ColorPreference.this.remove.setEnabled(sel >= 0 && ColorPreference.this.isRemoveColor(sel) != false);
                ColorPreference.this.colorEdit.setEnabled(sel >= 0);
                ColorPreference.this.defaultSet.setEnabled(sel >= 0);
            }
        };
        this.colors.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    ColorPreference.this.colorEdit.doClick();
                }
            }
        });
        this.colors.setSelectionMode(0);
        TableCellRenderer oldColorsRenderer = this.colors.getDefaultRenderer(Object.class);
        this.colors.setDefaultRenderer(Object.class, (t, o, selected, focus, row, column) -> {
            if (o == null) {
                return new JLabel();
            }
            if (column == 1) {
                Color c = (Color)o;
                JLabel l = new JLabel(ColorHelper.color2html(c));
                GuiHelper.setBackgroundReadable(l, c);
                l.setOpaque(true);
                return l;
            }
            return oldColorsRenderer.getTableCellRendererComponent(t, ColorPreference.getName(o.toString()), selected, focus, row, column);
        });
        this.colors.getColumnModel().getColumn(1).setWidth(100);
        this.colors.setToolTipText(I18n.tr("Colors used by different objects in JOSM.", new Object[0]));
        this.colors.setPreferredScrollableViewportSize(new Dimension(100, 112));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane scrollpane = new JScrollPane(this.colors);
        scrollpane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        panel.add((Component)scrollpane, GBC.eol().fill(1));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        panel.add((Component)buttonPanel, GBC.eol().insets(5, 0, 5, 5).fill(2));
        buttonPanel.add(Box.createHorizontalGlue(), GBC.std().fill(2));
        buttonPanel.add((Component)this.colorEdit, GBC.std().insets(0, 5, 0, 0));
        buttonPanel.add((Component)this.defaultSet, GBC.std().insets(5, 5, 5, 0));
        buttonPanel.add((Component)defaultAll, GBC.std().insets(0, 5, 0, 0));
        buttonPanel.add((Component)this.remove, GBC.std().insets(0, 5, 0, 0));
        gui.getDisplayPreference().addSubTab(this, I18n.tr("Colors", new Object[0]), panel);
    }

    Boolean isRemoveColor(int row) {
        return ((String)this.colors.getValueAt(row, 0)).startsWith("layer ");
    }

    private static void fixColorPrefixes() {
        PaintColors.values();
        ConflictColors.getColors();
        Severity.getColors();
        MarkerLayer.getGenericColor();
        GpxDrawHelper.getGenericColor();
        OsmDataLayer.getOutsideColor();
        MapScaler.getColor();
        MapStatus.getColors();
        ConflictDialog.getColor();
    }

    @Override
    public boolean ok() {
        boolean ret = false;
        for (String d : this.del) {
            Config.getPref().put("color." + d, null);
        }
        for (int i = 0; i < this.colors.getRowCount(); ++i) {
            String key = (String)this.colors.getValueAt(i, 0);
            if (!Main.pref.putColor(key, (Color)this.colors.getValueAt(i, 1)) || !key.startsWith("mappaint.")) continue;
            ret = true;
        }
        OsmDataLayer.createHatchTexture();
        return ret;
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane gui) {
        return gui.getDisplayPreference();
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new ColorPreference();
        }
    }
}

