/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.bbox.SlippyMapBBoxChooser;
import org.openstreetmap.josm.gui.preferences.imagery.AddImageryPanel;
import org.openstreetmap.josm.gui.preferences.imagery.WMSLayerTree;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.io.imagery.WMSImagery;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class AddWMSLayerPanel
extends AddImageryPanel {
    private final transient WMSImagery wms = new WMSImagery();
    private final JCheckBox endpoint = new JCheckBox(I18n.tr("Store WMS endpoint only, select layers at usage", new Object[0]));
    private final transient WMSLayerTree tree = new WMSLayerTree();
    private final JComboBox<String> formats = new JComboBox();
    private final JLabel wmsInstruction;
    private final JosmTextArea wmsUrl = new JosmTextArea(3, 40).transferFocusOnTab();
    private final JButton showBounds = new JButton(I18n.tr("Show bounds", new Object[0]));

    public AddWMSLayerPanel() {
        this.add((Component)new JLabel(I18n.tr("1. Enter service URL", new Object[0])), GBC.eol());
        this.add((Component)this.rawUrl, GBC.eol().fill());
        this.rawUrl.setLineWrap(true);
        JButton getLayers = new JButton(I18n.tr("Get layers", new Object[0]));
        this.add((Component)getLayers, GBC.eop().fill());
        this.add((Component)new JLabel(I18n.tr("2. Select layers", new Object[0])), GBC.eol());
        this.add((Component)this.endpoint, GBC.eol().fill());
        this.add((Component)new JScrollPane(this.tree.getLayerTree()), GBC.eol().fill().weight(1.0, 100.0));
        this.showBounds.setEnabled(false);
        this.add((Component)this.showBounds, GBC.eop().fill());
        this.add((Component)new JLabel(I18n.tr("3. Select image format", new Object[0])), GBC.eol());
        this.add(this.formats, GBC.eol().fill());
        this.wmsInstruction = new JLabel(I18n.tr("4. Verify generated WMS URL", new Object[0]));
        this.add((Component)this.wmsInstruction, GBC.eol());
        this.wmsInstruction.setLabelFor(this.wmsUrl);
        this.add((Component)this.wmsUrl, GBC.eop().fill());
        this.wmsUrl.setLineWrap(true);
        this.add((Component)new JLabel(I18n.tr("5. Enter name for this layer", new Object[0])), GBC.eol());
        this.add((Component)this.name, GBC.eop().fill());
        getLayers.addActionListener(e -> {
            try {
                this.wms.attemptGetCapabilities(this.rawUrl.getText());
                this.tree.updateTree(this.wms);
                List<String> wmsFormats = this.wms.getFormats();
                this.formats.setModel(new DefaultComboBoxModel<String>(wmsFormats.toArray(new String[wmsFormats.size()])));
                this.formats.setSelectedItem(this.wms.getPreferredFormats());
            }
            catch (MalformedURLException ex1) {
                Logging.log(Logging.LEVEL_ERROR, ex1);
                JOptionPane.showMessageDialog(this.getParent(), I18n.tr("Invalid service URL.", new Object[0]), I18n.tr("WMS Error", new Object[0]), 0);
            }
            catch (IOException ex2) {
                Logging.log(Logging.LEVEL_ERROR, ex2);
                JOptionPane.showMessageDialog(this.getParent(), I18n.tr("Could not retrieve WMS layer list.", new Object[0]), I18n.tr("WMS Error", new Object[0]), 0);
            }
            catch (WMSImagery.WMSGetCapabilitiesException ex3) {
                String incomingData = ex3.getIncomingData().trim();
                String title = I18n.tr("WMS Error", new Object[0]);
                StringBuilder message = new StringBuilder(I18n.tr("Could not parse WMS layer list.", new Object[0]));
                Logging.log(Logging.LEVEL_ERROR, "Could not parse WMS layer list. Incoming data:\n" + incomingData, ex3);
                if ((incomingData.startsWith("<html>") || incomingData.startsWith("<HTML>")) && (incomingData.endsWith("</html>") || incomingData.endsWith("</HTML>"))) {
                    GuiHelper.notifyUserHtmlError(this, title, message.toString(), incomingData);
                }
                if (ex3.getMessage() != null) {
                    message.append('\n').append(ex3.getMessage());
                }
                JOptionPane.showMessageDialog(this.getParent(), message.toString(), title, 0);
            }
        });
        this.endpoint.addItemListener(e -> {
            this.tree.getLayerTree().setEnabled(!this.endpoint.isSelected());
            this.showBounds.setEnabled(!this.endpoint.isSelected());
            this.wmsInstruction.setEnabled(!this.endpoint.isSelected());
            this.formats.setEnabled(!this.endpoint.isSelected());
            this.wmsUrl.setEnabled(!this.endpoint.isSelected());
            if (this.endpoint.isSelected()) {
                URL url = this.wms.getServiceUrl();
                if (url != null) {
                    this.name.setText(url.getHost());
                }
            } else {
                this.onLayerSelectionChanged();
            }
        });
        this.tree.getLayerTree().addPropertyChangeListener("selectedLayers", evt -> this.onLayerSelectionChanged());
        this.formats.addActionListener(e -> this.onLayerSelectionChanged());
        this.showBounds.addActionListener(e -> {
            if (this.tree.getSelectedLayers().get((int)0).bounds != null) {
                SlippyMapBBoxChooser mapPanel = new SlippyMapBBoxChooser();
                mapPanel.setBoundingBox(this.tree.getSelectedLayers().get((int)0).bounds);
                JOptionPane.showMessageDialog(null, mapPanel, I18n.tr("Show Bounds", new Object[0]), -1);
            } else {
                JOptionPane.showMessageDialog(null, I18n.tr("No bounding box was found for this layer.", new Object[0]), I18n.tr("WMS Error", new Object[0]), 0);
            }
        });
        this.registerValidableComponent(this.endpoint);
        this.registerValidableComponent(this.rawUrl);
        this.registerValidableComponent(this.wmsUrl);
    }

    protected final void onLayerSelectionChanged() {
        if (this.wms.getServiceUrl() != null) {
            this.wmsUrl.setText(this.wms.buildGetMapUrl(this.tree.getSelectedLayers(), (String)this.formats.getSelectedItem()));
            this.name.setText(this.wms.getServiceUrl().getHost() + ": " + Utils.join(", ", this.tree.getSelectedLayers()));
        }
        this.showBounds.setEnabled(this.tree.getSelectedLayers().size() == 1);
    }

    @Override
    public ImageryInfo getImageryInfo() {
        ImageryInfo info;
        if (this.endpoint.isSelected()) {
            info = new ImageryInfo(this.getImageryName(), this.getImageryRawUrl());
            info.setImageryType(ImageryInfo.ImageryType.WMS_ENDPOINT);
        } else {
            info = this.wms.toImageryInfo(this.getImageryName(), this.tree.getSelectedLayers());
            info.setUrl(this.getWmsUrl());
            info.setImageryType(ImageryInfo.ImageryType.WMS);
        }
        return info;
    }

    protected final String getWmsUrl() {
        return AddWMSLayerPanel.sanitize(this.wmsUrl.getText(), ImageryInfo.ImageryType.WMS);
    }

    @Override
    protected boolean isImageryValid() {
        if (this.getImageryName().isEmpty()) {
            return false;
        }
        if (this.endpoint.isSelected()) {
            return !this.getImageryRawUrl().isEmpty();
        }
        return !this.getWmsUrl().isEmpty();
    }
}

