/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.oauth.OAuthAccessTokenHolder;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.oauth.AdvancedOAuthPropertiesPanel;
import org.openstreetmap.josm.gui.oauth.OAuthAuthorizationWizard;
import org.openstreetmap.josm.gui.oauth.TestAccessTokenTask;
import org.openstreetmap.josm.gui.preferences.server.OsmApiUrlInputPanel;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UserCancelException;

public class OAuthAuthenticationPreferencesPanel
extends JPanel
implements PropertyChangeListener {
    private final JCheckBox cbShowAdvancedParameters = new JCheckBox();
    private final JCheckBox cbSaveToPreferences = new JCheckBox(I18n.tr("Save to preferences", new Object[0]));
    private final JPanel pnlAuthorisationMessage = new JPanel(new BorderLayout());
    private final NotYetAuthorisedPanel pnlNotYetAuthorised = new NotYetAuthorisedPanel();
    private final AdvancedOAuthPropertiesPanel pnlAdvancedProperties = new AdvancedOAuthPropertiesPanel();
    private final AlreadyAuthorisedPanel pnlAlreadyAuthorised = new AlreadyAuthorisedPanel();
    private String apiUrl;

    public OAuthAuthenticationPreferencesPanel() {
        this.build();
        this.refreshView();
    }

    protected JPanel buildAdvancedPropertiesPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 0, 3);
        pnl.add((Component)this.cbShowAdvancedParameters, gc);
        this.cbShowAdvancedParameters.setSelected(false);
        this.cbShowAdvancedParameters.addItemListener(evt -> this.pnlAdvancedProperties.setVisible(evt.getStateChange() == 1));
        gc.gridx = 1;
        gc.weightx = 1.0;
        JMultilineLabel lbl = new JMultilineLabel(I18n.tr("Display Advanced OAuth Parameters", new Object[0]));
        lbl.setFont(lbl.getFont().deriveFont(0));
        pnl.add((Component)lbl, gc);
        gc.gridy = 1;
        gc.gridx = 1;
        gc.insets = new Insets(3, 0, 3, 0);
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        pnl.add((Component)this.pnlAdvancedProperties, gc);
        this.pnlAdvancedProperties.initFromPreferences(Main.pref);
        this.pnlAdvancedProperties.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.pnlAdvancedProperties.setVisible(false);
        return pnl;
    }

    protected final void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 1;
        gc.anchor = 18;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        gc.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.pnlAuthorisationMessage, gc);
    }

    protected void refreshView() {
        this.pnlAuthorisationMessage.removeAll();
        if (OAuthAccessTokenHolder.getInstance().containsAccessToken()) {
            this.pnlAuthorisationMessage.add((Component)this.pnlAlreadyAuthorised, "Center");
            this.pnlAlreadyAuthorised.refreshView();
            this.pnlAlreadyAuthorised.revalidate();
        } else {
            this.pnlAuthorisationMessage.add((Component)this.pnlNotYetAuthorised, "Center");
            this.pnlNotYetAuthorised.revalidate();
        }
        this.repaint();
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
        this.pnlAdvancedProperties.setApiUrl(apiUrl);
    }

    public void initFromPreferences() {
        this.setApiUrl(OsmApi.getOsmApi().getServerUrl().trim());
        this.refreshView();
    }

    public void saveToPreferences() {
        OAuthAccessTokenHolder.getInstance().setSaveToPreferences(this.cbSaveToPreferences.isSelected());
        OAuthAccessTokenHolder.getInstance().save(Main.pref, CredentialsManager.getInstance());
        this.pnlAdvancedProperties.rememberPreferences(Main.pref);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals(OsmApiUrlInputPanel.API_URL_PROP)) {
            return;
        }
        this.setApiUrl((String)evt.getNewValue());
    }

    private class TestAuthorisationAction
    extends AbstractAction {
        TestAuthorisationAction() {
            this.putValue("Name", I18n.tr("Test Access Token", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Click test access to the OSM server with the current access token", new Object[0]));
            new ImageProvider("oauth", "oauth-small").getResource().attachImageIcon(this);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            OAuthToken token = OAuthAccessTokenHolder.getInstance().getAccessToken();
            OAuthParameters parameters = OAuthParameters.createFromPreferences(Main.pref);
            TestAccessTokenTask task = new TestAccessTokenTask(OAuthAuthenticationPreferencesPanel.this, OAuthAuthenticationPreferencesPanel.this.apiUrl, parameters, token);
            MainApplication.worker.submit(task);
        }
    }

    private class RenewAuthorisationAction
    extends AuthoriseNowAction {
        RenewAuthorisationAction() {
            this.putValue("Name", I18n.tr("New Access Token", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Click to step through the OAuth authorization process and generate a new Access Token", new Object[0]));
            new ImageProvider("oauth", "oauth-small").getResource().attachImageIcon(this);
        }
    }

    private class AuthoriseNowAction
    extends AbstractAction {
        AuthoriseNowAction() {
            this.putValue("Name", I18n.tr("Authorize now", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Click to step through the OAuth authorization process", new Object[0]));
            new ImageProvider("oauth", "oauth-small").getResource().attachImageIcon(this);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            OAuthAuthorizationWizard wizard = new OAuthAuthorizationWizard(OAuthAuthenticationPreferencesPanel.this, OAuthAuthenticationPreferencesPanel.this.apiUrl, MainApplication.worker);
            try {
                wizard.showDialog();
            }
            catch (UserCancelException ignore) {
                Logging.trace(ignore);
                return;
            }
            OAuthAuthenticationPreferencesPanel.this.pnlAdvancedProperties.setAdvancedParameters(wizard.getOAuthParameters());
            OAuthAuthenticationPreferencesPanel.this.refreshView();
        }
    }

    private class AlreadyAuthorisedPanel
    extends JPanel {
        private final JosmTextField tfAccessTokenKey = new JosmTextField();
        private final JosmTextField tfAccessTokenSecret = new JosmTextField();

        AlreadyAuthorisedPanel() {
            this.build();
            this.refreshView();
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.insets = new Insets(0, 0, 3, 3);
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.gridwidth = 2;
            JMultilineLabel lbl = new JMultilineLabel(I18n.tr("You already have an Access Token to access the OSM server using OAuth.", new Object[0]));
            this.add((Component)lbl, gc);
            lbl.setFont(lbl.getFont().deriveFont(0));
            gc.gridy = 1;
            gc.gridx = 0;
            gc.gridwidth = 1;
            gc.weightx = 0.0;
            this.add((Component)new JLabel(I18n.tr("Access Token Key:", new Object[0])), gc);
            gc.gridx = 1;
            gc.weightx = 1.0;
            this.add((Component)this.tfAccessTokenKey, gc);
            this.tfAccessTokenKey.setEditable(false);
            gc.gridy = 2;
            gc.gridx = 0;
            gc.gridwidth = 1;
            gc.weightx = 0.0;
            this.add((Component)new JLabel(I18n.tr("Access Token Secret:", new Object[0])), gc);
            gc.gridx = 1;
            gc.weightx = 1.0;
            this.add((Component)this.tfAccessTokenSecret, gc);
            this.tfAccessTokenSecret.setEditable(false);
            gc.gridy = 3;
            gc.gridx = 0;
            gc.gridwidth = 2;
            gc.weightx = 1.0;
            this.add((Component)OAuthAuthenticationPreferencesPanel.this.cbSaveToPreferences, gc);
            OAuthAuthenticationPreferencesPanel.this.cbSaveToPreferences.setSelected(OAuthAccessTokenHolder.getInstance().isSaveToPreferences());
            JPanel btns = new JPanel(new FlowLayout(0));
            btns.add(new JButton(new RenewAuthorisationAction()));
            btns.add(new JButton(new TestAuthorisationAction()));
            gc.gridy = 4;
            gc.gridx = 0;
            gc.gridwidth = 2;
            gc.weightx = 1.0;
            this.add((Component)btns, gc);
            gc.gridy = 5;
            gc.gridx = 0;
            gc.gridwidth = 2;
            gc.weightx = 1.0;
            this.add((Component)OAuthAuthenticationPreferencesPanel.this.buildAdvancedPropertiesPanel(), gc);
            gc.gridy = 6;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            this.add((Component)new JPanel(), gc);
        }

        protected final void refreshView() {
            String v = OAuthAccessTokenHolder.getInstance().getAccessTokenKey();
            this.tfAccessTokenKey.setText(v == null ? "" : v);
            v = OAuthAccessTokenHolder.getInstance().getAccessTokenSecret();
            this.tfAccessTokenSecret.setText(v == null ? "" : v);
            OAuthAuthenticationPreferencesPanel.this.cbSaveToPreferences.setSelected(OAuthAccessTokenHolder.getInstance().isSaveToPreferences());
        }
    }

    private class NotYetAuthorisedPanel
    extends JPanel {
        NotYetAuthorisedPanel() {
            this.build();
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.insets = new Insets(0, 0, 3, 0);
            gc.fill = 2;
            gc.weightx = 1.0;
            JMultilineLabel lbl = new JMultilineLabel(I18n.tr("You do not have an Access Token yet to access the OSM server using OAuth. Please authorize first.", new Object[0]));
            this.add((Component)lbl, gc);
            lbl.setFont(lbl.getFont().deriveFont(0));
            gc.gridy = 1;
            gc.fill = 0;
            gc.weightx = 0.0;
            this.add((Component)new JButton(new AuthoriseNowAction()), gc);
            gc.gridy = 2;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            this.add((Component)new JPanel(), gc);
        }
    }
}

