/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.Model;
import com.ibm.xmi.framework.Namespace;
import com.ibm.xmi.framework.Package;
import com.ibm.xmi.framework.XMIClass;
import com.ibm.xmi.framework.XMIException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

class Namespaces {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private Model m;
    private Vector list;

    public Namespaces(Vector vector, Collection collection) {
        try {
            this.m = new Model(null, collection.iterator());
        }
        catch (XMIException xMIException) {
            xMIException.printStackTrace();
        }
        this.list = vector;
    }

    private void assignAll(Namespace namespace) {
        Iterator iterator = this.m.getTopLevel().iterator();
        while (iterator.hasNext()) {
            this.assignNamespaces(namespace, (Data)iterator.next());
        }
    }

    private void assignNamespaces(Namespace namespace, Data data) {
        Object object;
        data.setXMINamespace(namespace);
        if (data instanceof XMIClass) {
            object = (XMIClass)data;
            Iterator iterator = object.getXMIFeatures().iterator();
            while (iterator.hasNext()) {
                ((Data)iterator.next()).setXMINamespace(namespace);
            }
        }
        if (data instanceof Package) {
            object = ((Package)data).getXMIContents().iterator();
            while (object.hasNext()) {
                this.assignNamespaces(namespace, (Data)object.next());
            }
        }
    }

    private void set() {
        int n = 0;
        while (n < this.list.size() - 1) {
            String string = (String)this.list.get(n);
            Namespace namespace = (Namespace)this.list.get(n + 1);
            if (string != null && string.equals("")) {
                this.assignAll(namespace);
                return;
            }
            Data data = this.m.getDeclaration(null, string);
            if (data != null) {
                this.assignNamespaces(namespace, data);
            }
            n += 2;
        }
    }

    public void setNamespaces() {
        this.set();
    }
}

