#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: generic-deriving
version: 1.11.2
id: generic-deriving-1.11.2-I1hKFTmgsiECj4HOwgPf5J
key: generic-deriving-1.11.2-I1hKFTmgsiECj4HOwgPf5J
license: BSD3
copyright: 2011-2013 Universiteit Utrecht, University of Oxford
maintainer: generics@haskell.org
stability: experimental
homepage: https://github.com/dreixel/generic-deriving
synopsis: Generic programming library for generalised deriving.
description:
    This package provides functionality for generalising the deriving mechanism
    in Haskell to arbitrary classes. It was first described in the paper:
    .
    *  /A generic deriving mechanism for Haskell/.
    Jose Pedro Magalhaes, Atze Dijkstra, Johan Jeuring, and Andres Loeh.
    Haskell'\''10.
    .
    The current implementation integrates with the new GHC Generics. See
    <http://www.haskell.org/haskellwiki/GHC.Generics> for more information.
    Template Haskell code is provided for supporting older GHCs.
category: Generics
author: José Pedro Magalhães
exposed: True
indefinite: False
exposed-modules:
    Generics.Deriving Generics.Deriving.Base Generics.Deriving.ConNames
    Generics.Deriving.Copoint Generics.Deriving.Enum
    Generics.Deriving.Eq Generics.Deriving.Foldable
    Generics.Deriving.Functor Generics.Deriving.Instances
    Generics.Deriving.Monoid Generics.Deriving.Semigroup
    Generics.Deriving.Show Generics.Deriving.TH
    Generics.Deriving.Traversable Generics.Deriving.Uniplate
hidden-modules: Generics.Deriving.Base.Internal
                Generics.Deriving.TH.Internal Paths_generic_deriving
                Generics.Deriving.TH.Post4_9
abi: 7f9a8be0d94ccfee90d00f3f677a8748
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/generic-deriving-1.11.2
library-dirs: /usr/lib/ghc-8.2.1/site-local/generic-deriving-1.11.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/generic-deriving-1.11.2
hs-libraries: HSgeneric-deriving-1.11.2-I1hKFTmgsiECj4HOwgPf5J
depends:
    containers-0.5.10.2 ghc-prim-0.5.1.0 template-haskell-2.12.0.0
    base-4.10.0.0
abi-depends: containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
             ghc-prim-0.5.1.0=557c7fce76ef13c2417583cc28848f14
             template-haskell-2.12.0.0=612ee923b47f5e11502cef08338c9f82
             base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
haddock-interfaces: /usr/share/doc/haskell-generic-deriving/html/generic-deriving.haddock
haddock-html: /usr/share/doc/haskell-generic-deriving/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

