#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: uniplate
version: 1.6.12
id: uniplate-1.6.12-7N3IMg4lwN2FPMc94OrKMJ
key: uniplate-1.6.12-7N3IMg4lwN2FPMc94OrKMJ
license: BSD3
copyright: Neil Mitchell 2006-2013
maintainer: Neil Mitchell <ndmitchell@gmail.com>
homepage: http://community.haskell.org/~ndm/uniplate/
synopsis: Help writing simple, concise and fast generic operations.
description:
    Uniplate is library for writing simple and concise generic operations.
    Uniplate has similar goals to the original Scrap Your Boilerplate work,
    but is substantially simpler and faster. The Uniplate manual is available at
    <http://community.haskell.org/~ndm/darcs/uniplate/uniplate.htm>.
    .
    To get started with Uniplate you should import one of the three following
    modules:
    .
    * "Data.Generics.Uniplate.Data" - to quickly start writing generic functions.
    Most users should start by importing this module.
    .
    * "Data.Generics.Uniplate.Direct" - a replacement for "Data.Generics.Uniplate.Data"
    with substantially higher performance (around 5 times), but requires writing
    instance declarations.
    .
    * "Data.Generics.Uniplate.Operations" - definitions of all the operations defined
    by Uniplate. Both the above two modules re-export this module.
    .
    In addition, some users may want to make use of the following modules:
    .
    * "Data.Generics.Uniplate.Zipper" - a zipper built on top of Uniplate instances.
    .
    * "Data.Generics.SYB" - users transitioning from the Scrap Your Boilerplate library.
    .
    * "Data.Generics.Compos" - users transitioning from the Compos library.
    .
    * "Data.Generics.Uniplate.DataOnly" - users making use of both @Data@ and @Direct@
    to avoid getting instance conflicts.
category: Generics
author: Neil Mitchell <ndmitchell@gmail.com>
exposed: True
indefinite: False
exposed-modules:
    Data.Generics.Biplate Data.Generics.Compos Data.Generics.PlateData
    Data.Generics.PlateDirect Data.Generics.PlateTypeable
    Data.Generics.SYB Data.Generics.Str Data.Generics.Uniplate
    Data.Generics.Uniplate.Data Data.Generics.Uniplate.Data.Instances
    Data.Generics.Uniplate.DataOnly Data.Generics.Uniplate.Direct
    Data.Generics.Uniplate.Operations Data.Generics.Uniplate.Typeable
    Data.Generics.Uniplate.Zipper Data.Generics.UniplateOn
    Data.Generics.UniplateStr Data.Generics.UniplateStrOn
hidden-modules: Data.Generics.Uniplate.Internal.Data
                Data.Generics.Uniplate.Internal.DataOnlyOperations
                Data.Generics.Uniplate.Internal.Utils
abi: aca07ca2d05ef0b3aaff6d1615e5287c
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/uniplate-1.6.12
library-dirs: /usr/lib/ghc-8.2.1/site-local/uniplate-1.6.12
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/uniplate-1.6.12
hs-libraries: HSuniplate-1.6.12-7N3IMg4lwN2FPMc94OrKMJ
depends:
    base-4.10.0.0 containers-0.5.10.2
    hashable-1.2.6.1-5D85BzUWIsjDNuFvtLMWyk
    syb-0.7-2rRPTNxBP6YFePrCXw4i2o
    unordered-containers-0.2.8.0-KL4HUdwCmhYBQDTvY5v0GN
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
             hashable-1.2.6.1-5D85BzUWIsjDNuFvtLMWyk=90545b19a76e197f153fb1577996b718
             syb-0.7-2rRPTNxBP6YFePrCXw4i2o=119e2c6ac6f570dd5e30835fe9c8c288
             unordered-containers-0.2.8.0-KL4HUdwCmhYBQDTvY5v0GN=c3a6cf2eb5dea0a9b852305436978b94
haddock-interfaces: /usr/share/doc/haskell-uniplate/html/uniplate.haddock
haddock-html: /usr/share/doc/haskell-uniplate/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

