/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_lb extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Zentralafrikanesch Z\u00e4it",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Moskauer Normalz\u00e4it",
               "MSK",
               "Moskauer Summerz\u00e4it",
               "MSD",
               "Moskauer Z\u00e4it",
               "MT",
            };
        final String[] Japan = new String[] {
               "Japanesch Normalz\u00e4it",
               "JST",
               "Japanesch Summerz\u00e4it",
               "JDT",
               "Japanesch Z\u00e4it",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Pakistanesch Normalz\u00e4it",
               "PKT",
               "Pakistanesch Summerz\u00e4it",
               "PKST",
               "Pakistanesch Z\u00e4it",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Taipei-Normalz\u00e4it",
               "CST",
               "Taipei-Summerz\u00e4it",
               "CDT",
               "Taipei-Z\u00e4it",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Hovd-Normalz\u00e4it",
               "HOVT",
               "Hovd-Summerz\u00e4it",
               "HOVST",
               "Hovd-Z\u00e4it",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Magadan-Normalz\u00e4it",
               "MAGT",
               "Magadan-Summerz\u00e4it",
               "MAGST",
               "Magadan-Z\u00e4it",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Zentral-/Westaustralesch Normalz\u00e4it",
               "ACWST",
               "Zentral-/Westaustralesch Summerz\u00e4it",
               "ACWDT",
               "Zentral-/Westaustralesch Z\u00e4it",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "M\u00ebtteleurop\u00e4esch Normalz\u00e4it",
               "CET",
               "M\u00ebtteleurop\u00e4esch Summerz\u00e4it",
               "CEST",
               "M\u00ebtteleurop\u00e4esch Z\u00e4it",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalin-Normalz\u00e4it",
               "SAKT",
               "Sakhalin-Summerz\u00e4it",
               "SAKST",
               "Sakhalin-Z\u00e4it",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguayanesch Normalz\u00e4it",
               "PYT",
               "Paraguayanesch Summerz\u00e4it",
               "PYST",
               "Paraguayanesch Z\u00e4it",
               "PYT",
            };
        final String[] Acre = new String[] {
               "Acre-Normalz\u00e4it",
               "ACT",
               "Acre-Summerz\u00e4it",
               "ACST",
               "Acre-Z\u00e4it",
               "ACT",
            };
        final String[] Malaysia = new String[] {
               "Malaysesch Z\u00e4it",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Nordamerikanesch Ostk\u00fcsten-Normalz\u00e4it",
               "EST",
               "Nordamerikanesch Ostk\u00fcsten-Summerz\u00e4it",
               "EDT",
               "Nordamerikanesch Ostk\u00fcstenz\u00e4it",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Lord-Howe-Normalz\u00e4it",
               "LHST",
               "Lord-Howe-Summerz\u00e4it",
               "LHDT",
               "Lord-Howe-Z\u00e4it",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Neis\u00e9iland-Normalz\u00e4it",
               "NZST",
               "Neis\u00e9iland-Summerz\u00e4it",
               "NZDT",
               "Neis\u00e9iland-Z\u00e4it",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Indeschen Ozean-Z\u00e4it",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Jakutsk-Normalz\u00e4it",
               "YAKT",
               "Jakutsk-Summerz\u00e4it",
               "YAKST",
               "Jakutsk-Z\u00e4it",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Mauritius-Normalz\u00e4it",
               "MUT",
               "Mauritius-Summerz\u00e4it",
               "MUST",
               "Mauritius-Z\u00e4it",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Ostafrikanesch Z\u00e4it",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Osttimor-Z\u00e4it",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Salomoninselen-Z\u00e4it",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae-Z\u00e4it",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshallinselen-Z\u00e4it",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Osteurop\u00e4esch Normalz\u00e4it",
               "EET",
               "Osteurop\u00e4esch Summerz\u00e4it",
               "EEST",
               "Osteurop\u00e4esch Z\u00e4it",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Neifundland-Normalz\u00e4it",
               "NST",
               "Neifundland-Summerz\u00e4it",
               "NDT",
               "Neifundland-Z\u00e4it",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Afghanistan-Z\u00e4it",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Hong-Kong-Normalz\u00e4it",
               "HKT",
               "Hong-Kong-Summerz\u00e4it",
               "HKST",
               "Hong-Kong-Z\u00e4it",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Westargentinesch Normalz\u00e4it",
               "ART",
               "Westargentinesch Summerz\u00e4it",
               "ARST",
               "Westargentinesch Z\u00e4it",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Atlantik-Normalz\u00e4it",
               "AST",
               "Atlantik-Summerz\u00e4it",
               "ADT",
               "Atlantik-Z\u00e4it",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Ponape-Z\u00e4it",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Bolivianesch Z\u00e4it",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint-Pierre-a-Miquelon-Normalz\u00e4it",
               "PMST",
               "Saint-Pierre-a-Miquelon-Summerz\u00e4it",
               "PMDT",
               "Saint-Pierre-a-Miquelon-Z\u00e4it",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Indochina-Z\u00e4it",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinbuerg-Normalz\u00e4it",
               "YEKT",
               "Jekaterinbuerg-Summerz\u00e4it",
               "YEKST",
               "Jekaterinbuerg-Z\u00e4it",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Maldiven-Z\u00e4it",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Tahiti-Z\u00e4it",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Israelesch Normalz\u00e4it",
               "IST",
               "Israelesch Summerz\u00e4it",
               "IDT",
               "Israelesch Z\u00e4it",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Zentralindonesesch Z\u00e4it",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Wallis-a-Futuna-Z\u00e4it",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "S\u00fcdafrikanesch Z\u00e4it",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Syowa-Z\u00e4it",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Linneninselen-Z\u00e4it",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Usbekistan-Normalz\u00e4it",
               "UZT",
               "Usbekistan-Summerz\u00e4it",
               "UZST",
               "Usbekistan-Z\u00e4it",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Omsk-Normalz\u00e4it",
               "OMST",
               "Omsk-Summerz\u00e4it",
               "OMSST",
               "Omsk-Z\u00e4it",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Seychellen-Z\u00e4it",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Uruguyanesch Normalz\u00e4it",
               "UYT",
               "Uruguayanesch Summerz\u00e4it",
               "UYST",
               "Uruguayanesch Z\u00e4it",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Nepalesesch Z\u00e4it",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Ulaanbaatar-Normalz\u00e4it",
               "ULAT",
               "Ulaanbaatar-Summerz\u00e4it",
               "ULAST",
               "Ulaanbaatar-Z\u00e4it",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Nordamerikanesch Inland-Normalz\u00e4it",
               "CST",
               "Nordamerikanesch Inland-Summerz\u00e4it",
               "CDT",
               "Nordamerikanesch Inlandz\u00e4it",
               "CT",
            };
        final String[] Truk = new String[] {
               "Chuuk-Z\u00e4it",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Niue-Z\u00e4it",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Wake-Insel-Z\u00e4it",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Falklandinselen-Normalz\u00e4it",
               "FKT",
               "Falklandinselen-Summerz\u00e4it",
               "FKST",
               "Falklandinselen-Z\u00e4it",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu-Normalz\u00e4it",
               "VUT",
               "Vanuatu-Summerz\u00e4it",
               "VUST",
               "Vanuatu-Z\u00e4it",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Nowosibirsk-Normalz\u00e4it",
               "NOVT",
               "Nowosibirsk-Summerz\u00e4it",
               "NOVST",
               "Nowosibirsk-Z\u00e4it",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Singapur-Standardz\u00e4it",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Azoren-Normalz\u00e4it",
               "AZOT",
               "Azoren-Summerz\u00e4it",
               "AZOST",
               "Azoren-Z\u00e4it",
               "AZOT",
            };
        final String[] Bhutan = new String[] {
               "Bhutan-Z\u00e4it",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Suriname-Z\u00e4it",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Nauru-Z\u00e4it",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsk-Normalz\u00e4it",
               "KRAT",
               "Krasnojarsk-Summerz\u00e4it",
               "KRAST",
               "Krasnojarsk-Z\u00e4it",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Westkasachesch Z\u00e4it",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Myanmar-Z\u00e4it",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Chr\u00ebschtdagsinsel-Z\u00e4it",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Amazonas-Normalz\u00e4it",
               "AMT",
               "Amazonas-Summerz\u00e4it",
               "AMST",
               "Amazonas-Z\u00e4it",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Ostkasachesch Z\u00e4it",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Fidschi-Normalz\u00e4it",
               "FJT",
               "Fidschi-Summerz\u00e4it",
               "FJST",
               "Fidschi-Z\u00e4it",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "R\u00e9union-Z\u00e4it",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Kokosinselen-Z\u00e4it",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Chatham-Normalz\u00e4it",
               "CHAST",
               "Chatham-Summerz\u00e4it",
               "CHADT",
               "Chatham-Z\u00e4it",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Wostok-Z\u00e4it",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Argentinesch Normalz\u00e4it",
               "ART",
               "Argentinesch Summerz\u00e4it",
               "ARST",
               "Argentinesch Z\u00e4it",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Gambier-Z\u00e4it",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Kamtschatka-Normalz\u00e4it",
               "PETT",
               "Kamtschatka-Summerz\u00e4it",
               "PETST",
               "Kamtschatka-Z\u00e4it",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu-Z\u00e4it",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Galapagos-Z\u00e4it",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Macquarieinsel-Z\u00e4it",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Venezuela-Z\u00e4it",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleuten-Normalz\u00e4it",
               "HAST",
               "Hawaii-Aleuten-Summerz\u00e4it",
               "HADT",
               "Hawaii-Aleuten-Z\u00e4it",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Zentralaustralesch Normalz\u00e4it",
               "ACST",
               "Zentralaustralesch Summerz\u00e4it",
               "ACDT",
               "Zentralaustralesch Z\u00e4it",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Nordamerikanesch Westk\u00fcsten-Normalz\u00e4it",
               "PST",
               "Nordamerikanesch Westk\u00fcsten-Summerz\u00e4it",
               "PDT",
               "Nordamerikanesch Westk\u00fcstenz\u00e4it",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenixinselen-Z\u00e4it",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistan-Normalz\u00e4it",
               "TMT",
               "Turkmenistan-Summerz\u00e4it",
               "TMST",
               "Turkmenistan-Z\u00e4it",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Westeurop\u00e4esch Normalz\u00e4it",
               "WET",
               "Westeurop\u00e4esch Summerz\u00e4it",
               "WEST",
               "Westeurop\u00e4esch Z\u00e4it",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Kap-Verde-Normalz\u00e4it",
               "CVT",
               "Kap-Verde-Summerz\u00e4it",
               "CVST",
               "Kap-Verde-Z\u00e4it",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Norfolkinselen-Z\u00e4it",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Guyana-Z\u00e4it",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairninselen-Z\u00e4it",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Rothera-Z\u00e4it",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Samoa-Normalz\u00e4it",
               "SST",
               "Samoa-Summerz\u00e4it",
               "SDT",
               "Samoa-Z\u00e4it",
               "ST",
            };
        final String[] Palau = new String[] {
               "Palau-Z\u00e4it",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Azerbaijan = new String[] {
               "Aserbeidschanesch Normalz\u00e4it",
               "AZT",
               "Aserbaidschanesch Summerz\u00e4it",
               "AZST",
               "Aserbaidschanesch Z\u00e4it",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Mawson-Z\u00e4it",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mexikanesch Pazifik-Normalz\u00e4it",
               "MST",
               "Mexikanesch Pazifik-Summerz\u00e4it",
               "MDT",
               "Mexikanesch Pazifikz\u00e4it",
               "MT",
            };
        final String[] Davis = new String[] {
               "Davis-Z\u00e4it",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Kubanesch Normalz\u00e4it",
               "CST",
               "Kubanesch Summerz\u00e4it",
               "CDT",
               "Kubanesch Z\u00e4it",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Westafrikanesch Normalz\u00e4it",
               "WAT",
               "Westafrikanesch Summerz\u00e4it",
               "WAST",
               "Westafrikanesch Z\u00e4it",
               "WAT",
            };
        final String[] GMT = new String[] {
               "M\u00ebttler Greenwich-Z\u00e4it",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Philippinnesch Normalz\u00e4it",
               "PHT",
               "Philippinnesch Summerz\u00e4it",
               "PHST",
               "Philippinnesch Z\u00e4it",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Frans\u00e9isch S\u00fcd- an Antarktisgebidder-Z\u00e4it",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "S\u00fcdgeorgesch Z\u00e4it",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Neikaledonesch Normalz\u00e4it",
               "NCT",
               "Neikaledonesch Summerz\u00e4it",
               "NCST",
               "Neikaledonesch Z\u00e4it",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Brunei-Z\u00e4it",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Iranesch Normalz\u00e4it",
               "IRST",
               "Iranesch Summerz\u00e4it",
               "IRDT",
               "Iranesch Z\u00e4it",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Ouschterinsel-Normalz\u00e4it",
               "EAST",
               "Ouschterinsel-Summerz\u00e4it",
               "EASST",
               "Ouschterinsel-Z\u00e4it",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Nordwest-Mexiko-Normalz\u00e4it",
               "PST",
               "Nordwest-Mexiko-Summerz\u00e4it",
               "PDT",
               "Nordwest-Mexiko-Z\u00e4it",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville-Z\u00e4it",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Tadschikistan-Z\u00e4it",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Tonganesch Normalz\u00e4it",
               "TOT",
               "Tonganesch Summerz\u00e4it",
               "TOST",
               "Tonganesch Z\u00e4it",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesch-Normalz\u00e4it",
               "BDT",
               "Bangladesch-Summerz\u00e4it",
               "BDST",
               "Bangladesch-Z\u00e4it",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Peruanesch Normalz\u00e4it",
               "PET",
               "Peruanesch Summerz\u00e4it",
               "PEST",
               "Peruanesch Z\u00e4it",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Westgr\u00f6nland-Normalz\u00e4it",
               "WGT",
               "Westgr\u00f6nland-Summerz\u00e4it",
               "WGST",
               "Westgr\u00f6nland-Z\u00e4it",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Ecuadorianesch Z\u00e4it",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Ostgr\u00f6nland-Normalz\u00e4it",
               "EGT",
               "Ostgr\u00f6nland-Summerz\u00e4it",
               "EGST",
               "Ostgr\u00f6nland-Z\u00e4it",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Golf-Z\u00e4it",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ostindonesesch Z\u00e4it",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Koreanesch Normalz\u00e4it",
               "KST",
               "Koreanesch Summerz\u00e4it",
               "KDT",
               "Koreanesch Z\u00e4it",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Westaustralesch Normalz\u00e4it",
               "AWST",
               "Westaustralesch Summerz\u00e4it",
               "AWDT",
               "Westaustralesch Z\u00e4it",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgisistan-Z\u00e4it",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Westindonesesch Z\u00e4it",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Ostaustralesch Normalz\u00e4it",
               "AEST",
               "Ostaustralesch Summerz\u00e4it",
               "AEDT",
               "Ostaustralesch Z\u00e4it",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Frans\u00e9isch-Guayane-Z\u00e4it",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Kolumbianesch Normalz\u00e4it",
               "COT",
               "Kolumbianesch Summerz\u00e4it",
               "COST",
               "Kolumbianesch Z\u00e4it",
               "COT",
            };
        final String[] Chile = new String[] {
               "Chilenesch Normalz\u00e4it",
               "CLT",
               "Chilenesch Summerz\u00e4it",
               "CLST",
               "Chilenesch Z\u00e4it",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert-Inselen-Z\u00e4it",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Rocky-Mountain-Normalz\u00e4it",
               "MST",
               "Rocky-Mountain-Summerz\u00e4it",
               "MDT",
               "Rocky-Mountain-Z\u00e4it",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Marquesas-Z\u00e4it",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Arabesch Normalz\u00e4it",
               "AST",
               "Arabesch Summerz\u00e4it",
               "ADT",
               "Arabesch Z\u00e4it",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Alaska-Normalz\u00e4it",
               "AKST",
               "Alaska-Summerz\u00e4it",
               "AKDT",
               "Alaska-Z\u00e4it",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Wladiwostok-Normalz\u00e4it",
               "VLAT",
               "Wladiwostok-Summerz\u00e4it",
               "VLAST",
               "Wladiwostok-Z\u00e4it",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Chamorro-Z\u00e4it",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk-Normalz\u00e4it",
               "IRKT",
               "Irkutsk-Summerz\u00e4it",
               "IRKST",
               "Irkutsk-Z\u00e4it",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Georgesch Normalz\u00e4it",
               "GET",
               "Georgesch Summerz\u00e4it",
               "GEST",
               "Georgesch Z\u00e4it",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Tokelau-Z\u00e4it",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua-Neiguinea-Z\u00e4it",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Fernando-de-Noronha-Normalz\u00e4it",
               "FNT",
               "Fernando-de-Noronha-Summerz\u00e4it",
               "FNST",
               "Fernando-de-Noronha-Z\u00e4it",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Choibalsan-Normalz\u00e4it",
               "CHOT",
               "Choibalsan-Summerz\u00e4it",
               "CHOST",
               "Choibalsan-Z\u00e4it",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Bras\u00edlia-Normalz\u00e4it",
               "BRT",
               "Bras\u00edlia-Summerz\u00e4it",
               "BRST",
               "Bras\u00edlia-Z\u00e4it",
               "BRT",
            };
        final String[] China = new String[] {
               "Chinesesch Normalz\u00e4it",
               "CST",
               "Chinesesch Summerz\u00e4it",
               "CDT",
               "Chinesesch Z\u00e4it",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Armenesch Normalz\u00e4it",
               "AMT",
               "Armenesch Summerz\u00e4it",
               "AMST",
               "Armenesch Z\u00e4it",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Samara-Normalz\u00e4it",
               "SAMT",
               "Samara-Summerz\u00e4it",
               "SAMST",
               "Samara-Z\u00e4it",
               "SAMT",
            };
        final String[] India = new String[] {
               "Indesch Z\u00e4it",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Cookinselen-Normalz\u00e4it",
               "CKT",
               "Cookinselen-Summerz\u00e4it",
               "CKHST",
               "Cookinselen-Z\u00e4it",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "M\u00ebttler Greenwich-Z\u00e4it",
                    "GMT",
                    "Britesch Summerz\u00e4it",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "M\u00ebttler Greenwich-Z\u00e4it",
                    "GMT",
                    "Iresch Summerz\u00e4it",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
