/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_lv extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Centr\u0101l\u0101frikas laiks",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Maskavas ziemas laiks",
               "MSK",
               "Maskavas vasaras laiks",
               "MSD",
               "Maskavas laiks",
               "MT",
            };
        final String[] Japan = new String[] {
               "Jap\u0101nas ziemas laiks",
               "JST",
               "Jap\u0101nas vasaras laiks",
               "JDT",
               "Jap\u0101nas laiks",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Pakist\u0101nas ziemas laiks",
               "PKT",
               "Pakist\u0101nas vasaras laiks",
               "PKST",
               "Pakist\u0101nas laiks",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Taibei ziemas laiks",
               "CST",
               "Taibei vasaras laiks",
               "CDT",
               "Taibei laiks",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Hovdas ziemas laiks",
               "HOVT",
               "Hovdas vasaras laiks",
               "HOVST",
               "Hovdas laiks",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Magadanas ziemas laiks",
               "MAGT",
               "Magadanas vasaras laiks",
               "MAGST",
               "Magadanas laiks",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Austr\u0101lijas centr\u0101lais rietumu ziemas laiks",
               "ACWST",
               "Austr\u0101lijas centr\u0101lais rietumu vasaras laiks",
               "ACWDT",
               "Austr\u0101lijas centr\u0101lais rietumu laiks",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Centr\u0101leiropas ziemas laiks",
               "CET",
               "Centr\u0101leiropas vasaras laiks",
               "CEST",
               "Centr\u0101leiropas laiks",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Sahal\u012bnas ziemas laiks",
               "SAKT",
               "Sahal\u012bnas vasaras laiks",
               "SAKST",
               "Sahal\u012bnas laiks",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Paragvajas ziemas laiks",
               "PYT",
               "Paragvajas vasaras laiks",
               "PYST",
               "Paragvajas laiks",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "Malaizijas laiks",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Austrumu ziemas laiks",
               "EST",
               "Austrumu vasaras laiks",
               "EDT",
               "Austrumu laiks",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Lorda Hava salas ziemas laiks",
               "LHST",
               "Lorda Hava salas vasaras laiks",
               "LHDT",
               "Lorda Hava salas laiks",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Jaunz\u0113landes ziemas laiks",
               "NZST",
               "Jaunz\u0113landes vasaras laiks",
               "NZDT",
               "Jaunz\u0113landes laiks",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Indijas oke\u0101na laiks",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Jakutskas ziemas laiks",
               "YAKT",
               "Jakutskas vasaras laiks",
               "YAKST",
               "Jakutskas laiks",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Maur\u012bcijas ziemas laiks",
               "MUT",
               "Maur\u012bcijas vasaras laiks",
               "MUST",
               "Maur\u012bcijas laiks",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Austrum\u0101frikas laiks",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Austrumtimoras laiks",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Z\u0101lamana salu laiks",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae laiks",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "M\u0101r\u0161ala salu laiks",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Austrumeiropas ziemas laiks",
               "EET",
               "Austrumeiropas vasaras laiks",
               "EEST",
               "Austrumeiropas laiks",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "\u0145\u016bfaundlendas ziemas laiks",
               "NST",
               "\u0145\u016bfaundlendas vasaras laiks",
               "NDT",
               "\u0145\u016bfaundlendas laiks",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Afganist\u0101nas laiks",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Honkongas ziemas laiks",
               "HKT",
               "Honkongas vasaras laiks",
               "HKST",
               "Honkongas laiks",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Rietumargent\u012bnas ziemas laiks",
               "ART",
               "Rietumargent\u012bnas vasaras laiks",
               "ARST",
               "Rietumargent\u012bnas laiks",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Atlantijas ziemas laiks",
               "AST",
               "Atlantijas vasaras laiks",
               "ADT",
               "Atlantijas laiks",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Ponap\u0113 laiks",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Bol\u012bvijas laiks",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Senpj\u0113ras un Mikelonas ziemas laiks",
               "PMST",
               "Senpj\u0113ras un Mikelonas vasaras laiks",
               "PMDT",
               "Senpj\u0113ras un Mikelonas laiks",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Indo\u0137\u012bnas laiks",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburgas ziemas laiks",
               "YEKT",
               "Jekaterinburgas vasaras laiks",
               "YEKST",
               "Jekaterinburgas laiks",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Mald\u012bvu salu laiks",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Taiti laiks",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Izra\u0113las ziemas laiks",
               "IST",
               "Izra\u0113las vasaras laiks",
               "IDT",
               "Izra\u0113las laiks",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Centr\u0101lindon\u0113zijas laiks",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Volisas un Futunas laiks",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Dienvid\u0101frikas ziemas laiks",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "\u0160ovas laiks",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Lainas salu laiks",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekist\u0101nas ziemas laiks",
               "UZT",
               "Uzbekist\u0101nas vasaras laiks",
               "UZST",
               "Uzbekist\u0101nas laiks",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Omskas ziemas laiks",
               "OMST",
               "Omskas vasaras laiks",
               "OMSST",
               "Omskas laiks",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Sei\u0161e\u013cu salu laiks",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Urugvajas ziemas laiks",
               "UYT",
               "Urugvajas vasaras laiks",
               "UYST",
               "Urugvajas laiks",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Nep\u0101las laiks",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Ulanbatoras ziemas laiks",
               "ULAT",
               "Ulanbatoras vasaras laiks",
               "ULAST",
               "Ulanbatoras laiks",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Centr\u0101lais ziemas laiks",
               "CST",
               "Centr\u0101lais vasaras laiks",
               "CDT",
               "Centr\u0101lais laiks",
               "CT",
            };
        final String[] Truk = new String[] {
               "\u010c\u016bkas laiks",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Niue laiks",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Veika salas laiks",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Folklenda salu ziemas laiks",
               "FKT",
               "Folklenda salu vasaras laiks",
               "FKST",
               "Folklenda salu laiks",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu ziemas laiks",
               "VUT",
               "Vanuatu vasaras laiks",
               "VUST",
               "Vanuatu laiks",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirskas ziemas laiks",
               "NOVT",
               "Novosibirskas vasaras laiks",
               "NOVST",
               "Novosibirskas laiks",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Singap\u016bras laiks",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Azoru salu ziemas laiks",
               "AZOT",
               "Azoru salu vasaras laiks",
               "AZOST",
               "Azoru salu laiks",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Apijas ziemas laiks",
               "WSST",
               "Apijas vasaras laiks",
               "WSDT",
               "Apijas laiks",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "But\u0101nas laiks",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Surinamas laiks",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Nauru laiks",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarskas ziemas laiks",
               "KRAT",
               "Krasnojarskas vasaras laiks",
               "KRAST",
               "Krasnojarskas laiks",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Rietumkazahst\u0101nas laiks",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Mjanmas laiks",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Ziemsv\u0113tku salas laiks",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Amazones ziemas laiks",
               "AMT",
               "Amazones vasaras laiks",
               "AMST",
               "Amazones laiks",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Austrumkazahst\u0101nas laiks",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Fid\u017ei ziemas laiks",
               "FJT",
               "Fid\u017ei vasaras laiks",
               "FJST",
               "Fid\u017ei laiks",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Reinjonas laiks",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Kokosa salu laiks",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "\u010cetemas ziemas laiks",
               "CHAST",
               "\u010cetemas vasaras laiks",
               "CHADT",
               "\u010cetemas laiks",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Vostokas laiks",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Argent\u012bnas ziemas laiks",
               "ART",
               "Argent\u012bnas vasaras laiks",
               "ARST",
               "Argent\u012bnas laiks",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Gambj\u0113 salu laiks",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovskas-Kam\u010datskas ziemas laiks",
               "PETT",
               "Petropavlovskas-Kam\u010datskas vasaras laiks",
               "PETST",
               "Petropavlovskas-Kam\u010datskas laiks",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu laiks",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Galapagu laiks",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Makvorija salas laiks",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Venecu\u0113las laiks",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havaju\u2013Aleutu ziemas laiks",
               "HAST",
               "Havaju\u2013Aleutu vasaras laiks",
               "HADT",
               "Havaju\u2013Aleutu laiks",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Austr\u0101lijas centr\u0101lais ziemas laiks",
               "ACST",
               "Austr\u0101lijas centr\u0101lais vasaras laiks",
               "ACDT",
               "Austr\u0101lijas centr\u0101lais laiks",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Klus\u0101 oke\u0101na ziemas laiks",
               "PST",
               "Klus\u0101 oke\u0101na vasaras laiks",
               "PDT",
               "Klus\u0101 oke\u0101na laiks",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "F\u0113niksa salu laiks",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenist\u0101nas ziemas laiks",
               "TMT",
               "Turkmenist\u0101nas vasaras laiks",
               "TMST",
               "Turkmenist\u0101nas laiks",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Rietumeiropas ziemas laiks",
               "WET",
               "Rietumeiropas vasaras laiks",
               "WEST",
               "Rietumeiropas laiks",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Kaboverdes ziemas laiks",
               "CVT",
               "Kaboverdes vasaras laiks",
               "CVST",
               "Kaboverdes laiks",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Norfolkas salas laiks",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Gaj\u0101nas laiks",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Pitk\u0113rnas laiks",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Roteras laiks",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Samoa ziemas laiks",
               "SST",
               "Samoa vasaras laiks",
               "SDT",
               "Samoa laiks",
               "ST",
            };
        final String[] Palau = new String[] {
               "Palau laiks",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Austrumeiropas laika josla (FET)",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbaid\u017e\u0101nas ziemas laiks",
               "AZT",
               "Azerbaid\u017e\u0101nas vasaras laiks",
               "AZST",
               "Azerbaid\u017e\u0101nas laiks",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Mosonas laiks",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksikas Klus\u0101 oke\u0101na piekrastes ziemas laiks",
               "MST",
               "Meksikas Klus\u0101 oke\u0101na piekrastes vasaras laiks",
               "MDT",
               "Meksikas Klus\u0101 oke\u0101na piekrastes laiks",
               "MT",
            };
        final String[] Davis = new String[] {
               "Deivisas laiks",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Kubas ziemas laiks",
               "CST",
               "Kubas vasaras laiks",
               "CDT",
               "Kubas laiks",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Rietum\u0101frikas ziemas laiks",
               "WAT",
               "Rietum\u0101frikas vasaras laiks",
               "WAST",
               "Rietum\u0101frikas laiks",
               "WAT",
            };
        final String[] GMT = new String[] {
               "Grini\u010das laiks",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Filip\u012bnu ziemas laiks",
               "PHT",
               "Filip\u012bnu vasaras laiks",
               "PHST",
               "Filip\u012bnu laiks",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Francijas Dienidj\u016bru un Antarktikas teritorijas laiks",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "Dienvidd\u017eord\u017eijas laiks",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Jaunkaledonijas ziemas laiks",
               "NCT",
               "Jaunkaledonijas vasaras laiks",
               "NCST",
               "Jaunkaledonijas laiks",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Brunejas Darusalamas laiks",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Ir\u0101nas ziemas laiks",
               "IRST",
               "Ir\u0101nas vasaras laiks",
               "IRDT",
               "Ir\u0101nas laiks",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Lieldienu salas ziemas laiks",
               "EAST",
               "Lieldienu salas vasaras laiks",
               "EASST",
               "Lieldienu salas laiks",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Zieme\u013crietumu Meksikas ziemas laiks",
               "PST",
               "Zieme\u013crietumu Meksikas vasaras laiks",
               "PDT",
               "Zieme\u013crietumu Meksikas laiks",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Dimondirvilas laiks",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Tad\u017eikist\u0101nas laiks",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Tongas ziemas laiks",
               "TOT",
               "Tongas vasaras laiks",
               "TOST",
               "Tongas laiks",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Banglade\u0161as ziemas laiks",
               "BDT",
               "Banglade\u0161as vasaras laiks",
               "BDST",
               "Banglade\u0161as laiks",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Peru ziemas laiks",
               "PET",
               "Peru vasaras laiks",
               "PEST",
               "Peru laiks",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Rietumgrenlandes ziemas laiks",
               "WGT",
               "Rietumgrenlandes vasaras laiks",
               "WGST",
               "Rietumgrenlandes laiks",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Ekvadoras laiks",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Austrumgrenlandes ziemas laiks",
               "EGT",
               "Austrumgrenlandes vasaras laiks",
               "EGST",
               "Austrumgrenlandes laiks",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Persijas l\u012b\u010da laiks",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Austrumindon\u0113zijas laiks",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Korejas ziemas laiks",
               "KST",
               "Korejas vasaras laiks",
               "KDT",
               "Korejas laiks",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Austr\u0101lijas rietumu ziemas laiks",
               "AWST",
               "Austr\u0101lijas rietumu vasaras laiks",
               "AWDT",
               "Austr\u0101lijas rietumu laiks",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgizst\u0101nas laiks",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Rietumindon\u0113zijas laiks",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Austr\u0101lijas austrumu ziemas laiks",
               "AEST",
               "Austr\u0101lijas austrumu vasaras laiks",
               "AEDT",
               "Austr\u0101lijas austrumu laiks",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Fran\u010du Gvi\u0101nas laiks",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Kolumbijas ziemas laiks",
               "COT",
               "Kolumbijas vasaras laiks",
               "COST",
               "Kolumbijas laiks",
               "COT",
            };
        final String[] Chile = new String[] {
               "\u010c\u012bles ziemas laiks",
               "CLT",
               "\u010c\u012bles vasaras laiks",
               "CLST",
               "\u010c\u012bles laiks",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilberta salu laiks",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Kalnu ziemas laiks",
               "MST",
               "Kalnu vasaras laiks",
               "MDT",
               "Kalnu laiks",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Mar\u0137\u012bza salu laiks",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Ar\u0101bijas pussalas ziemas laiks",
               "AST",
               "Ar\u0101bijas pussalas vasaras laiks",
               "ADT",
               "Ar\u0101bijas pussalas laiks",
               "AT",
            };
        final String[] Alaska = new String[] {
               "A\u013caskas ziemas laiks",
               "AKST",
               "A\u013caskas vasaras laiks",
               "AKDT",
               "A\u013caskas laiks",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostokas ziemas laiks",
               "VLAT",
               "Vladivostokas vasaras laiks",
               "VLAST",
               "Vladivostokas laiks",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "\u010camoro standarta laiks",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutskas ziemas laiks",
               "IRKT",
               "Irkutskas vasaras laiks",
               "IRKST",
               "Irkutskas laiks",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Gruzijas ziemas laiks",
               "GET",
               "Gruzijas vasaras laiks",
               "GEST",
               "Gruzijas laiks",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Tokelau laiks",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua-Jaungvinejas laiks",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Fernandu di Noro\u0146as ziemas laiks",
               "FNT",
               "Fernandu di Noro\u0146as vasaras laiks",
               "FNST",
               "Fernandu di Noro\u0146as laiks",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u010coibalsanas ziemas laiks",
               "CHOT",
               "\u010coibalsanas vasaras laiks",
               "CHOST",
               "\u010coibalsanas laiks",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Braz\u012blijas ziemas laiks",
               "BRT",
               "Braz\u012blijas vasaras laiks",
               "BRST",
               "Braz\u012blijas laiks",
               "BRT",
            };
        final String[] China = new String[] {
               "\u0136\u012bnas ziemas laiks",
               "CST",
               "\u0136\u012bnas vasaras laiks",
               "CDT",
               "\u0136\u012bnas laiks",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Arm\u0113nijas ziemas laiks",
               "AMT",
               "Arm\u0113nijas vasaras laiks",
               "AMST",
               "Arm\u0113nijas laiks",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Samaras ziemas laiks",
               "SAMT",
               "Samaras vasaras laiks",
               "SAMST",
               "Samaras laiks",
               "SAMT",
            };
        final String[] India = new String[] {
               "Indijas ziemas laiks",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Kuka salu ziemas laiks",
               "CKT",
               "Kuka salu vasaras laiks",
               "CKHST",
               "Kuka salu laiks",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Grini\u010das laiks",
                    "GMT",
                    "Lielbrit\u0101nijas vasaras laiks",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Grini\u010das laiks",
                    "GMT",
                    "\u012arijas ziemas laiks",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
