/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.repo;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.url.URLRepository;
import org.apache.ivy.plugins.repository.url.URLResource;

public class RelativeURLRepository
extends URLRepository {
    private final URL baseUrl;
    private Map<String, Resource> resourcesCache = new HashMap<String, Resource>();

    public RelativeURLRepository() {
        this.baseUrl = null;
    }

    public RelativeURLRepository(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    public Resource getResource(String source) throws IOException {
        Resource res = this.resourcesCache.get(source = RelativeURLRepository.encode(source));
        if (res == null) {
            URI uri;
            try {
                uri = new URI(source);
            }
            catch (URISyntaxException e) {
                uri = null;
            }
            res = uri == null || uri.isAbsolute() ? new URLResource(new URL(source)) : new URLResource(new URL(this.baseUrl + source));
            this.resourcesCache.put(source, res);
        }
        return res;
    }

    private static String encode(String source) {
        return source.trim().replaceAll(" ", "%20");
    }
}

