/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.generator.sorting;

import com.baselet.control.basics.geom.Dimension;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.generator.sorting.SortableElement;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class Layout {
    protected final int GRIDSIZE = CurrentDiagram.getInstance().getDiagramHandler().getGridSize();
    protected Dimension bounds;

    public abstract void layout(List<SortableElement> var1);

    public void simpleLayout(Comparator<SortableElement> comparator, List<SortableElement> elements) {
        int maxHeight = 0;
        int sumWidth = 0;
        for (SortableElement e : elements) {
            if (e.getElement().getRectangle().height > maxHeight) {
                maxHeight = e.getElement().getRectangle().height;
            }
            sumWidth += e.getElement().getRectangle().width;
        }
        double m = Math.sqrt((double)sumWidth / (0.4 * (double)maxHeight));
        int desiredWidth = (int)((double)sumWidth / m);
        Collections.sort(elements, comparator);
        int rows = 1;
        int curX = this.GRIDSIZE;
        int curY = this.GRIDSIZE;
        Dimension d = new Dimension(curX, curY);
        int maxHeightThisRow = 0;
        for (SortableElement e : elements) {
            e.getElement().setLocation(curX, curY);
            if (e.getElement().getRectangle().height > maxHeightThisRow) {
                maxHeightThisRow = e.getElement().getRectangle().height;
            }
            Rectangle dim = e.getElement().getRectangle();
            if (curX + dim.width > d.width) {
                d.width = curX + e.getElement().getRectangle().width;
            }
            if (curX > desiredWidth) {
                ++rows;
                curY += maxHeightThisRow + this.GRIDSIZE;
                curX = this.GRIDSIZE;
                maxHeightThisRow = 0;
            } else {
                curX += e.getElement().getRectangle().width + this.GRIDSIZE;
            }
            if (elements.indexOf(e) != elements.size() - 1) continue;
            d.height = curY + maxHeightThisRow + (rows + 1) * this.GRIDSIZE;
        }
        d.width += this.GRIDSIZE;
        this.bounds = d;
    }
}

