/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.dialogresults;

import java.util.EnumSet;
import java.util.Objects;
import net.sourceforge.jnlp.security.dialogresults.BasicDialogValue;
import net.sourceforge.jnlp.security.dialogresults.DialogResult;
import net.sourceforge.jnlp.security.dialogresults.YesNo;

public class AccessWarningPaneComplexReturn
implements DialogResult {
    private final YesNo regularReturn;
    private ShortcutResult dekstop;
    private ShortcutResult menu;

    public static AccessWarningPaneComplexReturn readValue(String s) {
        String[] sq = s.split(",");
        BasicDialogValue.Primitive regularReturn = BasicDialogValue.Primitive.valueOf(sq[0]);
        sq = s.replace("()", "( )").split("[()]");
        ShortcutResult d = null;
        if (sq.length > 1) {
            d = ShortcutResult.readValue(sq[1]);
        }
        ShortcutResult m = null;
        if (sq.length > 3) {
            m = ShortcutResult.readValue(sq[3]);
        }
        AccessWarningPaneComplexReturn a = new AccessWarningPaneComplexReturn(regularReturn);
        a.dekstop = d;
        a.menu = m;
        return a;
    }

    @Override
    public String writeValue() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.regularReturn.writeValue()).append(",D(");
        if (this.dekstop != null) {
            sb.append(this.dekstop.writeValue());
        }
        sb.append(")M(");
        if (this.menu != null) {
            sb.append(this.menu.writeValue());
        }
        sb.append(")");
        return sb.toString();
    }

    public AccessWarningPaneComplexReturn(boolean b) {
        this.regularReturn = b ? YesNo.yes() : YesNo.no();
    }

    public AccessWarningPaneComplexReturn(BasicDialogValue.Primitive regularReturn) {
        this.regularReturn = new YesNo(regularReturn);
    }

    public void setDekstop(ShortcutResult dekstop) {
        this.dekstop = dekstop;
    }

    public ShortcutResult getDekstop() {
        return this.dekstop;
    }

    public void setMenu(ShortcutResult menu) {
        this.menu = menu;
    }

    public ShortcutResult getMenu() {
        return this.menu;
    }

    @Override
    public boolean toBoolean() {
        if (this.regularReturn == null) {
            return false;
        }
        return this.regularReturn.toBoolean();
    }

    public YesNo getRegularReturn() {
        return this.regularReturn;
    }

    @Override
    public int getButtonIndex() {
        if (this.regularReturn == null) {
            return BasicDialogValue.Primitive.NO.getLegacyButton();
        }
        return this.regularReturn.getButtonIndex();
    }

    public static class ShortcutResult {
        private String browser = "not_found_browser";
        private boolean fixHref = false;
        private Shortcut shortcutType = null;
        private final boolean create;

        public static ShortcutResult readValue(String s) {
            if (s.trim().isEmpty()) {
                return null;
            }
            String[] sq = s.split(",");
            ShortcutResult sr = new ShortcutResult(Boolean.valueOf(sq[3]));
            sr.browser = sq[0];
            sr.fixHref = Boolean.parseBoolean(sq[1]);
            if (!sq[2].equalsIgnoreCase("null")) {
                sr.shortcutType = Shortcut.valueOf(sq[2]);
            }
            return sr;
        }

        public String writeValue() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.browser).append(",").append(this.fixHref).append(",").append((Object)this.shortcutType).append(",").append(this.create).append(",");
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ShortcutResult)) {
                return false;
            }
            ShortcutResult sr = (ShortcutResult)obj;
            return this.create == sr.create && this.fixHref == sr.fixHref && this.browser.equals(sr.browser) && this.shortcutType == sr.shortcutType;
        }

        public int hashCode() {
            int hash = 3;
            hash = 89 * hash + Objects.hashCode(this.browser);
            hash = 89 * hash + (this.fixHref ? 1 : 0);
            hash = 89 * hash + Objects.hashCode((Object)this.shortcutType);
            hash = 89 * hash + (this.create ? 1 : 0);
            return hash;
        }

        ShortcutResult(String browser, boolean fixHref, Shortcut shortcutType, boolean create) {
            this.browser = browser;
            this.fixHref = fixHref;
            this.shortcutType = shortcutType;
            this.create = create;
        }

        public ShortcutResult(boolean create) {
            this.create = create;
        }

        public boolean isCreate() {
            return this.create;
        }

        public String getBrowser() {
            return this.browser;
        }

        public Shortcut getShortcutType() {
            return this.shortcutType;
        }

        public boolean isFixHref() {
            return this.fixHref;
        }

        public void setBrowser(String browser) {
            this.browser = browser;
        }

        public void setFixHref(boolean fixHref) {
            this.fixHref = fixHref;
        }

        public void setShortcutType(Shortcut shortcutType) {
            this.shortcutType = shortcutType;
        }

        public static enum Shortcut {
            BROWSER,
            GENERATED_JNLP,
            JNLP_HREF,
            JAVAWS_HTML;


            public static String allValues() {
                EnumSet<Shortcut> all = EnumSet.of(BROWSER, GENERATED_JNLP, JNLP_HREF, JAVAWS_HTML);
                return all.toString();
            }
        }
    }
}

