/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.cache;

import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;

public class BundleCacheResourceWrapper
implements Resource {
    private Resource parent;
    private ResourceKey outsideKey;

    public BundleCacheResourceWrapper(Resource parent, ResourceKey outsideKey) {
        this.parent = parent;
        this.outsideKey = outsideKey;
    }

    public Object getResource() throws ResourceException {
        return this.parent.getResource();
    }

    public Class getTargetType() {
        return this.parent.getTargetType();
    }

    public long getVersion(ResourceKey key) {
        if (ObjectUtilities.equal((Object)key, (Object)this.outsideKey)) {
            return this.parent.getVersion(this.parent.getSource());
        }
        return this.parent.getVersion(key);
    }

    public ResourceKey[] getDependencies() {
        ResourceKey[] resourceKeys = this.parent.getDependencies();
        ResourceKey[] target = new ResourceKey[resourceKeys.length + 1];
        target[0] = this.parent.getSource();
        System.arraycopy(resourceKeys, 0, target, 1, resourceKeys.length);
        return target;
    }

    public ResourceKey getSource() {
        return this.outsideKey;
    }

    public boolean isTemporaryResult() {
        return this.parent.isTemporaryResult();
    }
}

