/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.datetime;

import java.sql.Date;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.DateTimeType;
import org.pentaho.reporting.libraries.formula.util.DateUtil;

public class DateFunction
implements Function {
    private static final long serialVersionUID = 4956151361696995668L;

    public String getCanonicalName() {
        return "DATE";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        if (parameters.getParameterCount() != 3) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Number n1 = typeRegistry.convertToNumber(parameters.getType(0), parameters.getValue(0));
        Number n2 = typeRegistry.convertToNumber(parameters.getType(1), parameters.getValue(1));
        Number n3 = typeRegistry.convertToNumber(parameters.getType(2), parameters.getValue(2));
        if (n1 == null || n2 == null || n3 == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        LocalizationContext localizationContext = context.getLocalizationContext();
        Date date = DateUtil.createDate(n1.intValue(), n2.intValue(), n3.intValue(), localizationContext);
        return new TypeValuePair(DateTimeType.DATE_TYPE, date);
    }
}

