/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler;

import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.CSSValueReadHandler;
import org.jfree.layouting.input.style.values.CSSAutoValue;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public abstract class AbstractWidthReadHandler
implements CSSValueReadHandler {
    private boolean allowPercentages;
    private boolean allowAuto;

    protected AbstractWidthReadHandler(boolean bl, boolean bl2) {
        this.allowPercentages = bl;
        this.allowAuto = bl2;
    }

    public boolean isAllowPercentages() {
        return this.allowPercentages;
    }

    public boolean isAllowAuto() {
        return this.allowAuto;
    }

    public CSSValue createValue(StyleKey styleKey, LexicalUnit lexicalUnit) {
        return this.parseWidth(lexicalUnit);
    }

    protected CSSValue parseWidth(LexicalUnit lexicalUnit) {
        if (this.allowPercentages && lexicalUnit.getLexicalUnitType() == 23) {
            return CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, lexicalUnit.getFloatValue());
        }
        if (this.allowAuto && lexicalUnit.getLexicalUnitType() == 35) {
            if ("auto".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return CSSAutoValue.getInstance();
            }
            return null;
        }
        return CSSValueFactory.createLengthValue(lexicalUnit);
    }
}

