/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.content;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.content.ContentStyleKeys;
import org.jfree.layouting.input.style.values.CSSAttrFunction;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public class CounterIncrementResolveHandler
implements ResolveHandler {
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{ContentStyleKeys.COUNTER_RESET};
    }

    public void resolve(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        CSSValue cSSValue = layoutElement.getLayoutContext().getValue(styleKey);
        if (!(cSSValue instanceof CSSValueList)) {
            return;
        }
        CSSValueList cSSValueList = (CSSValueList)cSSValue;
        for (int i = 0; i < cSSValueList.getLength(); ++i) {
            CSSValuePair cSSValuePair;
            CSSValue cSSValue2;
            CSSValue cSSValue3 = cSSValueList.getItem(i);
            if (!(cSSValue3 instanceof CSSValuePair) || !((cSSValue2 = (cSSValuePair = (CSSValuePair)cSSValue3).getFirstValue()) instanceof CSSConstant)) continue;
            CSSValue cSSValue4 = cSSValuePair.getSecondValue();
            int n = this.parseCounterValue(cSSValue4, layoutElement);
            layoutElement.incrementCounter(cSSValue2.getCSSText(), n);
        }
    }

    private int parseCounterValue(CSSValue cSSValue, LayoutElement layoutElement) {
        if (cSSValue instanceof CSSNumericValue) {
            CSSNumericValue cSSNumericValue = (CSSNumericValue)cSSValue;
            return (int)cSSNumericValue.getValue();
        }
        if (cSSValue instanceof CSSAttrFunction) {
            CSSAttrFunction cSSAttrFunction = (CSSAttrFunction)cSSValue;
            String string = cSSAttrFunction.getName();
            String string2 = cSSAttrFunction.getNamespace();
            Object object = layoutElement.getLayoutContext().getAttributes().getAttribute(string2, string);
            if (object instanceof Number) {
                Number number = (Number)object;
                return number.intValue();
            }
        }
        return 0;
    }
}

