/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.table;

import org.jfree.layouting.input.style.keys.table.TableStyleKeys;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.RenderBox;

public class TableColumnGroupNode
extends RenderBox {
    private int colspan;

    public TableColumnGroupNode(BoxDefinition boxDefinition) {
        super(boxDefinition);
    }

    public void appyStyle(LayoutContext layoutContext, OutputProcessorMetaData outputProcessorMetaData) {
        super.appyStyle(layoutContext, outputProcessorMetaData);
        CSSValue cSSValue = layoutContext.getValue(TableStyleKeys.COL_SPAN);
        this.colspan = (int)CSSValueResolverUtility.getNumericValue(cSSValue, 1.0);
    }

    public int getColSpan() {
        return this.colspan;
    }

    public boolean isDiscardable() {
        return false;
    }

    public boolean isIgnorableForRendering() {
        return true;
    }
}

