/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.table;

import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowInfoStructure;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.model.table.cols.TableColumnModel;

public class TableRowRenderBox
extends BlockRenderBox {
    private boolean autoGenerated;
    private TableRowInfoStructure infoStructure;

    public TableRowRenderBox(BoxDefinition boxDefinition, boolean bl) {
        super(boxDefinition);
        this.autoGenerated = bl;
        this.infoStructure = new TableRowInfoStructure();
        this.setMajorAxis(0);
        this.setMinorAxis(1);
    }

    public TableRowInfoStructure getRowInfoStructure() {
        return this.infoStructure;
    }

    public boolean isIgnorableForRendering() {
        if (this.autoGenerated) {
            return false;
        }
        return super.isIgnorableForRendering();
    }

    public TableRenderBox getTable() {
        RenderBox renderBox = this.getParent();
        if (renderBox instanceof TableSectionRenderBox) {
            TableSectionRenderBox tableSectionRenderBox = (TableSectionRenderBox)renderBox;
            return tableSectionRenderBox.getTable();
        }
        return null;
    }

    public TableColumnModel getColumnModel() {
        TableRenderBox tableRenderBox = this.getTable();
        if (tableRenderBox == null) {
            return null;
        }
        return tableRenderBox.getColumnModel();
    }

    public Object clone() {
        try {
            TableRowRenderBox tableRowRenderBox = (TableRowRenderBox)super.clone();
            if (!this.infoStructure.isValidationDone()) {
                tableRowRenderBox.infoStructure = (TableRowInfoStructure)this.infoStructure.clone();
            }
            return tableRowRenderBox;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Clone not supported is not supported.");
        }
    }
}

