/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.table;

import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.cols.TableColumnModel;
import org.jfree.layouting.renderer.model.table.rows.SeparateRowModel;
import org.jfree.layouting.renderer.model.table.rows.TableRowModel;

public class TableSectionRenderBox
extends BlockRenderBox {
    private CSSValue displayRole;
    private TableRowModel rowModel = new SeparateRowModel(this);
    private boolean structureValidated;

    public TableSectionRenderBox(BoxDefinition boxDefinition) {
        super(boxDefinition);
    }

    public void appyStyle(LayoutContext layoutContext, OutputProcessorMetaData outputProcessorMetaData) {
        super.appyStyle(layoutContext, outputProcessorMetaData);
        this.displayRole = layoutContext.getValue(BoxStyleKeys.DISPLAY_ROLE);
    }

    public CSSValue getDisplayRole() {
        return this.displayRole;
    }

    public TableRenderBox getTable() {
        RenderBox renderBox = this.getParent();
        if (renderBox instanceof TableRenderBox) {
            return (TableRenderBox)renderBox;
        }
        throw new IllegalStateException("A table section without a table is invalid.");
    }

    public TableColumnModel getColumnModel() {
        TableRenderBox tableRenderBox = this.getTable();
        if (tableRenderBox == null) {
            return null;
        }
        return tableRenderBox.getColumnModel();
    }

    public TableRowModel getRowModel() {
        return this.rowModel;
    }

    public boolean isStructureValidated() {
        return this.structureValidated;
    }

    public void setStructureValidated(boolean bl) {
        this.structureValidated = bl;
    }
}

