/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.table.cols;

import java.util.ArrayList;
import org.jfree.layouting.renderer.border.Border;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.table.cols.TableColumn;
import org.jfree.layouting.renderer.model.table.cols.TableColumnGroup;
import org.jfree.layouting.renderer.model.table.cols.TableColumnModel;

public abstract class AbstractColumnModel
implements TableColumnModel {
    private boolean validated;
    private boolean incrementalModeSupported = true;
    private ArrayList columnGroups = new ArrayList();
    private TableColumn[] columns = null;

    public void addColumnGroup(TableColumnGroup tableColumnGroup) {
        this.columnGroups.add(tableColumnGroup);
        tableColumnGroup.freeze();
        this.validated = false;
    }

    public void addAutoColumn() {
        TableColumnGroup tableColumnGroup = new TableColumnGroup();
        TableColumn tableColumn = new TableColumn(Border.createEmptyBorder(), RenderLength.AUTO, true);
        tableColumnGroup.addColumn(tableColumn);
        tableColumnGroup.freeze();
        this.columnGroups.add(tableColumnGroup);
        this.validated = false;
    }

    public boolean isIncrementalModeSupported() {
        return this.incrementalModeSupported;
    }

    public int getColumnGroupCount() {
        return this.columnGroups.size();
    }

    public int getColumnCount() {
        this.buildColumns();
        return this.columns.length;
    }

    private void buildColumns() {
        if (this.validated) {
            return;
        }
        ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>();
        for (int i = 0; i < this.columnGroups.size(); ++i) {
            TableColumnGroup tableColumnGroup = (TableColumnGroup)this.columnGroups.get(i);
            int n = tableColumnGroup.getColumnCount();
            for (int j = 0; j < n; ++j) {
                TableColumn tableColumn = tableColumnGroup.getColumn(j);
                arrayList.add(tableColumn);
            }
        }
        this.columns = arrayList.toArray(new TableColumn[arrayList.size()]);
        this.validated = true;
    }

    public TableColumnGroup getColumnGroup(int n) {
        return (TableColumnGroup)this.columnGroups.get(n);
    }

    public TableColumn getColumn(int n) {
        this.buildColumns();
        return this.columns[n];
    }

    public TableColumn[] getColumns() {
        this.buildColumns();
        return this.columns;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public long getBorderSpacing() {
        return 0L;
    }

    public TableColumnGroup getGroupForIndex(int n) {
        int n2 = 0;
        for (int i = 0; i < this.columnGroups.size(); ++i) {
            TableColumnGroup tableColumnGroup = (TableColumnGroup)this.columnGroups.get(i);
            if (n2 + tableColumnGroup.getColumnCount() <= n) {
                n2 += tableColumnGroup.getColumnCount();
                continue;
            }
            return tableColumnGroup;
        }
        throw new IndexOutOfBoundsException("No such group");
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractColumnModel abstractColumnModel = (AbstractColumnModel)super.clone();
        abstractColumnModel.columns = null;
        abstractColumnModel.validated = false;
        abstractColumnModel.columnGroups = (ArrayList)this.columnGroups.clone();
        return abstractColumnModel;
    }
}

