/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.table.rows;

import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.model.table.rows.AbstractRowModel;
import org.jfree.layouting.renderer.model.table.rows.TableRow;

public class SeparateRowModel
extends AbstractRowModel {
    private long preferredSize;
    private boolean validatedSize;
    private long rowSpacing;

    public SeparateRowModel(TableSectionRenderBox tableSectionRenderBox) {
        super(tableSectionRenderBox);
    }

    public long getPreferredSize() {
        this.validateSizes();
        return this.preferredSize;
    }

    public long getRowSpacing() {
        return this.rowSpacing;
    }

    public void validateSizes() {
        int n;
        Object object;
        if (this.validatedSize) {
            return;
        }
        int n2 = 0;
        TableRow[] tableRowArray = this.getRows();
        int n3 = tableRowArray.length;
        for (int i = 0; i < n3; ++i) {
            object = tableRowArray[i];
            n = ((TableRow)object).getMaximumRowSpan();
            if (n <= n2) continue;
            n2 = n;
        }
        TableRenderBox tableRenderBox = this.getTableSection().getTable();
        this.rowSpacing = tableRenderBox.getRowSpacing().resolve(0L);
        this.preferredSize = (long)(n3 - 1) * this.rowSpacing;
        object = new long[n3];
        for (n = 1; n <= n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                TableRow tableRow = tableRowArray[i];
                long l = tableRow.getPreferredSize(n);
                this.distribute(l, (long[])object, i, n);
            }
        }
        for (n = 0; n < n3; ++n) {
            this.preferredSize += object[n];
            TableRow tableRow = tableRowArray[n];
            tableRow.setPreferredSize((long)object[n]);
        }
        this.validatedSize = true;
    }

    public void validateActualSizes() {
        int n;
        int n2;
        this.validateSizes();
        int n3 = 0;
        TableRow[] tableRowArray = this.getRows();
        int n4 = tableRowArray.length;
        for (int i = 0; i < n4; ++i) {
            TableRow tableRow = tableRowArray[i];
            n2 = tableRow.getMaxValidatedRowSpan();
            if (n2 <= n3) continue;
            n3 = n2;
        }
        long[] lArray = new long[n4];
        for (n = 1; n <= n3; ++n) {
            for (n2 = 0; n2 < lArray.length; ++n2) {
                TableRow tableRow = tableRowArray[n2];
                long l = tableRow.getValidatedTrailingSize(n);
                this.distribute(l, lArray, n2, n);
            }
        }
        for (n = 0; n < lArray.length; ++n) {
            TableRow tableRow = tableRowArray[n];
            long l = lArray[n] + tableRow.getValidatedLeadingSize();
            tableRow.setValidateSize(Math.max(tableRow.getPreferredSize(), l));
        }
    }

    private void distribute(long l, long[] lArray, int n, int n2) {
        int n3 = Math.min(n + n2, lArray.length) - n;
        long l2 = 0L;
        int n4 = Math.min(lArray.length, n + n3);
        for (int i = n; i < n4; ++i) {
            l2 += lArray[i];
        }
        if (l <= l2) {
            return;
        }
        long l3 = l - l2;
        long l4 = l3 / (long)n3;
        for (int i = 0; i < n3 - 1; ++i) {
            lArray[n + i] = l4;
        }
        lArray[n + n3 - 1] = l3 - (long)(n3 - 1) * l4;
    }

    public void clear() {
        for (TableRow tableRow : this.getRows()) {
            tableRow.clear();
        }
    }
}

