/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.encoding;

import org.pentaho.reporting.libraries.fonts.encoding.ByteBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointBuffer;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingCore;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingErrorType;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingException;
import org.pentaho.reporting.libraries.fonts.encoding.External8BitEncodingData;

public final class External8BitEncodingCore
implements EncodingCore {
    private char[] byteToChar;
    private byte[] charToByte;

    public External8BitEncodingCore(External8BitEncodingData resource) {
        int i;
        if (resource == null) {
            throw new NullPointerException();
        }
        int[] indexDelta = resource.getIndexDelta();
        int[] valueDelta = resource.getValueDelta();
        this.byteToChar = new char[256];
        int encodingLength = this.byteToChar.length;
        for (int i2 = 0; i2 < encodingLength; ++i2) {
            this.byteToChar[i2] = (char)i2;
        }
        int index = 0;
        int value = 0;
        int indexDeltaLength = indexDelta.length;
        for (i = 0; i < indexDeltaLength; ++i) {
            this.byteToChar[index += indexDelta[i]] = (char)(value += valueDelta[i]);
        }
        this.charToByte = new byte[65536];
        for (i = 0; i < encodingLength; ++i) {
            this.charToByte[this.byteToChar[i]] = (byte)i;
        }
    }

    public boolean isUnicodeCharacterSupported(int c) {
        if (c == 0) {
            return true;
        }
        return this.charToByte[c] != 0;
    }

    public ByteBuffer encode(CodePointBuffer text, ByteBuffer buffer) {
        int textLength = text.getLength();
        if (buffer == null) {
            buffer = new ByteBuffer(textLength);
        } else if (buffer.getLength() < textLength) {
            buffer.ensureSize(textLength);
        }
        byte[] targetArray = buffer.getData();
        int[] sourceArray = text.getData();
        int targetIdx = buffer.getOffset();
        int endPos = text.getCursor();
        for (int i = text.getOffset(); i < endPos; ++i) {
            int sourceItem = sourceArray[i];
            if (!this.isUnicodeCharacterSupported(sourceItem)) continue;
            targetArray[targetIdx] = this.charToByte[sourceItem & 0xFFFF];
            ++targetIdx;
        }
        buffer.setCursor(targetIdx);
        return buffer;
    }

    public ByteBuffer encode(CodePointBuffer text, ByteBuffer buffer, EncodingErrorType errorHandling) throws EncodingException {
        int textLength = text.getLength();
        if (buffer == null) {
            buffer = new ByteBuffer(textLength);
        } else if (buffer.getLength() < textLength) {
            buffer.ensureSize(textLength);
        }
        byte[] targetArray = buffer.getData();
        int[] sourceArray = text.getData();
        int targetIdx = buffer.getOffset();
        int endPos = text.getCursor();
        for (int i = text.getOffset(); i < endPos; ++i) {
            int sourceItem = sourceArray[i];
            if (this.isUnicodeCharacterSupported(sourceItem)) {
                targetArray[targetIdx] = this.charToByte[sourceItem & 0xFFFF];
                ++targetIdx;
                continue;
            }
            if (EncodingErrorType.REPLACE.equals(errorHandling)) {
                targetArray[targetIdx] = 63;
                ++targetIdx;
                continue;
            }
            if (!EncodingErrorType.FAIL.equals(errorHandling)) continue;
            throw new EncodingException();
        }
        buffer.setCursor(targetIdx);
        return buffer;
    }

    public CodePointBuffer decode(ByteBuffer text, CodePointBuffer buffer) {
        int textLength = text.getLength();
        if (buffer == null) {
            buffer = new CodePointBuffer(textLength);
        } else if (buffer.getLength() < textLength) {
            buffer.ensureSize(textLength);
        }
        int[] targetArray = buffer.getData();
        byte[] sourceArray = text.getData();
        int targetIdx = buffer.getOffset();
        int endPos = text.getCursor();
        for (int i = text.getOffset(); i < endPos; ++i) {
            targetArray[targetIdx] = this.byteToChar[sourceArray[i] & 0xFF];
            ++targetIdx;
        }
        buffer.setCursor(targetIdx);
        return buffer;
    }

    public CodePointBuffer decode(ByteBuffer text, CodePointBuffer buffer, EncodingErrorType errorHandling) {
        int textLength = text.getLength();
        if (buffer == null) {
            buffer = new CodePointBuffer(textLength);
        } else if (buffer.getLength() < textLength) {
            buffer.ensureSize(textLength);
        }
        int[] targetArray = buffer.getData();
        byte[] sourceArray = text.getData();
        int targetIdx = buffer.getOffset();
        int endPos = text.getCursor();
        for (int i = text.getOffset(); i < endPos; ++i) {
            targetArray[targetIdx] = this.byteToChar[sourceArray[i] & 0xFF];
            ++targetIdx;
        }
        buffer.setCursor(targetIdx);
        return buffer;
    }
}

