/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.beans.PropertyValue;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.PropertyNames;

public abstract class Configuration {
    public static Object getConfigurationRoot(XMultiServiceFactory xmsf, String sPath, boolean updateable) throws Exception {
        Object oConfigProvider = xmsf.createInstance("com.sun.star.configuration.ConfigurationProvider");
        XMultiServiceFactory confMsf = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)oConfigProvider);
        String sView = updateable ? "com.sun.star.configuration.ConfigurationUpdateAccess" : "com.sun.star.configuration.ConfigurationAccess";
        Object[] args = new Object[updateable ? 2 : 1];
        PropertyValue aPathArgument = new PropertyValue();
        aPathArgument.Name = "nodepath";
        aPathArgument.Value = sPath;
        args[0] = aPathArgument;
        if (updateable) {
            PropertyValue aModeArgument = new PropertyValue();
            aModeArgument.Name = "lazywrite";
            aModeArgument.Value = Boolean.FALSE;
            args[1] = aModeArgument;
        }
        return confMsf.createInstanceWithArguments(sView, args);
    }

    public static String getProductName(XMultiServiceFactory xMSF) {
        try {
            Object oProdNameAccess = Configuration.getConfigurationRoot(xMSF, "org.openoffice.Setup/Product", false);
            return (String)Helper.getUnoObjectbyName(oProdNameAccess, "ooName");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    private static String getLocaleString(XMultiServiceFactory xMSF, String root, String key) {
        String sLocale = PropertyNames.EMPTY_STRING;
        try {
            Object oMasterKey = Configuration.getConfigurationRoot(xMSF, root, false);
            sLocale = (String)Helper.getUnoObjectbyName(oMasterKey, key);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        if (!(sLocale.length() != 0 || key.equals("Locale") && root.equals("org.openoffice.System/L10N/"))) {
            return Configuration.getLocaleString(xMSF, "org.openoffice.System/L10N/", "Locale");
        }
        return sLocale;
    }

    private static Locale getLocale(XMultiServiceFactory xMSF, String root, String key) {
        Locale aLocLocale = new Locale();
        String sLocale = Configuration.getLocaleString(xMSF, root, key);
        String[] sLocaleList = JavaTools.ArrayoutofString(sLocale, "-");
        aLocLocale.Language = sLocaleList[0];
        if (sLocaleList.length > 1) {
            aLocLocale.Country = sLocaleList[1];
        }
        return aLocLocale;
    }

    public static Locale getLocale(XMultiServiceFactory xMSF) {
        return Configuration.getLocale(xMSF, "org.openoffice.Setup/L10N/", "ooSetupSystemLocale");
    }

    public static String[] getNodeDisplayNames(XNameAccess _xNameAccessNode) {
        return Configuration.getNodeChildNames(_xNameAccessNode, PropertyNames.PROPERTY_NAME);
    }

    public static String[] getNodeChildNames(XNameAccess xNameAccessNode, String _schildname) {
        String[] snames = null;
        try {
            snames = xNameAccessNode.getElementNames();
            String[] sdisplaynames = new String[snames.length];
            for (int i = 0; i < snames.length; ++i) {
                Object oContent = Helper.getUnoPropertyValue(xNameAccessNode.getByName(snames[i]), _schildname);
                sdisplaynames[i] = !AnyConverter.isVoid((Object)oContent) ? (String)Helper.getUnoPropertyValue(xNameAccessNode.getByName(snames[i]), _schildname) : snames[i];
            }
            return sdisplaynames;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return snames;
        }
    }

    public static XNameAccess getChildNodebyIndex(XNameAccess _xNameAccess, int _index) throws Exception {
        String[] snames = _xNameAccess.getElementNames();
        Object oNode = _xNameAccess.getByName(snames[_index]);
        return (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)oNode);
    }

    public static XNameAccess getChildNodebyName(XNameAccess _xNameAccessNode, String _SubNodeName) {
        try {
            if (_xNameAccessNode.hasByName(_SubNodeName)) {
                return (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)_xNameAccessNode.getByName(_SubNodeName));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return null;
    }

    public static XNameAccess getChildNodebyDisplayName(XMultiServiceFactory _xMSF, Locale _aLocale, XNameAccess _xNameAccessNode, String _displayname, String _nodename, int _nmaxcharcount) {
        String[] snames = null;
        try {
            snames = _xNameAccessNode.getElementNames();
            for (int i = 0; i < snames.length; ++i) {
                String curdisplayname = (String)Helper.getUnoPropertyValue(_xNameAccessNode.getByName(snames[i]), _nodename);
                if (_nmaxcharcount > 0 && _nmaxcharcount < curdisplayname.length()) {
                    curdisplayname = curdisplayname.substring(0, _nmaxcharcount);
                }
                if (!(curdisplayname = Desktop.removeSpecialCharacters(_xMSF, _aLocale, curdisplayname)).equals(_displayname)) continue;
                return (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)_xNameAccessNode.getByName(snames[i]));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return null;
    }
}

