/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.deps.behavior;

import net.adaptivebox.deps.behavior.AbsGTBehavior;
import net.adaptivebox.global.RandomGenerator;
import net.adaptivebox.goodness.IGoodnessCompareEngine;
import net.adaptivebox.knowledge.ILibEngine;
import net.adaptivebox.knowledge.Library;
import net.adaptivebox.knowledge.SearchPoint;
import net.adaptivebox.problem.ProblemEncoder;

public class DEGTBehavior
extends AbsGTBehavior
implements ILibEngine {
    private static final int DVNum = 2;
    public double FACTOR = 0.5;
    public double CR = 0.9;
    private SearchPoint pbest_t;

    public void setPbest(SearchPoint pbest) {
        this.pbest_t = pbest;
    }

    public void generateBehavior(SearchPoint trailPoint, ProblemEncoder problemEncoder) {
        SearchPoint gbest_t = this.socialLib.getGbest();
        SearchPoint[] referPoints = this.getReferPoints();
        int DIMENSION = problemEncoder.getDesignSpace().getDimension();
        int rj = RandomGenerator.intRangeRandom(0, DIMENSION - 1);
        for (int k = 0; k < DIMENSION; ++k) {
            if (Math.random() < this.CR || k == DIMENSION - 1) {
                double Dabcd = 0.0;
                for (int i = 0; i < referPoints.length; ++i) {
                    Dabcd += Math.pow(-1.0, i % 2) * referPoints[i].getLocation()[rj];
                }
                trailPoint.getLocation()[rj] = gbest_t.getLocation()[rj] + this.FACTOR * Dabcd;
            } else {
                trailPoint.getLocation()[rj] = this.pbest_t.getLocation()[rj];
            }
            rj = (rj + 1) % DIMENSION;
        }
    }

    public void testBehavior(SearchPoint trailPoint, IGoodnessCompareEngine qualityComparator) {
        Library.replace(qualityComparator, trailPoint, this.pbest_t);
    }

    private SearchPoint[] getReferPoints() {
        SearchPoint[] referPoints = new SearchPoint[4];
        for (int i = 0; i < referPoints.length; ++i) {
            referPoints[i] = this.socialLib.getSelectedPoint(RandomGenerator.intRangeRandom(0, this.socialLib.getPopSize() - 1));
        }
        return referPoints;
    }
}

