/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.text;

import com.sun.star.awt.Size;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.style.XStyleLoader;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.PropertyNames;

public class TextStyleHandler {
    public XStyleFamiliesSupplier xStyleFamiliesSupplier;

    public TextStyleHandler(XTextDocument xTextDocument) {
        this.xStyleFamiliesSupplier = (XStyleFamiliesSupplier)UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)xTextDocument);
    }

    public void loadStyleTemplates(String sTemplateUrl, String OptionString) {
        try {
            XStyleLoader xStyleLoader = (XStyleLoader)UnoRuntime.queryInterface(XStyleLoader.class, (Object)this.xStyleFamiliesSupplier.getStyleFamilies());
            PropertyValue[] StyleOptions = xStyleLoader.getStyleLoaderOptions();
            String CurOptionName = PropertyNames.EMPTY_STRING;
            int PropCount = StyleOptions.length;
            for (int i = 0; i < PropCount; ++i) {
                CurOptionName = StyleOptions[i].Name;
                StyleOptions[i].Value = CurOptionName.equals(OptionString) || CurOptionName.equals("OverwriteStyles");
            }
            xStyleLoader.loadStylesFromURL(sTemplateUrl, StyleOptions);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public XPropertySet getStyleByName(String sStyleFamily, String sStyleName) {
        try {
            XPropertySet xPropertySet = null;
            Object oStyleFamily = this.xStyleFamiliesSupplier.getStyleFamilies().getByName(sStyleFamily);
            XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)oStyleFamily);
            if (xNameAccess.hasByName(sStyleName)) {
                xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xNameAccess.getByName(sStyleName));
            }
            return xPropertySet;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public Size changePageAlignment(XPropertySet _xPropPageStyle, boolean _bIsLandscape) {
        try {
            _xPropPageStyle.setPropertyValue("IsLandscape", (Object)_bIsLandscape);
            Size aPageSize = (Size)AnyConverter.toObject(Size.class, (Object)_xPropPageStyle.getPropertyValue("Size"));
            int nPageWidth = aPageSize.Width;
            int nPageHeight = aPageSize.Height;
            Size aSize = new Size(nPageHeight, nPageWidth);
            _xPropPageStyle.setPropertyValue("Size", (Object)aSize);
            return (Size)AnyConverter.toObject(Size.class, (Object)_xPropPageStyle.getPropertyValue("Size"));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }
}

