/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.content;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.jfree.layouting.DocumentContextUtility;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.content.ContentStyleKeys;
import org.jfree.layouting.input.style.keys.content.ContentValues;
import org.jfree.layouting.input.style.values.CSSAttrFunction;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSStringType;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.content.computed.CloseQuoteToken;
import org.jfree.layouting.layouter.content.computed.ContentsToken;
import org.jfree.layouting.layouter.content.computed.CounterToken;
import org.jfree.layouting.layouter.content.computed.OpenQuoteToken;
import org.jfree.layouting.layouter.content.statics.ExternalContentToken;
import org.jfree.layouting.layouter.content.statics.ResourceContentToken;
import org.jfree.layouting.layouter.content.statics.StaticTextToken;
import org.jfree.layouting.layouter.context.ContentSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.counters.CounterStyle;
import org.jfree.layouting.layouter.counters.CounterStyleFactory;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.FunctionFactory;
import org.jfree.layouting.layouter.style.functions.values.StyleValueFunction;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;
import org.jfree.layouting.layouter.style.values.CSSRawValue;
import org.jfree.layouting.layouter.style.values.CSSResourceValue;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class StringSetResolveHandler
implements ResolveHandler {
    private static final ContentToken[] DEFAULT_CONTENT = new ContentToken[0];
    private HashMap tokenMapping = new HashMap();

    public StringSetResolveHandler() {
        this.tokenMapping.put(ContentValues.CONTENTS, ContentsToken.CONTENTS);
        this.tokenMapping.put(ContentValues.OPEN_QUOTE, new OpenQuoteToken(false));
        this.tokenMapping.put(ContentValues.NO_OPEN_QUOTE, new OpenQuoteToken(true));
        this.tokenMapping.put(ContentValues.CLOSE_QUOTE, new CloseQuoteToken(false));
        this.tokenMapping.put(ContentValues.NO_CLOSE_QUOTE, new CloseQuoteToken(true));
    }

    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{ContentStyleKeys.COUNTER_RESET, ContentStyleKeys.COUNTER_INCREMENT, ContentStyleKeys.QUOTES, ContentStyleKeys.STRING_DEFINE};
    }

    public void resolve(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        Object object;
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        ContentSpecification contentSpecification = layoutContext.getContentSpecification();
        CSSValue cSSValue = layoutContext.getValue(styleKey);
        if (cSSValue instanceof CSSConstant && ContentValues.NONE.equals(cSSValue)) {
            contentSpecification.setStrings(DEFAULT_CONTENT);
            return;
        }
        contentSpecification.setStrings(DEFAULT_CONTENT);
        if (cSSValue instanceof CSSAttrFunction) {
            object = this.evaluateFunction((CSSFunctionValue)cSSValue, layoutProcess, layoutElement);
            if (object == null) {
                return;
            }
            contentSpecification.setStrings(new ContentToken[]{object});
        }
        if (!(cSSValue instanceof CSSValueList)) {
            return;
        }
        object = new ArrayList();
        CSSValueList cSSValueList = (CSSValueList)cSSValue;
        int n = cSSValueList.getLength();
        block0: for (int i = 0; i < n; ++i) {
            CSSValueList cSSValueList2 = (CSSValueList)cSSValueList.getItem(i);
            for (int j = 0; j < cSSValueList2.getLength(); ++j) {
                CSSValue cSSValue2 = cSSValueList2.getItem(j);
                ContentToken contentToken = this.createToken(layoutProcess, layoutElement, cSSValue2);
                if (contentToken == null) {
                    ((ArrayList)object).clear();
                    continue block0;
                }
                ((ArrayList)object).add(contentToken);
            }
        }
        ContentToken[] contentTokenArray = ((ArrayList)object).toArray(new ContentToken[((ArrayList)object).size()]);
        contentSpecification.setStrings(contentTokenArray);
    }

    private ContentToken createToken(LayoutProcess layoutProcess, LayoutElement layoutElement, CSSValue cSSValue) {
        if (cSSValue instanceof CSSStringValue) {
            CSSStringValue cSSStringValue = (CSSStringValue)cSSValue;
            if (CSSStringType.STRING.equals(cSSStringValue.getType())) {
                return new StaticTextToken(cSSStringValue.getValue());
            }
            CSSFunctionValue cSSFunctionValue = new CSSFunctionValue("url", new CSSValue[]{cSSStringValue});
            return this.evaluateFunction(cSSFunctionValue, layoutProcess, layoutElement);
        }
        if (cSSValue instanceof CSSFunctionValue) {
            return this.evaluateFunction((CSSFunctionValue)cSSValue, layoutProcess, layoutElement);
        }
        if (cSSValue instanceof CSSConstant) {
            if (ContentValues.DOCUMENT_URL.equals(cSSValue)) {
                Object object = layoutProcess.getDocumentContext().getMetaAttribute("document-url");
                if (object != null) {
                    return new StaticTextToken(String.valueOf(object));
                }
                ResourceKey resourceKey = DocumentContextUtility.getBaseResource(layoutProcess.getDocumentContext());
                ResourceManager resourceManager = DocumentContextUtility.getResourceManager(layoutProcess.getDocumentContext());
                URL uRL = resourceManager.toURL(resourceKey);
                if (uRL != null) {
                    return new StaticTextToken(uRL.toExternalForm());
                }
                return null;
            }
            ContentToken contentToken = (ContentToken)this.tokenMapping.get(cSSValue);
            if (contentToken != null) {
                return contentToken;
            }
            return this.resolveContentAlias(cSSValue);
        }
        return null;
    }

    private ContentToken resolveContentAlias(CSSValue cSSValue) {
        if (ContentValues.FOOTNOTE.equals(cSSValue)) {
            CounterStyle counterStyle = CounterStyleFactory.getInstance().getCounterStyle("normal");
            return new CounterToken("footnote", counterStyle);
        }
        if (ContentValues.ENDNOTE.equals(cSSValue)) {
            CounterStyle counterStyle = CounterStyleFactory.getInstance().getCounterStyle("normal");
            return new CounterToken("endnote", counterStyle);
        }
        if (ContentValues.SECTIONNOTE.equals(cSSValue)) {
            CounterStyle counterStyle = CounterStyleFactory.getInstance().getCounterStyle("normal");
            return new CounterToken("section-note", counterStyle);
        }
        if (ContentValues.LISTITEM.equals(cSSValue)) {
            CounterStyle counterStyle = CounterStyleFactory.getInstance().getCounterStyle("normal");
            return new CounterToken("list-item", counterStyle);
        }
        return null;
    }

    private ContentToken evaluateFunction(CSSFunctionValue cSSFunctionValue, LayoutProcess layoutProcess, LayoutElement layoutElement) {
        StyleValueFunction styleValueFunction = FunctionFactory.getInstance().getStyleFunction(cSSFunctionValue.getFunctionName());
        try {
            CSSValue cSSValue = styleValueFunction.evaluate(layoutProcess, layoutElement, cSSFunctionValue);
            if (cSSValue instanceof CSSResourceValue) {
                CSSResourceValue cSSResourceValue = (CSSResourceValue)cSSValue;
                return new ResourceContentToken(cSSResourceValue.getValue());
            }
            if (cSSValue instanceof CSSStringValue) {
                CSSStringValue cSSStringValue = (CSSStringValue)cSSValue;
                return new StaticTextToken(cSSStringValue.getValue());
            }
            if (cSSValue instanceof CSSRawValue) {
                CSSRawValue cSSRawValue = (CSSRawValue)cSSValue;
                return new ExternalContentToken(cSSRawValue.getValue());
            }
            return new StaticTextToken(cSSValue.getCSSText());
        }
        catch (FunctionEvaluationException functionEvaluationException) {
            return null;
        }
    }
}

