/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableReplacedContent;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.process.IterateVisualProcessStep;
import org.jfree.layouting.util.geom.StrictDimension;

public class ComputeICMMetricsStep
extends IterateVisualProcessStep {
    public void compute(LogicalPageBox logicalPageBox) {
        this.startProcessing(logicalPageBox);
    }

    protected void processParagraphChilds(ParagraphRenderBox paragraphRenderBox) {
        this.processBoxChilds(paragraphRenderBox.getLineboxContainer());
    }

    protected boolean startBlockLevelBox(RenderBox renderBox) {
        return true;
    }

    protected boolean startInlineLevelBox(RenderBox renderBox) {
        return true;
    }

    protected void finishInlineLevelBox(RenderBox renderBox) {
        ComputedLayoutProperties computedLayoutProperties = renderBox.getComputedLayoutProperties();
        long l = computedLayoutProperties.getBorderLeft() + computedLayoutProperties.getBorderRight() + computedLayoutProperties.getPaddingLeft() + computedLayoutProperties.getPaddingRight() + computedLayoutProperties.getMarginLeft() + computedLayoutProperties.getMarginRight();
        long l2 = 0L;
        long l3 = 0L;
        for (RenderNode renderNode = renderBox.getVisibleFirst(); renderNode != null; renderNode = renderNode.getVisibleNext()) {
            l3 += renderNode.getMaximumBoxWidth();
            long l4 = renderNode.getMinimumChunkWidth();
            if (l4 <= l2) continue;
            l2 = l4;
        }
        renderBox.setMinimumChunkWidth(l + l2);
        renderBox.setMaximumBoxWidth(l + l3);
        renderBox.setIcmMetricsFinished(!renderBox.isOpen());
    }

    protected void finishBlockLevelBox(RenderBox renderBox) {
        ComputedLayoutProperties computedLayoutProperties = renderBox.getComputedLayoutProperties();
        long l = computedLayoutProperties.getBorderLeft() + computedLayoutProperties.getBorderRight() + computedLayoutProperties.getPaddingLeft() + computedLayoutProperties.getPaddingRight() + computedLayoutProperties.getMarginLeft() + computedLayoutProperties.getMarginRight();
        if (renderBox instanceof ParagraphRenderBox) {
            ParagraphRenderBox paragraphRenderBox = (ParagraphRenderBox)renderBox;
            BlockRenderBox blockRenderBox = paragraphRenderBox.getLineboxContainer();
            renderBox.setMinimumChunkWidth(l + blockRenderBox.getMinimumChunkWidth());
            renderBox.setMaximumBoxWidth(l + blockRenderBox.getMaximumBoxWidth());
            renderBox.setIcmMetricsFinished(!renderBox.isOpen());
            return;
        }
        long l2 = 0L;
        long l3 = 0L;
        for (RenderNode renderNode = renderBox.getVisibleFirst(); renderNode != null; renderNode = renderNode.getVisibleNext()) {
            long l4;
            long l5 = renderNode.getMinimumChunkWidth();
            if (l5 > l2) {
                l2 = l5;
            }
            if ((l4 = renderNode.getMaximumBoxWidth()) <= l3) continue;
            l3 = l4;
        }
        renderBox.setMinimumChunkWidth(l + l2);
        renderBox.setMaximumBoxWidth(l + l3);
        renderBox.setIcmMetricsFinished(!renderBox.isOpen());
    }

    protected void processInlineLevelNode(RenderNode renderNode) {
        if (renderNode.isIcmMetricsFinished()) {
            return;
        }
        if (renderNode instanceof RenderableReplacedContent) {
            RenderableReplacedContent renderableReplacedContent = (RenderableReplacedContent)renderNode;
            RenderLength renderLength = renderableReplacedContent.getRequestedWidth();
            StrictDimension strictDimension = renderableReplacedContent.getContentSize();
            if (renderLength == RenderLength.AUTO) {
                renderNode.setMaximumBoxWidth(strictDimension.getWidth());
            } else {
                renderNode.setMaximumBoxWidth(renderLength.resolve(strictDimension.getWidth()));
            }
            renderNode.setMinimumChunkWidth(0L);
            renderNode.setIcmMetricsFinished(true);
        }
    }

    protected void processBlockLevelNode(RenderNode renderNode) {
        if (renderNode.isIcmMetricsFinished()) {
            return;
        }
        if (renderNode instanceof RenderableReplacedContent) {
            RenderableReplacedContent renderableReplacedContent = (RenderableReplacedContent)renderNode;
            RenderLength renderLength = renderableReplacedContent.getRequestedWidth();
            StrictDimension strictDimension = renderableReplacedContent.getContentSize();
            if (renderLength == RenderLength.AUTO) {
                renderNode.setMaximumBoxWidth(strictDimension.getWidth());
            } else {
                renderNode.setMaximumBoxWidth(renderLength.resolve(strictDimension.getWidth()));
            }
            renderNode.setMinimumChunkWidth(0L);
            renderNode.setIcmMetricsFinished(true);
        }
    }
}

