/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.input.style.keys.text.TextAlign;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.FinishedRenderNode;
import org.jfree.layouting.renderer.model.InlineRenderBox;
import org.jfree.layouting.renderer.model.ParagraphPoolBox;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.PlaceholderRenderNode;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.RenderableReplacedContent;
import org.jfree.layouting.renderer.model.RenderableText;
import org.jfree.layouting.renderer.model.SpacerRenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.page.PageGrid;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.cols.TableColumn;
import org.jfree.layouting.renderer.model.table.cols.TableColumnModel;
import org.jfree.layouting.renderer.process.CenterAlignmentProcessor;
import org.jfree.layouting.renderer.process.IterateVisualProcessStep;
import org.jfree.layouting.renderer.process.LeftAlignmentProcessor;
import org.jfree.layouting.renderer.process.ParagraphBreakState;
import org.jfree.layouting.renderer.process.RightAlignmentProcessor;
import org.jfree.layouting.renderer.process.TextAlignmentProcessor;
import org.jfree.layouting.renderer.process.layoutrules.EndSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.InlineBoxSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.InlineNodeSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.InlineSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.ReplacedContentSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.SpacerSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.StartSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.TextSequenceElement;
import org.pentaho.reporting.libraries.base.util.DebugLog;

public class InfiniteMinorAxisLayoutStep
extends IterateVisualProcessStep {
    private ParagraphBreakState breakState;
    private PageGrid pageGrid;
    private RenderBox continuedElement;

    public void compute(LogicalPageBox logicalPageBox) {
        this.breakState = null;
        this.pageGrid = logicalPageBox.getPageGrid();
        this.startProcessing(logicalPageBox);
        this.pageGrid = null;
        this.breakState = null;
    }

    public void continueComputation(PageGrid pageGrid, RenderBox renderBox) {
        if (renderBox.getContentAreaX2() == 0L || renderBox.getWidth() == 0L) {
            throw new IllegalStateException("Box must be layouted a bit ..");
        }
        this.pageGrid = pageGrid;
        this.breakState = null;
        this.continuedElement = renderBox;
        this.startProcessing(renderBox);
        this.continuedElement = null;
        this.pageGrid = null;
        this.breakState = null;
    }

    protected boolean startBlockLevelBox(RenderBox renderBox) {
        if (this.breakState == null) {
            if (renderBox instanceof ParagraphRenderBox) {
                this.computeContentArea(renderBox);
                ParagraphRenderBox paragraphRenderBox = (ParagraphRenderBox)renderBox;
                if (this.continuedElement == null) {
                    boolean bl;
                    BlockRenderBox blockRenderBox = paragraphRenderBox.getLineboxContainer();
                    boolean bl2 = bl = blockRenderBox.getChangeTracker() == paragraphRenderBox.getMinorLayoutAge();
                    if (bl) {
                        return false;
                    }
                }
                paragraphRenderBox.clearLayout();
                this.breakState = new ParagraphBreakState(paragraphRenderBox);
            } else if (renderBox instanceof TableCellRenderBox) {
                this.computeCellArea((TableCellRenderBox)renderBox);
            } else {
                this.computeContentArea(renderBox);
                if (renderBox instanceof TableRenderBox) {
                    this.computeCellPositions((TableRenderBox)renderBox);
                }
            }
            return true;
        }
        if (!this.breakState.isSuspended()) {
            throw new IllegalStateException("This cannot be.");
        }
        return false;
    }

    protected void finishBlockLevelBox(RenderBox renderBox) {
        this.verifyContentWidth(renderBox);
        if (this.breakState != null) {
            Object object = this.breakState.getSuspendItem();
            if (renderBox.getInstanceId() == object) {
                this.breakState.setSuspendItem(null);
                return;
            }
            if (object != null) {
                return;
            }
            if (renderBox instanceof ParagraphRenderBox) {
                ParagraphRenderBox paragraphRenderBox = (ParagraphRenderBox)renderBox;
                paragraphRenderBox.setMinorLayoutAge(paragraphRenderBox.getLineboxContainer().getChangeTracker());
                this.breakState = null;
            }
        }
    }

    private void computeCellPositions(TableRenderBox tableRenderBox) {
        TableColumnModel tableColumnModel = tableRenderBox.getColumnModel();
        long l = 0L;
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setEffectiveCellPosition(l);
            l += tableColumn.getEffectiveSize() + tableColumnModel.getBorderSpacing();
        }
    }

    private void computeCellArea(TableCellRenderBox tableCellRenderBox) {
        int n = tableCellRenderBox.getColumnIndex();
        TableRenderBox tableRenderBox = tableCellRenderBox.getTable();
        TableColumnModel tableColumnModel = tableRenderBox.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        long l = tableColumn.getEffectiveSize();
        int n2 = tableCellRenderBox.getColSpan();
        if (n2 > 1) {
            for (int i = 1; i < n2; ++i) {
                TableColumn tableColumn2 = tableColumnModel.getColumn(n + i);
                l += tableColumn2.getEffectiveSize();
                l += tableColumnModel.getBorderSpacing();
            }
        }
        long l2 = tableColumn.getEffectiveCellPosition();
        tableCellRenderBox.setX(l2);
        tableCellRenderBox.setWidth(l);
        ComputedLayoutProperties computedLayoutProperties = tableCellRenderBox.getComputedLayoutProperties();
        long l3 = computedLayoutProperties.getBorderLeft();
        tableCellRenderBox.setContentAreaX1(l2 + (l3 += computedLayoutProperties.getPaddingLeft()));
        long l4 = computedLayoutProperties.getBorderRight();
        long l5 = l - (l4 += computedLayoutProperties.getPaddingRight());
        tableCellRenderBox.setContentAreaX2(l2 + l5);
    }

    private void computeContentArea(RenderBox renderBox) {
        if (renderBox == this.continuedElement) {
            return;
        }
        ComputedLayoutProperties computedLayoutProperties = renderBox.getComputedLayoutProperties();
        long l = this.computeX(renderBox) + computedLayoutProperties.getMarginLeft();
        renderBox.setX(l);
        long l2 = computedLayoutProperties.getBorderLeft();
        renderBox.setContentAreaX1(l + (l2 += computedLayoutProperties.getPaddingLeft()));
        RenderLength renderLength = renderBox.getComputedLayoutProperties().getComputedWidth();
        if (renderLength == RenderLength.AUTO) {
            RenderBox renderBox2 = renderBox.getParent();
            if (renderBox2 instanceof BlockRenderBox) {
                long l3 = computedLayoutProperties.getMarginRight();
                l3 += computedLayoutProperties.getBorderRight();
                BlockRenderBox blockRenderBox = (BlockRenderBox)renderBox2;
                renderBox.setContentAreaX2(blockRenderBox.getContentAreaX2() - (l3 += computedLayoutProperties.getPaddingRight()));
            } else {
                renderBox.setContentAreaX2(l + l2 + renderBox.getMinimumChunkWidth());
            }
        } else {
            long l4 = renderLength.resolve(0L);
            renderBox.setContentAreaX2(l + l2 + l4);
        }
    }

    private long computeX(RenderNode renderNode) {
        RenderBox renderBox = renderNode.getParent();
        if (renderBox == null) {
            return 0L;
        }
        return renderBox.getContentAreaX1();
    }

    private void verifyContentWidth(RenderBox renderBox) {
        long l = renderBox.getX();
        long l2 = renderBox.getContentAreaX2();
        ComputedLayoutProperties computedLayoutProperties = renderBox.getComputedLayoutProperties();
        long l3 = l2 + computedLayoutProperties.getBorderRight() + computedLayoutProperties.getPaddingRight();
        renderBox.setWidth(l3 - l);
    }

    protected boolean startInlineLevelBox(RenderBox renderBox) {
        if (this.breakState == null) {
            return true;
        }
        if (this.breakState.isSuspended()) {
            return false;
        }
        if (renderBox instanceof InlineRenderBox) {
            this.breakState.add(new StartSequenceElement((InlineRenderBox)renderBox));
            return true;
        }
        this.computeContentArea(renderBox);
        this.breakState.add(new InlineBoxSequenceElement(renderBox));
        this.breakState.setSuspendItem(renderBox.getInstanceId());
        return false;
    }

    protected void finishInlineLevelBox(RenderBox renderBox) {
        if (this.breakState == null) {
            return;
        }
        if (this.breakState.getSuspendItem() == renderBox.getInstanceId()) {
            this.breakState.setSuspendItem(null);
            return;
        }
        if (renderBox instanceof InlineRenderBox) {
            this.breakState.add(new EndSequenceElement((InlineRenderBox)renderBox));
            return;
        }
        Object object = this.breakState.getSuspendItem();
        if (renderBox.getInstanceId() == object) {
            this.breakState.setSuspendItem(null);
            return;
        }
        if (object != null) {
            return;
        }
        if (renderBox instanceof ParagraphRenderBox) {
            throw new IllegalStateException("This cannot be.");
        }
    }

    protected void processInlineLevelNode(RenderNode renderNode) {
        if (this.breakState == null || this.breakState.isSuspended()) {
            return;
        }
        if (renderNode instanceof FinishedRenderNode) {
            FinishedRenderNode finishedRenderNode = (FinishedRenderNode)renderNode;
            renderNode.setWidth(finishedRenderNode.getLayoutedWidth());
        }
        if (renderNode instanceof RenderableText) {
            this.breakState.add(new TextSequenceElement((RenderableText)renderNode));
        } else if (renderNode instanceof RenderableReplacedContent) {
            this.breakState.add(new ReplacedContentSequenceElement((RenderableReplacedContent)renderNode));
        } else if (renderNode instanceof PlaceholderRenderNode) {
            this.breakState.add(new InlineNodeSequenceElement(renderNode));
        } else if (renderNode instanceof SpacerRenderNode) {
            if (this.breakState.isContainsContent()) {
                this.breakState.add(new SpacerSequenceElement((SpacerRenderNode)renderNode));
            }
        } else {
            this.breakState.add(new InlineNodeSequenceElement(renderNode));
        }
    }

    protected void processBlockLevelNode(RenderNode renderNode) {
        long l = this.computeX(renderNode);
        renderNode.setX(l);
        if (renderNode instanceof FinishedRenderNode) {
            FinishedRenderNode finishedRenderNode = (FinishedRenderNode)renderNode;
            renderNode.setWidth(finishedRenderNode.getLayoutedWidth());
        } else {
            renderNode.setWidth(renderNode.getComputedLayoutProperties().getComputedWidth().resolve(0L));
        }
    }

    protected void processParagraphChilds(ParagraphRenderBox paragraphRenderBox) {
        BlockRenderBox blockRenderBox = paragraphRenderBox.getLineboxContainer();
        for (RenderNode renderNode = blockRenderBox.getVisibleFirst(); renderNode != null; renderNode = renderNode.getVisibleNext()) {
            if (!(renderNode instanceof ParagraphPoolBox)) {
                throw new IllegalStateException("Expected ParagraphPoolBox elements.");
            }
            InlineRenderBox inlineRenderBox = (InlineRenderBox)renderNode;
            this.startLine(inlineRenderBox);
            this.processBoxChilds(inlineRenderBox);
            this.finishLine(inlineRenderBox);
        }
    }

    protected void startLine(InlineRenderBox inlineRenderBox) {
        if (this.breakState == null) {
            return;
        }
        if (this.breakState.isSuspended()) {
            return;
        }
        this.breakState.clear();
        this.breakState.add(new StartSequenceElement(inlineRenderBox));
    }

    protected void finishLine(InlineRenderBox inlineRenderBox) {
        if (this.breakState == null || this.breakState.isSuspended()) {
            return;
        }
        this.breakState.add(new EndSequenceElement(inlineRenderBox));
        ParagraphRenderBox paragraphRenderBox = this.breakState.getParagraph();
        CSSValue cSSValue = paragraphRenderBox.getLastLineAlignment();
        CSSValue cSSValue2 = paragraphRenderBox.getTextAlignment();
        TextAlignmentProcessor textAlignmentProcessor = this.create(cSSValue2, cSSValue);
        InlineSequenceElement[] inlineSequenceElementArray = this.breakState.getSequence();
        if (inlineSequenceElementArray.length == 0) {
            return;
        }
        long l = paragraphRenderBox.getContentAreaX1();
        long l2 = paragraphRenderBox.getContentAreaX2();
        if (l2 - l <= 0L) {
            long l3 = paragraphRenderBox.getMinimumChunkWidth();
            textAlignmentProcessor.initialize(inlineSequenceElementArray, l, l + l3, this.pageGrid);
            DebugLog.log((Object)"Auto-Corrected zero-width linebox.");
        } else {
            textAlignmentProcessor.initialize(inlineSequenceElementArray, l, l2, this.pageGrid);
        }
        while (textAlignmentProcessor.hasNext()) {
            RenderNode renderNode = textAlignmentProcessor.next();
            if (!(renderNode instanceof ParagraphPoolBox)) {
                throw new NullPointerException("Line must not be null");
            }
            paragraphRenderBox.addGeneratedChild(renderNode);
        }
    }

    protected TextAlignmentProcessor create(CSSValue cSSValue, CSSValue cSSValue2) {
        if (TextAlign.CENTER.equals(cSSValue)) {
            return new CenterAlignmentProcessor();
        }
        if (TextAlign.RIGHT.equals(cSSValue)) {
            return new RightAlignmentProcessor();
        }
        return new LeftAlignmentProcessor();
    }
}

