/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.modules.factory.svg;

import java.io.IOException;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.gvt.GraphicsNode;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.SimpleResource;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;
import org.pentaho.reporting.libraries.resourceloader.modules.factory.svg.AbstractSVGFactoryModule;
import org.pentaho.reporting.libraries.resourceloader.modules.factory.svg.HeadlessSVGUserAgent;
import org.pentaho.reporting.libraries.resourceloader.modules.factory.svg.SVGDrawable;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class SVGDrawableFactoryModule
extends AbstractSVGFactoryModule {
    public Resource create(ResourceManager caller, ResourceData data, ResourceKey context) throws ResourceLoadingException {
        try {
            long version = data.getVersion(caller);
            HeadlessSVGUserAgent userAgent = new HeadlessSVGUserAgent();
            DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
            SVGDocument document = (SVGDocument)loader.loadDocument(String.valueOf(data.getKey().getIdentifier()), data.getResourceAsStream(caller));
            BridgeContext ctx = new BridgeContext((UserAgent)userAgent, loader);
            GVTBuilder builder = new GVTBuilder();
            GraphicsNode node = builder.build(ctx, (Document)document);
            return new SimpleResource(data.getKey(), new SVGDrawable(node), DrawableWrapper.class, version);
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Failed to process WMF file", e);
        }
    }
}

