/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_eu extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Afrika erdialdeko ordua",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Moskuko ordu estandarra",
               "MSK",
               "Moskuko udako ordua",
               "MSD",
               "Moskuko ordua",
               "MT",
            };
        final String[] Japan = new String[] {
               "Japoniako ordu estandarra",
               "JST",
               "Japoniako udako ordua",
               "JDT",
               "Japoniako ordua",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Pakistango ordu estandarra",
               "PKT",
               "Pakistango udako ordua",
               "PKST",
               "Pakistango ordua",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Taipeiko ordu estandarra",
               "CST",
               "Taipeiko udako ordua",
               "CDT",
               "Taipeiko ordua",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Hovdeko ordu estandarra",
               "HOVT",
               "Hovdeko udako ordua",
               "HOVST",
               "Hovdeko ordua",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Magadango ordu estandarra",
               "MAGT",
               "Magadango udako ordua",
               "MAGST",
               "Magadako ordua",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Australia erdi-mendebaldeko ordu estandarra",
               "ACWST",
               "Australia erdi-mendebaldeko udako ordua",
               "ACWDT",
               "Australia erdi-mendebaldeko ordua",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Europa erdialdeko ordu estandarra",
               "CET",
               "Europa erdialdeko udako ordua",
               "CEST",
               "Europa erdialdeko ordua",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalingo ordu estandarra",
               "SAKT",
               "Sakhalingo udako ordua",
               "SAKST",
               "Sakhalingo ordua",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguayko ordu estandarra",
               "PYT",
               "Paraguayko udako ordua",
               "PYST",
               "Paraguayko ordua",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "Malaysiako ordua",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Ipar Amerikako ekialdeko ordu estandarra",
               "EST",
               "Ipar Amerikako ekialdeko udako ordua",
               "EDT",
               "Ipar Amerikako ekialdeko ordua",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howeko ordu estandarra",
               "LHST",
               "Lord Howeko udako ordua",
               "LHDT",
               "Lord Howeko ordua",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Zeelanda Berriko ordu estandarra",
               "NZST",
               "Zeelanda Berriko udako ordua",
               "NZDT",
               "Zeelanda Berriko ordua",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Ozeano Indikoko ordua",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Yakutskeko ordu estandarra",
               "YAKT",
               "Yakutskeko udako ordua",
               "YAKST",
               "Yakutskeko ordua",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Maurizioko ordu estandarra",
               "MUT",
               "Maurizioko udako ordua",
               "MUST",
               "Maurizioko ordua",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Afrika ekialdeko ordua",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Ekialdeko Timorreko ordua",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Salomon uharteetako ordua",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Kosraeko ordua",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshall uharteetako ordua",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Europa ekialdeko ordu estandarra",
               "EET",
               "Europa ekialdeko udako ordua",
               "EEST",
               "Europa ekialdeko ordua",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Ternuako ordu estandarra",
               "NST",
               "Ternuako udako ordua",
               "NDT",
               "Ternuako ordua",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Afganistango ordua",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Hong Kongo ordu estandarra",
               "HKT",
               "Hong Kongo udako ordua",
               "HKST",
               "Hong Kongo ordua",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Argentina mendebaldeko ordu estandarra",
               "ART",
               "Argentina mendebaldeko udako ordua",
               "ARST",
               "Argentina mendebaldeko ordua",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Atlantikoko ordu estandarra",
               "AST",
               "Atlantikoko udako ordua",
               "ADT",
               "Atlantikoko ordua",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Ponapeko ordua",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Boliviako ordua",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint-Pierre eta Mikeluneko ordu estandarra",
               "PMST",
               "Saint-Pierre eta Mikeluneko udako ordua",
               "PMDT",
               "Saint-Pierre eta Mikeluneko ordua",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Indotxinako ordua",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburgeko ordu estandarra",
               "YEKT",
               "Yekaterinburgeko udako ordua",
               "YEKST",
               "Yekaterinburgeko ordua",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Maldivetako ordua",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Tahitiko ordua",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Israelgo ordu estandarra",
               "IST",
               "Israelgo udako ordua",
               "IDT",
               "Israelgo ordua",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Indonesia erdialdeko ordua",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Wallis eta Futunako ordua",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Afrika hegoaldeko ordua",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Syowako ordua",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Line uharteetako ordua",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekistango ordu estandarra",
               "UZT",
               "Uzbekistango udako ordua",
               "UZST",
               "Uzbekistango ordua",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Omskeko ordu estandarra",
               "OMST",
               "Omskeko udako ordua",
               "OMSST",
               "Omskeko ordua",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Seychelle uharteetako ordua",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Uruguayko ordu estandarra",
               "UYT",
               "Uruguayko udako ordua",
               "UYST",
               "Uruguayko ordua",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Nepalgo ordua",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Ulan Batorreko ordu estandarra",
               "ULAT",
               "Ulan Batorreko udako ordua",
               "ULAST",
               "Ulan Batorreko ordua",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Ipar Amerikako erdialdeko ordu estandarra",
               "CST",
               "Ipar Amerikako erdialdeko udako ordua",
               "CDT",
               "Ipar Amerikako erdialdeko ordua",
               "CT",
            };
        final String[] Truk = new String[] {
               "Chuukeko ordua",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Niueko ordua",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Wake uharteko ordua",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Falkland uharteetako ordu estandarra",
               "FKT",
               "Falkland uharteetako udako ordua",
               "FKST",
               "Falkland uharteetako ordua",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatuko ordu estandarra",
               "VUT",
               "Vanuatuko udako ordua",
               "VUST",
               "Vanuatuko ordua",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirskeko ordu estandarra",
               "NOVT",
               "Novosibirskeko udako ordua",
               "NOVST",
               "Novosibirskeko ordua",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Singapurreko ordu estandarra",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Azoreetako ordu estandarra",
               "AZOT",
               "Azoreetako udako ordua",
               "AZOST",
               "Azoreetako ordua",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Apiako ordu estandarra",
               "WSST",
               "Apiako udako ordua",
               "WSDT",
               "Apiako ordua",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Bhutango ordua",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Surinamgo ordua",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Nauruko ordua",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyarskeko ordu estandarra",
               "KRAT",
               "Krasnoyarskeko udako ordua",
               "KRAST",
               "Krasnoyarskeko ordua",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Kazakhstan mendebaldeko ordua",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Myanmarreko ordua",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Christmas uharteko ordua",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Amazoniako ordu estandarra",
               "AMT",
               "Amazoniako udako ordua",
               "AMST",
               "Amazoniako ordua",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Kazakhstan ekialdeko ordua",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Fijiko ordu estandarra",
               "FJT",
               "Fijiko udako ordua",
               "FJST",
               "Fijiko ordua",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Reunion uharteetako ordua",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Cocos uharteetako ordua",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Chathamgo ordu estandarra",
               "CHAST",
               "Chathamgo udako ordua",
               "CHADT",
               "Chathamgo ordua",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Vostokeko ordua",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Argentinako ordu estandarra",
               "ART",
               "Argentinako udako ordua",
               "ARST",
               "Argentinako ordua",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Gambierreko ordua",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsk-Kamchatskiko ordu estandarra",
               "PETT",
               "Petropavlovsk-Kamchatskiko udako ordua",
               "PETST",
               "Petropavlovsk-Kamchatskiko ordua",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvaluko ordua",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Galapagoetako ordua",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Macquarie uharteko ordua",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Venezuelako ordua",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleutiar uharteetako ordu estandarra",
               "HAST",
               "Hawaii-Aleutiar uharteetako udako ordua",
               "HADT",
               "Hawaii-Aleutiar uharteetako ordua",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Australia erdialdeko ordu estandarra",
               "ACST",
               "Australia erdialdeko udako ordua",
               "ACDT",
               "Australia erdialdeko ordua",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Ipar Amerikako Pazifikoko ordu estandarra",
               "PST",
               "Ipar Amerikako Pazifikoko udako ordua",
               "PDT",
               "Ipar Amerikako Pazifikoko ordua",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenix uharteetako ordua",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistango ordu estandarra",
               "TMT",
               "Turkmenistango udako ordua",
               "TMST",
               "Turkmenistango ordua",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Europa mendebaldeko ordu estandarra",
               "WET",
               "Europa mendebaldeko udako ordua",
               "WEST",
               "Europa mendebaldeko ordua",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Cabo Verdeko ordu estandarra",
               "CVT",
               "Cabo Verdeko udako ordua",
               "CVST",
               "Cabo Verdeko ordua",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Norfolk uharteetako ordua",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Guyanako ordua",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairneko ordua",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Rotherako ordua",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Samoako ordu estandarra",
               "SST",
               "Samoako udako ordua",
               "SDT",
               "Samoako ordua",
               "ST",
            };
        final String[] Palau = new String[] {
               "Palauko ordua",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Ekialde urruneko Europako ordua",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbaijango ordu estandarra",
               "AZT",
               "Azerbaijango udako ordua",
               "AZST",
               "Azerbaijango ordua",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Mawsoneko ordua",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mexikoko Pazifikoko ordu estandarra",
               "MST",
               "Mexikoko Pazifikoko udako ordua",
               "MDT",
               "Mexikoko Pazifikoko ordua",
               "MT",
            };
        final String[] Davis = new String[] {
               "Daviseko ordua",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Kubako ordu estandarra",
               "CST",
               "Kubako udako ordua",
               "CDT",
               "Kubako ordua",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Afrika mendebaldeko ordu estandarra",
               "WAT",
               "Afrika mendebaldeko udako ordua",
               "WAST",
               "Afrika mendebaldeko ordua",
               "WAT",
            };
        final String[] GMT = new String[] {
               "Greenwich meridianoko ordua",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Filipinetako ordu estandarra",
               "PHT",
               "Filipinetako udako ordua",
               "PHST",
               "Filipinetako ordua",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Frantziaren lurralde austral eta antartikoetako ordua",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "Hego Georgiako ordua",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Kaledonia Berriko ordu estandarra",
               "NCT",
               "Kaledonia Berriko udako ordua",
               "NCST",
               "Kaledonia Berriako ordua",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalamgo ordua",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Irango ordu estandarra",
               "IRST",
               "Irango udako ordua",
               "IRDT",
               "Irango ordua",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Pazko uharteko ordu estandarra",
               "EAST",
               "Pazko uharteko udako ordua",
               "EASST",
               "Pazko uharteko ordua",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Mexikoko ipar-ekialdeko ordu estandarra",
               "PST",
               "Mexikoko ipar-ekialdeko udako ordua",
               "PDT",
               "Mexikoko ipar-ekialdeko ordua",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urvilleko ordua",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Tadjikistango ordua",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Tongako ordu estandarra",
               "TOT",
               "Tongako udako ordua",
               "TOST",
               "Tongako ordua",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesheko ordu estandarra",
               "BDT",
               "Bangladesheko udako ordua",
               "BDST",
               "Bangladesheko ordua",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Peruko ordu estandarra",
               "PET",
               "Peruko udako ordua",
               "PEST",
               "Peruko ordua",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Groenlandia mendebaldeko ordu estandarra",
               "WGT",
               "Groenlandia mendebaldeko udako ordua",
               "WGST",
               "Groenlandia mendebaldeko ordua",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Ekuadorreko ordua",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Groenlandia ekialdeko ordu estandarra",
               "EGT",
               "Groenlandia ekialdeko udako ordua",
               "EGST",
               "Groenlandia ekialdeko ordua",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Golkoko ordu estandarra",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Indonesia ekialdeko ordua",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Koreako ordu estandarra",
               "KST",
               "Koreako udako ordua",
               "KDT",
               "Koreako ordua",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Australia mendebaldeko ordu estandarra",
               "AWST",
               "Australia mendebaldeko udako ordua",
               "AWDT",
               "Australia mendebaldeko ordua",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgizistango ordua",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Indonesia mendebaldeko ordua",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Australia ekialdeko ordu estandarra",
               "AEST",
               "Australia ekialdeko udako ordua",
               "AEDT",
               "Australia ekialdeko ordua",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Guyana Frantseseko ordua",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Kolonbiako ordu estandarra",
               "COT",
               "Kolonbiako udako ordua",
               "COST",
               "Kolonbiako ordua",
               "COT",
            };
        final String[] Chile = new String[] {
               "Txileko ordu estandarra",
               "CLT",
               "Txileko udako ordua",
               "CLST",
               "Txileko ordua",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert uharteetako ordua",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Ipar Amerikako mendialdeko ordu estandarra",
               "MST",
               "Ipar Amerikako mendialdeko udako ordua",
               "MDT",
               "Ipar Amerikako mendialdeko ordua",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Markesetako ordua",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Arabiako ordu estandarra",
               "AST",
               "Arabiako udako ordua",
               "ADT",
               "Arabiako ordua",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Alaskako ordu estandarra",
               "AKST",
               "Alaskako udako ordua",
               "AKDT",
               "Alaskako ordua",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostokeko ordu estandarra",
               "VLAT",
               "Vladivostokeko udako ordua",
               "VLAST",
               "Vladivostokeko ordua",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Chamorroko ordu estandarra",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutskeko ordu estandarra",
               "IRKT",
               "Irkutskeko udako ordua",
               "IRKST",
               "Irkutskeko ordua",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Georgiako ordu estandarra",
               "GET",
               "Georgiako udako ordua",
               "GEST",
               "Georgiako ordua",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Tokelauko ordua",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua Ginea Berriko ordua",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronhako ordu estandarra",
               "FNT",
               "Fernando de Noronhako udako ordua",
               "FNST",
               "Fernando de Noronhako ordua",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Choibalsango ordu estandarra",
               "CHOT",
               "Choibalsango udako ordua",
               "CHOST",
               "Choibalsango ordua",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Brasiliako ordu estandarra",
               "BRT",
               "Brasiliako udako ordua",
               "BRST",
               "Brasiliako ordua",
               "BRT",
            };
        final String[] China = new String[] {
               "Txinako ordu estandarra",
               "CST",
               "Txinako udako ordua",
               "CDT",
               "Txinako ordua",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Armeniako ordu estandarra",
               "AMT",
               "Armeniako udako ordua",
               "AMST",
               "Armeniako ordua",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Samarako ordu estandarra",
               "SAMT",
               "Samarako udako ordua",
               "SAMST",
               "Samarako ordua",
               "SAMT",
            };
        final String[] India = new String[] {
               "Indiako ordua",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Cook uharteetako ordu estandarra",
               "CKT",
               "Cook uharteetako uda erdialdeko ordua",
               "CKHST",
               "Cook uharteetako ordua",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Greenwich meridianoko ordua",
                    "GMT",
                    "Londresko udako ordua",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich meridianoko ordua",
                    "GMT",
                    "Dublingo udako ordua",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
