#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: sbv
version: 7.3
id: sbv-7.3-5VDu1hw18uRDPfTw5U8WfG
key: sbv-7.3-5VDu1hw18uRDPfTw5U8WfG
license: BSD3
copyright: Levent Erkok, 2010-2017
maintainer: Levent Erkok (erkokl@gmail.com)
stability: Experimental
homepage: http://leventerkok.github.com/sbv/
synopsis: SMT Based Verification: Symbolic Haskell theorem prover using SMT solving.
description:
    Express properties about Haskell programs and automatically prove them using SMT
    (Satisfiability Modulo Theories) solvers.
    .
    For details, please see: <http://leventerkok.github.com/sbv/>
category: Formal Methods, Theorem Provers, Bit vectors, Symbolic Computation, Math, SMT
author: Levent Erkok
exposed: True
indefinite: False
exposed-modules:
    Data.SBV Data.SBV.Control Data.SBV.Dynamic
    Data.SBV.Examples.BitPrecise.BitTricks
    Data.SBV.Examples.BitPrecise.Legato
    Data.SBV.Examples.BitPrecise.MergeSort
    Data.SBV.Examples.BitPrecise.MultMask
    Data.SBV.Examples.BitPrecise.PrefixSum
    Data.SBV.Examples.CodeGeneration.AddSub
    Data.SBV.Examples.CodeGeneration.CRC_USB5
    Data.SBV.Examples.CodeGeneration.Fibonacci
    Data.SBV.Examples.CodeGeneration.GCD
    Data.SBV.Examples.CodeGeneration.PopulationCount
    Data.SBV.Examples.CodeGeneration.Uninterpreted
    Data.SBV.Examples.Crypto.AES Data.SBV.Examples.Crypto.RC4
    Data.SBV.Examples.Existentials.CRCPolynomial
    Data.SBV.Examples.Existentials.Diophantine
    Data.SBV.Examples.Misc.Auxiliary Data.SBV.Examples.Misc.Enumerate
    Data.SBV.Examples.Misc.Floating Data.SBV.Examples.Misc.ModelExtract
    Data.SBV.Examples.Misc.NoDiv0 Data.SBV.Examples.Misc.Word4
    Data.SBV.Examples.Optimization.ExtField
    Data.SBV.Examples.Optimization.LinearOpt
    Data.SBV.Examples.Optimization.Production
    Data.SBV.Examples.Optimization.VM
    Data.SBV.Examples.Polynomials.Polynomials
    Data.SBV.Examples.Puzzles.Birthday Data.SBV.Examples.Puzzles.Coins
    Data.SBV.Examples.Puzzles.Counts
    Data.SBV.Examples.Puzzles.DogCatMouse
    Data.SBV.Examples.Puzzles.Euler185 Data.SBV.Examples.Puzzles.Fish
    Data.SBV.Examples.Puzzles.MagicSquare
    Data.SBV.Examples.Puzzles.NQueens
    Data.SBV.Examples.Puzzles.SendMoreMoney
    Data.SBV.Examples.Puzzles.Sudoku Data.SBV.Examples.Puzzles.U2Bridge
    Data.SBV.Examples.Queries.AllSat
    Data.SBV.Examples.Queries.CaseSplit Data.SBV.Examples.Queries.Enums
    Data.SBV.Examples.Queries.FourFours
    Data.SBV.Examples.Queries.GuessNumber
    Data.SBV.Examples.Queries.Interpolants
    Data.SBV.Examples.Queries.UnsatCore
    Data.SBV.Examples.Uninterpreted.AUF
    Data.SBV.Examples.Uninterpreted.Deduce
    Data.SBV.Examples.Uninterpreted.Function
    Data.SBV.Examples.Uninterpreted.Shannon
    Data.SBV.Examples.Uninterpreted.Sort
    Data.SBV.Examples.Uninterpreted.UISortAllSat Data.SBV.Internals
    Data.SBV.Tools.CodeGen Data.SBV.Tools.GenTest
    Data.SBV.Tools.Polynomial Data.SBV.Tools.STree
hidden-modules: Data.SBV.Core.AlgReals Data.SBV.Core.Concrete
                Data.SBV.Core.Data Data.SBV.Core.Kind Data.SBV.Core.Model
                Data.SBV.Core.Operations Data.SBV.Core.Floating
                Data.SBV.Core.Splittable Data.SBV.Core.Symbolic
                Data.SBV.Control.Query Data.SBV.Control.Types
                Data.SBV.Control.Utils Data.SBV.Compilers.C
                Data.SBV.Compilers.CodeGen Data.SBV.SMT.SMT Data.SBV.SMT.SMTLib
                Data.SBV.SMT.SMTLib2 Data.SBV.SMT.SMTLibNames Data.SBV.SMT.Utils
                Data.SBV.Provers.Prover Data.SBV.Provers.Boolector
                Data.SBV.Provers.CVC4 Data.SBV.Provers.Yices Data.SBV.Provers.Z3
                Data.SBV.Provers.MathSAT Data.SBV.Provers.ABC
                Data.SBV.Utils.Boolean Data.SBV.Utils.Numeric Data.SBV.Utils.TDiff
                Data.SBV.Utils.Lib Data.SBV.Utils.PrettyNum Data.SBV.Utils.SExpr
abi: 30447f61b70aefe043bb47345a4488c5
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/sbv-7.3
library-dirs: /usr/lib/ghc-8.2.1/site-local/sbv-7.3
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/sbv-7.3
hs-libraries: HSsbv-7.3-5VDu1hw18uRDPfTw5U8WfG
depends:
    base-4.10.0.0 ghc-8.2.1 QuickCheck-2.10.1-KIwpOgIMAPpCfx99HppzCX
    crackNum-1.9-5jXWz844E7YEt3zFZucyQJ template-haskell-2.12.0.0
    array-0.5.2.0 async-2.1.1.1-2NW8RVpRWiC9M88FM7mCHc
    containers-0.5.10.2 deepseq-1.4.3.0 directory-1.3.0.2
    filepath-1.4.1.2 time-1.8.0.2 pretty-1.1.3.3 process-1.6.1.0
    mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3 random-1.1-DtLcP2Z2iOOC0RwcSmXjBK
    syb-0.7-2rRPTNxBP6YFePrCXw4i2o
    data-binary-ieee754-0.4.4-AeazHSDlclYKQFsNsak7mZ
    generic-deriving-1.11.2-I1hKFTmgsiECj4HOwgPf5J
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             ghc-8.2.1=d7763332c13b50f139523c2e03ca393f
             QuickCheck-2.10.1-KIwpOgIMAPpCfx99HppzCX=698e905b23be91d72fd87efbe66c208e
             crackNum-1.9-5jXWz844E7YEt3zFZucyQJ=3e6977e6cb05dea4ccf5c8da3a5c453a
             template-haskell-2.12.0.0=612ee923b47f5e11502cef08338c9f82
             array-0.5.2.0=5abf025fb7bf60079ec1f42bab285152
             async-2.1.1.1-2NW8RVpRWiC9M88FM7mCHc=4ad1a36fd79247fdbaa53c120c46b6d7
             containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
             deepseq-1.4.3.0=15f2832424b38ea5b23f1ebc9071dcc3
             directory-1.3.0.2=f0be8e5bd351f97ab9c9e693d2eba4ad
             filepath-1.4.1.2=30ad74f2069d36b2d0af3972630d4ac4
             time-1.8.0.2=3f789f9c9fc88790a10579b55c2f0b4f
             pretty-1.1.3.3=5491220463456849eb660c64bb0df8c8
             process-1.6.1.0=b3854816fc29ad3caa05e87ab6680404
             mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3=5531911f09693672654e6de645ce55e7
             random-1.1-DtLcP2Z2iOOC0RwcSmXjBK=4de0c0628e95d26e613f423e1634f42a
             syb-0.7-2rRPTNxBP6YFePrCXw4i2o=119e2c6ac6f570dd5e30835fe9c8c288
             data-binary-ieee754-0.4.4-AeazHSDlclYKQFsNsak7mZ=771930238c8e1a697594d1a8ad7f99e6
             generic-deriving-1.11.2-I1hKFTmgsiECj4HOwgPf5J=7f9a8be0d94ccfee90d00f3f677a8748
haddock-interfaces: /usr/share/doc/haskell-sbv/html/sbv.haddock
haddock-html: /usr/share/doc/haskell-sbv/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

