#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: turtle
version: 1.4.4
id: turtle-1.4.4-96MJc3Ez9nFJ9anGojq5or
key: turtle-1.4.4-96MJc3Ez9nFJ9anGojq5or
license: BSD3
copyright: 2015 Gabriel Gonzalez
maintainer: Gabriel439@gmail.com
synopsis: Shell programming, Haskell-style
description:
    @turtle@ is a reimplementation of the Unix command line environment
    in Haskell so that you can use Haskell as both a shell and a scripting
    language.
    .
    Features include:
    .
    * Batteries included: Command an extended suite of predefined utilities
    .
    * Interoperability: You can still run external shell commands
    .
    * Portability: Works on Windows, OS X, and Linux
    .
    * Exception safety: Safely acquire and release resources
    .
    * Streaming: Transform or fold command output in constant space
    .
    * Patterns: Use typed regular expressions that can parse structured values
    .
    * Formatting: Type-safe @printf@-style text formatting
    .
    * Modern: Supports @text@ and @system-filepath@
    .
    Read "Turtle.Tutorial" for a detailed tutorial or "Turtle.Prelude" for a
    quick-start guide
    .
    @turtle@ is designed to be beginner-friendly, but as a result lacks certain
    features, like tracing commands.  If you feel comfortable using @turtle@
    then you should also check out the @Shelly@ library which provides similar
    functionality.
category: System
author: Gabriel Gonzalez
exposed: True
indefinite: False
exposed-modules:
    Turtle Turtle.Bytes Turtle.Format Turtle.Line Turtle.Options
    Turtle.Pattern Turtle.Prelude Turtle.Shell Turtle.Tutorial
hidden-modules: Turtle.Internal
abi: 860b1644fe1331778983e85389a65c0c
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/turtle-1.4.4
library-dirs: /usr/lib/ghc-8.2.1/site-local/turtle-1.4.4
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/turtle-1.4.4
hs-libraries: HSturtle-1.4.4-96MJc3Ez9nFJ9anGojq5or
depends:
    base-4.10.0.0 ansi-wl-pprint-0.6.8.1-80vSxm39oopFZHdKk9kEEk
    async-2.1.1.1-2NW8RVpRWiC9M88FM7mCHc bytestring-0.10.8.2
    clock-0.7.2-9fV7rV7wNUo6v6mDurfiVg directory-1.3.0.2
    foldl-1.3.3-49VW3LzmspQ2MyVG57SLFx
    hostname-1.0-ITdZPWe9XL7105h6B80pVP
    managed-1.0.5-AtVs0QEjn5cnY7UxRWyLE process-1.6.1.0
    semigroups-0.18.3-6KPIVJcHqOOBHjBl8WA5LP
    system-filepath-0.4.13.4-H5ZT610b48ZDAWGB9PlvnB
    system-fileio-0.3.16.3-8q55Bl57w6jJvYSIouKL6q
    stm-2.4.4.1-4JDnVtQYo787gU0ccBstsJ
    temporary-1.2.1.1-JiAl6vZksoXBKGEB3ysIBo
    text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz time-1.8.0.2
    transformers-0.5.2.0
    optparse-applicative-0.14.0.0-CJtbqXiElwvHJ8bj23xDw2
    optional-args-1.0.1-Ca5saO7bmrq5UodVMXfAMM
    unix-compat-0.4.3.1-EzGzmB3Cz3F9KJc1tD42yp unix-2.7.2.2
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             ansi-wl-pprint-0.6.8.1-80vSxm39oopFZHdKk9kEEk=5dd9f62bbccf0f5ea87688386a1940a6
             async-2.1.1.1-2NW8RVpRWiC9M88FM7mCHc=4ad1a36fd79247fdbaa53c120c46b6d7
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             clock-0.7.2-9fV7rV7wNUo6v6mDurfiVg=92f7216679a05fc7241dae2b2b6f6e0e
             directory-1.3.0.2=f0be8e5bd351f97ab9c9e693d2eba4ad
             foldl-1.3.3-49VW3LzmspQ2MyVG57SLFx=5802dff2867d5eae64850cfa76f5dab2
             hostname-1.0-ITdZPWe9XL7105h6B80pVP=27e312d8f07f823ceab6bdfaa4ee12c3
             managed-1.0.5-AtVs0QEjn5cnY7UxRWyLE=15b995d4dd0816866315060d33aab390
             process-1.6.1.0=b3854816fc29ad3caa05e87ab6680404
             semigroups-0.18.3-6KPIVJcHqOOBHjBl8WA5LP=7bc502c1773a3f628e3db58cb706740b
             system-filepath-0.4.13.4-H5ZT610b48ZDAWGB9PlvnB=435c09767046bc024155cc2d3464dd2e
             system-fileio-0.3.16.3-8q55Bl57w6jJvYSIouKL6q=73cc15107d6c94185719694d508bcd4c
             stm-2.4.4.1-4JDnVtQYo787gU0ccBstsJ=a88f5bbac4be96a38c5ca2a658c158a0
             temporary-1.2.1.1-JiAl6vZksoXBKGEB3ysIBo=ba806cd7fa58c88cefcf360552466b99
             text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz=42480b67fee41ad692110e11eaac57c4
             time-1.8.0.2=3f789f9c9fc88790a10579b55c2f0b4f
             transformers-0.5.2.0=9705988bf0172d3bbbcdcaf65e1d842a
             optparse-applicative-0.14.0.0-CJtbqXiElwvHJ8bj23xDw2=9137170527362bcbf66dd39b0705c132
             optional-args-1.0.1-Ca5saO7bmrq5UodVMXfAMM=4e1b30bcda92090d1f56c14ff30e3073
             unix-compat-0.4.3.1-EzGzmB3Cz3F9KJc1tD42yp=f0e3615d16ccc9a099618a4b1bfc9d59
             unix-2.7.2.2=7af8630098b53e228272ffaea5bacf62
haddock-interfaces: /usr/share/doc/haskell-turtle/html/turtle.haddock
haddock-html: /usr/share/doc/haskell-turtle/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

