#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: hledger
version: 1.4
id: hledger-1.4-AIq6K1MP4hs3dKemNlmB5G
key: hledger-1.4-AIq6K1MP4hs3dKemNlmB5G
license: GPL-3
maintainer: Simon Michael <simon@joyful.com>
stability: stable
homepage: http://hledger.org
synopsis: Command-line interface for the hledger accounting tool
description:
    This is hledger'\''s command-line interface.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.
    .
    hledger is a cross-platform program for tracking money, time, or
    any other commodity, using double-entry accounting and a simple,
    editable file format. It is inspired by and largely compatible
    with ledger(1).  hledger provides command-line, curses and web
    interfaces, and aims to be a reliable, practical tool for daily
    use.
category: Finance, Console
author: Simon Michael <simon@joyful.com>
exposed: True
indefinite: False
exposed-modules:
    Hledger.Cli Hledger.Cli.CliOptions Hledger.Cli.Commands
    Hledger.Cli.Commands.Accounts Hledger.Cli.Commands.Activity
    Hledger.Cli.Commands.Add Hledger.Cli.Commands.Balance
    Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Checkdates
    Hledger.Cli.Commands.Checkdupes Hledger.Cli.Commands.Equity
    Hledger.Cli.Commands.Help Hledger.Cli.Commands.Import
    Hledger.Cli.Commands.Incomestatement Hledger.Cli.Commands.Prices
    Hledger.Cli.Commands.Print Hledger.Cli.Commands.Printunique
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Registermatch
    Hledger.Cli.Commands.Rewrite Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.DocFiles Hledger.Cli.Main Hledger.Cli.Utils
    Hledger.Cli.Version Text.Tabular.AsciiWide
hidden-modules: Paths_hledger
abi: 5c0185ce11d9aa9d36a8a8c37d610f34
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/hledger-1.4
library-dirs: /usr/lib/ghc-8.2.1/site-local/hledger-1.4
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/hledger
hs-libraries: HShledger-1.4-AIq6K1MP4hs3dKemNlmB5G
depends:
    base-4.10.0.0 base-compat-0.9.3-7gxrulAnYCf9OVK5Ok3lMW
    ansi-terminal-0.6.3.1-BIEgiaci8VQ7yyITu4jhfU directory-1.3.0.2
    file-embed-0.0.10.1-22oUm17C4yT5YwW0zZXlor filepath-1.4.1.2
    here-1.2.11-7oDOz8L1Ula2z3e5ZeDko8
    pretty-show-1.6.13-1Y3SqFKPaj5ELeEKE7rREK process-1.6.1.0
    shakespeare-2.0.14-ILbjPbZM5dUCAePhfgNGCi
    temporary-1.2.1.1-JiAl6vZksoXBKGEB3ysIBo
    tabular-0.2.2.7-H6HQxZw1kjr7chsimRmSHU time-1.8.0.2
    utility-ht-0.0.14-4br28cWzxu32AcVJ156WVj
    hledger-lib-1.4-6P8oShydK9J3djtUIdqOY8 bytestring-0.10.8.2
    containers-0.5.10.2
    unordered-containers-0.2.8.0-KL4HUdwCmhYBQDTvY5v0GN
    cmdargs-0.10.18-FddQmgeT9xb4xNYVbmZNzf
    csv-0.1.2-FTLnfLeG7H17CWj1kGbhS5
    data-default-0.7.1.1-7D2kYbZAPZs3NL2w6K0r5J
    Diff-0.3.4-9Jk7nn49ORI32Gqvs1rQQi
    hashable-1.2.6.1-5D85BzUWIsjDNuFvtLMWyk haskeline-0.7.4.0
    HUnit-1.6.0.0-32Hmh42Ovy04fXZEjkNwW3
    mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3
    old-time-1.1.0.3-JBqRS8v7R0IBEIYolASC7h
    megaparsec-6.1.1-JyQgsAppHsyCsp6bh0sliz
    regex-tdfa-1.2.2-1G5AA2OVGrl1AkVWQSHaiw
    safe-0.3.15-AsY8t7BqxG7J4M7E7fbih5
    split-0.2.3.2-89BHvn20PlL73pGr1SBIHj transformers-0.5.2.0
    text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz
    utf8-string-1.0.1.1-CvukXmdyLbdJ7d5kadRf8m
    wizards-1.0.2-ZspRevRBIDHbopg40X3g1 terminfo-0.4.1.0
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             base-compat-0.9.3-7gxrulAnYCf9OVK5Ok3lMW=99c1023c304a14d4b5f863c8a16db1e9
             ansi-terminal-0.6.3.1-BIEgiaci8VQ7yyITu4jhfU=8d42c7012ae6bb1dfca5905fe8a25762
             directory-1.3.0.2=f0be8e5bd351f97ab9c9e693d2eba4ad
             file-embed-0.0.10.1-22oUm17C4yT5YwW0zZXlor=5018b921cb741d8b43f50680a0ae3431
             filepath-1.4.1.2=30ad74f2069d36b2d0af3972630d4ac4
             here-1.2.11-7oDOz8L1Ula2z3e5ZeDko8=e2ea607b3e5a66afbf7beeb4e2efa24e
             pretty-show-1.6.13-1Y3SqFKPaj5ELeEKE7rREK=87b44348ec83a99a6bb6345f11ac2835
             process-1.6.1.0=b3854816fc29ad3caa05e87ab6680404
             shakespeare-2.0.14-ILbjPbZM5dUCAePhfgNGCi=d0814b475354dc774cee8fd548e0d047
             temporary-1.2.1.1-JiAl6vZksoXBKGEB3ysIBo=ba806cd7fa58c88cefcf360552466b99
             tabular-0.2.2.7-H6HQxZw1kjr7chsimRmSHU=d2c3066262269b962e641f9cddedd35b
             time-1.8.0.2=3f789f9c9fc88790a10579b55c2f0b4f
             utility-ht-0.0.14-4br28cWzxu32AcVJ156WVj=1a1809eb8ba2e75eb9ba0f6b65f67465
             hledger-lib-1.4-6P8oShydK9J3djtUIdqOY8=ff298d97e0ec88e3ffa819435b5c3089
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             containers-0.5.10.2=e086202b65ca66a107fcba9d846fc3e0
             unordered-containers-0.2.8.0-KL4HUdwCmhYBQDTvY5v0GN=c3a6cf2eb5dea0a9b852305436978b94
             cmdargs-0.10.18-FddQmgeT9xb4xNYVbmZNzf=ae2d362734d28c623f00890866ffdf43
             csv-0.1.2-FTLnfLeG7H17CWj1kGbhS5=2b26144b3cdd6320c90851f81d71726c
             data-default-0.7.1.1-7D2kYbZAPZs3NL2w6K0r5J=51023526c672e559ef5f8b366e37519b
             Diff-0.3.4-9Jk7nn49ORI32Gqvs1rQQi=2dadc8f3cec9314235d4b2baeae0901b
             hashable-1.2.6.1-5D85BzUWIsjDNuFvtLMWyk=90545b19a76e197f153fb1577996b718
             haskeline-0.7.4.0=36adec7915bbe665923e4f83d1084101
             HUnit-1.6.0.0-32Hmh42Ovy04fXZEjkNwW3=403e14f0201c382f502c00d4ca640d0c
             mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3=5531911f09693672654e6de645ce55e7
             old-time-1.1.0.3-JBqRS8v7R0IBEIYolASC7h=e36378d40a60df0fd2f08fb5571aec27
             megaparsec-6.1.1-JyQgsAppHsyCsp6bh0sliz=796e22e0aa14a01146c0b4b1992adba5
             regex-tdfa-1.2.2-1G5AA2OVGrl1AkVWQSHaiw=a50652c6ce72d1a607b5e2d5892b65bc
             safe-0.3.15-AsY8t7BqxG7J4M7E7fbih5=6cf1fe7158a61976010b5254caed2ddd
             split-0.2.3.2-89BHvn20PlL73pGr1SBIHj=c51f43c3e91d41531ae5282d108271a0
             transformers-0.5.2.0=9705988bf0172d3bbbcdcaf65e1d842a
             text-1.2.2.2-KYRZgO9N4MoJ4sC5lMiKTz=42480b67fee41ad692110e11eaac57c4
             utf8-string-1.0.1.1-CvukXmdyLbdJ7d5kadRf8m=8d643a529d99a952051170bc6a18d0f2
             wizards-1.0.2-ZspRevRBIDHbopg40X3g1=0c770298bb4e01c4213c3d65fc83e866
             terminfo-0.4.1.0=8644ddbf3a910c8572272110dcb45e84
haddock-interfaces: /usr/share/doc/hledger/html/hledger.haddock
haddock-html: /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

