/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings;

import org.jcodings.Encoding;
import org.jcodings.EncodingList;
import org.jcodings.exception.InternalException;
import org.jcodings.util.CaseInsensitiveBytesHash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncodingDB {
    static Entry ascii;
    static final CaseInsensitiveBytesHash<Entry> encodings;
    static final CaseInsensitiveBytesHash<Entry> aliases;

    public static final CaseInsensitiveBytesHash<Entry> getEncodings() {
        return encodings;
    }

    public static final CaseInsensitiveBytesHash<Entry> getAliases() {
        return aliases;
    }

    public static void declare(String name2, String encodingClass) {
        byte[] bytes2 = name2.getBytes();
        if (encodings.get(bytes2) != null) {
            throw new InternalException("encoding already registerd <%n>", name2);
        }
        encodings.putDirect(bytes2, new Entry(encodingClass));
    }

    public static void alias(String alias, String original) {
        byte[] origBytes = original.getBytes();
        Entry originalEntry = encodings.get(origBytes);
        if (originalEntry == null) {
            throw new InternalException("no such encoding <%n>", original);
        }
        byte[] aliasBytes = alias.getBytes();
        if (aliases.get(aliasBytes) != null) {
            throw new InternalException("encoding alias already registerd <%n>", alias);
        }
        aliases.putDirect(aliasBytes, originalEntry);
    }

    public static void replicate(String replica, String original) {
        byte[] origBytes = original.getBytes();
        Entry originalEntry = encodings.get(origBytes);
        if (originalEntry == null) {
            throw new InternalException("no such encoding <%n>", original);
        }
        EncodingDB.finishReplica(replica, originalEntry.isDummy, originalEntry);
    }

    private static void replicate(String replica, String original, boolean dummy) {
        byte[] origBytes = original.getBytes();
        Entry originalEntry = encodings.get(origBytes);
        if (originalEntry == null) {
            throw new InternalException("no such encoding <%n>", original);
        }
        EncodingDB.finishReplica(replica, dummy, originalEntry);
    }

    private static void finishReplica(String replica, boolean dummy, Entry originalEntry) {
        byte[] replicaBytes = replica.getBytes();
        if (encodings.get(replicaBytes) != null) {
            throw new InternalException("encoding replica already registerd <%n>", replica);
        }
        encodings.putDirect(replicaBytes, new Entry(replicaBytes, originalEntry, dummy));
    }

    public static void set_base(String name2, String original) {
    }

    public static Entry dummy(byte[] bytes2) {
        if (encodings.get(bytes2) != null) {
            throw new InternalException("encoding already registerd <%n>", new String(bytes2));
        }
        Entry entry = new Entry(bytes2);
        encodings.putDirect(bytes2, entry);
        return entry;
    }

    public static void dummy(String name2) {
        EncodingDB.dummy(name2.getBytes());
    }

    public static void dummy_unicode(String replica) {
        EncodingDB.replicate(replica, replica + "BE", true);
    }

    static {
        encodings = new CaseInsensitiveBytesHash(50);
        aliases = new CaseInsensitiveBytesHash(150);
        EncodingList.load();
    }

    public static final class Entry {
        private static int count;
        private final Entry base;
        private Encoding encoding;
        private final String encodingClass;
        private final int index;
        private final boolean isDummy;
        private final byte[] name;

        private Entry(byte[] name2, String encodingClass, Entry base, boolean isDummy) {
            this.name = name2;
            this.encodingClass = encodingClass;
            this.base = base;
            this.isDummy = isDummy;
            this.index = count++;
        }

        Entry(String encodingClass) {
            this(null, encodingClass, null, false);
        }

        Entry(byte[] name2, Entry base) {
            this(name2, base.encodingClass, base, false);
        }

        Entry(byte[] name2) {
            this(name2, EncodingDB.ascii.encodingClass, ascii, true);
        }

        Entry(byte[] name2, Entry base, boolean dummy) {
            this(name2, base.encodingClass, base, dummy);
        }

        public int hashCode() {
            return this.encodingClass.hashCode();
        }

        public Entry getBase() {
            return this.base;
        }

        public Encoding getEncoding() {
            if (this.encoding == null) {
                if (this.name == null) {
                    this.encoding = Encoding.load(this.encodingClass);
                } else {
                    this.encoding = Encoding.load(this.encodingClass).replicate(this.name);
                    if (this.isDummy) {
                        this.encoding.setDummy();
                    }
                }
            }
            return this.encoding;
        }

        public String getEncodingClass() {
            return this.encodingClass;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isDummy() {
            return this.isDummy;
        }
    }
}

