/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtElementImpl;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceFilter;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolver;
import org.jetbrains.kotlin.resolve.calls.KotlinResolutionConfigurationKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.CoroutineInferenceUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallKind;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyForImplicitConstructorDelegationCall;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyForInvoke;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyImpl;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolutionOldInference;
import org.jetbrains.kotlin.resolve.calls.tower.PSICallResolver;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.SyntheticScopes;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitorDispatcher;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.PerformanceCounter;

public class CallResolver {
    private ExpressionTypingServices expressionTypingServices;
    private TypeResolver typeResolver;
    private ArgumentTypeResolver argumentTypeResolver;
    private GenericCandidateResolver genericCandidateResolver;
    private CallCompleter callCompleter;
    private SyntheticScopes syntheticScopes;
    private NewResolutionOldInference newResolutionOldInference;
    private PSICallResolver PSICallResolver;
    private final KotlinBuiltIns builtIns;
    private final LanguageVersionSettings languageVersionSettings;
    private static final PerformanceCounter callResolvePerfCounter = PerformanceCounter.Companion.create("Call resolve", ExpressionTypingVisitorDispatcher.typeInfoPerfCounter);

    public CallResolver(@NotNull KotlinBuiltIns builtIns, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (builtIns == null) {
            CallResolver.$$$reportNull$$$0(0);
        }
        if (languageVersionSettings == null) {
            CallResolver.$$$reportNull$$$0(1);
        }
        this.builtIns = builtIns;
        this.languageVersionSettings = languageVersionSettings;
    }

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            CallResolver.$$$reportNull$$$0(2);
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    @Inject
    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        if (typeResolver == null) {
            CallResolver.$$$reportNull$$$0(3);
        }
        this.typeResolver = typeResolver;
    }

    @Inject
    public void setArgumentTypeResolver(@NotNull ArgumentTypeResolver argumentTypeResolver) {
        if (argumentTypeResolver == null) {
            CallResolver.$$$reportNull$$$0(4);
        }
        this.argumentTypeResolver = argumentTypeResolver;
    }

    @Inject
    public void setGenericCandidateResolver(GenericCandidateResolver genericCandidateResolver) {
        this.genericCandidateResolver = genericCandidateResolver;
    }

    @Inject
    public void setCallCompleter(@NotNull CallCompleter callCompleter) {
        if (callCompleter == null) {
            CallResolver.$$$reportNull$$$0(5);
        }
        this.callCompleter = callCompleter;
    }

    @Inject
    public void setResolutionOldInference(@NotNull NewResolutionOldInference newResolutionOldInference) {
        if (newResolutionOldInference == null) {
            CallResolver.$$$reportNull$$$0(6);
        }
        this.newResolutionOldInference = newResolutionOldInference;
    }

    @Inject
    public void setPSICallResolver(@NotNull PSICallResolver PSICallResolver2) {
        if (PSICallResolver2 == null) {
            CallResolver.$$$reportNull$$$0(7);
        }
        this.PSICallResolver = PSICallResolver2;
    }

    @Inject
    public void setSyntheticScopes(@NotNull SyntheticScopes syntheticScopes) {
        if (syntheticScopes == null) {
            CallResolver.$$$reportNull$$$0(8);
        }
        this.syntheticScopes = syntheticScopes;
    }

    @NotNull
    public OverloadResolutionResults<VariableDescriptor> resolveSimpleProperty(@NotNull BasicCallResolutionContext context) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(9);
        }
        KtExpression calleeExpression = context.call.getCalleeExpression();
        assert (calleeExpression instanceof KtSimpleNameExpression);
        KtSimpleNameExpression nameExpression = (KtSimpleNameExpression)calleeExpression;
        Name referencedName = nameExpression.getReferencedNameAsName();
        OverloadResolutionResults<VariableDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context, referencedName, nameExpression, NewResolutionOldInference.ResolutionKind.Variable.INSTANCE);
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(10);
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<CallableDescriptor> resolveCallForMember(@NotNull KtSimpleNameExpression nameExpression, @NotNull BasicCallResolutionContext context) {
        if (nameExpression == null) {
            CallResolver.$$$reportNull$$$0(11);
        }
        if (context == null) {
            CallResolver.$$$reportNull$$$0(12);
        }
        OverloadResolutionResults<CallableDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context, nameExpression.getReferencedNameAsName(), nameExpression, NewResolutionOldInference.ResolutionKind.CallableReference.INSTANCE);
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(13);
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenName(@NotNull ResolutionContext<?> context, @NotNull Call call2, @NotNull KtReferenceExpression functionReference, @NotNull Name name) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(14);
        }
        if (call2 == null) {
            CallResolver.$$$reportNull$$$0(15);
        }
        if (functionReference == null) {
            CallResolver.$$$reportNull$$$0(16);
        }
        if (name == null) {
            CallResolver.$$$reportNull$$$0(17);
        }
        BasicCallResolutionContext callResolutionContext = BasicCallResolutionContext.create(context, call2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(callResolutionContext, name, functionReference, NewResolutionOldInference.ResolutionKind.Function.INSTANCE);
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(18);
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenName(@NotNull ResolutionContext<?> context, @NotNull Call call2, @NotNull Name name, @NotNull TracingStrategy tracing) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(19);
        }
        if (call2 == null) {
            CallResolver.$$$reportNull$$$0(20);
        }
        if (name == null) {
            CallResolver.$$$reportNull$$$0(21);
        }
        if (tracing == null) {
            CallResolver.$$$reportNull$$$0(22);
        }
        BasicCallResolutionContext callResolutionContext = BasicCallResolutionContext.create(context, call2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(callResolutionContext, name, tracing, NewResolutionOldInference.ResolutionKind.Function.INSTANCE);
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(23);
        }
        return overloadResolutionResults;
    }

    @NotNull
    private OverloadResolutionResults<FunctionDescriptor> resolveCallForInvoke(@NotNull BasicCallResolutionContext context, @NotNull TracingStrategy tracing) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(24);
        }
        if (tracing == null) {
            CallResolver.$$$reportNull$$$0(25);
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context, OperatorNameConventions.INVOKE, tracing, NewResolutionOldInference.ResolutionKind.Invoke.INSTANCE);
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(26);
        }
        return overloadResolutionResults;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResults<D> computeTasksAndResolveCall(@NotNull BasicCallResolutionContext context, @NotNull Name name, @NotNull KtReferenceExpression referenceExpression, @NotNull NewResolutionOldInference.ResolutionKind<D> kind) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(27);
        }
        if (name == null) {
            CallResolver.$$$reportNull$$$0(28);
        }
        if (referenceExpression == null) {
            CallResolver.$$$reportNull$$$0(29);
        }
        if (kind == null) {
            CallResolver.$$$reportNull$$$0(30);
        }
        TracingStrategy tracing = TracingStrategyImpl.create(referenceExpression, context.call);
        OverloadResolutionResults<D> overloadResolutionResults = this.computeTasksAndResolveCall(context, name, tracing, kind);
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(31);
        }
        return overloadResolutionResults;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResults<D> computeTasksAndResolveCall(@NotNull BasicCallResolutionContext context, @NotNull Name name, @NotNull TracingStrategy tracing, @NotNull NewResolutionOldInference.ResolutionKind<D> kind) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(32);
        }
        if (name == null) {
            CallResolver.$$$reportNull$$$0(33);
        }
        if (tracing == null) {
            CallResolver.$$$reportNull$$$0(34);
        }
        if (kind == null) {
            CallResolver.$$$reportNull$$$0(35);
        }
        OverloadResolutionResults overloadResolutionResults = callResolvePerfCounter.time(() -> {
            if (kind == null) {
                CallResolver.$$$reportNull$$$0(124);
            }
            if (name == null) {
                CallResolver.$$$reportNull$$$0(125);
            }
            if (context == null) {
                CallResolver.$$$reportNull$$$0(126);
            }
            if (tracing == null) {
                CallResolver.$$$reportNull$$$0(127);
            }
            ResolutionTask resolutionTask = new ResolutionTask(kind, name, null);
            return this.doResolveCallOrGetCachedResults(context, resolutionTask, tracing);
        });
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(36);
        }
        return overloadResolutionResults;
    }

    @NotNull
    private <D extends FunctionDescriptor> OverloadResolutionResults<D> computeTasksFromCandidatesAndResolvedCall(@NotNull BasicCallResolutionContext context, @NotNull KtReferenceExpression referenceExpression, @NotNull Collection<ResolutionCandidate<D>> candidates2) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(37);
        }
        if (referenceExpression == null) {
            CallResolver.$$$reportNull$$$0(38);
        }
        if (candidates2 == null) {
            CallResolver.$$$reportNull$$$0(39);
        }
        OverloadResolutionResults<D> overloadResolutionResults = this.computeTasksFromCandidatesAndResolvedCall(context, candidates2, TracingStrategyImpl.create(referenceExpression, context.call));
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(40);
        }
        return overloadResolutionResults;
    }

    @NotNull
    private <D extends FunctionDescriptor> OverloadResolutionResults<D> computeTasksFromCandidatesAndResolvedCall(@NotNull BasicCallResolutionContext context, @NotNull Collection<ResolutionCandidate<D>> candidates2, @NotNull TracingStrategy tracing) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(41);
        }
        if (candidates2 == null) {
            CallResolver.$$$reportNull$$$0(42);
        }
        if (tracing == null) {
            CallResolver.$$$reportNull$$$0(43);
        }
        OverloadResolutionResults overloadResolutionResults = callResolvePerfCounter.time(() -> {
            if (candidates2 == null) {
                CallResolver.$$$reportNull$$$0(121);
            }
            if (context == null) {
                CallResolver.$$$reportNull$$$0(122);
            }
            if (tracing == null) {
                CallResolver.$$$reportNull$$$0(123);
            }
            ResolutionTask resolutionTask = new ResolutionTask(new NewResolutionOldInference.ResolutionKind.GivenCandidates(), null, candidates2);
            return this.doResolveCallOrGetCachedResults(context, resolutionTask, tracing);
        });
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(44);
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveBinaryCall(ExpressionTypingContext context, ExpressionReceiver receiver, KtBinaryExpression binaryExpression, Name name) {
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveCallWithGivenName(context, CallMaker.makeCall((ReceiverValue)receiver, binaryExpression), binaryExpression.getOperationReference(), name);
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(45);
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCollectionLiteralCallWithGivenDescriptor(@NotNull ExpressionTypingContext context, @NotNull KtCollectionLiteralExpression expression2, @NotNull Call call2, @NotNull Collection<FunctionDescriptor> functionDescriptors2) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(46);
        }
        if (expression2 == null) {
            CallResolver.$$$reportNull$$$0(47);
        }
        if (call2 == null) {
            CallResolver.$$$reportNull$$$0(48);
        }
        if (functionDescriptors2 == null) {
            CallResolver.$$$reportNull$$$0(49);
        }
        BasicCallResolutionContext callResolutionContext = BasicCallResolutionContext.create(context, call2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        List candidates2 = CollectionsKt.map(functionDescriptors2, descriptor2 -> {
            if (call2 == null) {
                CallResolver.$$$reportNull$$$0(120);
            }
            return ResolutionCandidate.create(call2, descriptor2, null, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, null);
        });
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksFromCandidatesAndResolvedCall(callResolutionContext, candidates2, TracingStrategyImpl.create(expression2, call2));
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(50);
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveEqualsCallWithGivenDescriptors(@NotNull ExpressionTypingContext context, @NotNull KtReferenceExpression expression2, @NotNull ExpressionReceiver receiver, @NotNull Call call2, @NotNull Collection<FunctionDescriptor> functionDescriptors2) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(51);
        }
        if (expression2 == null) {
            CallResolver.$$$reportNull$$$0(52);
        }
        if (receiver == null) {
            CallResolver.$$$reportNull$$$0(53);
        }
        if (call2 == null) {
            CallResolver.$$$reportNull$$$0(54);
        }
        if (functionDescriptors2 == null) {
            CallResolver.$$$reportNull$$$0(55);
        }
        BasicCallResolutionContext callResolutionContext = BasicCallResolutionContext.create(context, call2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        List resolutionCandidates = CollectionsKt.map(functionDescriptors2, descriptor2 -> {
            if (call2 == null) {
                CallResolver.$$$reportNull$$$0(118);
            }
            if (receiver == null) {
                CallResolver.$$$reportNull$$$0(119);
            }
            return ResolutionCandidate.create(call2, descriptor2, receiver, ExplicitReceiverKind.DISPATCH_RECEIVER, null);
        });
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksFromCandidatesAndResolvedCall(callResolutionContext, resolutionCandidates, TracingStrategyImpl.create(expression2, call2));
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(56);
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFunctionCall(@NotNull BindingTrace trace, @NotNull LexicalScope scope, @NotNull Call call2, @NotNull KotlinType expectedType2, @NotNull DataFlowInfo dataFlowInfo, boolean isAnnotationContext) {
        if (trace == null) {
            CallResolver.$$$reportNull$$$0(57);
        }
        if (scope == null) {
            CallResolver.$$$reportNull$$$0(58);
        }
        if (call2 == null) {
            CallResolver.$$$reportNull$$$0(59);
        }
        if (expectedType2 == null) {
            CallResolver.$$$reportNull$$$0(60);
        }
        if (dataFlowInfo == null) {
            CallResolver.$$$reportNull$$$0(61);
        }
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveFunctionCall(BasicCallResolutionContext.create(trace, scope, call2, expectedType2, dataFlowInfo, ContextDependency.INDEPENDENT, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, isAnnotationContext));
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(62);
        }
        return overloadResolutionResults;
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFunctionCall(@NotNull BasicCallResolutionContext context) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(63);
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        Call.CallType callType = context.call.getCallType();
        if (callType == Call.CallType.ARRAY_GET_METHOD || callType == Call.CallType.ARRAY_SET_METHOD) {
            Name name = callType == Call.CallType.ARRAY_GET_METHOD ? OperatorNameConventions.GET : OperatorNameConventions.SET;
            KtArrayAccessExpression arrayAccessExpression = (KtArrayAccessExpression)context.call.getCallElement();
            OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context, name, arrayAccessExpression, NewResolutionOldInference.ResolutionKind.Function.INSTANCE);
            if (overloadResolutionResults == null) {
                CallResolver.$$$reportNull$$$0(64);
            }
            return overloadResolutionResults;
        }
        KtExpression calleeExpression = context.call.getCalleeExpression();
        if (calleeExpression instanceof KtSimpleNameExpression) {
            KtSimpleNameExpression expression2 = (KtSimpleNameExpression)calleeExpression;
            OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.computeTasksAndResolveCall(context, expression2.getReferencedNameAsName(), expression2, NewResolutionOldInference.ResolutionKind.Function.INSTANCE);
            if (overloadResolutionResults == null) {
                CallResolver.$$$reportNull$$$0(65);
            }
            return overloadResolutionResults;
        }
        if (calleeExpression instanceof KtConstructorCalleeExpression) {
            OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveCallForConstructor(context, (KtConstructorCalleeExpression)calleeExpression);
            if (overloadResolutionResults == null) {
                CallResolver.$$$reportNull$$$0(66);
            }
            return overloadResolutionResults;
        }
        if (calleeExpression instanceof KtConstructorDelegationReferenceExpression) {
            KtConstructorDelegationCall delegationCall = (KtConstructorDelegationCall)context.call.getCallElement();
            DeclarationDescriptor container2 = context.scope.getOwnerDescriptor();
            assert (container2 instanceof ConstructorDescriptor) : "Trying to resolve JetConstructorDelegationCall not in constructor. scope.ownerDescriptor = " + container2;
            OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveConstructorDelegationCall(context, delegationCall, (KtConstructorDelegationReferenceExpression)calleeExpression, (ClassConstructorDescriptor)container2);
            if (overloadResolutionResults == null) {
                CallResolver.$$$reportNull$$$0(67);
            }
            return overloadResolutionResults;
        }
        if (calleeExpression == null) {
            OverloadResolutionResultsImpl<FunctionDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context);
            if (overloadResolutionResultsImpl == null) {
                CallResolver.$$$reportNull$$$0(68);
            }
            return overloadResolutionResultsImpl;
        }
        SimpleType expectedType2 = TypeUtils.NO_EXPECTED_TYPE;
        if (calleeExpression instanceof KtLambdaExpression) {
            int parameterNumber = ((KtLambdaExpression)calleeExpression).getValueParameters().size();
            ArrayList<SimpleType> parameterTypes = new ArrayList<SimpleType>(parameterNumber);
            for (int i = 0; i < parameterNumber; ++i) {
                parameterTypes.add(TypeUtils.NO_EXPECTED_TYPE);
            }
            expectedType2 = FunctionTypesKt.createFunctionType(this.builtIns, Annotations.Companion.getEMPTY(), null, parameterTypes, null, context.expectedType);
        }
        KotlinType calleeType = this.expressionTypingServices.safeGetType(context.scope, calleeExpression, expectedType2, context.dataFlowInfo, context.trace);
        ExpressionReceiver expressionReceiver = ExpressionReceiver.Companion.create(calleeExpression, calleeType, context.trace.getBindingContext());
        CallTransformer.CallForImplicitInvoke call2 = new CallTransformer.CallForImplicitInvoke(context.call.getExplicitReceiver(), expressionReceiver, context.call, false);
        TracingStrategyForInvoke tracingForInvoke = new TracingStrategyForInvoke(calleeExpression, call2, calleeType);
        OverloadResolutionResults<FunctionDescriptor> overloadResolutionResults = this.resolveCallForInvoke(context.replaceCall(call2), tracingForInvoke);
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(69);
        }
        return overloadResolutionResults;
    }

    private OverloadResolutionResults<ConstructorDescriptor> resolveCallForConstructor(@NotNull BasicCallResolutionContext context, @NotNull KtConstructorCalleeExpression expression2) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(70);
        }
        if (expression2 == null) {
            CallResolver.$$$reportNull$$$0(71);
        }
        assert (context.call.getExplicitReceiver() == null) : "Constructor can't be invoked with explicit receiver: " + context.call.getCallElement().getText();
        context.trace.record(BindingContext.LEXICAL_SCOPE, context.call.getCallElement(), context.scope);
        KtSimpleNameExpression functionReference = expression2.getConstructorReferenceExpression();
        KtTypeReference typeReference = expression2.getTypeReference();
        if (functionReference == null || typeReference == null) {
            return this.checkArgumentTypesAndFail(context);
        }
        KotlinType constructedType = this.typeResolver.resolveType(context.scope, typeReference, context.trace, true);
        if (KotlinTypeKt.isError(constructedType)) {
            return this.checkArgumentTypesAndFail(context);
        }
        ClassifierDescriptor declarationDescriptor = constructedType.getConstructor().getDeclarationDescriptor();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            context.trace.report(Errors.NOT_A_CLASS.on(expression2));
            return this.checkArgumentTypesAndFail(context);
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        Collection<ClassConstructorDescriptor> constructors2 = classDescriptor.getConstructors();
        if (constructors2.isEmpty()) {
            context.trace.report(Errors.NO_CONSTRUCTOR.on(CallUtilKt.getValueArgumentListOrElement(context.call)));
            return this.checkArgumentTypesAndFail(context);
        }
        return this.resolveConstructorCall(context, functionReference, constructedType);
    }

    @NotNull
    public OverloadResolutionResults<ConstructorDescriptor> resolveConstructorCall(@NotNull BasicCallResolutionContext context, @NotNull KtReferenceExpression functionReference, @NotNull KotlinType constructedType) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(72);
        }
        if (functionReference == null) {
            CallResolver.$$$reportNull$$$0(73);
        }
        if (constructedType == null) {
            CallResolver.$$$reportNull$$$0(74);
        }
        Pair<Collection<ResolutionCandidate<ConstructorDescriptor>>, BasicCallResolutionContext> candidatesAndContext = CallResolver.prepareCandidatesAndContextForConstructorCall(constructedType, context, this.syntheticScopes);
        Collection candidates2 = candidatesAndContext.getFirst();
        context = candidatesAndContext.getSecond();
        OverloadResolutionResults<ConstructorDescriptor> overloadResolutionResults = this.computeTasksFromCandidatesAndResolvedCall(context, functionReference, candidates2);
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(75);
        }
        return overloadResolutionResults;
    }

    @Nullable
    public OverloadResolutionResults<ConstructorDescriptor> resolveConstructorDelegationCall(@NotNull BindingTrace trace, @NotNull LexicalScope scope, @NotNull DataFlowInfo dataFlowInfo, @NotNull ClassConstructorDescriptor constructorDescriptor, @NotNull KtConstructorDelegationCall call2) {
        if (trace == null) {
            CallResolver.$$$reportNull$$$0(76);
        }
        if (scope == null) {
            CallResolver.$$$reportNull$$$0(77);
        }
        if (dataFlowInfo == null) {
            CallResolver.$$$reportNull$$$0(78);
        }
        if (constructorDescriptor == null) {
            CallResolver.$$$reportNull$$$0(79);
        }
        if (call2 == null) {
            CallResolver.$$$reportNull$$$0(80);
        }
        BasicCallResolutionContext context = BasicCallResolutionContext.create(trace, scope, CallMaker.makeCall(null, null, call2), TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, ContextDependency.INDEPENDENT, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, false);
        if (call2.getCalleeExpression() == null) {
            return this.checkArgumentTypesAndFail(context);
        }
        if (constructorDescriptor.getConstructedClass().getKind() == ClassKind.ENUM_CLASS && call2.isImplicit()) {
            return null;
        }
        return this.resolveConstructorDelegationCall(context, call2, call2.getCalleeExpression(), constructorDescriptor);
    }

    @NotNull
    private OverloadResolutionResults<ConstructorDescriptor> resolveConstructorDelegationCall(@NotNull BasicCallResolutionContext context, @NotNull KtConstructorDelegationCall call2, @NotNull KtConstructorDelegationReferenceExpression calleeExpression, @NotNull ClassConstructorDescriptor calleeConstructor) {
        KtElementImpl reportOn;
        if (context == null) {
            CallResolver.$$$reportNull$$$0(81);
        }
        if (call2 == null) {
            CallResolver.$$$reportNull$$$0(82);
        }
        if (calleeExpression == null) {
            CallResolver.$$$reportNull$$$0(83);
        }
        if (calleeConstructor == null) {
            CallResolver.$$$reportNull$$$0(84);
        }
        context.trace.record(BindingContext.LEXICAL_SCOPE, call2, context.scope);
        ClassDescriptor currentClassDescriptor = calleeConstructor.getContainingDeclaration();
        boolean isThisCall = calleeExpression.isThis();
        if (currentClassDescriptor.getKind() == ClassKind.ENUM_CLASS && !isThisCall) {
            context.trace.report(Errors.DELEGATION_SUPER_CALL_IN_ENUM_CONSTRUCTOR.on(calleeExpression));
            OverloadResolutionResultsImpl<ConstructorDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context);
            if (overloadResolutionResultsImpl == null) {
                CallResolver.$$$reportNull$$$0(85);
            }
            return overloadResolutionResultsImpl;
        }
        ClassDescriptor delegateClassDescriptor = isThisCall ? currentClassDescriptor : DescriptorUtilsKt.getSuperClassOrAny(currentClassDescriptor);
        Collection<ClassConstructorDescriptor> constructors2 = delegateClassDescriptor.getConstructors();
        if (!isThisCall && currentClassDescriptor.getUnsubstitutedPrimaryConstructor() != null) {
            if (DescriptorUtils.canHaveDeclaredConstructors(currentClassDescriptor)) {
                context.trace.report(Errors.PRIMARY_CONSTRUCTOR_DELEGATION_CALL_EXPECTED.on((KtConstructorDelegationCall)calleeExpression.getParent()));
            }
            if (call2.isImplicit()) {
                OverloadResolutionResultsImpl<ConstructorDescriptor> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.nameNotFound();
                if (overloadResolutionResultsImpl == null) {
                    CallResolver.$$$reportNull$$$0(86);
                }
                return overloadResolutionResultsImpl;
            }
        }
        if (constructors2.isEmpty()) {
            context.trace.report(Errors.NO_CONSTRUCTOR.on(CallUtilKt.getValueArgumentListOrElement(context.call)));
            OverloadResolutionResultsImpl<ConstructorDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context);
            if (overloadResolutionResultsImpl == null) {
                CallResolver.$$$reportNull$$$0(87);
            }
            return overloadResolutionResultsImpl;
        }
        KotlinType superType = isThisCall ? calleeConstructor.getContainingDeclaration().getDefaultType() : DescriptorUtils.getSuperClassType(currentClassDescriptor);
        Pair<Collection<ResolutionCandidate<ConstructorDescriptor>>, BasicCallResolutionContext> candidatesAndContext = CallResolver.prepareCandidatesAndContextForConstructorCall(superType, context, this.syntheticScopes);
        Collection candidates2 = candidatesAndContext.getFirst();
        context = candidatesAndContext.getSecond();
        TracingStrategy tracing = call2.isImplicit() ? new TracingStrategyForImplicitConstructorDelegationCall(call2, context.call) : TracingStrategyImpl.create(calleeExpression, context.call);
        KtElementImpl ktElementImpl = reportOn = call2.isImplicit() ? call2 : calleeExpression;
        if (delegateClassDescriptor.isInner() && !DescriptorResolver.checkHasOuterClassInstance(context.scope, context.trace, reportOn, (ClassDescriptor)delegateClassDescriptor.getContainingDeclaration())) {
            OverloadResolutionResultsImpl<ConstructorDescriptor> overloadResolutionResultsImpl = this.checkArgumentTypesAndFail(context);
            if (overloadResolutionResultsImpl == null) {
                CallResolver.$$$reportNull$$$0(88);
            }
            return overloadResolutionResultsImpl;
        }
        OverloadResolutionResults<ConstructorDescriptor> overloadResolutionResults = this.computeTasksFromCandidatesAndResolvedCall(context, candidates2, tracing);
        if (overloadResolutionResults == null) {
            CallResolver.$$$reportNull$$$0(89);
        }
        return overloadResolutionResults;
    }

    @NotNull
    private static Pair<Collection<ResolutionCandidate<ConstructorDescriptor>>, BasicCallResolutionContext> prepareCandidatesAndContextForConstructorCall(@NotNull KotlinType superType, @NotNull BasicCallResolutionContext context, @NotNull SyntheticScopes syntheticScopes) {
        if (superType == null) {
            CallResolver.$$$reportNull$$$0(90);
        }
        if (context == null) {
            CallResolver.$$$reportNull$$$0(91);
        }
        if (syntheticScopes == null) {
            CallResolver.$$$reportNull$$$0(92);
        }
        if (!(superType.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor)) {
            Pair<Collection<ResolutionCandidate<ConstructorDescriptor>>, BasicCallResolutionContext> pair = new Pair<Collection<ResolutionCandidate<ConstructorDescriptor>>, BasicCallResolutionContext>(Collections.emptyList(), context);
            if (pair == null) {
                CallResolver.$$$reportNull$$$0(93);
            }
            return pair;
        }
        boolean anyConstructorHasDeclaredTypeParameters = CallResolver.anyConstructorHasDeclaredTypeParameters(superType.getConstructor().getDeclarationDescriptor());
        if (anyConstructorHasDeclaredTypeParameters) {
            context = (BasicCallResolutionContext)context.replaceExpectedType(superType);
        }
        List<ResolutionCandidate<ConstructorDescriptor>> candidates2 = CallResolverUtilKt.createResolutionCandidatesForConstructors(context.scope, context.call, superType, !anyConstructorHasDeclaredTypeParameters, syntheticScopes);
        Pair<Collection<ResolutionCandidate<ConstructorDescriptor>>, BasicCallResolutionContext> pair = new Pair<Collection<ResolutionCandidate<ConstructorDescriptor>>, BasicCallResolutionContext>(candidates2, context);
        if (pair == null) {
            CallResolver.$$$reportNull$$$0(94);
        }
        return pair;
    }

    private static boolean anyConstructorHasDeclaredTypeParameters(@Nullable ClassifierDescriptor classDescriptor) {
        if (!(classDescriptor instanceof ClassDescriptor)) {
            return false;
        }
        for (ConstructorDescriptor constructorDescriptor : ((ClassDescriptor)classDescriptor).getConstructors()) {
            if (constructorDescriptor.getTypeParameters().size() <= constructorDescriptor.getContainingDeclaration().getDeclaredTypeParameters().size()) continue;
            return true;
        }
        return false;
    }

    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithKnownCandidate(@NotNull Call call2, @NotNull TracingStrategy tracing, @NotNull ResolutionContext<?> context, @NotNull ResolutionCandidate<FunctionDescriptor> candidate, @Nullable MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        if (call2 == null) {
            CallResolver.$$$reportNull$$$0(95);
        }
        if (tracing == null) {
            CallResolver.$$$reportNull$$$0(96);
        }
        if (context == null) {
            CallResolver.$$$reportNull$$$0(97);
        }
        if (candidate == null) {
            CallResolver.$$$reportNull$$$0(98);
        }
        return callResolvePerfCounter.time(() -> {
            if (context == null) {
                CallResolver.$$$reportNull$$$0(114);
            }
            if (call2 == null) {
                CallResolver.$$$reportNull$$$0(115);
            }
            if (candidate == null) {
                CallResolver.$$$reportNull$$$0(116);
            }
            if (tracing == null) {
                CallResolver.$$$reportNull$$$0(117);
            }
            BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(context, call2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, dataFlowInfoForArguments);
            Set<ResolutionCandidate> candidates2 = Collections.singleton(candidate);
            ResolutionTask resolutionTask = new ResolutionTask(new NewResolutionOldInference.ResolutionKind.GivenCandidates(), null, candidates2);
            return this.doResolveCallOrGetCachedResults(basicCallResolutionContext, resolutionTask, tracing);
        });
    }

    private <D extends CallableDescriptor> OverloadResolutionResults<D> doResolveCallOrGetCachedResults(@NotNull BasicCallResolutionContext context, @NotNull ResolutionTask<D> resolutionTask, @NotNull TracingStrategy tracing) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(99);
        }
        if (resolutionTask == null) {
            CallResolver.$$$reportNull$$$0(100);
        }
        if (tracing == null) {
            CallResolver.$$$reportNull$$$0(101);
        }
        Call call2 = context.call;
        tracing.bindCall(context.trace, call2);
        if (KotlinResolutionConfigurationKt.getUSE_NEW_INFERENCE() && resolutionTask.resolutionKind.getKotlinCallKind() != KotlinCallKind.UNSUPPORTED) {
            assert (resolutionTask.name != null);
            return this.PSICallResolver.runResolutionAndInference(context, resolutionTask.name, resolutionTask.resolutionKind, tracing);
        }
        if (KotlinResolutionConfigurationKt.getUSE_NEW_INFERENCE() && resolutionTask.resolutionKind instanceof NewResolutionOldInference.ResolutionKind.GivenCandidates) {
            assert (resolutionTask.givenCandidates != null);
            return this.PSICallResolver.runResolutionAndInferenceForGivenCandidates(context, resolutionTask.givenCandidates, tracing);
        }
        TemporaryBindingTrace traceToResolveCall = TemporaryBindingTrace.create(context.trace, "trace to resolve call", call2);
        BasicCallResolutionContext newContext = (BasicCallResolutionContext)context.replaceBindingTrace(traceToResolveCall);
        BindingContextUtilsKt.recordScope(newContext.trace, newContext.scope, newContext.call.getCalleeExpression());
        BindingContextUtilsKt.recordDataFlowInfo(newContext, newContext.call.getCalleeExpression());
        OverloadResolutionResultsImpl<D> results = this.doResolveCall(newContext, resolutionTask, tracing);
        if (CoroutineInferenceUtilKt.isResultWithCoroutineInference(results)) {
            traceToResolveCall.commit();
            return results;
        }
        DelegatingBindingTrace deltasTraceForTypeInference = results.getTrace();
        if (deltasTraceForTypeInference != null) {
            deltasTraceForTypeInference.addOwnDataTo(traceToResolveCall);
        }
        this.completeTypeInferenceDependentOnFunctionLiterals(newContext, results, tracing);
        if (context.contextDependency == ContextDependency.DEPENDENT) {
            CallResolver.cacheResults(context, results, traceToResolveCall, tracing);
        }
        traceToResolveCall.commit();
        if (context.contextDependency == ContextDependency.INDEPENDENT) {
            results = this.callCompleter.completeCall(context, results, tracing);
        }
        return results;
    }

    private <D extends CallableDescriptor> void completeTypeInferenceDependentOnFunctionLiterals(@NotNull BasicCallResolutionContext context, @NotNull OverloadResolutionResultsImpl<D> results, @NotNull TracingStrategy tracing) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(102);
        }
        if (results == null) {
            CallResolver.$$$reportNull$$$0(103);
        }
        if (tracing == null) {
            CallResolver.$$$reportNull$$$0(104);
        }
        if (CallResolverUtilKt.isInvokeCallOnVariable(context.call)) {
            return;
        }
        if (!results.isSingleResult()) {
            if (results.getResultCode() == OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE) {
                this.argumentTypeResolver.checkTypesWithNoCallee(context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
            }
            return;
        }
        CallCandidateResolutionContext candidateContext = CallCandidateResolutionContext.createForCallBeingAnalyzed(results.getResultingCall(), context, tracing);
        this.genericCandidateResolver.completeTypeInferenceDependentOnFunctionArgumentsForCall(candidateContext);
    }

    private static <F extends CallableDescriptor> void cacheResults(@NotNull BasicCallResolutionContext context, @NotNull OverloadResolutionResultsImpl<F> results, @NotNull DelegatingBindingTrace traceToResolveCall, @NotNull TracingStrategy tracing) {
        Call call2;
        if (context == null) {
            CallResolver.$$$reportNull$$$0(105);
        }
        if (results == null) {
            CallResolver.$$$reportNull$$$0(106);
        }
        if (traceToResolveCall == null) {
            CallResolver.$$$reportNull$$$0(107);
        }
        if (tracing == null) {
            CallResolver.$$$reportNull$$$0(108);
        }
        if (CallResolverUtilKt.isInvokeCallOnVariable(call2 = context.call)) {
            return;
        }
        DelegatingBindingTrace deltasTraceToCacheResolve = new DelegatingBindingTrace(BindingContext.EMPTY, "delta trace for caching resolve of", context.call, BindingTraceFilter.Companion.getACCEPT_ALL(), false);
        traceToResolveCall.addOwnDataTo(deltasTraceToCacheResolve);
        context.resolutionResultsCache.record(call2, results, context, tracing, deltasTraceToCacheResolve);
    }

    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> checkArgumentTypesAndFail(BasicCallResolutionContext context) {
        this.argumentTypeResolver.checkTypesWithNoCallee(context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        return OverloadResolutionResultsImpl.nameNotFound();
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> doResolveCall(@NotNull BasicCallResolutionContext context, @NotNull ResolutionTask<D> resolutionTask, @NotNull TracingStrategy tracing) {
        if (context == null) {
            CallResolver.$$$reportNull$$$0(109);
        }
        if (resolutionTask == null) {
            CallResolver.$$$reportNull$$$0(110);
        }
        if (tracing == null) {
            CallResolver.$$$reportNull$$$0(111);
        }
        if (context.checkArguments == CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) {
            this.argumentTypeResolver.analyzeArgumentsAndRecordTypes(context, ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
        }
        List<KtTypeProjection> typeArguments2 = context.call.getTypeArguments();
        for (KtTypeProjection projection : typeArguments2) {
            KotlinType type2;
            if (projection.getProjectionKind() != KtProjectionKind.NONE) {
                context.trace.report(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT.on(projection));
                ModifierCheckerCore.INSTANCE.check(projection, context.trace, null, this.languageVersionSettings);
            }
            if ((type2 = this.argumentTypeResolver.resolveTypeRefWithDefault(projection.getTypeReference(), context.scope, context.trace, null)) == null) continue;
            ForceResolveUtil.forceResolveAllContents(type2);
        }
        if (!(resolutionTask.resolutionKind instanceof NewResolutionOldInference.ResolutionKind.GivenCandidates)) {
            assert (resolutionTask.name != null);
            OverloadResolutionResultsImpl overloadResolutionResultsImpl = this.newResolutionOldInference.runResolution(context, resolutionTask.name, resolutionTask.resolutionKind, tracing);
            if (overloadResolutionResultsImpl == null) {
                CallResolver.$$$reportNull$$$0(112);
            }
            return overloadResolutionResultsImpl;
        }
        assert (resolutionTask.givenCandidates != null);
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = this.newResolutionOldInference.runResolutionForGivenCandidates(context, tracing, resolutionTask.givenCandidates);
        if (overloadResolutionResultsImpl == null) {
            CallResolver.$$$reportNull$$$0(113);
        }
        return overloadResolutionResultsImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 13: 
            case 18: 
            case 23: 
            case 26: 
            case 31: 
            case 36: 
            case 40: 
            case 44: 
            case 45: 
            case 50: 
            case 56: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 75: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 93: 
            case 94: 
            case 112: 
            case 113: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 13: 
            case 18: 
            case 23: 
            case 26: 
            case 31: 
            case 36: 
            case 40: 
            case 44: 
            case 45: 
            case 50: 
            case 56: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 75: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 93: 
            case 94: 
            case 112: 
            case 113: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtIns";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionTypingServices";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeResolver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypeResolver";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callCompleter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newResolutionOldInference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "PSICallResolver";
                break;
            }
            case 8: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntheticScopes";
                break;
            }
            case 9: 
            case 12: 
            case 14: 
            case 19: 
            case 24: 
            case 27: 
            case 32: 
            case 37: 
            case 41: 
            case 46: 
            case 51: 
            case 63: 
            case 70: 
            case 72: 
            case 81: 
            case 91: 
            case 97: 
            case 99: 
            case 102: 
            case 105: 
            case 109: 
            case 114: 
            case 122: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 13: 
            case 18: 
            case 23: 
            case 26: 
            case 31: 
            case 36: 
            case 40: 
            case 44: 
            case 45: 
            case 50: 
            case 56: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 75: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 93: 
            case 94: 
            case 112: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/calls/CallResolver";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameExpression";
                break;
            }
            case 15: 
            case 20: 
            case 48: 
            case 54: 
            case 59: 
            case 80: 
            case 82: 
            case 95: 
            case 115: 
            case 118: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 16: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReference";
                break;
            }
            case 17: 
            case 21: 
            case 28: 
            case 33: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: 
            case 25: 
            case 34: 
            case 43: 
            case 96: 
            case 101: 
            case 104: 
            case 108: 
            case 111: 
            case 117: 
            case 123: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracing";
                break;
            }
            case 29: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 30: 
            case 35: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 39: 
            case 42: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 47: 
            case 52: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 49: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptors";
                break;
            }
            case 53: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 57: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 58: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 61: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlowInfo";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructedType";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorDescriptor";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calleeExpression";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calleeConstructor";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superType";
                break;
            }
            case 98: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 100: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolutionTask";
                break;
            }
            case 103: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceToResolveCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/CallResolver";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSimpleProperty";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveCallForMember";
                break;
            }
            case 18: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveCallWithGivenName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveCallForInvoke";
                break;
            }
            case 31: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTasksAndResolveCall";
                break;
            }
            case 40: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTasksFromCandidatesAndResolvedCall";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveBinaryCall";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveCollectionLiteralCallWithGivenDescriptor";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveEqualsCallWithGivenDescriptors";
                break;
            }
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFunctionCall";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveConstructorCall";
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveConstructorDelegationCall";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareCandidatesAndContextForConstructorCall";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setExpressionTypingServices";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTypeResolver";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setArgumentTypeResolver";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCallCompleter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setResolutionOldInference";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setPSICallResolver";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setSyntheticScopes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveSimpleProperty";
                break;
            }
            case 10: 
            case 13: 
            case 18: 
            case 23: 
            case 26: 
            case 31: 
            case 36: 
            case 40: 
            case 44: 
            case 45: 
            case 50: 
            case 56: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 75: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 93: 
            case 94: 
            case 112: 
            case 113: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveCallForMember";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolveCallWithGivenName";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "resolveCallForInvoke";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "computeTasksAndResolveCall";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "computeTasksFromCandidatesAndResolvedCall";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "resolveCollectionLiteralCallWithGivenDescriptor";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "resolveEqualsCallWithGivenDescriptors";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "resolveFunctionCall";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "resolveCallForConstructor";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstructorCall";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstructorDelegationCall";
                break;
            }
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "prepareCandidatesAndContextForConstructorCall";
                break;
            }
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "resolveCallWithKnownCandidate";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "doResolveCallOrGetCachedResults";
                break;
            }
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "completeTypeInferenceDependentOnFunctionLiterals";
                break;
            }
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "cacheResults";
                break;
            }
            case 109: 
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "doResolveCall";
                break;
            }
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveCallWithKnownCandidate$4";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveEqualsCallWithGivenDescriptors$3";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveCollectionLiteralCallWithGivenDescriptor$2";
                break;
            }
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "lambda$computeTasksFromCandidatesAndResolvedCall$1";
                break;
            }
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "lambda$computeTasksAndResolveCall$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 13: 
            case 18: 
            case 23: 
            case 26: 
            case 31: 
            case 36: 
            case 40: 
            case 44: 
            case 45: 
            case 50: 
            case 56: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 75: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 93: 
            case 94: 
            case 112: 
            case 113: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ResolutionTask<D extends CallableDescriptor> {
        @Nullable
        final Name name;
        @Nullable
        final Collection<ResolutionCandidate<D>> givenCandidates;
        @NotNull
        final NewResolutionOldInference.ResolutionKind<D> resolutionKind;

        private ResolutionTask(@NotNull NewResolutionOldInference.ResolutionKind<D> kind, @Nullable Name name, @Nullable Collection<ResolutionCandidate<D>> candidates2) {
            if (kind == null) {
                ResolutionTask.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.givenCandidates = candidates2;
            this.resolutionKind = kind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/resolve/calls/CallResolver$ResolutionTask", "<init>"));
        }
    }
}

