/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.TypeAliasExpansionReportStrategy;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.CandidateResolver;
import org.jetbrains.kotlin.resolve.calls.CandidateResolver$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolver;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolverKt;
import org.jetbrains.kotlin.resolve.calls.ValueArgumentsToParametersMapper;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CandidateResolveMode;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.SubstitutionFilteringInternalResolveAnnotations;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatchStatus;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastManager;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastResult;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.FunctionPlaceholdersKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.ErrorTypesAreEqualToAnything;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.DoubleColonExpressionResolver;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001:\u0002lmB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ&\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J*\u0010\u001b\u001a\u00060\u001cR\u00020\u0000\"\b\b\u0000\u0010\u001d*\u00020\u000f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u00102\u0006\u0010\u001f\u001a\u00020 J\u0014\u0010!\u001a\u00020\u00142\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J \u0010\"\u001a\u00020#\"\b\b\u0000\u0010\u001d*\u00020\u000f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0010H\u0002J(\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002JJ\u0010,\u001a\u00060\u001cR\u00020\u0000\"\b\b\u0000\u0010\u001d*\u00020\u000f\"\u000e\b\u0001\u0010-*\b\u0012\u0004\u0012\u0002H-0.2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H-0.2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H\u001d002\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\u000fH\u0002J\u0014\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u000107H\u0002J&\u00108\u001a\u00020%\"\b\b\u0000\u0010\u001d*\u00020\u000f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u00102\u0006\u00109\u001a\u00020:J.\u0010;\u001a\u0004\u0018\u00010\u00162\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00162\u0006\u0010?\u001a\u00020\u00162\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030@H\u0002J\u001a\u0010A\u001a\u0004\u0018\u00010#2\u0006\u0010B\u001a\u00020\u00162\u0006\u0010C\u001a\u00020\u0016H\u0002J<\u0010D\u001a\u00020%\"\b\b\u0000\u0010\u001d*\u00020\u000f*\b\u0012\u0004\u0012\u0002H\u001d0\u00102\u001d\u0010E\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0\u0010\u0012\u0004\u0012\u00020%0F\u00a2\u0006\u0002\bGH\u0082\bJ\u0010\u0010H\u001a\u00020%*\u0006\u0012\u0002\b\u00030\u0010H\u0002J<\u0010I\u001a\u00020%\"\b\b\u0000\u0010\u001d*\u00020\u000f*\b\u0012\u0004\u0012\u0002H\u001d0\u00102\u001d\u0010E\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0\u0010\u0012\u0004\u0012\u00020#0F\u00a2\u0006\u0002\bGH\u0082\bJ\u0010\u0010J\u001a\u00020%*\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u0010\u0010K\u001a\u00020%*\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u001c\u0010L\u001a\u00020%\"\b\b\u0000\u0010\u001d*\u00020\u000f*\b\u0012\u0004\u0012\u0002H\u001d0\u0010H\u0002J\u0010\u0010M\u001a\u00020%*\u0006\u0012\u0002\b\u00030\u0010H\u0002JD\u0010N\u001a\u00020%*\u0006\u0012\u0002\b\u00030\u00102\f\u0010O\u001a\b\u0012\u0004\u0012\u00020P0\u00192\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00160\u00192\u0006\u0010R\u001a\u00020\u000f2\u0006\u0010S\u001a\u00020*2\u0006\u0010T\u001a\u00020UH\u0002J6\u0010V\u001a\u00020%*\u0006\u0012\u0002\b\u00030\u00102\f\u0010O\u001a\b\u0012\u0004\u0012\u00020P0\u00192\u0006\u0010W\u001a\u00020X2\u0006\u0010)\u001a\u00020*2\u0006\u0010T\u001a\u00020UH\u0002JV\u0010Y\u001a\u00020#\"\b\b\u0000\u0010\u001d*\u00020\u000f*\b\u0012\u0004\u0012\u0002H\u001d0\u00102\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H\u001d002\b\u0010Z\u001a\u0004\u0018\u00010[2\b\u0010\\\u001a\u0004\u0018\u00010]2\u0006\u0010^\u001a\u00020\u00142\u0006\u0010_\u001a\u00020\u00142\u0006\u0010`\u001a\u00020\u0014H\u0002J\u0010\u0010a\u001a\u00020%*\u0006\u0012\u0002\b\u00030\u0010H\u0002J$\u0010a\u001a\u00020%*\u0006\u0012\u0002\b\u00030\u00102\b\u0010b\u001a\u0004\u0018\u00010[2\b\u0010\\\u001a\u0004\u0018\u00010]H\u0002J\u0010\u0010c\u001a\u00020%*\u0006\u0012\u0002\b\u00030\u0010H\u0002J$\u0010d\u001a\u00020#*\u0006\u0012\u0002\b\u00030\u00102\b\u0010\\\u001a\u0004\u0018\u00010]2\b\u0010e\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010f\u001a\u00020%*\u0006\u0012\u0002\b\u00030\u0010H\u0002J$\u0010g\u001a\u00020\u0014*\u0006\u0012\u0002\b\u00030\u00102\b\u0010\\\u001a\u0004\u0018\u00010]2\b\u0010e\u001a\u0004\u0018\u00010\u0016H\u0002J,\u0010h\u001a\u00020\u0014*\u0006\u0012\u0002\b\u00030\u00102\b\u0010\\\u001a\u0004\u0018\u00010]2\b\u0010e\u001a\u0004\u0018\u00010\u00162\u0006\u0010`\u001a\u00020\u0014H\u0002J\u001c\u0010i\u001a\u00020%\"\b\b\u0000\u0010\u001d*\u00020\u000f*\b\u0012\u0004\u0012\u0002H\u001d0\u0010H\u0002J\u0010\u0010j\u001a\u00020%*\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u001c\u0010k\u001a\u00020\u0014\"\b\b\u0000\u0010\u001d*\u00020\u000f*\b\u0012\u0004\u0012\u0002H\u001d0\u0010H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006n"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;", "", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "genericCandidateResolver", "Lorg/jetbrains/kotlin/resolve/calls/GenericCandidateResolver;", "reflectionTypes", "Lorg/jetbrains/kotlin/builtins/ReflectionTypes;", "additionalTypeCheckers", "", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "smartCastManager", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager;", "(Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/resolve/calls/GenericCandidateResolver;Lorg/jetbrains/kotlin/builtins/ReflectionTypes;Ljava/lang/Iterable;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager;)V", "candidateDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/context/CallCandidateResolutionContext;", "getCandidateDescriptor", "(Lorg/jetbrains/kotlin/resolve/calls/context/CallCandidateResolutionContext;)Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "canBeSubtype", "", "subType", "Lorg/jetbrains/kotlin/types/KotlinType;", "superType", "candidateTypeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "checkAllValueArguments", "Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver$ValueArgumentsCheckingResult;", "D", "context", "resolveFunctionArgumentBodies", "Lorg/jetbrains/kotlin/resolve/calls/callResolverUtil/ResolveArgumentsMode;", "checkOuterClassMemberIsAccessible", "checkReceivers", "Lorg/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;", "checkTypeInTypeAliasSubstitutionRec", "", "reportStrategy", "Lorg/jetbrains/kotlin/resolve/TypeAliasExpansionReportStrategy;", "unsubstitutedType", "typeAliasParametersSubstitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "boundsSubstitutor", "checkValueArgumentTypes", "C", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "candidateCall", "Lorg/jetbrains/kotlin/resolve/calls/model/MutableResolvedCall;", "getDeclaringClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "candidate", "getReceiverSuper", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "performResolutionForCandidateCall", "checkArguments", "Lorg/jetbrains/kotlin/resolve/calls/context/CheckArgumentTypesMode;", "smartCastValueArgumentTypeIfPossible", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expectedType", "actualType", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "tryNotNullableArgument", "argumentType", "parameterType", "check", "checker", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "checkAbstractAndSuper", "checkAndReport", "checkConstructedExpandedType", "checkDispatchReceiver", "checkExpectedCallableType", "checkExtensionReceiver", "checkGenericBoundsInAFunctionCall", "ktTypeArguments", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "typeArguments", "functionDescriptor", "substitutor", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkGenericBoundsInTypeAliasConstructorCall", "typeAliasConstructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/TypeAliasConstructorDescriptor;", "checkReceiver", "receiverParameter", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "receiverArgument", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "isExplicitReceiver", "implicitInvokeCheck", "isDispatchReceiver", "checkReceiverTypeError", "receiverParameterDescriptor", "checkValueArguments", "checkVisibilityWithDispatchReceiver", "smartCastType", "checkVisibilityWithoutReceiver", "isCandidateVisible", "isCandidateVisibleOrExtensionReceiver", "mapArguments", "processTypeArguments", "shouldContinue", "TypeAliasSingleStepExpansionReportStrategy", "ValueArgumentsCheckingResult", "kotlin-compiler"})
public final class CandidateResolver {
    private final ArgumentTypeResolver argumentTypeResolver;
    private final GenericCandidateResolver genericCandidateResolver;
    private final ReflectionTypes reflectionTypes;
    private final Iterable<AdditionalTypeChecker> additionalTypeCheckers;
    private final SmartCastManager smartCastManager;

    public final <D extends CallableDescriptor> void performResolutionForCandidateCall(@NotNull CallCandidateResolutionContext<D> context, @NotNull CheckArgumentTypesMode checkArguments) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull((Object)checkArguments, "checkArguments");
        CallCandidateResolutionContext<D> $receiver = context;
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        if (ErrorUtils.isError(this.getCandidateDescriptor($receiver))) {
            $receiver.candidateCall.addStatus(ResolutionStatus.SUCCESS);
            return;
        }
        if (!this.checkOuterClassMemberIsAccessible($receiver)) {
            $receiver.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            return;
        }
        if (!context.isDebuggerContext) {
            this.checkVisibilityWithoutReceiver($receiver);
        }
        switch (CandidateResolver$WhenMappings.$EnumSwitchMapping$0[checkArguments.ordinal()]) {
            case 1: {
                this.mapArguments($receiver);
                break;
            }
            case 2: {
                this.checkExpectedCallableType($receiver);
            }
        }
        this.checkReceiverTypeError($receiver);
        this.checkExtensionReceiver($receiver);
        this.checkDispatchReceiver($receiver);
        this.processTypeArguments($receiver);
        this.checkValueArguments($receiver);
        this.checkAbstractAndSuper($receiver);
        this.checkConstructedExpandedType($receiver);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkValueArguments(@NotNull CallCandidateResolutionContext<?> $receiver) {
        CandidateResolver this_$iv = this;
        CallCandidateResolutionContext<?> $receiver$iv = $receiver;
        if (this_$iv.shouldContinue($receiver$iv)) {
            void $receiver2;
            CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver$iv;
            MutableResolvedCall mutableResolvedCall = $receiver$iv.candidateCall;
            ResolutionStatus resolutionStatus = $receiver2.call.getTypeArguments().isEmpty() && !this.getCandidateDescriptor((CallCandidateResolutionContext<?>)$receiver2).getTypeParameters().isEmpty() && $receiver2.candidateCall.getKnownTypeParametersSubstitutor() == null ? this.genericCandidateResolver.inferTypeArguments($receiver2) : this.checkAllValueArguments((CallCandidateResolutionContext)$receiver2, ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS).getStatus();
            mutableResolvedCall.addStatus(resolutionStatus);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processTypeArguments(@NotNull CallCandidateResolutionContext<?> $receiver) {
        block10: {
            TypeSubstitution substitution2;
            int type22;
            List<KtTypeProjection> ktTypeArguments;
            CallCandidateResolutionContext<?> $receiver2;
            block11: {
                CandidateResolver this_$iv = this;
                CallCandidateResolutionContext<?> $receiver$iv = $receiver;
                if (!this_$iv.shouldContinue($receiver$iv)) break block10;
                $receiver2 = $receiver$iv;
                ktTypeArguments = $receiver2.call.getTypeArguments();
                if ($receiver2.candidateCall.getKnownTypeParametersSubstitutor() == null) break block11;
                MutableResolvedCall mutableResolvedCall = $receiver2.candidateCall;
                TypeSubstitutor typeSubstitutor2 = $receiver2.candidateCall.getKnownTypeParametersSubstitutor();
                if (typeSubstitutor2 == null) {
                    Intrinsics.throwNpe();
                }
                mutableResolvedCall.setResultingSubstitutor(typeSubstitutor2);
                break block10;
            }
            Collection collection = ktTypeArguments;
            if (!(!collection.isEmpty())) break block10;
            ArrayList<Object> typeArguments2 = new ArrayList<Object>();
            for (KtTypeProjection projection : ktTypeArguments) {
                Object object;
                block13: {
                    block12: {
                        KtTypeReference ktTypeReference;
                        object = projection.getTypeReference();
                        if (object == null) break block12;
                        KtTypeReference it = ktTypeReference = object;
                        object = (KotlinType)$receiver2.trace.getBindingContext().get(BindingContext.TYPE, it);
                        if (object != null) break block13;
                    }
                    SimpleType simpleType2 = ErrorUtils.createErrorType("Star projection in a call");
                    Intrinsics.checkExpressionValueIsNotNull(simpleType2, "ErrorUtils.createErrorTy\u2026ar projection in a call\")");
                    object = simpleType2;
                }
                Object type22 = object;
                typeArguments2.add(type22);
            }
            int expectedTypeArgumentCount = this.getCandidateDescriptor($receiver2).getTypeParameters().size();
            int n = ktTypeArguments.size();
            if (n <= (type22 = expectedTypeArgumentCount - 1)) {
                while (true) {
                    void index2;
                    typeArguments2.add(ErrorUtils.createErrorType("Explicit type argument expected for " + this.getCandidateDescriptor($receiver2).getTypeParameters().get((int)index2).getName()));
                    if (index2 == type22) break;
                    ++index2;
                }
            }
            CallableDescriptor callableDescriptor = this.getCandidateDescriptor($receiver2);
            if (callableDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
            }
            TypeSubstitution typeSubstitution = substitution2 = FunctionDescriptorUtil.createSubstitution((FunctionDescriptor)callableDescriptor, (List<KotlinType>)typeArguments2);
            Intrinsics.checkExpressionValueIsNotNull(typeSubstitution, "substitution");
            TypeSubstitutor substitutor2 = TypeSubstitutor.create(new SubstitutionFilteringInternalResolveAnnotations(typeSubstitution));
            if (expectedTypeArgumentCount != ktTypeArguments.size()) {
                $receiver2.candidateCall.addStatus(ResolutionStatus.WRONG_NUMBER_OF_TYPE_ARGUMENTS_ERROR);
                $receiver2.tracing.wrongNumberOfTypeArguments($receiver2.trace, expectedTypeArgumentCount, this.getCandidateDescriptor($receiver2));
            } else {
                List<KtTypeProjection> list2 = ktTypeArguments;
                Intrinsics.checkExpressionValueIsNotNull(list2, "ktTypeArguments");
                List list3 = typeArguments2;
                CallableDescriptor callableDescriptor2 = this.getCandidateDescriptor($receiver2);
                TypeSubstitutor typeSubstitutor3 = substitutor2;
                Intrinsics.checkExpressionValueIsNotNull(typeSubstitutor3, "substitutor");
                BindingTrace bindingTrace = $receiver2.trace;
                Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "trace");
                this.checkGenericBoundsInAFunctionCall($receiver2, list2, list3, callableDescriptor2, typeSubstitutor3, bindingTrace);
            }
            $receiver2.candidateCall.setResultingSubstitutor(substitutor2);
        }
    }

    private final <D extends CallableDescriptor> void mapArguments(@NotNull CallCandidateResolutionContext<D> $receiver) {
        CandidateResolver this_$iv = this;
        CallCandidateResolutionContext<D> $receiver$iv = $receiver;
        if (this_$iv.shouldContinue($receiver$iv)) {
            CallCandidateResolutionContext<D> $receiver2 = $receiver$iv;
            ValueArgumentsToParametersMapper.Status argumentMappingStatus = ValueArgumentsToParametersMapper.mapValueArgumentsToParameters($receiver2.call, $receiver2.tracing, $receiver2.candidateCall);
            if (!argumentMappingStatus.isSuccess()) {
                $receiver2.candidateCall.addStatus(ResolutionStatus.ARGUMENTS_MAPPING_ERROR);
            }
        }
    }

    private final <D extends CallableDescriptor> void checkExpectedCallableType(@NotNull CallCandidateResolutionContext<D> $receiver) {
        block6: {
            CallCandidateResolutionContext<D> $receiver2;
            block7: {
                DoubleColonLHS doubleColonLHS;
                KtExpression ktExpression;
                CandidateResolver this_$iv = this;
                CallCandidateResolutionContext<D> $receiver$iv = $receiver;
                if (!this_$iv.shouldContinue($receiver$iv)) break block6;
                $receiver2 = $receiver$iv;
                if (TypeUtils.noExpectedType($receiver2.expectedType)) break block6;
                DoubleColonExpressionResolver.Companion companion = DoubleColonExpressionResolver.Companion;
                Object d = $receiver2.candidateCall.getCandidateDescriptor();
                Object d2 = d;
                Intrinsics.checkExpressionValueIsNotNull(d, "candidateCall.candidateDescriptor");
                PsiElement psiElement = $receiver2.call.getCallElement().getParent();
                if (!(psiElement instanceof KtCallableReferenceExpression)) {
                    psiElement = null;
                }
                if ((ktExpression = (KtCallableReferenceExpression)psiElement) != null && (ktExpression = ktExpression.getReceiverExpression()) != null) {
                    KtExpression ktExpression2 = ktExpression;
                    Object d3 = d2;
                    DoubleColonExpressionResolver.Companion companion2 = companion;
                    KtExpression it = ktExpression2;
                    DoubleColonLHS doubleColonLHS2 = (DoubleColonLHS)$receiver2.trace.getBindingContext().get(BindingContext.DOUBLE_COLON_LHS, it);
                    companion = companion2;
                    d2 = d3;
                    doubleColonLHS = doubleColonLHS2;
                } else {
                    doubleColonLHS = null;
                }
                KotlinType candidateKCallableType = companion.createKCallableTypeForReference((CallableDescriptor)d2, doubleColonLHS, this.reflectionTypes, $receiver2.scope.getOwnerDescriptor());
                if (candidateKCallableType == null) break block7;
                KotlinType kotlinType = $receiver2.expectedType;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "expectedType");
                List<TypeParameterDescriptor> list2 = $receiver2.candidateCall.getCandidateDescriptor().getTypeParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, "candidateCall.candidateDescriptor.typeParameters");
                if (this.canBeSubtype(candidateKCallableType, kotlinType, list2)) break block6;
            }
            $receiver2.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
        }
    }

    private final boolean canBeSubtype(KotlinType subType, KotlinType superType, List<? extends TypeParameterDescriptor> candidateTypeParameters) {
        KotlinType subTypeSubstituted;
        Collection collection = candidateTypeParameters;
        SimpleType simpleType2 = TypeUtils.DONT_CARE;
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "TypeUtils.DONT_CARE");
        TypeSubstitutor substituteDontCare = GenericCandidateResolverKt.makeConstantSubstitutor(collection, simpleType2);
        KotlinType kotlinType = substituteDontCare.substitute(subType, Variance.INVARIANT);
        if (kotlinType == null) {
            return true;
        }
        KotlinType kotlinType2 = subTypeSubstituted = kotlinType;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "subTypeSubstituted");
        return ErrorTypesAreEqualToAnything.INSTANCE.isSubtypeOf(kotlinType2, superType);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkVisibilityWithoutReceiver(@NotNull CallCandidateResolutionContext<?> $receiver) {
        CandidateResolver this_$iv = this;
        CallCandidateResolutionContext<?> $receiver$iv = $receiver;
        if (this_$iv.shouldContinue($receiver$iv)) {
            void $receiver2;
            CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver$iv;
            MutableResolvedCall mutableResolvedCall = $receiver$iv.candidateCall;
            ResolutionStatus resolutionStatus = this.checkVisibilityWithDispatchReceiver((CallCandidateResolutionContext<?>)$receiver2, Visibilities.ALWAYS_SUITABLE_RECEIVER, null);
            mutableResolvedCall.addStatus(resolutionStatus);
        }
    }

    private final ResolutionStatus checkVisibilityWithDispatchReceiver(@NotNull CallCandidateResolutionContext<?> $receiver, ReceiverValue receiverArgument, KotlinType smartCastType) {
        ResolutionStatus resolutionStatus;
        DeclarationDescriptorWithVisibility invisibleMember = Visibilities.findInvisibleMember(SmartCastUtilKt.getReceiverValueWithSmartCast(receiverArgument, smartCastType), this.getCandidateDescriptor($receiver), $receiver.scope.getOwnerDescriptor());
        if (invisibleMember != null) {
            $receiver.tracing.invisibleMember($receiver.trace, invisibleMember);
            resolutionStatus = ResolutionStatus.INVISIBLE_MEMBER_ERROR;
        } else {
            resolutionStatus = ResolutionStatus.SUCCESS;
        }
        return resolutionStatus;
    }

    private final boolean isCandidateVisibleOrExtensionReceiver(@NotNull CallCandidateResolutionContext<?> $receiver, ReceiverValue receiverArgument, KotlinType smartCastType, boolean isDispatchReceiver) {
        return !isDispatchReceiver || this.isCandidateVisible($receiver, receiverArgument, smartCastType);
    }

    private final boolean isCandidateVisible(@NotNull CallCandidateResolutionContext<?> $receiver, ReceiverValue receiverArgument, KotlinType smartCastType) {
        return Visibilities.findInvisibleMember(SmartCastUtilKt.getReceiverValueWithSmartCast(receiverArgument, smartCastType), this.getCandidateDescriptor($receiver), $receiver.scope.getOwnerDescriptor()) == null;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkExtensionReceiver(@NotNull CallCandidateResolutionContext<?> $receiver) {
        CandidateResolver this_$iv = this;
        CallCandidateResolutionContext<?> $receiver$iv = $receiver;
        if (this_$iv.shouldContinue($receiver$iv)) {
            ResolutionStatus resolutionStatus;
            void $receiver2;
            CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver$iv;
            MutableResolvedCall mutableResolvedCall = $receiver$iv.candidateCall;
            ReceiverParameterDescriptor receiverParameter = $receiver2.candidateCall.getCandidateDescriptor().getExtensionReceiverParameter();
            ReceiverValue receiverArgument = $receiver2.candidateCall.getExtensionReceiver();
            if (receiverParameter != null && receiverArgument == null) {
                $receiver2.tracing.missingReceiver($receiver2.candidateCall.getTrace(), receiverParameter);
                resolutionStatus = ResolutionStatus.OTHER_ERROR;
            } else if (receiverParameter == null && receiverArgument != null) {
                $receiver2.tracing.noReceiverAllowed($receiver2.candidateCall.getTrace());
                resolutionStatus = $receiver2.call.getCalleeExpression() instanceof KtSimpleNameExpression ? ResolutionStatus.RECEIVER_PRESENCE_ERROR : ResolutionStatus.OTHER_ERROR;
            } else {
                resolutionStatus = ResolutionStatus.SUCCESS;
            }
            ResolutionStatus resolutionStatus2 = resolutionStatus;
            mutableResolvedCall.addStatus(resolutionStatus2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkDispatchReceiver(@NotNull CallCandidateResolutionContext<?> $receiver) {
        block6: {
            this_$iv = this;
            $receiver$iv = $receiver;
            if (!CandidateResolver.access$shouldContinue(this_$iv, $receiver$iv)) break block6;
            var4_4 = $receiver$iv;
            var12_5 = $receiver$iv.candidateCall;
            candidateDescriptor = this.getCandidateDescriptor((CallCandidateResolutionContext<?>)$receiver);
            dispatchReceiver = $receiver.candidateCall.getDispatchReceiver();
            if (dispatchReceiver == null) ** GOTO lbl-1000
            nestedClass = null;
            if (candidateDescriptor instanceof ClassConstructorDescriptor && DescriptorUtils.isStaticNestedClass(((ClassConstructorDescriptor)candidateDescriptor).getContainingDeclaration())) {
                nestedClass = ((ClassConstructorDescriptor)candidateDescriptor).getContainingDeclaration();
            } else if (candidateDescriptor instanceof FakeCallableDescriptorForObject) {
                nestedClass = ((FakeCallableDescriptorForObject)candidateDescriptor).getReferencedObject();
            }
            if (nestedClass != null) {
                $receiver.tracing.nestedClassAccessViaInstanceReference($receiver.trace, nestedClass, $receiver.candidateCall.getExplicitReceiverKind());
                v0 = ResolutionStatus.OTHER_ERROR;
            } else lbl-1000:
            // 2 sources

            {
                v1 = var7_9 = dispatchReceiver != null == ($receiver.candidateCall.getResultingDescriptor().getDispatchReceiverParameter() != null);
                if (_Assertions.ENABLED && !var7_9) {
                    var8_10 = "Shouldn't happen because of TaskPrioritizer: " + candidateDescriptor;
                    throw (Throwable)new AssertionError((Object)var8_10);
                }
                v0 = ResolutionStatus.SUCCESS;
            }
            var13_11 = v0;
            var12_5.addStatus(var13_11);
        }
    }

    private final boolean checkOuterClassMemberIsAccessible(CallCandidateResolutionContext<?> context) {
        checkOuterClassMemberIsAccessible.1 insideScript$ = checkOuterClassMemberIsAccessible.1.INSTANCE;
        if (!insideScript$.invoke(context.call.getCallElement())) {
            return true;
        }
        if (context.call.getExplicitReceiver() != null || context.call.getDispatchReceiver() != null) {
            return true;
        }
        Object d = context.candidateCall.getCandidateDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(d, "context.candidateCall.candidateDescriptor");
        ClassDescriptor candidateThis = this.getDeclaringClass((CallableDescriptor)d);
        if (candidateThis == null || candidateThis.getKind().isSingleton()) {
            return true;
        }
        return DescriptorResolver.checkHasOuterClassInstance(context.scope, context.trace, context.call.getCallElement(), candidateThis);
    }

    private final void checkAbstractAndSuper(@NotNull CallCandidateResolutionContext<?> $receiver) {
        CandidateResolver this_$iv = this;
        CallCandidateResolutionContext<?> $receiver$iv = $receiver;
        if (this_$iv.shouldContinue($receiver$iv)) {
            KtSuperExpression superExtensionReceiver;
            KtSuperExpression superDispatchReceiver;
            Modality modality;
            CallCandidateResolutionContext<?> $receiver2 = $receiver$iv;
            CallableDescriptor descriptor2 = this.getCandidateDescriptor($receiver2);
            KtExpression expression2 = $receiver2.candidateCall.getCall().getCalleeExpression();
            if (expression2 instanceof KtSimpleNameExpression && descriptor2 instanceof ConstructorDescriptor && Intrinsics.areEqual((Object)(modality = ((ConstructorDescriptor)descriptor2).getConstructedClass().getModality()), (Object)Modality.ABSTRACT)) {
                $receiver2.tracing.instantiationOfAbstractClass($receiver2.trace);
            }
            if ((superDispatchReceiver = this.getReceiverSuper($receiver2.candidateCall.getDispatchReceiver())) != null && descriptor2 instanceof MemberDescriptor && Intrinsics.areEqual((Object)((MemberDescriptor)((Object)descriptor2)).getModality(), (Object)Modality.ABSTRACT)) {
                $receiver2.tracing.abstractSuperCall($receiver2.trace);
                $receiver2.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            }
            if ((superExtensionReceiver = this.getReceiverSuper($receiver2.candidateCall.getExtensionReceiver())) != null) {
                $receiver2.trace.report(Errors.SUPER_CANT_BE_EXTENSION_RECEIVER.on((KtSuperExpression)((PsiElement)superExtensionReceiver), superExtensionReceiver.getText()));
                $receiver2.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            }
        }
    }

    private final void checkConstructedExpandedType(@NotNull CallCandidateResolutionContext<?> $receiver) {
        CallCandidateResolutionContext<?> $receiver2;
        CallableDescriptor descriptor2;
        CandidateResolver this_$iv = this;
        CallCandidateResolutionContext<?> $receiver$iv = $receiver;
        if (this_$iv.shouldContinue($receiver$iv) && (descriptor2 = this.getCandidateDescriptor($receiver2 = $receiver$iv)) instanceof TypeAliasConstructorDescriptor && TypeUtilsKt.containsTypeProjectionsInTopLevelArguments(((TypeAliasConstructorDescriptor)descriptor2).getReturnType())) {
            $receiver2.trace.report(Errors.EXPANDED_TYPE_CANNOT_BE_CONSTRUCTED.on((KtElement)((PsiElement)$receiver2.call.getCallElement()), ((TypeAliasConstructorDescriptor)descriptor2).getReturnType()));
            $receiver2.candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
        }
    }

    private final KtSuperExpression getReceiverSuper(Receiver receiver) {
        KtExpression expression2;
        if (receiver instanceof ExpressionReceiver && (expression2 = ((ExpressionReceiver)receiver).getExpression()) instanceof KtSuperExpression) {
            return (KtSuperExpression)expression2;
        }
        return null;
    }

    private final ClassDescriptor getDeclaringClass(CallableDescriptor candidate) {
        ReceiverParameterDescriptor receiverParameterDescriptor = candidate.getDispatchReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return null;
        }
        ReceiverParameterDescriptor expectedThis = receiverParameterDescriptor;
        DeclarationDescriptor descriptor2 = expectedThis.getContainingDeclaration();
        return descriptor2 instanceof ClassDescriptor ? (ClassDescriptor)descriptor2 : null;
    }

    @NotNull
    public final <D extends CallableDescriptor> ValueArgumentsCheckingResult checkAllValueArguments(@NotNull CallCandidateResolutionContext<D> context, @NotNull ResolveArgumentsMode resolveFunctionArgumentBodies) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull((Object)resolveFunctionArgumentBodies, "resolveFunctionArgumentBodies");
        CallResolutionContext callResolutionContext = context;
        MutableResolvedCall mutableResolvedCall = context.candidateCall;
        Intrinsics.checkExpressionValueIsNotNull(mutableResolvedCall, "context.candidateCall");
        ValueArgumentsCheckingResult checkingResult = this.checkValueArgumentTypes(callResolutionContext, mutableResolvedCall, resolveFunctionArgumentBodies);
        ResolutionStatus resultStatus = checkingResult.getStatus();
        ResolutionStatus resolutionStatus = resultStatus.combine(this.checkReceivers(context));
        Intrinsics.checkExpressionValueIsNotNull((Object)resolutionStatus, "resultStatus.combine(checkReceivers(context))");
        resultStatus = resolutionStatus;
        return new ValueArgumentsCheckingResult(resultStatus, checkingResult.getArgumentTypes());
    }

    private final <D extends CallableDescriptor, C extends CallResolutionContext<C>> ValueArgumentsCheckingResult checkValueArgumentTypes(CallResolutionContext<C> context, MutableResolvedCall<D> candidateCall, ResolveArgumentsMode resolveFunctionArgumentBodies) {
        ResolutionStatus resultStatus = ResolutionStatus.SUCCESS;
        ArrayList<KotlinType> argumentTypes2 = Lists.newArrayList();
        MutableDataFlowInfoForArguments infoForArguments = candidateCall.getDataFlowInfoForArguments();
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = candidateCall.getValueArguments();
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry2 = entry = iterator2.next();
            ValueParameterDescriptor parameterDescriptor = entry2.getKey();
            entry2 = entry;
            ResolvedValueArgument resolvedArgument = entry2.getValue();
            for (ValueArgument argument : resolvedArgument.getArguments()) {
                KtExpression expression2;
                if (argument.getArgumentExpression() == null) {
                    continue;
                }
                ValueParameterDescriptor valueParameterDescriptor = parameterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "parameterDescriptor");
                ValueArgument valueArgument = argument;
                Intrinsics.checkExpressionValueIsNotNull(valueArgument, "argument");
                KotlinType expectedType2 = CallResolverUtilKt.getEffectiveExpectedType(valueParameterDescriptor, valueArgument);
                CallResolutionContext newContext = (CallResolutionContext)((CallResolutionContext)context.replaceDataFlowInfo(infoForArguments.getInfo(argument))).replaceExpectedType(expectedType2);
                KotlinTypeInfo typeInfoForCall = this.argumentTypeResolver.getArgumentTypeInfo(expression2, newContext, resolveFunctionArgumentBodies);
                KotlinType type2 = typeInfoForCall.getType();
                infoForArguments.updateInfo(argument, typeInfoForCall.getDataFlowInfo());
                ArgumentMatchStatus matchStatus = ArgumentMatchStatus.SUCCESS;
                KotlinType resultingType = type2;
                if (type2 == null || KotlinTypeKt.isError(type2) && !FunctionPlaceholdersKt.isFunctionPlaceholder(type2)) {
                    matchStatus = ArgumentMatchStatus.ARGUMENT_HAS_NO_TYPE;
                } else if (!TypeUtils.noExpectedType(expectedType2)) {
                    DataFlowValue dataFlowValue;
                    SmartCastResult smartCastResult2;
                    if (!ArgumentTypeResolver.isSubtypeOfForArgumentType(type2, expectedType2)) {
                        KotlinType kotlinType = newContext.expectedType;
                        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "newContext.expectedType");
                        CallResolutionContext callResolutionContext = newContext;
                        Intrinsics.checkExpressionValueIsNotNull(callResolutionContext, "newContext");
                        KotlinType smartCast = this.smartCastValueArgumentTypeIfPossible(expression2, kotlinType, type2, callResolutionContext);
                        if (smartCast == null) {
                            ResolutionStatus resolutionStatus = this.tryNotNullableArgument(type2, expectedType2);
                            if (resolutionStatus == null) {
                                resolutionStatus = ResolutionStatus.OTHER_ERROR;
                            }
                            resultStatus = resolutionStatus;
                            matchStatus = ArgumentMatchStatus.TYPE_MISMATCH;
                        } else {
                            resultingType = smartCast;
                        }
                    } else if (ErrorUtils.containsUninferredParameter(expectedType2)) {
                        matchStatus = ArgumentMatchStatus.MATCH_MODULO_UNINFERRED_TYPES;
                    }
                    LeafPsiElement spreadElement = argument.getSpreadElement();
                    if (!(spreadElement == null || FlexibleTypesKt.isFlexible(type2) || !type2.isMarkedNullable() || (smartCastResult2 = SmartCastManager.Companion.checkAndRecordPossibleCast(dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression2, type2, (ResolutionContext)context), expectedType2, expression2, (ResolutionContext)context, null, false)) != null && smartCastResult2.isCorrect())) {
                        context.trace.report(Errors.SPREAD_OF_NULLABLE.on((LeafPsiElement)((PsiElement)spreadElement)));
                    }
                }
                argumentTypes2.add(resultingType);
                candidateCall.recordArgumentMatchStatus(argument, matchStatus);
            }
        }
        ArrayList<KotlinType> arrayList = argumentTypes2;
        Intrinsics.checkExpressionValueIsNotNull(arrayList, "argumentTypes");
        return new ValueArgumentsCheckingResult(resultStatus, (List<? extends KotlinType>)arrayList);
    }

    private final KotlinType smartCastValueArgumentTypeIfPossible(KtExpression expression2, KotlinType expectedType2, KotlinType actualType, ResolutionContext<?> context) {
        Object v2;
        block1: {
            KtExpression ktExpression = KtPsiUtil.safeDeparenthesize(expression2);
            Intrinsics.checkExpressionValueIsNotNull(ktExpression, "KtPsiUtil.safeDeparenthesize(expression)");
            BindingContext bindingContext = context.trace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull(bindingContext, "context.trace.bindingContext");
            ExpressionReceiver receiverToCast = ExpressionReceiver.Companion.create(ktExpression, actualType, bindingContext);
            Collection<KotlinType> variants = this.smartCastManager.getSmartCastVariantsExcludingReceiver(context, receiverToCast);
            Iterable $receiver$iv = variants;
            for (Object element$iv : $receiver$iv) {
                KotlinType possibleType = (KotlinType)element$iv;
                if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(possibleType, expectedType2)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    private final ResolutionStatus tryNotNullableArgument(KotlinType argumentType, KotlinType parameterType) {
        if (!argumentType.isMarkedNullable() || parameterType.isMarkedNullable()) {
            return null;
        }
        KotlinType notNullableArgumentType = TypeUtilsKt.makeNotNullable(argumentType);
        boolean isApplicable = ArgumentTypeResolver.isSubtypeOfForArgumentType(notNullableArgumentType, parameterType);
        return isApplicable ? ResolutionStatus.NULLABLE_ARGUMENT_TYPE_MISMATCH : null;
    }

    private final void checkReceiverTypeError(@NotNull CallCandidateResolutionContext<?> $receiver) {
        CandidateResolver this_$iv = this;
        CallCandidateResolutionContext<?> $receiver$iv = $receiver;
        if (this_$iv.shouldContinue($receiver$iv)) {
            CallCandidateResolutionContext<?> $receiver2 = $receiver$iv;
            ReceiverParameterDescriptor extensionReceiver = this.getCandidateDescriptor($receiver2).getExtensionReceiverParameter();
            ReceiverParameterDescriptor dispatchReceiver = this.getCandidateDescriptor($receiver2).getDispatchReceiverParameter();
            Call call2 = $receiver2.call;
            Intrinsics.checkExpressionValueIsNotNull(call2, "call");
            if (!CallResolverUtilKt.isInvokeCallOnExpressionWithBothReceivers(call2)) {
                this.checkReceiverTypeError($receiver2, extensionReceiver, $receiver2.candidateCall.getExtensionReceiver());
            }
            this.checkReceiverTypeError($receiver2, dispatchReceiver, $receiver2.candidateCall.getDispatchReceiver());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkReceiverTypeError(@NotNull CallCandidateResolutionContext<?> $receiver, ReceiverParameterDescriptor receiverParameterDescriptor, ReceiverValue receiverArgument) {
        void $receiver$iv;
        CallCandidateResolutionContext<?> callCandidateResolutionContext = $receiver;
        CandidateResolver this_$iv = this;
        if (this_$iv.shouldContinue((CallCandidateResolutionContext)$receiver$iv)) {
            void $receiver2;
            KotlinType erasedReceiverType;
            void var6_6 = $receiver$iv;
            MutableResolvedCall mutableResolvedCall = $receiver$iv.candidateCall;
            ResolutionStatus resolutionStatus = receiverParameterDescriptor == null || receiverArgument == null ? ResolutionStatus.SUCCESS : (!this.smartCastManager.isSubTypeBySmartCastIgnoringNullability(receiverArgument, erasedReceiverType = CallResolverUtilKt.getErasedReceiverType(receiverParameterDescriptor, this.getCandidateDescriptor((CallCandidateResolutionContext<?>)$receiver2)), (ResolutionContext)$receiver2) ? ResolutionStatus.RECEIVER_TYPE_ERROR : ResolutionStatus.SUCCESS);
            ResolutionStatus resolutionStatus2 = resolutionStatus;
            mutableResolvedCall.addStatus(resolutionStatus2);
        }
    }

    private final <D extends CallableDescriptor> ResolutionStatus checkReceivers(CallCandidateResolutionContext<D> context) {
        MutableResolvedCall candidateCall;
        ResolutionStatus resultStatus = ResolutionStatus.SUCCESS;
        MutableResolvedCall mutableResolvedCall = candidateCall = context.candidateCall;
        Intrinsics.checkExpressionValueIsNotNull(mutableResolvedCall, "candidateCall");
        ResolutionStatus resolutionStatus = resultStatus.combine(this.checkReceiver(context, mutableResolvedCall, candidateCall.getResultingDescriptor().getExtensionReceiverParameter(), candidateCall.getExtensionReceiver(), candidateCall.getExplicitReceiverKind().isExtensionReceiver(), false, false));
        Intrinsics.checkExpressionValueIsNotNull((Object)resolutionStatus, "resultStatus.combine(con\u2026ceiver = false\n        ))");
        resultStatus = resolutionStatus;
        ResolutionStatus resolutionStatus2 = resultStatus.combine(this.checkReceiver(context, candidateCall, candidateCall.getResultingDescriptor().getDispatchReceiverParameter(), candidateCall.getDispatchReceiver(), candidateCall.getExplicitReceiverKind().isDispatchReceiver(), context.call instanceof CallTransformer.CallForImplicitInvoke, true));
        Intrinsics.checkExpressionValueIsNotNull((Object)resolutionStatus2, "resultStatus.combine(con\u2026eceiver = true\n        ))");
        resultStatus = resolutionStatus2;
        if (!context.isDebuggerContext && candidateCall.getDispatchReceiver() != null && this.isCandidateVisible(context, Visibilities.ALWAYS_SUITABLE_RECEIVER, null)) {
            ResolutionStatus resolutionStatus3 = resultStatus.combine(this.checkVisibilityWithDispatchReceiver(context, candidateCall.getDispatchReceiver(), candidateCall.getSmartCastDispatchReceiverType()));
            Intrinsics.checkExpressionValueIsNotNull((Object)resolutionStatus3, "resultStatus.combine(\n  \u2026astDispatchReceiverType))");
            resultStatus = resolutionStatus3;
        }
        return resultStatus;
    }

    private final <D extends CallableDescriptor> ResolutionStatus checkReceiver(@NotNull CallCandidateResolutionContext<D> $receiver, MutableResolvedCall<D> candidateCall, ReceiverParameterDescriptor receiverParameter, ReceiverValue receiverArgument, boolean isExplicitReceiver, boolean implicitInvokeCheck, boolean isDispatchReceiver) {
        KtExpression expression2;
        DataFlowValue outerReceiverDataFlowValue;
        Nullability outerReceiverNullability;
        Receiver outerCallReceiver;
        if (receiverParameter == null || receiverArgument == null) {
            return ResolutionStatus.SUCCESS;
        }
        Object candidateDescriptor = candidateCall.getCandidateDescriptor();
        if (TypeUtils.dependsOnTypeParameters(receiverParameter.getType(), (Collection<TypeParameterDescriptor>)candidateDescriptor.getTypeParameters())) {
            return ResolutionStatus.SUCCESS;
        }
        KotlinType kotlinType = receiverParameter.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "receiverParameter.type");
        boolean isSubtypeBySmartCastIgnoringNullability = this.smartCastManager.isSubTypeBySmartCastIgnoringNullability(receiverArgument, kotlinType, (ResolutionContext)$receiver);
        if (!isSubtypeBySmartCastIgnoringNullability) {
            $receiver.tracing.wrongReceiverType($receiver.trace, receiverParameter, receiverArgument, (ResolutionContext<?>)$receiver.replaceCallPosition(new CallPosition.ExtensionReceiverPosition((ResolvedCall)candidateCall)));
            return ResolutionStatus.OTHER_ERROR;
        }
        Call call2 = candidateCall.getCall();
        boolean safeAccess = isExplicitReceiver && !implicitInvokeCheck && CallUtilKt.isExplicitSafeCall(call2);
        KotlinType expectedReceiverParameterType = safeAccess ? TypeUtils.makeNullable(receiverParameter.getType()) : receiverParameter.getType();
        boolean notNullReceiverExpected = !ArgumentTypeResolver.isSubtypeOfForArgumentType(receiverArgument.getType(), expectedReceiverParameterType);
        boolean smartCastNeeded = notNullReceiverExpected || !this.isCandidateVisibleOrExtensionReceiver($receiver, receiverArgument, null, isDispatchReceiver);
        boolean reportUnsafeCall = false;
        boolean nullableImplicitInvokeReceiver = false;
        KotlinType receiverArgumentType = receiverArgument.getType();
        if (implicitInvokeCheck && call2 instanceof CallTransformer.CallForImplicitInvoke && CallUtilKt.isSafeCall(call2) && Intrinsics.areEqual(outerCallReceiver = ((CallTransformer.CallForImplicitInvoke)call2).getOuterCall().getExplicitReceiver(), ((CallTransformer.CallForImplicitInvoke)call2).getExplicitReceiver()) ^ true && outerCallReceiver instanceof ReceiverValue && (outerReceiverNullability = $receiver.dataFlowInfo.getStableNullability(outerReceiverDataFlowValue = DataFlowValueFactory.createDataFlowValue((ReceiverValue)outerCallReceiver, (ResolutionContext)$receiver))).canBeNull() && !TypeUtils.isNullableType(expectedReceiverParameterType)) {
            nullableImplicitInvokeReceiver = true;
            receiverArgumentType = TypeUtils.makeNullable(receiverArgumentType);
        }
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiverArgument, (ResolutionContext)$receiver);
        Nullability nullability = $receiver.dataFlowInfo.getStableNullability(dataFlowValue);
        ReceiverValue receiverValue = receiverArgument;
        if (!(receiverValue instanceof ExpressionReceiver)) {
            receiverValue = null;
        }
        ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
        KtExpression ktExpression = expression2 = expressionReceiver != null ? expressionReceiver.getExpression() : null;
        if (nullability.canBeNull() && !nullability.canBeNonNull()) {
            if (!TypeUtils.isNullableType(expectedReceiverParameterType)) {
                reportUnsafeCall = true;
            }
            if (dataFlowValue.getImmanentNullability().canBeNonNull()) {
                KtExpression ktExpression2 = expression2;
                if (ktExpression2 != null) {
                    KtExpression ktExpression3;
                    KtExpression it = ktExpression3 = ktExpression2;
                    $receiver.trace.record(BindingContext.SMARTCAST_NULL, it);
                }
            }
        } else if (!nullableImplicitInvokeReceiver && smartCastNeeded) {
            KotlinType kotlinType2 = expectedReceiverParameterType;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "expectedReceiverParameterType");
            SmartCastResult smartCastResult2 = SmartCastManager.Companion.checkAndRecordPossibleCast(dataFlowValue, kotlinType2, (Function1<? super KotlinType, Boolean>)new Function1<KotlinType, Boolean>(this, $receiver, receiverArgument, isDispatchReceiver){
                final /* synthetic */ CandidateResolver this$0;
                final /* synthetic */ CallCandidateResolutionContext receiver$0;
                final /* synthetic */ ReceiverValue $receiverArgument;
                final /* synthetic */ boolean $isDispatchReceiver;

                public final boolean invoke(@NotNull KotlinType possibleSmartCast) {
                    Intrinsics.checkParameterIsNotNull(possibleSmartCast, "possibleSmartCast");
                    return CandidateResolver.access$isCandidateVisibleOrExtensionReceiver(this.this$0, this.receiver$0, this.$receiverArgument, possibleSmartCast, this.$isDispatchReceiver);
                }
                {
                    this.this$0 = candidateResolver;
                    this.receiver$0 = callCandidateResolutionContext;
                    this.$receiverArgument = receiverValue;
                    this.$isDispatchReceiver = bl;
                    super(1);
                }
            }, expression2, (ResolutionContext)$receiver, candidateCall.getCall(), true);
            if (smartCastResult2 == null) {
                if (notNullReceiverExpected) {
                    reportUnsafeCall = true;
                }
            } else {
                if (isDispatchReceiver) {
                    candidateCall.setSmartCastDispatchReceiverType(smartCastResult2.getResultType());
                } else {
                    candidateCall.updateExtensionReceiverWithSmartCastIfNeeded(smartCastResult2.getResultType());
                }
                if (!smartCastResult2.isCorrect()) {
                    return ResolutionStatus.UNSTABLE_SMARTCAST_FOR_RECEIVER_ERROR;
                }
            }
        }
        if (reportUnsafeCall || nullableImplicitInvokeReceiver) {
            $receiver.tracing.unsafeCall($receiver.trace, receiverArgumentType, implicitInvokeCheck);
            return ResolutionStatus.UNSAFE_CALL_ERROR;
        }
        Iterable<AdditionalTypeChecker> $receiver$iv = this.additionalTypeCheckers;
        Iterator<AdditionalTypeChecker> iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            AdditionalTypeChecker element$iv;
            AdditionalTypeChecker it = element$iv = iterator2.next();
            it.checkReceiver(receiverParameter, receiverArgument, safeAccess, (CallResolutionContext)$receiver);
        }
        return ResolutionStatus.SUCCESS;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkGenericBoundsInAFunctionCall(@NotNull CallCandidateResolutionContext<?> $receiver, List<? extends KtTypeProjection> ktTypeArguments, List<? extends KotlinType> typeArguments2, CallableDescriptor functionDescriptor, TypeSubstitutor substitutor2, BindingTrace trace) {
        if (functionDescriptor instanceof TypeAliasConstructorDescriptor) {
            this.checkGenericBoundsInTypeAliasConstructorCall($receiver, ktTypeArguments, (TypeAliasConstructorDescriptor)functionDescriptor, substitutor2, trace);
            return;
        }
        int n = 0;
        List<TypeParameterDescriptor> typeParameters2 = functionDescriptor.getTypeParameters();
        int n2 = Math.min(typeParameters2.size(), ktTypeArguments.size()) - 1;
        if (n <= n2) {
            while (true) {
                void i;
                TypeParameterDescriptor typeParameterDescriptor = typeParameters2.get((int)i);
                KotlinType typeArgument = typeArguments2.get((int)i);
                KtTypeReference typeReference = ktTypeArguments.get((int)i).getTypeReference();
                if (typeReference != null) {
                    DescriptorResolver.checkBounds(typeReference, typeArgument, typeParameterDescriptor, substitutor2, trace);
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    private final void checkGenericBoundsInTypeAliasConstructorCall(@NotNull CallCandidateResolutionContext<?> $receiver, List<? extends KtTypeProjection> ktTypeArguments, TypeAliasConstructorDescriptor typeAliasConstructorDescriptor, TypeSubstitutor typeAliasParametersSubstitutor, BindingTrace trace) {
        KotlinType kotlinType = typeAliasParametersSubstitutor.substitute(typeAliasConstructorDescriptor.getReturnType(), Variance.INVARIANT);
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        KotlinType substitutedType = kotlinType;
        TypeSubstitutor boundsSubstitutor = TypeSubstitutor.create(substitutedType);
        TypeAliasDescriptor typeAliasDescriptor = typeAliasConstructorDescriptor.getContainingDeclaration();
        SimpleType unsubstitutedType = typeAliasDescriptor.getExpandedType();
        if (KotlinTypeKt.isError(unsubstitutedType)) {
            return;
        }
        KtElement ktElement = $receiver.call.getCallElement();
        Intrinsics.checkExpressionValueIsNotNull(ktElement, "call.callElement");
        TypeAliasSingleStepExpansionReportStrategy reportStrategy = new TypeAliasSingleStepExpansionReportStrategy(ktElement, typeAliasDescriptor, ktTypeArguments, trace);
        TypeAliasExpansionReportStrategy typeAliasExpansionReportStrategy = reportStrategy;
        KotlinType kotlinType2 = unsubstitutedType;
        TypeSubstitutor typeSubstitutor2 = boundsSubstitutor;
        Intrinsics.checkExpressionValueIsNotNull(typeSubstitutor2, "boundsSubstitutor");
        this.checkTypeInTypeAliasSubstitutionRec(typeAliasExpansionReportStrategy, kotlinType2, typeAliasParametersSubstitutor, typeSubstitutor2);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeInTypeAliasSubstitutionRec(TypeAliasExpansionReportStrategy reportStrategy, KotlinType unsubstitutedType, TypeSubstitutor typeAliasParametersSubstitutor, TypeSubstitutor boundsSubstitutor) {
        List<TypeParameterDescriptor> typeParameters2 = unsubstitutedType.getConstructor().getParameters();
        List<TypeProjection> substitutedTypeArguments = typeAliasParametersSubstitutor.safeSubstitute(unsubstitutedType, Variance.INVARIANT).getArguments();
        int n = 0;
        int n2 = Math.min(typeParameters2.size(), substitutedTypeArguments.size()) - 1;
        if (n <= n2) {
            while (true) {
                void i;
                TypeProjection substitutedTypeProjection;
                if (!(substitutedTypeProjection = substitutedTypeArguments.get((int)i)).isStarProjection()) {
                    TypeParameterDescriptor typeParameter = typeParameters2.get((int)i);
                    KotlinType substitutedTypeArgument = substitutedTypeProjection.getType();
                    KotlinType unsubstitutedTypeArgument = unsubstitutedType.getArguments().get((int)i).getType();
                    DescriptorResolver.checkBoundsInTypeAlias(reportStrategy, unsubstitutedTypeArgument, substitutedTypeArgument, typeParameter, boundsSubstitutor);
                    KotlinType kotlinType = unsubstitutedTypeArgument;
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType, "unsubstitutedTypeArgument");
                    this.checkTypeInTypeAliasSubstitutionRec(reportStrategy, kotlinType, typeAliasParametersSubstitutor, boundsSubstitutor);
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    private final <D extends CallableDescriptor> boolean shouldContinue(@NotNull CallCandidateResolutionContext<D> $receiver) {
        return Intrinsics.areEqual((Object)$receiver.candidateResolveMode, (Object)CandidateResolveMode.FULLY) || $receiver.candidateCall.getStatus().possibleTransformToSuccess();
    }

    private final CallableDescriptor getCandidateDescriptor(@NotNull CallCandidateResolutionContext<?> $receiver) {
        Object d = $receiver.candidateCall.getCandidateDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(d, "candidateCall.candidateDescriptor");
        return d;
    }

    public CandidateResolver(@NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull GenericCandidateResolver genericCandidateResolver, @NotNull ReflectionTypes reflectionTypes, @NotNull Iterable<? extends AdditionalTypeChecker> additionalTypeCheckers, @NotNull SmartCastManager smartCastManager) {
        Intrinsics.checkParameterIsNotNull(argumentTypeResolver, "argumentTypeResolver");
        Intrinsics.checkParameterIsNotNull(genericCandidateResolver, "genericCandidateResolver");
        Intrinsics.checkParameterIsNotNull(reflectionTypes, "reflectionTypes");
        Intrinsics.checkParameterIsNotNull(additionalTypeCheckers, "additionalTypeCheckers");
        Intrinsics.checkParameterIsNotNull(smartCastManager, "smartCastManager");
        this.argumentTypeResolver = argumentTypeResolver;
        this.genericCandidateResolver = genericCandidateResolver;
        this.reflectionTypes = reflectionTypes;
        this.additionalTypeCheckers = additionalTypeCheckers;
        this.smartCastManager = smartCastManager;
    }

    public static final /* synthetic */ boolean access$isCandidateVisibleOrExtensionReceiver(CandidateResolver $this, @NotNull CallCandidateResolutionContext $receiver, @Nullable ReceiverValue receiverArgument, @Nullable KotlinType smartCastType, boolean isDispatchReceiver) {
        return $this.isCandidateVisibleOrExtensionReceiver($receiver, receiverArgument, smartCastType, isDispatchReceiver);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver$ValueArgumentsCheckingResult;", "", "status", "Lorg/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;", "argumentTypes", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;Lorg/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;Ljava/util/List;)V", "getArgumentTypes", "()Ljava/util/List;", "getStatus", "()Lorg/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;", "kotlin-compiler"})
    public final class ValueArgumentsCheckingResult {
        @NotNull
        private final ResolutionStatus status;
        @NotNull
        private final List<KotlinType> argumentTypes;

        @NotNull
        public final ResolutionStatus getStatus() {
            return this.status;
        }

        @NotNull
        public final List<KotlinType> getArgumentTypes() {
            return this.argumentTypes;
        }

        public ValueArgumentsCheckingResult(@NotNull ResolutionStatus status2, @NotNull List<? extends KotlinType> argumentTypes2) {
            Intrinsics.checkParameterIsNotNull((Object)status2, "status");
            Intrinsics.checkParameterIsNotNull(argumentTypes2, "argumentTypes");
            this.status = status2;
            this.argumentTypes = argumentTypes2;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\"\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\"\u0010\f\u001a\u0016\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver$TypeAliasSingleStepExpansionReportStrategy;", "Lorg/jetbrains/kotlin/resolve/TypeAliasExpansionReportStrategy;", "callElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "typeAlias", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "ktTypeArguments", "", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;Ljava/util/List;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "argumentsMapping", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "kotlin.jvm.PlatformType", "boundsViolationInSubstitution", "", "bound", "Lorg/jetbrains/kotlin/types/KotlinType;", "unsubstitutedArgument", "argument", "typeParameter", "conflictingProjection", "substitutedArgument", "recursiveTypeAlias", "repeatedAnnotation", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "wrongNumberOfTypeArguments", "numberOfParameters", "", "kotlin-compiler"})
    private static final class TypeAliasSingleStepExpansionReportStrategy
    implements TypeAliasExpansionReportStrategy {
        private final Map<TypeParameterDescriptor, KtTypeProjection> argumentsMapping;
        private final KtElement callElement;
        private final BindingTrace trace;

        @Override
        public void wrongNumberOfTypeArguments(@NotNull TypeAliasDescriptor typeAlias, int numberOfParameters) {
            Intrinsics.checkParameterIsNotNull(typeAlias, "typeAlias");
        }

        @Override
        public void conflictingProjection(@NotNull TypeAliasDescriptor typeAlias, @Nullable TypeParameterDescriptor typeParameter, @NotNull KotlinType substitutedArgument) {
            Intrinsics.checkParameterIsNotNull(typeAlias, "typeAlias");
            Intrinsics.checkParameterIsNotNull(substitutedArgument, "substitutedArgument");
        }

        @Override
        public void recursiveTypeAlias(@NotNull TypeAliasDescriptor typeAlias) {
            Intrinsics.checkParameterIsNotNull(typeAlias, "typeAlias");
        }

        @Override
        public void repeatedAnnotation(@NotNull AnnotationDescriptor annotation2) {
            Intrinsics.checkParameterIsNotNull(annotation2, "annotation");
        }

        @Override
        public void boundsViolationInSubstitution(@NotNull KotlinType bound, @NotNull KotlinType unsubstitutedArgument, @NotNull KotlinType argument, @NotNull TypeParameterDescriptor typeParameter) {
            KtTypeReference argumentTypeReferenceElement;
            KtTypeProjection argumentElement;
            Map<TypeParameterDescriptor, KtTypeProjection> map2;
            Intrinsics.checkParameterIsNotNull(bound, "bound");
            Intrinsics.checkParameterIsNotNull(unsubstitutedArgument, "unsubstitutedArgument");
            Intrinsics.checkParameterIsNotNull(argument, "argument");
            Intrinsics.checkParameterIsNotNull(typeParameter, "typeParameter");
            ClassifierDescriptor descriptorForUnsubstitutedArgument = unsubstitutedArgument.getConstructor().getDeclarationDescriptor();
            Map<TypeParameterDescriptor, KtTypeProjection> map3 = map2 = this.argumentsMapping;
            if (map3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
            }
            KtTypeProjection ktTypeProjection = argumentElement = map3.get(descriptorForUnsubstitutedArgument);
            KtTypeReference ktTypeReference = argumentTypeReferenceElement = ktTypeProjection != null ? ktTypeProjection.getTypeReference() : null;
            if (argumentTypeReferenceElement != null) {
                this.trace.report(Errors.UPPER_BOUND_VIOLATED.on((KtTypeReference)((PsiElement)argumentTypeReferenceElement), bound, argument));
            } else {
                this.trace.report(Errors.UPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION.on((KtElement)((PsiElement)this.callElement), bound, argument, typeParameter));
            }
        }

        public TypeAliasSingleStepExpansionReportStrategy(@NotNull KtElement callElement, @NotNull TypeAliasDescriptor typeAlias, @NotNull List<? extends KtTypeProjection> ktTypeArguments, @NotNull BindingTrace trace) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull(callElement, "callElement");
            Intrinsics.checkParameterIsNotNull(typeAlias, "typeAlias");
            Intrinsics.checkParameterIsNotNull(ktTypeArguments, "ktTypeArguments");
            Intrinsics.checkParameterIsNotNull(trace, "trace");
            this.callElement = callElement;
            this.trace = trace;
            boolean bl2 = bl = !KotlinTypeKt.isError(typeAlias.getExpandedType());
            if (_Assertions.ENABLED && !bl) {
                String string = "Incorrect type alias: " + typeAlias;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.argumentsMapping = MapsKt.toMap(CollectionsKt.zip((Iterable)typeAlias.getDeclaredTypeParameters(), (Iterable)ktTypeArguments));
        }
    }
}

