/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_uz extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arab";
        final String metaValue_bn = "bengal";
        final String metaValue_bo = "tibet";
        final String metaValue_el = "grek";
        final String metaValue_gu = "gujarot";
        final String metaValue_he = "ibroniy";
        final String metaValue_hy = "arman";
        final String metaValue_ja = "yapon";
        final String metaValue_kn = "kannada";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mo\u2018g\u2018ul";
        final String metaValue_or = "oriya";
        final String metaValue_si = "singal";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final String metaValue_th = "tay";
        final String metaValue_zh = "xitoy";
        final String metaValue_Hans = "soddalashgan xitoy";
        final String metaValue_Hant = "an\u2019anaviy xitoy";
        final Object[][] data = new Object[][] {
            { "sbp", "sangu" },
            { "nyn", "nyankole" },
            { "luo", "luo" },
            { "Zsym", "belgilar" },
            { "fil", "filipincha" },
            { "luy", "luhya" },
            { "es_ES", "ispan (Yevropa)" },
            { "teo", "teso" },
            { "ab", "abxaz" },
            { "AC", "Me\u2019roj oroli" },
            { "AD", "Andorra" },
            { "AE", "Birlashgan Arab Amirliklari" },
            { "nl_BE", "flamand" },
            { "AF", "Afg\u02bboniston" },
            { "af", "afrikaans" },
            { "AG", "Antigua va Barbados" },
            { "AI", "Angilya" },
            { "ak", "akan" },
            { "AL", "Albaniya" },
            { "AM", "Armaniston" },
            { "am", "amxar" },
            { "Arab", metaValue_ar },
            { "AO", "Angola" },
            { "Jpan", metaValue_ja },
            { "AQ", "Antarktida" },
            { "ar", metaValue_ar },
            { "AR", "Argentina" },
            { "AS", "Amerika Samoasi" },
            { "as", "assam" },
            { "AT", "Avstriya" },
            { "AU", "Avstraliya" },
            { "AW", "Aruba" },
            { "sdh", "janubiy kurd" },
            { "en_US", "ingliz (Amerika)" },
            { "AX", "Aland orollari" },
            { "AZ", "Ozarbayjon" },
            { "az", "ozarbayjon" },
            { "BA", "Bosniya va Gertsegovina" },
            { "ba", "boshqird" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgiya" },
            { "be", "belarus" },
            { "BF", "Burkina-Faso" },
            { "BG", "Bolgariya" },
            { "bg", "bolgar" },
            { "BH", "Bahrayn" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Sen-Bartelemi" },
            { "BM", "Bermuda orollari" },
            { "bm", "bambar" },
            { "bn", metaValue_bn },
            { "BN", "Bruney" },
            { "bo", metaValue_bo },
            { "BO", "Boliviya" },
            { "BQ", "Boneyr, Sint-Estatius va Saba" },
            { "BR", "Braziliya" },
            { "br", "breton" },
            { "BS", "Bagama orollari" },
            { "bs", "bosniy" },
            { "xog", "soga" },
            { "BT", "Butan" },
            { "BV", "Buve oroli" },
            { "BW", "Botsvana" },
            { "Mymr", "myanma" },
            { "BY", "Belarus" },
            { "seh", "sena" },
            { "BZ", "Beliz" },
            { "CA", "Kanada" },
            { "ca", "katalan" },
            { "CC", "Kokos (Kiling) orollari" },
            { "mzn", "mazanderan" },
            { "ses", "koyraboro-senni" },
            { "CD", "Kongo \u2013 Kinshasa" },
            { "ce", "chechen" },
            { "CF", "Markaziy Afrika Respublikasi" },
            { "CG", "Kongo \u2013 Brazzavil" },
            { "CH", "Shveytsariya" },
            { "CI", "Kot-d\u2019Ivuar" },
            { "CK", "Kuk orollari" },
            { "CL", "Chili" },
            { "CM", "Kamerun" },
            { "CN", "Xitoy" },
            { "CO", "Kolumbiya" },
            { "co", "korsikan" },
            { "CP", "Klipperton oroli" },
            { "Orya", metaValue_or },
            { "CR", "Kosta-Rika" },
            { "cs", "chex" },
            { "CU", "Kuba" },
            { "CV", "Kabo-Verde" },
            { "cv", "chuvash" },
            { "CW", "Kyurasao" },
            { "CX", "Rojdestvo oroli" },
            { "CY", "Kipr" },
            { "cy", "valliy" },
            { "CZ", "Chexiya Respublikasi" },
            { "da", "dat" },
            { "pt_PT", "portugal (Yevropa)" },
            { "DE", "Germaniya" },
            { "de", "nemischa" },
            { "cgg", "chiga" },
            { "DG", "Diyego-Garsiya" },
            { "DJ", "Jibuti" },
            { "DK", "Daniya" },
            { "Brai", "Brayl" },
            { "DM", "Dominika" },
            { "DO", "Dominikan Respublikasi" },
            { "bem", "bemba" },
            { "es_419", "ispan (Lotin Amerikasi)" },
            { "DZ", "Jazoir" },
            { "dz", "dzongka" },
            { "bez", "bena" },
            { "EA", "Seuta va Melilya" },
            { "EC", "Ekvador" },
            { "dje", "zarma" },
            { "EE", "Estoniya" },
            { "ee", "eve" },
            { "EG", "Misr" },
            { "EH", "G\u2018arbiy Sahroi Kabir" },
            { "ro_MD", "moldovan" },
            { "el", metaValue_el },
            { "en", "inglizcha" },
            { "eo", "esperanto" },
            { "chr", "cheroki" },
            { "ER", "Eritreya" },
            { "ES", "Ispaniya" },
            { "es", "ispancha" },
            { "ET", "Efiopiya" },
            { "et", "estoncha" },
            { "EU", "Yevropa Ittifoqi" },
            { "eu", "bask" },
            { "Hang", "hangul" },
            { "shi", "tashelxit" },
            { "Hani", metaValue_zh },
            { "hsb", "yuqori sorb" },
            { "fa", "fors" },
            { "Hans", metaValue_Hans },
            { "Hant", metaValue_Hant },
            { "FI", "Finlandiya" },
            { "fi", "fincha" },
            { "FJ", "Fiji" },
            { "fj", "fiji" },
            { "FK", "Folklend orollari" },
            { "FM", "Mikroneziya" },
            { "bgn", "g\u2018arbiy beluji" },
            { "FO", "Farer orollari" },
            { "fo", "farercha" },
            { "Taml", metaValue_ta },
            { "FR", "Fransiya" },
            { "fr", "fransuzcha" },
            { "fy", "g\u2018arbiy friz" },
            { "GA", "Gabon" },
            { "ga", "irland" },
            { "GB", "Birlashgan Qirollik" },
            { "GD", "Grenada" },
            { "GE", "Gruziya" },
            { "GF", "Fransuz Gvianasi" },
            { "GG", "Gernsi" },
            { "GH", "Gana" },
            { "GI", "Gibraltar" },
            { "GL", "Grenlandiya" },
            { "gl", "galisiy" },
            { "GM", "Gambiya" },
            { "GN", "Gvineya" },
            { "gn", "guarani" },
            { "GP", "Gvadelupe" },
            { "GQ", "Ekvatorial Gvineya" },
            { "und", "noma\u2019lum til" },
            { "GR", "Gretsiya" },
            { "GS", "Janubiy Georgiya va Janubiy Sendvich orollari" },
            { "GT", "Gvatemala" },
            { "gu", metaValue_gu },
            { "GU", "Guam" },
            { "gv", "men" },
            { "GW", "Gvineya-Bisau" },
            { "GY", "Gayana" },
            { "ha", "xausa" },
            { "ckb", "sorani-kurd" },
            { "zxx", "til tarkibi yo\u2018q" },
            { "he", metaValue_he },
            { "hi", "hind" },
            { "de_AT", "nemis (Avstriya)" },
            { "HK", "Gonkong (Xitoy MMH)" },
            { "HM", "Xerd va Makdonald orollari" },
            { "HN", "Gonduras" },
            { "HR", "Xorvatiya" },
            { "hr", "xorvat" },
            { "agq", "agem" },
            { "gsw", "nemis (Shveytsariya)" },
            { "HT", "Gaiti" },
            { "ht", "gaityan" },
            { "HU", "Vengriya" },
            { "hu", "venger" },
            { "hy", metaValue_hy },
            { "IC", "Kanar orollari" },
            { "ID", "Indoneziya" },
            { "id", "indonez" },
            { "IE", "Irlandiya" },
            { "ig", "igbo" },
            { "naq", "nama" },
            { "ii", "sichuan" },
            { "IL", "Isroil" },
            { "IM", "Men oroli" },
            { "IN", "Hindiston" },
            { "IO", "Britaniyaning Hind okeanidagi hududi" },
            { "IQ", "Iroq" },
            { "IR", "Eron" },
            { "IS", "Islandiya" },
            { "is", "island" },
            { "IT", "Italiya" },
            { "it", "italyan" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "JE", "Jersi" },
            { "Beng", metaValue_bn },
            { "JM", "Yamayka" },
            { "JO", "Iordaniya" },
            { "JP", "Yaponiya" },
            { "sma", "janubiy saam" },
            { "jv", "yavan" },
            { "guz", "gusii" },
            { "smj", "lule-saam" },
            { "de_CH", "yuqori nemis (Shveytsariya)" },
            { "smn", "inari-saam" },
            { "ka", "gruzincha" },
            { "sms", "skolt-saam" },
            { "KE", "Keniya" },
            { "419", "Lotin Amerikasi" },
            { "KG", "Qirg\u02bbiziston" },
            { "KH", "Kambodja" },
            { "KI", "Kiribati" },
            { "ki", "kikuyu" },
            { "mas", "masay" },
            { "kk", "qozoqcha" },
            { "kl", "grenland" },
            { "KM", "Komor orollari" },
            { "km", "xmercha" },
            { "Knda", metaValue_kn },
            { "kn", metaValue_kn },
            { "KN", "Sent-Kits va Nevis" },
            { "fr_CA", "fransuz (Kanada)" },
            { "ko", "koreyscha" },
            { "KP", "Shimoliy Koreya" },
            { "KR", "Janubiy Koreya" },
            { "ks", "kashmircha" },
            { "ku", "kurdcha" },
            { "fr_CH", "fransuz (Shveytsariya)" },
            { "KW", "Quvayt" },
            { "kw", "korn" },
            { "KY", "Kayman orollari" },
            { "ky", "qirg\u02bbizcha" },
            { "KZ", "Qozog\u02bbiston" },
            { "Cyrl", "kirill" },
            { "LA", "Laos" },
            { "la", "lotincha" },
            { "LB", "Livan" },
            { "lb", "lyuksemburgcha" },
            { "LC", "Sent-Lyusiya" },
            { "lg", "ganda" },
            { "nds", "quyi nemis" },
            { "LI", "Lixtenshteyn" },
            { "LK", "Shri-Lanka" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "lo", "laoscha" },
            { "LR", "Liberiya" },
            { "LS", "Lesoto" },
            { "LT", "Litva" },
            { "lt", "litva" },
            { "LU", "Lyuksemburg" },
            { "lu", "luba-katanga" },
            { "LV", "Latviya" },
            { "lv", "latishcha" },
            { "Kana", "katakana" },
            { "LY", "Liviya" },
            { "vun", "vunjo" },
            { "lag", "langi" },
            { "Thaa", "taana" },
            { "MA", "Marokash" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Chernogoriya" },
            { "MF", "Sent-Martin" },
            { "MG", "Madagaskar" },
            { "mg", "malagasiy" },
            { "Thai", metaValue_th },
            { "MH", "Marshall orollari" },
            { "mi", "maori" },
            { "MK", "Makedoniya" },
            { "mk", "makedon" },
            { "ml", metaValue_ml },
            { "ML", "Mali" },
            { "MM", "Myanma (Birma)" },
            { "mn", metaValue_mn },
            { "MN", "Mongoliya" },
            { "MO", "Makao (Xitoy MMH)" },
            { "MP", "Shimoliy Mariana orollari" },
            { "MQ", "Martinika" },
            { "MR", "Mavritaniya" },
            { "mr", "maratxi" },
            { "MS", "Montserrat" },
            { "ms", "malay" },
            { "MT", "Malta" },
            { "mt", "maltiy" },
            { "MU", "Mavrikiy" },
            { "MV", "Maldiv orollari" },
            { "MW", "Malavi" },
            { "MX", "Meksika" },
            { "MY", "Malayziya" },
            { "my", "birman" },
            { "Armn", metaValue_hy },
            { "MZ", "Mozambik" },
            { "dsb", "quyi sorbcha" },
            { "NA", "Namibiya" },
            { "nb", "norveg-bokmal" },
            { "NC", "Yangi Kaledoniya" },
            { "nd", "shimoliy ndebele" },
            { "NE", "Niger" },
            { "ne", "nepal" },
            { "NF", "Norfolk oroli" },
            { "NG", "Nigeriya" },
            { "NI", "Nikaragua" },
            { "NL", "Niderlandiya" },
            { "nl", "golland" },
            { "nn", "norveg-nyunorsk" },
            { "NO", "Norvegiya" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "NZ", "Yangi Zelandiya" },
            { "kab", "kabil" },
            { "kam", "kamba" },
            { "men", "mende" },
            { "mer", "meru" },
            { "OM", "Ummon" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "mfe", "morisyen" },
            { "PA", "Panama" },
            { "pa", "panjobcha" },
            { "dua", "duala" },
            { "en_GB", "ingliz (Britaniya)" },
            { "PE", "Peru" },
            { "PF", "Fransuz Polineziyasi" },
            { "PG", "Papua \u2013 Yangi Gvineya" },
            { "PH", "Filippin" },
            { "PK", "Pokiston" },
            { "PL", "Polsha" },
            { "pl", "polyakcha" },
            { "PM", "Sent-Pyer va Mikelon" },
            { "PN", "Pitkern orollari" },
            { "PR", "Puerto-Riko" },
            { "PS", "Falastin hududi" },
            { "ps", "pushtu" },
            { "PT", "Portugaliya" },
            { "pt", "portugalcha" },
            { "PW", "Palau" },
            { "PY", "Paragvay" },
            { "pt_BR", "portugal (Braziliya)" },
            { "Hebr", metaValue_he },
            { "mgh", "maxuva-mitto" },
            { "QA", "Qatar" },
            { "Laoo", "laos" },
            { "mgo", "meta" },
            { "QO", "Yondosh Okeaniya" },
            { "qu", "kechua" },
            { "brx", "bodo" },
            { "kde", "makonde" },
            { "001", "Dunyo" },
            { "Ethi", "habash" },
            { "002", "Afrika" },
            { "003", "Shimoliy Amerika" },
            { "RE", "Reyunion" },
            { "005", "Janubiy Amerika" },
            { "009", "Okeaniya" },
            { "rm", "romansh" },
            { "rn", "rundi" },
            { "RO", "Ruminiya" },
            { "ro", "rumincha" },
            { "RS", "Serbiya" },
            { "RU", "Rossiya" },
            { "ru", "ruscha" },
            { "RW", "Ruanda" },
            { "rw", "kinyaruanda" },
            { "kea", "kabuverdianu" },
            { "en_AU", "ingliz (Avstraliya)" },
            { "SA", "Saudiya Arabistoni" },
            { "sa", "sanskrit" },
            { "SB", "Solomon orollari" },
            { "twq", "tasavaq" },
            { "011", "G\u2018arbiy Afrika" },
            { "SC", "Seyshel orollari" },
            { "SD", "Sudan" },
            { "sd", "sindxi" },
            { "013", "Markaziy Amerika" },
            { "SE", "Shvetsiya" },
            { "se", "shimoliy saam" },
            { "014", "Sharqiy Afrika" },
            { "015", "Shimoliy Afrika" },
            { "SG", "Singapur" },
            { "sg", "sango" },
            { "SH", "Muqaddas Yelena oroli" },
            { "si", metaValue_si },
            { "017", "Markaziy Afrika" },
            { "SI", "Sloveniya" },
            { "018", "Janubiy Afrika" },
            { "SJ", "Svalbard va Yan-Mayen" },
            { "019", "Amerika" },
            { "SK", "Slovakiya" },
            { "sk", "slovakcha" },
            { "SL", "Syerra-Leone" },
            { "sl", "slovencha" },
            { "SM", "San-Marino" },
            { "SN", "Senegal" },
            { "sn", "shona" },
            { "SO", "Somali" },
            { "so", "somalicha" },
            { "arn", "araukan" },
            { "sq", "alban" },
            { "SR", "Surinam" },
            { "sr", "serbcha" },
            { "SS", "Janubiy Sudan" },
            { "ST", "San-Tome va Prinsipi" },
            { "su", "sundan" },
            { "SV", "Salvador" },
            { "sv", "shved" },
            { "sw", "suaxili" },
            { "SX", "Sint-Marten" },
            { "SY", "Suriya" },
            { "SZ", "Svazilend" },
            { "ta", metaValue_ta },
            { "TA", "Tristan-da-Kunya" },
            { "asa", "asu" },
            { "021", "Shimoliy Amerika \u2013 AQSH va Kanada" },
            { "142", "Osiyo" },
            { "TC", "Turks va Kaykos orollari" },
            { "143", "Markaziy Osiyo" },
            { "TD", "Chad" },
            { "te", metaValue_te },
            { "145", "G\u2018arbiy Osiyo" },
            { "TF", "Fransuz Janubiy hududlari" },
            { "TG", "Togo" },
            { "tg", "tojik" },
            { "th", metaValue_th },
            { "TH", "Tailand" },
            { "ti", "tigrinya" },
            { "TJ", "Tojikiston" },
            { "en_CA", "ingliz (Kanada)" },
            { "029", "Karib havzasi" },
            { "TK", "Tokelau" },
            { "tk", "turkman" },
            { "TL", "Timor" },
            { "TM", "Turkmaniston" },
            { "TN", "Tunis" },
            { "TO", "Tonga" },
            { "to", "tongan" },
            { "dyo", "diola-fogni" },
            { "TR", "Turkiya" },
            { "tr", "turk" },
            { "TT", "Trinidad va Tobago" },
            { "tt", "tatar" },
            { "TV", "Tuvalu" },
            { "TW", "Tayvan" },
            { "TZ", "Tanzaniya" },
            { "nmg", "kvasio" },
            { "Zzzz", "noma\u2019lum yozuv" },
            { "150", "Yevropa" },
            { "UA", "Ukraina" },
            { "030", "Sharqiy Osiyo" },
            { "151", "Sharqiy Yevropa" },
            { "154", "Shimoliy Yevropa" },
            { "sw_CD", "kongo-suaxili" },
            { "034", "Janubiy Osiyo" },
            { "155", "G\u2018arbiy Yevropa" },
            { "035", "Janubi-sharqiy Osiyo" },
            { "UG", "Uganda" },
            { "ug", "uyg\u2018ur" },
            { "Kore", "koreys" },
            { "Zyyy", "umumiy" },
            { "039", "Janubiy Yevropa" },
            { "uk", "ukrain" },
            { "Sinh", metaValue_si },
            { "UM", "AQSH yondosh orollari" },
            { "ur", "urdu" },
            { "US", "Qo\u02bbshma Shtatlar" },
            { "haw", "gavaycha" },
            { "UY", "Urugvay" },
            { "UZ", "O\u02bbzbekiston" },
            { "uz", "o\u2018zbek" },
            { "tzm", "markaziy atlas tamazigxt" },
            { "VA", "Vatikan" },
            { "nds_NL", "quyi sakson" },
            { "VC", "Sent-Vinsent va Grenadin" },
            { "VE", "Venesuela" },
            { "VG", "Britaniya Virgin orollari" },
            { "VI", "AQSH Virgin orollari" },
            { "vi", "vyetnam" },
            { "khq", "koyra-chiini" },
            { "VN", "Vyetnam" },
            { "quc", "kiche" },
            { "VU", "Vanuatu" },
            { "rwk", "ruanda" },
            { "gag", "gagauz" },
            { "053", "Avstralaziya" },
            { "054", "Melaneziya" },
            { "WF", "Uollis va Futuna" },
            { "Grek", metaValue_el },
            { "057", "Mikroneziya mintaqasi" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "wo", "volof" },
            { "zgh", "tamazigxt" },
            { "ar_001", "standart arab" },
            { "WS", "Samoa" },
            { "Mong", metaValue_mn },
            { "061", "Polineziya" },
            { "Latn", "lotin" },
            { "xh", "kxosa" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "yozuvsiz" },
            { "wbp", "valbiri" },
            { "moh", "mohauk" },
            { "YE", "Yaman" },
            { "nqo", "nko" },
            { "yo", "yoruba" },
            { "es_MX", "ispan (Meksika)" },
            { "YT", "Mayotta" },
            { "vai", "vai" },
            { "ZA", "Janubiy Afrika Respublikasi" },
            { "kln", "kalenjin" },
            { "Deva", "devanagar" },
            { "zh", metaValue_zh },
            { "Hira", "hiragana" },
            { "ZM", "Zambiya" },
            { "Bopo", "bopomofo" },
            { "zu", "zulu" },
            { "ZW", "Zimbabve" },
            { "ZZ", "Noma\u2019lum mintaqa" },
            { "Geor", "gruzin" },
            { "ebu", "embu" },
            { "jmc", "machame" },
            { "zh_Hans", metaValue_Hans },
            { "koi", "komi-permyak" },
            { "kok", "konkan" },
            { "nus", "nuer" },
            { "dav", "taita" },
            { "lrc", "shimoliy luri" },
            { "zh_Hant", metaValue_Hant },
            { "mua", "mundang" },
            { "Khmr", "xmer" },
            { "saq", "samburu" },
            { "Guru", "gurmukxi" },
            { "ksb", "shambala" },
            { "Telu", metaValue_te },
            { "ksf", "bafiya" },
        };
        return data;
    }
}
