/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_gl extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Horario de \u00c1frica Central",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Horario est\u00e1ndar de Moscova",
               "MSK",
               "Horario de ver\u00e1n de Moscova",
               "MSD",
               "Horario de Moscova",
               "MT",
            };
        final String[] Japan = new String[] {
               "Horario est\u00e1ndar de Xap\u00f3n",
               "JST",
               "Horario de ver\u00e1n de Xap\u00f3n",
               "JDT",
               "Horario de Xap\u00f3n",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Horario est\u00e1ndar de Paquist\u00e1n",
               "PKT",
               "Horario de ver\u00e1n de Paquist\u00e1n",
               "PKST",
               "Horario de Paquist\u00e1n",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Horario est\u00e1ndar de Taipei",
               "CST",
               "Horario de ver\u00e1n de Taipei",
               "CDT",
               "Horario de Taipei",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Horario est\u00e1ndar de Hovd",
               "HOVT",
               "Horario de ver\u00e1n de Hovd",
               "HOVST",
               "Horario de Hovd",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Horario est\u00e1ndar de Magad\u00e1n",
               "MAGT",
               "Horario de ver\u00e1n de Magad\u00e1n",
               "MAGST",
               "Horario de Magad\u00e1n",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Horario est\u00e1ndar de Australia Occidental Central",
               "ACWST",
               "Horario de ver\u00e1n de Australia Occidental Central",
               "ACWDT",
               "Horario de Australia Occidental Central",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Horario est\u00e1ndar de Europa Central",
               "CET",
               "Horario de ver\u00e1n de Europa Central",
               "CEST",
               "Horario de Europa Central",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Horario est\u00e1ndar de Sakhal\u00edn",
               "SAKT",
               "Horario de ver\u00e1n de Sakhalin",
               "SAKST",
               "Horario de Sakhalin",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Horario est\u00e1ndar de Paraguai",
               "PYT",
               "Horario de ver\u00e1n de Paraguai",
               "PYST",
               "Horario de Paraguai",
               "PYT",
            };
        final String[] Malaysia = new String[] {
               "Horario de Malaisia",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Horario est\u00e1ndar Am\u00e9rica Oriental",
               "EST",
               "Horario de ver\u00e1n de Am\u00e9rica Oriental",
               "EDT",
               "Horario de Am\u00e9rica Oriental",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Horario est\u00e1ndar de Lord Howe",
               "LHST",
               "Horario de ver\u00e1n de Lord Howe",
               "LHDT",
               "Horario de Lord Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Horario est\u00e1ndar de Nova Celandia",
               "NZST",
               "Horario de ver\u00e1n de Nova Celandia",
               "NZDT",
               "Horario de Nova Celandia",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Horario do Oc\u00e9ano \u00cdndico",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Horario est\u00e1ndar de Iakutsk",
               "YAKT",
               "Horario de ver\u00e1n de Iakutsk",
               "YAKST",
               "Horario de Iakutsk",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Horario est\u00e1ndar de Mauricio",
               "MUT",
               "Horario de ver\u00e1n de Mauricio",
               "MUST",
               "Horario de Mauricio",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Horario de \u00c1frica Oriental",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Horario de Timor Leste",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Horario das Illas Salom\u00f3n",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Horario de Kosrae",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Horario das Illas Marshall",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Horario est\u00e1ndar de Europa Oriental",
               "EET",
               "Horario de ver\u00e1n de Europa Oriental",
               "EEST",
               "Horario de Europa Oriental",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Horario est\u00e1ndar de Terranova",
               "NST",
               "Horario de ver\u00e1n de Terranova",
               "NDT",
               "Horario de Terranova",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Horario de Afganist\u00e1n",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Horario est\u00e1ndar de Hong Kong",
               "HKT",
               "Horario de ver\u00e1n de Hong Kong",
               "HKST",
               "Horario de Hong Kong",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Horario est\u00e1ndar de Arxentina Occidental",
               "ART",
               "Horario de ver\u00e1n de Arxentina Occidental",
               "ARST",
               "Horario de Arxentina Occidental",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Horario est\u00e1ndar do Atl\u00e1ntico",
               "AST",
               "Horario de ver\u00e1n do Atl\u00e1ntico",
               "ADT",
               "Horario do Atl\u00e1ntico",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Horario de Pohnpei",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Horario de Bolivia",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Horario est\u00e1ndar de San Pedro e Miguel\u00f3n",
               "PMST",
               "Horario de ver\u00e1n de San Pedro e Miguel\u00f3n",
               "PMDT",
               "Horario de San Pedro e Miguel\u00f3n",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Horario de Indochina",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Horario est\u00e1ndar de Ekaterimburgo",
               "YEKT",
               "Horario de ver\u00e1n de Ekaterimburgo",
               "YEKST",
               "Horario de Ekaterimburgo",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Horario das Maldivas",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Horario de Tahit\u00ed",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Horario est\u00e1ndar de Israel",
               "IST",
               "Horario de ver\u00e1n de Israel",
               "IDT",
               "Horario de Israel",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Horario de Indonesia Central",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Horario de Wallis e Futuna",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Horario est\u00e1ndar de Sud\u00e1frica",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Horario de Syowa",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Horario das Illas da Li\u00f1a",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Horario est\u00e1ndar de Usbequist\u00e1n",
               "UZT",
               "Horario de ver\u00e1n de Usbequist\u00e1n",
               "UZST",
               "Horario de Usbequist\u00e1n",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Horario est\u00e1ndar de Omsk",
               "OMST",
               "Horario de ver\u00e1n de Omsk",
               "OMSST",
               "Horario de Omsk",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Horario das Seixeles",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Horario est\u00e1ndar de Uruguai",
               "UYT",
               "Horario de ver\u00e1n de Uruguai",
               "UYST",
               "Horario de Uruguai",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Horario de Nepal",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Horario est\u00e1ndar de Ul\u00e1n B\u00e1tor",
               "ULAT",
               "Horario de ver\u00e1n de Ul\u00e1n B\u00e1tor",
               "ULAST",
               "Horario de Ul\u00e1n B\u00e1tor",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Horario est\u00e1ndar central",
               "CST",
               "Horario de ver\u00e1n da zona central",
               "CDT",
               "Horario central",
               "CT",
            };
        final String[] Truk = new String[] {
               "Horario de Chuuk",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Horario de Niue",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Horario da Illa Wake",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Horario est\u00e1ndar das Illas Malvinas",
               "FKT",
               "Horario de ver\u00e1n das Illas Malvinas",
               "FKST",
               "Horario das Illas Malvinas",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Horario est\u00e1ndar de Vanuatu",
               "VUT",
               "Horario de ver\u00e1n de Vanuatu",
               "VUST",
               "Horario de Vanuatu",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Horario est\u00e1ndar de Novosibirsk",
               "NOVT",
               "Horario de ver\u00e1n de Novosibirsk",
               "NOVST",
               "Horario de Novosibirsk",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Horario est\u00e1ndar de Singapur",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Horario est\u00e1ndar das Azores",
               "AZOT",
               "Horario de ver\u00e1n das Azores",
               "AZOST",
               "Horario das Azores",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Horario est\u00e1ndar de Apia",
               "WSST",
               "Horario de ver\u00e1n de Apia",
               "WSDT",
               "Horario de Apia",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Horario de But\u00e1n",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Horario de Surinam",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Horario de Nauru",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Horario est\u00e1ndar de Krasnoyarsk",
               "KRAT",
               "Horario de ver\u00e1n de Krasnoyarsk",
               "KRAST",
               "Horario de Krasnoyarsk",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Horario de Casaquist\u00e1n oeste",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Horario de Birmania",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Horario da Illa de Nadal",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Horario est\u00e1ndar do Amazonas",
               "AMT",
               "Horario de ver\u00e1n do Amazonas",
               "AMST",
               "Horario do Amazonas",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Horario de Casaquist\u00e1n este",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Horario est\u00e1ndar de Fidxi",
               "FJT",
               "Horario de ver\u00e1n de Fidxi",
               "FJST",
               "Horario de Fidxi",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Horario de Reuni\u00f3n",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Horario das Illas Cocos",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Horario est\u00e1ndar de Chatham",
               "CHAST",
               "Horario de ver\u00e1n de Chatham",
               "CHADT",
               "Horario de Chatham",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Horario de Vostok",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Horario est\u00e1ndar de Arxentina",
               "ART",
               "Horario de ver\u00e1n de Arxentina",
               "ARST",
               "Horario de Arxentina",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Horario de Gambier",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Horario est\u00e1ndar de Petrop\u00e1vlovsk-Kamchatski",
               "PETT",
               "Horario de ver\u00e1n de Petrop\u00e1vlovsk-Kamchatski",
               "PETST",
               "Horario de Petrop\u00e1vlovsk-Kamchatski",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "Horario de Tuvalu",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Horario das Gal\u00e1pagos",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Horario da Illa Macquarie",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Horario de Venezuela",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Horario est\u00e1ndar de Hawai-Aleutiano",
               "HAST",
               "Horario de ver\u00e1n de Hawai-Aleutiano",
               "HADT",
               "Horario de Hawai-Aleutiano",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Horario est\u00e1ndar de Australia Central",
               "ACST",
               "Horario de ver\u00e1n de Australia Central",
               "ACDT",
               "Horario de Australia Central",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Horario est\u00e1ndar do Pac\u00edfico",
               "PST",
               "Horario de ver\u00e1n do Pac\u00edfico",
               "PDT",
               "Horario do Pac\u00edfico",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Horario das Illas F\u00e9nix",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Horario est\u00e1ndar de Turcomenist\u00e1n",
               "TMT",
               "Horario de ver\u00e1n de Turcomenist\u00e1n",
               "TMST",
               "Horario de Turcomenist\u00e1n",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Horario est\u00e1ndar de Europa Occidental",
               "WET",
               "Horario de ver\u00e1n de Europa Occidental",
               "WEST",
               "Horario de Europa Occidental",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Horario est\u00e1ndar de Cabo Verde",
               "CVT",
               "Horario de ver\u00e1n de Cabo Verde",
               "CVST",
               "Horario de Cabo Verde",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Horario das Illas Norfolk",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Horario da G\u00fciana",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Horario de Pitcairn",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Horario de Rothera",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Horario est\u00e1ndar de Samoa",
               "SST",
               "Horario de ver\u00e1n de Samoa",
               "SDT",
               "Horario de Samoa",
               "ST",
            };
        final String[] Palau = new String[] {
               "Horario de Palau",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Horario de Kaliningrado",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Horario est\u00e1ndar de Acerbaix\u00e1n",
               "AZT",
               "Horario de ver\u00e1n de Acerbaix\u00e1n",
               "AZST",
               "Horario de Acerbaix\u00e1n",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Horario de Mawson",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Horario est\u00e1ndar do Pac\u00edfico mexicano",
               "MST",
               "Horario de ver\u00e1n do Pac\u00edfico mexicano",
               "MDT",
               "Horario do Pac\u00edfico mexicano",
               "MT",
            };
        final String[] Davis = new String[] {
               "Horario de Davis",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Horario est\u00e1ndar de Cuba",
               "CST",
               "Horario de ver\u00e1n de Cuba",
               "CDT",
               "Horario de Cuba",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Horario est\u00e1ndar de \u00c1frica Occidental",
               "WAT",
               "Horario de ver\u00e1n de \u00c1frica Occidental",
               "WAST",
               "Horario de \u00c1frica Occidental",
               "WAT",
            };
        final String[] GMT = new String[] {
               "Horario do meridiano de Greenwich",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Horario est\u00e1ndar de Filipinas",
               "PHT",
               "Horario de ver\u00e1n de Filipinas",
               "PHST",
               "Horario de Filipinas",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Horario das Terras Austrais e Ant\u00e1rticas Francesas",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "Horario de Xeorxia do Sur",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Horario est\u00e1ndar de Nova Caledonia",
               "NCT",
               "Horario de ver\u00e1n de Nova Caledonia",
               "NCST",
               "Horario de Nova Caledonia",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Horario de Brunei Darussalam",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Horario est\u00e1ndar de Ir\u00e1n",
               "IRST",
               "Horario de ver\u00e1n de Ir\u00e1n",
               "IRDT",
               "Horario de Ir\u00e1n",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Horario est\u00e1ndar da Illa de Pascua",
               "EAST",
               "Horario de ver\u00e1n da Illa de Pascua",
               "EASST",
               "Horario da Illa de Pascua",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Horario est\u00e1ndar de M\u00e9xico Noroeste",
               "PST",
               "Horario de ver\u00e1n de M\u00e9xico Noroeste",
               "PDT",
               "Horario de M\u00e9xico Noroeste",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Horario de Dumont-d\u2019Urville",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Horario de Taxiquist\u00e1n",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Horario est\u00e1ndar de Tonga",
               "TOT",
               "Horario de ver\u00e1n de Tonga",
               "TOST",
               "Horario de Tonga",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Horario est\u00e1ndar de Bangladesh",
               "BDT",
               "Horario de ver\u00e1n de Bangladesh",
               "BDST",
               "Horario de Bangladesh",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Horario est\u00e1ndar de Per\u00fa",
               "PET",
               "Horario de ver\u00e1n de Per\u00fa",
               "PEST",
               "Horario de Per\u00fa",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Horario est\u00e1ndar de Grenlandia Occidental",
               "WGT",
               "Horario de ver\u00e1n de Grenlandia Occidental",
               "WGST",
               "Horario de Grenlandia Occidental",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Horario de Ecuador",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Horario est\u00e1ndar de Grenlandia Oriental",
               "EGT",
               "Horario de ver\u00e1n de Grenlandia Oriental",
               "EGST",
               "Horario de Grenlandia Oriental",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Horario est\u00e1ndar do Golfo",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Horario de Indonesia Oriental",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Horario est\u00e1ndar de Corea",
               "KST",
               "Horario de ver\u00e1n de Corea",
               "KDT",
               "Horario de Corea",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Horario est\u00e1ndar de Australia Occidental",
               "AWST",
               "Horario de ver\u00e1n de Australia Occidental",
               "AWDT",
               "Horario de Australia Occidental",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Horario de Quirguicist\u00e1n",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Horario de Indonesia Occidental",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Horario est\u00e1ndar de Australia Oriental",
               "AEST",
               "Horario de ver\u00e1n de Australia Oriental",
               "AEDT",
               "Horario de Australia Oriental",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Horario da G\u00fciana Francesa",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Horario est\u00e1ndar de Colombia",
               "COT",
               "Horario de ver\u00e1n de Colombia",
               "COST",
               "Horario de Colombia",
               "COT",
            };
        final String[] Chile = new String[] {
               "Horario est\u00e1ndar de Chile",
               "CLT",
               "Horario de ver\u00e1n de Chile",
               "CLST",
               "Horario de Chile",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Horario das Illas Gilbert",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Horario est\u00e1ndar das monta\u00f1as americanas",
               "MST",
               "Horario de ver\u00e1n das monta\u00f1as americanas",
               "MDT",
               "Horario das monta\u00f1as americanas",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Horario das Marquesas",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Horario est\u00e1ndar \u00e1rabe",
               "AST",
               "Horario de ver\u00e1n \u00e1rabe",
               "ADT",
               "Horario \u00e1rabe",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Horario est\u00e1ndar de Alasca",
               "AKST",
               "Horario de ver\u00e1n de Alasca",
               "AKDT",
               "Horario de Alasca",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Horario est\u00e1ndar de Vladivostok",
               "VLAT",
               "Horario de ver\u00e1n de Vladivostok",
               "VLAST",
               "Horario de Vladivostok",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Horario est\u00e1ndar de Chamorro",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Horario est\u00e1ndar de Irkutsk",
               "IRKT",
               "Horario de ver\u00e1n de Irkutsk",
               "IRKST",
               "Horario de Irkutsk",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Horario est\u00e1ndar de Xeorxia",
               "GET",
               "Horario de ver\u00e1n de Xeorxia",
               "GEST",
               "Horario de Xeorxia",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Horario de Toquelau",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Horario de Pap\u00faa Nova Guinea",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Horario est\u00e1ndar de Fernando de Noronha",
               "FNT",
               "Horario de ver\u00e1n de Fernando de Noronha",
               "FNST",
               "Horario de Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Horario est\u00e1ndar de Choibalsan",
               "CHOT",
               "Horario de ver\u00e1n de Choibalsan",
               "CHOST",
               "Horario de Choibalsan",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Horario est\u00e1ndar de Brasilia",
               "BRT",
               "Horario de ver\u00e1n de Brasilia",
               "BRST",
               "Horario de Brasilia",
               "BRT",
            };
        final String[] China = new String[] {
               "Horario est\u00e1ndar de China",
               "CST",
               "Horario de ver\u00e1n de China",
               "CDT",
               "Horario de China",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Horario est\u00e1ndar de Armenia",
               "AMT",
               "Horario de ver\u00e1n de Armenia",
               "AMST",
               "Horario de Armenia",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Horario est\u00e1ndar de Samara",
               "SAMT",
               "Horario de ver\u00e1n de Samara",
               "SAMST",
               "Horario de Samara",
               "SAMT",
            };
        final String[] India = new String[] {
               "Horario est\u00e1ndar da India",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Horario est\u00e1ndar das Illas Cook",
               "CKT",
               "Horario de ver\u00e1n medio das Illas Cook",
               "CKHST",
               "Horario das Illas Cook",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Horario do meridiano de Greenwich",
                    "GMT",
                    "Horario de ver\u00e1n brit\u00e1nico",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Horario do meridiano de Greenwich",
                    "GMT",
                    "Horario est\u00e1ndar irland\u00e9s",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
