/*
 * Decompiled with CFR 0.152.
 */
package freemind.common;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import freemind.common.PropertyBean;
import freemind.common.PropertyControl;
import freemind.common.TextTranslator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class ComboProperty
extends PropertyBean
implements PropertyControl {
    String description;
    String label;
    protected JComboBox mComboBox = new JComboBox();
    protected Vector possibleValues;

    public ComboProperty(String description, String label, String[] possibles, TextTranslator pTranslator) {
        this.description = description;
        this.label = label;
        this.fillPossibleValues(possibles);
        Vector<String> possibleTranslations = new Vector<String>();
        for (String key : this.possibleValues) {
            possibleTranslations.add(pTranslator.getText(key));
        }
        this.mComboBox.setModel(new DefaultComboBoxModel(possibleTranslations));
        this.mComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                ComboProperty.this.firePropertyChangeEvent();
            }
        });
    }

    public ComboProperty(String description, String label, String[] possibles, List possibleTranslations) {
        this.description = description;
        this.label = label;
        this.fillPossibleValues(possibles);
        this.mComboBox.setModel(new DefaultComboBoxModel(new Vector(possibleTranslations)));
    }

    public ComboProperty(String description, String label, List possibles, List possibleTranslations) {
        this.description = description;
        this.label = label;
        this.fillPossibleValues(possibles);
        this.mComboBox.setModel(new DefaultComboBoxModel(new Vector(possibleTranslations)));
    }

    private void fillPossibleValues(String[] possibles) {
        this.fillPossibleValues(Arrays.asList(possibles));
    }

    private void fillPossibleValues(List possibles) {
        this.possibleValues = new Vector();
        this.possibleValues.addAll(possibles);
    }

    public void updateComboBoxEntries(List possibles, List possibleTranslations) {
        this.mComboBox.setModel(new DefaultComboBoxModel(new Vector(possibleTranslations)));
        this.fillPossibleValues(possibles);
        if (possibles.size() > 0) {
            this.mComboBox.setSelectedIndex(0);
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setValue(String value) {
        if (this.possibleValues.contains(value)) {
            this.mComboBox.setSelectedIndex(this.possibleValues.indexOf(value));
        } else {
            System.err.println("Can't set the value:" + value + " into the combo box " + this.getLabel() + "/" + this.getDescription());
            if (this.mComboBox.getModel().getSize() > 0) {
                this.mComboBox.setSelectedIndex(0);
            }
        }
    }

    @Override
    public String getValue() {
        return (String)this.possibleValues.get(this.mComboBox.getSelectedIndex());
    }

    @Override
    public void layout(DefaultFormBuilder builder, TextTranslator pTranslator) {
        JLabel label = builder.append(pTranslator.getText(this.getLabel()), (Component)this.mComboBox);
        label.setToolTipText(pTranslator.getText(this.getDescription()));
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.mComboBox.setEnabled(pEnabled);
    }
}

