/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.parser.sourcemaps;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMap;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapError;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapGroup;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapParseResult;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSegment;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSuccess;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapParser;", "", "()V", "parse", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapParseResult;", "reader", "Ljava/io/Reader;", "MappingStream", "kotlin-compiler"})
public final class SourceMapParser {
    public static final SourceMapParser INSTANCE;

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final SourceMapParseResult parse(@NotNull Reader reader) throws IOException {
        block46: {
            block44: {
                block43: {
                    block45: {
                        Intrinsics.checkParameterIsNotNull(reader, "reader");
                        try {
                            var3_2 = new JSONObject(new JSONTokener(reader));
                        }
                        catch (JSONException e) {
                            v0 = e.getMessage();
                            if (v0 == null) {
                                v0 = "parse error";
                            }
                            return new SourceMapError(v0);
                        }
                        jsonObject = var3_2;
                        if (!jsonObject.has("version")) {
                            return new SourceMapError("Version not defined");
                        }
                        var3_2 = jsonObject.get("version");
                        it = var3_2;
                        if (Intrinsics.areEqual(it, (Object)3) ^ true) {
                            return new SourceMapError("Unsupported version: " + it);
                        }
                        if (jsonObject.has("sourceRoot")) {
                            v1 = jsonObject.get("sourceRoot");
                            if (!(v1 instanceof String)) {
                                v1 = null;
                            }
                            if ((v2 = (String)v1) == null) {
                                return new SourceMapError("'sourceRoot' property is not of string type");
                            }
                        } else {
                            v2 = sourceRoot = "";
                        }
                        if (jsonObject.has("sources")) {
                            v3 = jsonObject.get("sources");
                            if (!(v3 instanceof JSONArray)) {
                                v3 = null;
                            }
                            v4 = (JSONArray)v3;
                            if (v4 == null) {
                                return new SourceMapError("'sources' property is not of array type");
                            }
                            sourcesProperty = v4;
                            var7_8 = $receiver$iv = (Iterable)sourcesProperty;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                            var9_11 = $receiver$iv$iv.iterator();
                            while (var9_11.hasNext()) {
                                var11_15 = item$iv$iv = var9_11.next();
                                var19_17 = destination$iv$iv;
                                v5 = it;
                                if (!(v5 instanceof String)) {
                                    v5 = null;
                                }
                                if ((String)v5 == null) {
                                    return new SourceMapError("'sources' array must contain strings");
                                }
                                var19_17.add(var20_18);
                            }
                            v6 = (List)destination$iv$iv;
                        } else {
                            v6 = sources = CollectionsKt.emptyList();
                        }
                        if (!jsonObject.has("sourcesContent")) break block44;
                        v7 = jsonObject.get("sourcesContent");
                        if (!(v7 instanceof JSONArray)) {
                            v7 = null;
                        }
                        v8 = (JSONArray)v7;
                        if (v8 == null) {
                            return new SourceMapError("'sourcesContent' property is not of array type");
                        }
                        sourcesContentProperty = v8;
                        $receiver$iv = sourcesContentProperty;
                        if (!($receiver$iv instanceof Collection) || !((Collection)$receiver$iv).isEmpty()) break block45;
                        v9 = false;
                        break block43;
                    }
                    for (E element$iv : $receiver$iv) {
                        it /* !! */  = element$iv;
                        if (!(Intrinsics.areEqual(it /* !! */ , JSONObject.NULL) ^ true)) ** GOTO lbl-1000
                        v10 = it /* !! */ ;
                        if (!(v10 != null ? v10 instanceof String : true)) {
                            v11 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v11 = false;
                        }
                        if (!v11) continue;
                        v9 = true;
                        break block43;
                    }
                    v9 = false;
                }
                if (v9) {
                    return new SourceMapError("'sources' array must contain strings");
                }
                $receiver$iv = sourcesContentProperty;
                destination$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                it /* !! */  = $receiver$iv$iv.iterator();
                while (it /* !! */ .hasNext()) {
                    $i$f$any /* !! */  = item$iv$iv /* !! */  = it /* !! */ .next();
                    var19_17 = destination$iv$iv;
                    var20_18 = Intrinsics.areEqual(it, JSONObject.NULL) != false ? null : (String)it;
                    var19_17.add(var20_18);
                }
                v12 = (List)destination$iv$iv;
                break block46;
            }
            v12 = CollectionsKt.emptyList();
        }
        sourcesContent = v12;
        $receiver$iv = CollectionsKt.zip((Iterable)sources, sourcesContent);
        capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
        destination$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
        for (T element$iv$iv : $receiver$iv$iv) {
            $i$a$2$map = destination$iv$iv;
            var16_22 = it = (Pair)element$iv$iv;
            $i$a$2$map.put(var16_22.getFirst(), var16_22.getSecond());
        }
        sourcePathToContent = destination$iv$iv;
        if (!jsonObject.has("mappings")) {
            return new SourceMapError("'mappings' property not found");
        }
        v13 = jsonObject.get("mappings");
        if (!(v13 instanceof String)) {
            v13 = null;
        }
        v14 = (String)v13;
        if (v14 == null) {
            return new SourceMapError("'mappings' property is not of string type");
        }
        mappings = v14;
        jsColumn = 0;
        sourceLine = 0;
        sourceColumn = 0;
        sourceIndex = 0;
        stream = new MappingStream(mappings);
        sourceMap = new SourceMap((Function1<? super String, ? extends Reader>)new Function1<String, StringReader>(sourcePathToContent){
            final /* synthetic */ Map $sourcePathToContent;

            @Nullable
            public final StringReader invoke(@NotNull String it) {
                StringReader stringReader;
                Intrinsics.checkParameterIsNotNull(it, "it");
                String string = (String)this.$sourcePathToContent.get(it);
                if (string != null) {
                    String string2;
                    String it2 = string2 = string;
                    stringReader = new StringReader(it2);
                } else {
                    stringReader = null;
                }
                return stringReader;
            }
            {
                this.$sourcePathToContent = map2;
                super(1);
            }
        });
        it = var15_23 = new SourceMapGroup();
        var17_24 = sourceMap.getGroups();
        var17_24.add(it);
        currentGroup = var15_23;
        while (!stream.isEof()) {
            if (stream.isGroupTerminator()) {
                it = var15_23 = new SourceMapGroup();
                var17_24 = sourceMap.getGroups();
                var17_24.add(it);
                currentGroup = var15_23;
                jsColumn = 0;
                stream.skipChar();
                continue;
            }
            v15 = stream.readInt();
            if (v15 == null) {
                return stream.createError("VLQ-encoded JS column number expected");
            }
            jsColumn += v15.intValue();
            if (stream.isEncodedInt()) {
                v16 = stream.readInt();
                if (v16 == null) {
                    return stream.createError("VLQ-encoded source index expected");
                }
                sourceIndex += v16.intValue();
                v17 = stream.readInt();
                if (v17 == null) {
                    return stream.createError("VLQ-encoded source line expected");
                }
                sourceLine += v17.intValue();
                v18 = stream.readInt();
                if (v18 == null) {
                    return stream.createError("VLQ-encoded source column expected");
                }
                sourceColumn += v18.intValue();
                if (stream.isEncodedInt()) {
                    v19 = stream.readInt();
                    if (v19 != null) {
                        v19.intValue();
                    } else {
                        return stream.createError("VLQ-encoded name index expected");
                    }
                }
                v20 = sourceIndex;
                if (0 > v20 || ((Collection)sources).size() <= v20) {
                    return stream.createError("Source index " + sourceIndex + " is out of bounds " + CollectionsKt.getIndices(sources));
                }
                var15_23 = currentGroup.getSegments();
                it = new SourceMapSegment(jsColumn, sourceRoot + (String)sources.get(sourceIndex), sourceLine, sourceColumn);
                var15_23.add(it);
            } else {
                var15_23 = currentGroup.getSegments();
                it = new SourceMapSegment(jsColumn, null, -1, -1);
                var15_23.add(it);
            }
            if (stream.isEof()) {
                return stream.createError("Unexpected EOF, ',' or ';' expected");
            }
            if (stream.isGroupTerminator()) {
                it = var15_23 = new SourceMapGroup();
                var17_24 = sourceMap.getGroups();
                var17_24.add(it);
                currentGroup = var15_23;
                jsColumn = 0;
            } else if (!stream.isSegmentTerminator()) {
                return stream.createError("Unexpected char, ',' or ';' expected");
            }
            stream.skipChar();
        }
        return new SourceMapSuccess(sourceMap);
    }

    private SourceMapParser() {
        INSTANCE = this;
    }

    static {
        new SourceMapParser();
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003J\r\u0010\u001a\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007R\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapParser$MappingStream;", "", "string", "", "(Ljava/lang/String;)V", "isEncodedInt", "", "()Z", "isEof", "isGroupTerminator", "isSegmentTerminator", "position", "", "getPosition", "()I", "setPosition", "(I)V", "getString", "()Ljava/lang/String;", "base64value", "c", "", "(C)Ljava/lang/Integer;", "createError", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapError;", "error", "readInt", "()Ljava/lang/Integer;", "skipChar", "", "kotlin-compiler"})
    public static final class MappingStream {
        private int position;
        @NotNull
        private final String string;

        public final int getPosition() {
            return this.position;
        }

        public final void setPosition(int n) {
            this.position = n;
        }

        public final boolean isEof() {
            return this.position == this.string.length();
        }

        public final boolean isSegmentTerminator() {
            return this.string.charAt(this.position) == ',';
        }

        public final boolean isGroupTerminator() {
            return this.string.charAt(this.position) == ';';
        }

        public final boolean isEncodedInt() {
            return !this.isEof() && !this.isSegmentTerminator() && !this.isGroupTerminator();
        }

        public final void skipChar() {
            int n = this.position;
            this.position = n + 1;
        }

        @Nullable
        public final Integer readInt() {
            int value = 0;
            int shift = 0;
            while (true) {
                if (this.isEof()) {
                    return null;
                }
                int n = this.position;
                this.position = n + 1;
                Integer n2 = this.base64value(this.string.charAt(n));
                if (n2 == null) {
                    return null;
                }
                int digit = n2;
                int digitValue = digit & 0x1F;
                value |= digitValue << shift;
                if ((digit & 0x20) == 0) break;
                shift += 5;
            }
            int unsignedValue = value >>> 1;
            return (value & 1) == 0 ? Integer.valueOf(unsignedValue) : Integer.valueOf(-unsignedValue);
        }

        private final Integer base64value(char c) {
            Integer n;
            char c2;
            char c3 = c2 = c;
            if ('A' <= c3 && 'Z' >= c3) {
                n = c - 65;
            } else {
                char c4 = c2;
                if ('a' <= c4 && 'z' >= c4) {
                    n = c - 97 + 26;
                } else {
                    char c5 = c2;
                    n = '0' <= c5 && '9' >= c5 ? Integer.valueOf(c - 48 + 52) : (c2 == '+' ? Integer.valueOf(62) : (c2 == '/' ? Integer.valueOf(63) : null));
                }
            }
            return n;
        }

        @NotNull
        public final SourceMapError createError(@NotNull String error) {
            Intrinsics.checkParameterIsNotNull(error, "error");
            return new SourceMapError("Error parsing stream at offset " + this.position + ": " + error);
        }

        @NotNull
        public final String getString() {
            return this.string;
        }

        public MappingStream(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull(string, "string");
            this.string = string;
        }
    }
}

