/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.table;

import org.jfree.layouting.input.style.keys.table.BorderCollapse;
import org.jfree.layouting.input.style.keys.table.EmptyCells;
import org.jfree.layouting.input.style.keys.table.TableLayout;
import org.jfree.layouting.input.style.keys.table.TableStyleKeys;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.DefaultBoxDefinitionFactory;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.table.TableLayoutInfo;
import org.jfree.layouting.renderer.model.table.cols.SpearateColumnModel;
import org.jfree.layouting.renderer.model.table.cols.TableColumnModel;

public class TableRenderBox
extends BlockRenderBox {
    private TableColumnModel columnModel = new SpearateColumnModel();
    private boolean needsPruning;
    private TableLayoutInfo tableInfo = new TableLayoutInfo();
    private boolean structureValidated;
    private boolean predefinedColumnsValidated;

    public TableRenderBox(BoxDefinition boxDefinition) {
        super(boxDefinition);
        this.tableInfo.setBorderSpacing(RenderLength.EMPTY);
    }

    public void appyStyle(LayoutContext layoutContext, OutputProcessorMetaData outputProcessorMetaData) {
        super.appyStyle(layoutContext, outputProcessorMetaData);
        CSSValue cSSValue = layoutContext.getValue(TableStyleKeys.EMPTY_CELLS);
        this.tableInfo.setDisplayEmptyCells(EmptyCells.SHOW.equals(cSSValue));
        CSSValue cSSValue2 = layoutContext.getValue(TableStyleKeys.BORDER_COLLAPSE);
        this.tableInfo.setCollapsingBorderModel(BorderCollapse.COLLAPSE.equals(cSSValue2));
        CSSValue cSSValue3 = layoutContext.getValue(TableStyleKeys.TABLE_LAYOUT);
        this.tableInfo.setAutoLayout(TableLayout.AUTO.equals(cSSValue3));
        CSSValue cSSValue4 = layoutContext.getValue(TableStyleKeys.BORDER_SPACING);
        if (cSSValue4 instanceof CSSValuePair) {
            CSSValuePair cSSValuePair = (CSSValuePair)cSSValue4;
            this.tableInfo.setRowSpacing(DefaultBoxDefinitionFactory.computeWidth(cSSValuePair.getFirstValue(), layoutContext, outputProcessorMetaData, false, false));
            this.tableInfo.setBorderSpacing(DefaultBoxDefinitionFactory.computeWidth(cSSValuePair.getSecondValue(), layoutContext, outputProcessorMetaData, false, false));
        } else {
            this.tableInfo.setBorderSpacing(RenderLength.EMPTY);
            this.tableInfo.setRowSpacing(RenderLength.EMPTY);
        }
    }

    public boolean isPredefinedColumnsValidated() {
        return this.predefinedColumnsValidated;
    }

    public void setPredefinedColumnsValidated(boolean bl) {
        this.predefinedColumnsValidated = bl;
    }

    public boolean isStructureValidated() {
        return this.structureValidated;
    }

    public void setStructureValidated(boolean bl) {
        this.structureValidated = bl;
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public void addChild(RenderNode renderNode) {
        super.addChild(renderNode);
        this.needsPruning = true;
    }

    public boolean isLayoutable() {
        return this.columnModel.isIncrementalModeSupported();
    }

    public RenderLength getBorderSpacing() {
        return this.tableInfo.getBorderSpacing();
    }

    public RenderLength getRowSpacing() {
        return this.tableInfo.getRowSpacing();
    }

    public boolean isDisplayEmptyCells() {
        return this.tableInfo.isDisplayEmptyCells();
    }

    public boolean isCollapsingBorderModel() {
        return this.tableInfo.isCollapsingBorderModel();
    }

    public boolean isAutoLayout() {
        return this.tableInfo.isAutoLayout();
    }

    public Object clone() {
        try {
            TableRenderBox tableRenderBox = (TableRenderBox)super.clone();
            if (!tableRenderBox.isStructureValidated()) {
                tableRenderBox.columnModel = (TableColumnModel)this.columnModel.clone();
            }
            return tableRenderBox;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Clone failed for some reason.");
        }
    }
}

