/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.awt.datatransfer.DataFlavor;
import java.io.InputStream;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;

public class ActivationDataFlavor
extends DataFlavor {
    private String mimeType;
    private String humanPresentableName;
    private Class representationClass;

    public ActivationDataFlavor(Class representationClass, String mimeType, String humanPresentableName) {
        super(mimeType, humanPresentableName);
        this.mimeType = mimeType;
        this.humanPresentableName = humanPresentableName;
        this.representationClass = representationClass;
    }

    public ActivationDataFlavor(Class representationClass, String humanPresentableName) {
        super(representationClass, humanPresentableName);
        this.mimeType = super.getMimeType();
        this.representationClass = representationClass;
        this.humanPresentableName = humanPresentableName;
    }

    public ActivationDataFlavor(String mimeType, String humanPresentableName) {
        super(mimeType, humanPresentableName);
        this.mimeType = mimeType;
        this.humanPresentableName = humanPresentableName;
        this.representationClass = InputStream.class;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    public Class getRepresentationClass() {
        return this.representationClass;
    }

    @Override
    public String getHumanPresentableName() {
        return this.humanPresentableName;
    }

    @Override
    public void setHumanPresentableName(String humanPresentableName) {
        this.humanPresentableName = humanPresentableName;
    }

    @Override
    public boolean equals(DataFlavor dataFlavor) {
        return this.isMimeTypeEqual(dataFlavor) && dataFlavor.getRepresentationClass() == this.representationClass;
    }

    @Override
    public boolean isMimeTypeEqual(String mimeType) {
        try {
            return new MimeType(this.mimeType).match(new MimeType(mimeType));
        }
        catch (MimeTypeParseException e) {
            return false;
        }
    }

    @Override
    protected String normalizeMimeTypeParameter(String parameterName, String parameterValue) {
        return new StringBuffer(parameterName).append('=').append(parameterValue).toString();
    }

    @Override
    protected String normalizeMimeType(String mimeType) {
        return mimeType;
    }
}

