/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.util.LayoutStyle;
import com.jgoodies.looks.BorderStyle;
import com.jgoodies.looks.HeaderStyle;
import com.zeroc.Glacier2.CannotCreateSessionException;
import com.zeroc.Glacier2.SessionPrx;
import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.ConnectionInfo;
import com.zeroc.Ice.Current;
import com.zeroc.Ice.IPConnectionInfo;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.InitializationData;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.LocatorFinderPrx;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.ObjectAdapter;
import com.zeroc.Ice.ObjectNotExistException;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.Properties;
import com.zeroc.Ice.Router;
import com.zeroc.Ice.RouterFinderPrx;
import com.zeroc.Ice.RouterPrx;
import com.zeroc.Ice.UserException;
import com.zeroc.Ice.Util;
import com.zeroc.IceGrid.AccessDeniedException;
import com.zeroc.IceGrid.AdapterDynamicInfo;
import com.zeroc.IceGrid.AdapterInfo;
import com.zeroc.IceGrid.AdminPrx;
import com.zeroc.IceGrid.AdminSessionPrx;
import com.zeroc.IceGrid.ApplicationDescriptor;
import com.zeroc.IceGrid.ApplicationInfo;
import com.zeroc.IceGrid.ApplicationUpdateInfo;
import com.zeroc.IceGrid.DeploymentException;
import com.zeroc.IceGrid.DistributionDescriptor;
import com.zeroc.IceGrid.FileParserPrx;
import com.zeroc.IceGrid.LocatorPrx;
import com.zeroc.IceGrid.NodeDescriptor;
import com.zeroc.IceGrid.NodeDynamicInfo;
import com.zeroc.IceGrid.ObjectInfo;
import com.zeroc.IceGrid.ParseException;
import com.zeroc.IceGrid.PermissionDeniedException;
import com.zeroc.IceGrid.PropertySetDescriptor;
import com.zeroc.IceGrid.RegistryInfo;
import com.zeroc.IceGrid.RegistryPrx;
import com.zeroc.IceGrid.ReplicaGroupDescriptor;
import com.zeroc.IceGrid.ServerDynamicInfo;
import com.zeroc.IceGrid.TemplateDescriptor;
import com.zeroc.IceGridGUI.Application.TreeNode;
import com.zeroc.IceGridGUI.Application.UpdateFailedException;
import com.zeroc.IceGridGUI.ApplicationActions;
import com.zeroc.IceGridGUI.ApplicationPane;
import com.zeroc.IceGridGUI.LiveActions;
import com.zeroc.IceGridGUI.LiveDeployment.MetricsViewEditor;
import com.zeroc.IceGridGUI.LiveDeployment.Root;
import com.zeroc.IceGridGUI.LiveDeployment.Service;
import com.zeroc.IceGridGUI.LiveDeploymentPane;
import com.zeroc.IceGridGUI.Logger;
import com.zeroc.IceGridGUI.MainPane;
import com.zeroc.IceGridGUI.SessionKeeper;
import com.zeroc.IceGridGUI.StatusBar;
import com.zeroc.IceGridGUI.Tab;
import com.zeroc.IceGridGUI.Utils;
import com.zeroc.IceGridGUI.XMLWriter;
import com.zeroc.IceSSL.CertificateVerifier;
import com.zeroc.IceSSL.Plugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;

public class Coordinator {
    private String _dataDir;
    private final InitializationData _initData;
    private Communicator _communicator;
    private boolean _traceObservers;
    private boolean _traceSaveToRegistry;
    private Preferences _prefs;
    private StatusBarI _statusBar = new StatusBarI();
    private Root _liveDeploymentRoot;
    private LiveDeploymentPane _liveDeploymentPane;
    private Map<String, ApplicationPane> _liveApplications = new HashMap<String, ApplicationPane>();
    private MainPane _mainPane;
    private int _latestSerial = -1;
    private int _writeSerial = -1;
    private Runnable _onExclusiveWrite;
    private int _writeAccessCount = 0;
    private boolean _substitute = false;
    private JFrame _mainFrame;
    private final SessionKeeper _sessionKeeper;
    private java.lang.Object _clipboard;
    private Action _newApplication;
    private Action _newApplicationWithDefaultTemplates;
    private Action _login;
    private Action _logout;
    private Action _acquireExclusiveWriteAccess;
    private Action _releaseExclusiveWriteAccess;
    private Action _newGraph;
    private Action _showLiveDeploymentFilters;
    private Action _openApplicationFromFile;
    private Action _openApplicationFromRegistry;
    private Action _closeApplication;
    private Action _save;
    private Action _saveToRegistry;
    private Action _saveToRegistryWithoutRestart;
    private Action _saveToFile;
    private Action _discardUpdates;
    private Action _certificateManager;
    private Action _exit;
    private Action _back;
    private Action _forward;
    private Action _helpContents;
    private Action _about;
    private Action _patchApplication;
    private Action _showApplicationDetails;
    private Action _removeApplicationFromRegistry;
    private Action _cutText = new DefaultEditorKit.CutAction();
    private Action _copyText = new DefaultEditorKit.CopyAction();
    private Action _pasteText = new DefaultEditorKit.PasteAction();
    private DeleteTextAction _deleteText = new DeleteTextAction("Delete");
    private ActionWrapper _cut;
    private ActionWrapper _copy;
    private ActionWrapper _paste;
    private ActionWrapper _delete;
    private ActionWrapper _moveUp;
    private ActionWrapper _moveDown;
    private LiveActions _liveActionsForMenu = new LiveActions();
    private LiveActions _liveActionsForPopup = new LiveActions();
    private ApplicationActions _appActionsForMenu = new ApplicationActions(false);
    private ApplicationActions _appActionsForPopup = new ApplicationActions(true);
    private JToggleButton _showVarsTool;
    private JToggleButton _substituteTool;
    private JCheckBoxMenuItem _substituteMenuItem;
    private JCheckBoxMenuItem _showVarsMenuItem;
    private JMenu _newMenu;
    private JMenu _newServerMenu;
    private JMenu _newServiceMenu;
    private JMenu _newTemplateMenu;
    private JMenu _appMenu;
    private JMenu _metricsViewMenu;
    private JMenu _nodeMenu;
    private JMenu _registryMenu;
    private JMenu _serverMenu;
    private JMenu _serviceMenu;
    private JMenu _signalMenu;
    private final Thread _shutdownHook;
    private JFileChooser _openChooser;
    private JFileChooser _saveXMLChooser;
    private JFileChooser _saveLogFileChooser;
    private JFileChooser _saveIceLogChooser;
    private Process _icegridadminProcess;
    private String _fileParser;
    private boolean _connected = false;
    private X509Certificate _transientCert;
    private List<IGraphView> _graphViews = new ArrayList<IGraphView>();
    private ScheduledExecutorService _executor;

    private void enableTreeEditActions() {
        this._cut.setTarget(null);
        this._copy.setTarget(this._appActionsForMenu.get(13));
        this._paste.setTarget(this._appActionsForMenu.get(14));
        this._delete.setTarget(this._appActionsForMenu.get(15));
        this._moveUp.setTarget(this._appActionsForMenu.get(18));
        this._moveDown.setTarget(this._appActionsForMenu.get(19));
    }

    public Communicator getCommunicator() {
        if (this._communicator == null) {
            this._communicator = Util.initialize(this._initData);
        }
        return this._communicator;
    }

    public Properties getProperties() {
        return this._initData.properties;
    }

    public Tab getCurrentTab() {
        return (Tab)((java.lang.Object)this._mainPane.getSelectedComponent());
    }

    public Action getBackAction() {
        return this._back;
    }

    public Action getForwardAction() {
        return this._forward;
    }

    public Action getCloseApplicationAction() {
        return this._closeApplication;
    }

    public Action getShowLiveDeploymentFiltersAction() {
        return this._showLiveDeploymentFilters;
    }

    public Action getSaveAction() {
        return this._save;
    }

    public Action getSaveToRegistryAction() {
        return this._saveToRegistry;
    }

    public Action getSaveToRegistryWithoutRestartAction() {
        return this._saveToRegistryWithoutRestart;
    }

    public Action getSaveToFileAction() {
        return this._saveToFile;
    }

    public Action getDiscardUpdatesAction() {
        return this._discardUpdates;
    }

    public ApplicationPane openLiveApplication(String applicationName) {
        ApplicationPane app = this._liveApplications.get(applicationName);
        if (app == null) {
            com.zeroc.IceGridGUI.Application.Root root;
            ApplicationDescriptor desc = this._liveDeploymentRoot.getApplicationDescriptor(applicationName);
            if (desc == null) {
                JOptionPane.showMessageDialog(this._mainFrame, "The application '" + applicationName + "' was not found in the registry.", "No such application", 0);
                return null;
            }
            desc = com.zeroc.IceGridGUI.Application.Root.copyDescriptor(desc);
            try {
                root = new com.zeroc.IceGridGUI.Application.Root(this, desc, true, null);
            }
            catch (UpdateFailedException e) {
                JOptionPane.showMessageDialog(this._mainFrame, e.toString(), "Bad Application Descriptor: Unable to load from Registry", 0);
                return null;
            }
            app = new ApplicationPane(root);
            this._mainPane.addApplication(app);
            this._liveApplications.put(applicationName, app);
        }
        this._mainPane.setSelectedComponent(app);
        return app;
    }

    public void removeLiveApplication(String name) {
        this._liveApplications.remove(name);
    }

    public void addLiveApplication(com.zeroc.IceGridGUI.Application.Root root) {
        ApplicationPane app = this._mainPane.findApplication(root);
        assert (app != null);
        this._liveApplications.put(app.getRoot().getId(), app);
    }

    public ApplicationPane getLiveApplication(String name) {
        return this._liveApplications.get(name);
    }

    void applicationInit(String instanceName, int serial, List<ApplicationInfo> applications) {
        assert (this._latestSerial == -1);
        this._latestSerial = serial;
        this._liveDeploymentRoot.applicationInit(instanceName, this._sessionKeeper.getReplicaName(), applications);
    }

    void applicationAdded(int serial, ApplicationInfo info) {
        this._liveDeploymentRoot.applicationAdded(info);
        this._liveDeploymentPane.refresh();
        this._statusBar.setText("Last update: new application '" + info.descriptor.name + "'");
        this.updateSerial(serial);
    }

    void applicationRemoved(int serial, String name) {
        this._liveDeploymentRoot.applicationRemoved(name);
        this._liveDeploymentPane.refresh();
        this._statusBar.setText("Last update: application '" + name + "' was removed");
        ApplicationPane app = this._liveApplications.get(name);
        if (app != null) {
            if (app.getRoot().kill()) {
                this._mainPane.remove(app);
            }
            this._liveApplications.remove(name);
        }
        this.updateSerial(serial);
    }

    void applicationUpdated(int serial, ApplicationUpdateInfo update) {
        this._liveDeploymentRoot.applicationUpdated(update);
        this._liveDeploymentPane.refresh();
        this._statusBar.setText("Last update: application  '" + update.descriptor.name + "' was updated");
        ApplicationPane app = this._liveApplications.get(update.descriptor.name);
        if (app != null && app.getRoot().update(update.descriptor)) {
            app.refresh();
        }
        this.updateSerial(serial);
    }

    void adapterInit(AdapterInfo[] adapters) {
        this._liveDeploymentRoot.adapterInit(adapters);
        this._liveDeploymentPane.refresh();
    }

    void adapterAdded(AdapterInfo info) {
        this._liveDeploymentRoot.adapterAdded(info);
        this._liveDeploymentPane.refresh();
    }

    void adapterUpdated(AdapterInfo info) {
        this._liveDeploymentRoot.adapterUpdated(info);
        this._liveDeploymentPane.refresh();
    }

    void adapterRemoved(String id) {
        this._liveDeploymentRoot.adapterRemoved(id);
        this._liveDeploymentPane.refresh();
    }

    void objectInit(ObjectInfo[] objects) {
        this._liveDeploymentRoot.objectInit(objects);
        this._liveDeploymentPane.refresh();
    }

    void objectAdded(ObjectInfo info) {
        this._liveDeploymentRoot.objectAdded(info);
        this._liveDeploymentPane.refresh();
    }

    void objectUpdated(ObjectInfo info) {
        this._liveDeploymentRoot.objectUpdated(info);
        this._liveDeploymentPane.refresh();
    }

    void objectRemoved(Identity id) {
        this._liveDeploymentRoot.objectRemoved(id);
        this._liveDeploymentPane.refresh();
    }

    public void accessDenied(AccessDeniedException e) {
        JOptionPane.showMessageDialog(this._mainFrame, "Another session (username = " + e.lockUserId + ") has exclusive write access to the registry", "Access Denied", 0);
    }

    public void pasteApplication() {
        java.lang.Object descriptor = this.getClipboard();
        ApplicationDescriptor desc = com.zeroc.IceGridGUI.Application.Root.copyDescriptor((ApplicationDescriptor)descriptor);
        com.zeroc.IceGridGUI.Application.Root root = new com.zeroc.IceGridGUI.Application.Root(this, desc);
        ApplicationPane app = new ApplicationPane(root);
        this._mainPane.addApplication(app);
        this._mainPane.setSelectedComponent(app);
        root.setSelectedNode(root);
    }

    public void removeApplicationFromRegistry(final String name) {
        this._mainFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Runnable runnable = new Runnable(){

                private void release() {
                    Coordinator.this.releaseExclusiveWriteAccess();
                    Coordinator.this.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                }

                private void handleFailure(String prefix, String title, String message) {
                    this.release();
                    Coordinator.this.getStatusBar().setText(prefix + "failed!");
                    JOptionPane.showMessageDialog(Coordinator.this.getMainFrame(), message, title, 0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Coordinator.this.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
                    boolean asyncRelease = false;
                    String prefix = "Deleting application '" + name + "'...";
                    if (Coordinator.this._traceSaveToRegistry) {
                        Coordinator.this.traceSaveToRegistry("sending removeApplication for application " + name);
                    }
                    try {
                        Coordinator.this._sessionKeeper.getAdmin().removeApplicationAsync(name).whenComplete((result, ex) -> {
                            if (Coordinator.this._traceSaveToRegistry) {
                                Coordinator.this.traceSaveToRegistry("removeApplication for application " + name + (ex == null ? ": success" : ": failed"));
                            }
                            if (ex == null) {
                                SwingUtilities.invokeLater(() -> {
                                    this.release();
                                    Coordinator.this.getStatusBar().setText(prefix + "done.");
                                });
                            } else if (ex instanceof UserException) {
                                SwingUtilities.invokeLater(() -> this.handleFailure(prefix, "Delete failed", "IceGrid exception: " + ex.toString()));
                            } else {
                                SwingUtilities.invokeLater(() -> this.handleFailure(prefix, "Delete failed", "Communication exception: " + ex.toString()));
                            }
                        });
                        asyncRelease = true;
                    }
                    catch (LocalException e) {
                        if (Coordinator.this._traceSaveToRegistry) {
                            Coordinator.this.traceSaveToRegistry("Ice communications exception while removing application " + name);
                        }
                        JOptionPane.showMessageDialog(Coordinator.this.getMainFrame(), e.toString(), "Communication Exception", 0);
                    }
                    finally {
                        if (!asyncRelease) {
                            Coordinator.this.releaseExclusiveWriteAccess();
                            Coordinator.this.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                        }
                    }
                }
            };
            this.acquireExclusiveWriteAccess(runnable);
        }
        catch (AccessDeniedException e) {
            this.accessDenied(e);
        }
        catch (LocalException e) {
            JOptionPane.showMessageDialog(this._mainFrame, "Could not remove application '" + name + "' from IceGrid registry:\n" + e.toString(), "Trouble with IceGrid registry", 0);
        }
    }

    public void acquireExclusiveWriteAccess(Runnable runnable) throws AccessDeniedException {
        if (this._writeSerial == -1) {
            this._mainFrame.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this._writeSerial = this._sessionKeeper.getSession().startUpdate();
                if (this._traceSaveToRegistry) {
                    this.traceSaveToRegistry("startUpdate returned serial " + this._writeSerial);
                }
            }
            finally {
                this._mainFrame.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        assert (this._onExclusiveWrite == null);
        ++this._writeAccessCount;
        if (this._traceSaveToRegistry) {
            this.traceSaveToRegistry("acquireExclusiveWriteAccess: writeAccessCount is " + this._writeAccessCount);
        }
        if (runnable != null) {
            if (this._traceSaveToRegistry) {
                this.traceSaveToRegistry("latestSerial is " + this._latestSerial);
            }
            if (this._writeSerial <= this._latestSerial) {
                if (this._traceSaveToRegistry) {
                    this.traceSaveToRegistry("run update immediately");
                }
                runnable.run();
            } else {
                if (this._traceSaveToRegistry) {
                    this.traceSaveToRegistry("wait for updates from ApplicationObserver");
                }
                this._onExclusiveWrite = runnable;
                this._mainFrame.setCursor(Cursor.getPredefinedCursor(3));
            }
        }
    }

    public void releaseExclusiveWriteAccess() {
        if (--this._writeAccessCount == 0) {
            try {
                this._writeSerial = -1;
                this._sessionKeeper.getSession().finishUpdate();
                if (this._traceSaveToRegistry) {
                    this.traceSaveToRegistry("finishUpdate done");
                }
            }
            catch (AccessDeniedException e) {
                this.accessDenied(e);
            }
            catch (ObjectNotExistException e) {
            }
            catch (LocalException e) {
                JOptionPane.showMessageDialog(this._mainFrame, "Could not release exclusive write access on the IceGrid registry:\n" + e.toString(), "Trouble with IceGrid registry", 0);
            }
        }
        if (this._traceSaveToRegistry) {
            this.traceSaveToRegistry("releaseExclusiveWriteAccess: writeAccessCount is " + this._writeAccessCount);
        }
    }

    private void updateSerial(int serial) {
        assert (serial == this._latestSerial + 1);
        this._latestSerial = serial;
        if (this._writeAccessCount > 0 && this._writeSerial <= this._latestSerial && this._onExclusiveWrite != null) {
            Runnable runnable = this._onExclusiveWrite;
            this._onExclusiveWrite = null;
            if (this._traceSaveToRegistry) {
                this.traceSaveToRegistry("writeSerial <= latestSerial, running update");
            }
            runnable.run();
            this._mainFrame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    void registryUp(RegistryInfo info) {
        this._liveDeploymentRoot.registryUp(info);
        this._liveDeploymentPane.refresh();
    }

    void registryDown(String registry) {
        this._liveDeploymentRoot.registryDown(registry);
        this._liveDeploymentPane.refresh();
    }

    void nodeUp(NodeDynamicInfo updatedInfo) {
        this._liveDeploymentRoot.nodeUp(updatedInfo);
        this._liveDeploymentPane.refresh();
    }

    void nodeDown(String node) {
        this._liveDeploymentRoot.nodeDown(node);
        this._liveDeploymentPane.refresh();
    }

    void updateServer(String node, ServerDynamicInfo updatedInfo) {
        this._liveDeploymentRoot.updateServer(node, updatedInfo);
        this._liveDeploymentPane.refresh();
    }

    void updateAdapter(String node, AdapterDynamicInfo updatedInfo) {
        this._liveDeploymentRoot.updateAdapter(node, updatedInfo);
        this._liveDeploymentPane.refresh();
    }

    void sessionLost() {
        this._latestSerial = -1;
        this._writeSerial = -1;
        this._writeAccessCount = 0;
        this._onExclusiveWrite = null;
        this._liveDeploymentRoot.clear();
        for (ApplicationPane p : this._liveApplications.values()) {
            if (!p.getRoot().kill()) continue;
            this._mainPane.remove(p);
        }
        this._liveApplications.clear();
        ArrayList<IGraphView> views = new ArrayList<IGraphView>(this._graphViews);
        for (IGraphView v : views) {
            v.close();
        }
        this._logout.setEnabled(false);
        this._showLiveDeploymentFilters.setEnabled(false);
        this._openApplicationFromRegistry.setEnabled(false);
        this._patchApplication.setEnabled(false);
        this._showApplicationDetails.setEnabled(false);
        this._removeApplicationFromRegistry.setEnabled(false);
        this._appMenu.setEnabled(false);
        this._newApplicationWithDefaultTemplates.setEnabled(false);
        this._acquireExclusiveWriteAccess.setEnabled(false);
        this._releaseExclusiveWriteAccess.setEnabled(false);
        this._saveToRegistry.setEnabled(false);
        this._saveToRegistryWithoutRestart.setEnabled(false);
    }

    void login(final SessionKeeper sessionKeeper, final SessionKeeper.ConnectionInfo info, final JDialog parent) {
        this._transientCert = null;
        this._liveDeploymentRoot.clear();
        this.destroyCommunicator();
        InitializationData initData = this._initData.clone();
        initData.properties = initData.properties._clone();
        initData.properties.setProperty("Ice.Plugin.IceSSL", "com.zeroc.IceSSL.PluginFactory");
        initData.properties.setProperty("IceSSL.VerifyPeer", "0");
        if (info.getAuth() == SessionKeeper.AuthType.X509CertificateAuthType | info.getUseX509Certificate()) {
            try {
                initData.properties.setProperty("IceSSL.Keystore", this.getDataDirectory() + "/MyCerts.jks");
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(parent, e.toString(), "Failed to access data directory", 0);
                this._sessionKeeper.loginFailed();
                return;
            }
            if (info.getKeyPassword() != null) {
                initData.properties.setProperty("IceSSL.Password", new String(info.getKeyPassword()));
            }
            initData.properties.setProperty("IceSSL.Alias", info.getAlias());
        }
        initData.properties.setProperty("Ice.Default.Router", "");
        try {
            this._communicator = Util.initialize(initData);
        }
        catch (LocalException e) {
            JOptionPane.showMessageDialog(parent, e.toString(), "Communicator initialization failed", 0);
            this._sessionKeeper.loginFailed();
            return;
        }
        Plugin plugin = (Plugin)this._communicator.getPluginManager().getPlugin("IceSSL");
        try {
            class CertificateVerifier
            implements com.zeroc.IceSSL.CertificateVerifier {
                private KeyStore _trustedCaKeyStore = KeyStore.getInstance("JKS");
                private KeyStore _trustedServerKeyStore;

                public CertificateVerifier() throws IOException, GeneralSecurityException, Exception {
                    FileInputStream is = null;
                    String path = Coordinator.this.getDataDirectory() + "/AuthorityCerts.jks";
                    if (new File(path).isFile()) {
                        is = new FileInputStream(new File(path));
                    }
                    this._trustedCaKeyStore.load(is, null);
                    this._trustedServerKeyStore = KeyStore.getInstance("JKS");
                    is = null;
                    path = Coordinator.this.getDataDirectory() + "/ServerCerts.jks";
                    if (new File(path).isFile()) {
                        is = new FileInputStream(new File(path));
                    }
                    this._trustedServerKeyStore.load(is, null);
                }

                @Override
                public boolean verify(com.zeroc.IceSSL.ConnectionInfo info) {
                    boolean validAlternateName;
                    boolean trustedCA;
                    boolean validDate;
                    X509Certificate cert;
                    block39: {
                        byte[] encoded;
                        if (!(info.certs[0] instanceof X509Certificate)) {
                            return false;
                        }
                        cert = (X509Certificate)info.certs[0];
                        try {
                            encoded = cert.getEncoded();
                        }
                        catch (GeneralSecurityException ex) {
                            return false;
                        }
                        if (Coordinator.this._transientCert != null && Coordinator.this._transientCert.equals(cert)) {
                            return true;
                        }
                        try {
                            Enumeration<String> e = this._trustedServerKeyStore.aliases();
                            while (e.hasMoreElements()) {
                                String alias = e.nextElement();
                                if (!this._trustedServerKeyStore.isCertificateEntry(alias)) continue;
                                Certificate c = this._trustedServerKeyStore.getCertificate(alias);
                                try {
                                    if (!Arrays.equals(encoded, c.getEncoded())) continue;
                                    return true;
                                }
                                catch (GeneralSecurityException ex) {
                                }
                            }
                        }
                        catch (KeyStoreException ex) {
                            while (true) {
                                try {
                                    SwingUtilities.invokeAndWait(() -> JOptionPane.showMessageDialog(parent, ex.toString(), "Error loading keystore", 0));
                                }
                                catch (InterruptedException alias) {
                                    continue;
                                }
                                catch (InvocationTargetException e) {
                                    // empty catch block
                                }
                                break;
                            }
                            return false;
                        }
                        validDate = true;
                        trustedCA = false;
                        validAlternateName = false;
                        Date now = new Date();
                        if (now.getTime() > cert.getNotAfter().getTime() || now.getTime() < cert.getNotBefore().getTime()) {
                            validDate = false;
                        }
                        String remoteAddress = null;
                        ConnectionInfo p = info.underlying;
                        while (p != null) {
                            if (p instanceof IPConnectionInfo) {
                                remoteAddress = ((IPConnectionInfo)p).remoteAddress;
                                break;
                            }
                            p = p.underlying;
                        }
                        if (remoteAddress != null) {
                            try {
                                Collection<List<?>> altNames = cert.getSubjectAlternativeNames();
                                if (altNames == null) break block39;
                                for (List<?> l : altNames) {
                                    Integer kind = (Integer)l.get(0);
                                    if (kind != 2 && kind != 7 || !remoteAddress.equalsIgnoreCase(l.get(1).toString())) continue;
                                    validAlternateName = true;
                                    break;
                                }
                            }
                            catch (CertificateParsingException ex) {
                                validAlternateName = false;
                            }
                        }
                    }
                    try {
                        Enumeration<String> e = this._trustedCaKeyStore.aliases();
                        while (e.hasMoreElements()) {
                            String alias = e.nextElement();
                            if (!this._trustedCaKeyStore.isCertificateEntry(alias)) continue;
                            Certificate c = this._trustedCaKeyStore.getCertificate(alias);
                            try {
                                cert.verify(c.getPublicKey());
                                trustedCA = true;
                                break;
                            }
                            catch (GeneralSecurityException ex) {
                            }
                        }
                    }
                    catch (KeyStoreException ex) {
                        while (true) {
                            try {
                                SwingUtilities.invokeAndWait(() -> JOptionPane.showMessageDialog(parent, ex.toString(), "Error loading keystore", 0));
                            }
                            catch (InterruptedException alias) {
                                continue;
                            }
                            catch (InvocationTargetException e) {
                                // empty catch block
                            }
                            break;
                        }
                        return false;
                    }
                    if (validDate && validAlternateName && trustedCA) {
                        return true;
                    }
                    TrustDecision decision = new 1CertificateVerifier.AcceptInvalidCertDialog().show(info, validDate, validAlternateName, trustedCA);
                    if (decision == TrustDecision.YesThisTime) {
                        Coordinator.this._transientCert = (X509Certificate)info.certs[0];
                        return true;
                    }
                    if (decision == TrustDecision.YesAlways) {
                        try {
                            String CN = "";
                            LdapName dn = new LdapName(cert.getSubjectX500Principal().getName());
                            for (Rdn rdn : dn.getRdns()) {
                                if (!rdn.getType().toUpperCase().equals("CN")) continue;
                                CN = rdn.getValue().toString();
                                break;
                            }
                            this._trustedServerKeyStore.setCertificateEntry(CN, info.certs[0]);
                            this._trustedServerKeyStore.store(new FileOutputStream(Coordinator.this.getDataDirectory() + "/ServerCerts.jks"), new char[0]);
                            sessionKeeper.certificateManager(parent).load();
                            return true;
                        }
                        catch (Exception ex) {
                            while (true) {
                                try {
                                    SwingUtilities.invokeAndWait(() -> JOptionPane.showMessageDialog(parent, ex.toString(), "Error saving certificate", 0));
                                }
                                catch (InterruptedException dn) {
                                    continue;
                                }
                                catch (InvocationTargetException e) {
                                }
                                break;
                            }
                        }
                    }
                    return false;
                }

                class 1CertificateVerifier.AcceptInvalidCertDialog
                implements Runnable {
                    private com.zeroc.IceSSL.ConnectionInfo _info;
                    private boolean _validDate;
                    private boolean _validAlternateName;
                    private boolean _trustedCA;
                    private TrustDecision _decision = TrustDecision.No;

                    1CertificateVerifier.AcceptInvalidCertDialog() {
                    }

                    public TrustDecision show(com.zeroc.IceSSL.ConnectionInfo info, boolean validDate, boolean validAlternateName, boolean trustedCA) {
                        this._info = info;
                        this._validDate = validDate;
                        this._validAlternateName = validAlternateName;
                        this._trustedCA = trustedCA;
                        while (true) {
                            try {
                                SwingUtilities.invokeAndWait(this);
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            catch (InvocationTargetException e) {
                            }
                            break;
                        }
                        return this._decision;
                    }

                    @Override
                    public void run() {
                        try {
                            UntrustedCertificateDialog dialog = new UntrustedCertificateDialog(parent, this._info, this._validDate, this._validAlternateName, this._trustedCA);
                            Utils.addEscapeListener(dialog);
                            this._decision = dialog.showDialog();
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(parent, ex.toString(), "Failed to inspect certificate details", 0);
                        }
                    }
                }
            }
            plugin.setCertificateVerifier(new CertificateVerifier());
        }
        catch (Exception ex) {
            while (true) {
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        JOptionPane.showMessageDialog(parent, ex.toString(), "Error creating certificate verifier", 0);
                        this._sessionKeeper.loginFailed();
                    });
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
                break;
            }
            return;
        }
        String finderStr = "Ice/" + (info.getDirect() ? "LocatorFinder" : "RouterFinder") + ":" + (info.getDefaultEndpoint() ? (info.getSSL() ? "ssl" : "tcp") + " -h " + info.getHost() + " -p " + info.getPort() : info.getEndpoint());
        if (!info.getDirect()) {
            class ConnectionCallback {
                private AdminSessionPrx _session;
                private long _sessionTimeout = 0L;
                private int _acmTimeout = 0;
                private boolean _failed = false;

                ConnectionCallback() {
                }

                public synchronized void setSession(AdminSessionPrx session) {
                    this._session = session;
                }

                public synchronized AdminSessionPrx getSession() {
                    return this._session;
                }

                public synchronized void setSessionTimeout(long sessionTimeout) {
                    this._sessionTimeout = sessionTimeout;
                }

                public synchronized void setACMTimeout(int acmTimeout) {
                    this._acmTimeout = acmTimeout;
                }

                public synchronized void loginSuccess() {
                    Coordinator.this._logout.setEnabled(true);
                    Coordinator.this._showLiveDeploymentFilters.setEnabled(true);
                    Coordinator.this._openApplicationFromRegistry.setEnabled(true);
                    Coordinator.this._patchApplication.setEnabled(true);
                    Coordinator.this._showApplicationDetails.setEnabled(true);
                    Coordinator.this._removeApplicationFromRegistry.setEnabled(true);
                    Coordinator.this._appMenu.setEnabled(true);
                    Coordinator.this._newApplicationWithDefaultTemplates.setEnabled(true);
                    Coordinator.this._acquireExclusiveWriteAccess.setEnabled(true);
                    Coordinator.this._mainPane.setSelectedComponent(Coordinator.this._liveDeploymentPane);
                    Coordinator.this._sessionKeeper.loginSuccess(parent, this._sessionTimeout, this._acmTimeout, this._session, info);
                }

                public synchronized void loginFailed() {
                    Coordinator.this._sessionKeeper.loginFailed();
                    this._failed = true;
                }

                public synchronized void permissionDenied(String msg) {
                    this._failed = true;
                    Coordinator.this._sessionKeeper.permissionDenied(parent, info, msg);
                }

                public synchronized boolean failed() {
                    return this._failed;
                }
            }
            ConnectionCallback cb = new ConnectionCallback();
            new Thread(() -> {
                try {
                    SessionPrx s;
                    RouterFinderPrx finder = RouterFinderPrx.uncheckedCast(this._communicator.stringToProxy(finderStr));
                    info.setInstanceName(finder.getRouter().ice_getIdentity().category);
                    info.save();
                    com.zeroc.Glacier2.RouterPrx router = com.zeroc.Glacier2.RouterPrx.uncheckedCast(finder.ice_identity(new Identity("router", info.getInstanceName())));
                    this._communicator.setDefaultRouter(router);
                    if (info.getAuth() == SessionKeeper.AuthType.X509CertificateAuthType) {
                        s = (router = com.zeroc.Glacier2.RouterPrx.uncheckedCast(router.ice_secure(true))).createSessionFromSecureConnection();
                        if (s == null) {
                            SwingUtilities.invokeLater(() -> {
                                JOptionPane.showMessageDialog(parent, "createSessionFromSecureConnection returned a null session: \nverify that Glacier2.SSLSessionManager is set to <IceGridInstanceName>/AdminSSLSessionManager in your Glacier2 router configuration", "Login failed", 0);
                                cb.loginFailed();
                            });
                            return;
                        }
                    } else {
                        s = (router = com.zeroc.Glacier2.RouterPrx.uncheckedCast(router.ice_preferSecure(true))).createSession(info.getUsername(), info.getPassword() != null ? new String(info.getPassword()) : "");
                        if (s == null) {
                            SwingUtilities.invokeLater(() -> {
                                JOptionPane.showMessageDialog(parent, "createSession returned a null session: \nverify that Glacier2.SessionManager is set to <IceGridInstanceName>/AdminSessionManager in your Glacier2 router configuration", "Login failed", 0);
                                cb.loginFailed();
                            });
                            return;
                        }
                    }
                    cb.setSession(AdminSessionPrx.uncheckedCast(s));
                    cb.setSessionTimeout(router.getSessionTimeout());
                    try {
                        cb.setACMTimeout(router.getACMTimeout());
                    }
                    catch (OperationNotExistException operationNotExistException) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(() -> cb.loginSuccess());
                }
                catch (com.zeroc.Glacier2.PermissionDeniedException e) {
                    SwingUtilities.invokeLater(() -> {
                        String msg = e.reason;
                        if (msg.length() == 0) {
                            String string = msg = info.getAuth() == SessionKeeper.AuthType.X509CertificateAuthType ? "Invalid credentials" : "Invalid username/password";
                        }
                        if (info.getAuth() == SessionKeeper.AuthType.X509CertificateAuthType) {
                            JOptionPane.showMessageDialog(parent, "Permission denied: " + msg, "Login failed", 0);
                            cb.loginFailed();
                        } else {
                            cb.permissionDenied(msg);
                        }
                    });
                    return;
                }
                catch (CannotCreateSessionException e) {
                    SwingUtilities.invokeLater(() -> {
                        JOptionPane.showMessageDialog(parent, "Could not create session: " + e.reason, "Login failed", 0);
                        cb.loginFailed();
                    });
                    return;
                }
                catch (BackingStoreException ex) {
                    SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.getMainFrame(), ex.toString(), "Error saving connection", 0));
                    return;
                }
                catch (LocalException e) {
                    SwingUtilities.invokeLater(() -> {
                        JOptionPane.showMessageDialog(parent, "Could not create session: " + e.toString(), "Login failed", 0);
                        cb.loginFailed();
                    });
                    return;
                }
            }).start();
        } else {
            class RegistryCallback
            extends ConnectionCallback {
                private LocatorPrx _locator;
                private RegistryPrx _registry;
                private RegistryPrx _currentRegistry;

                RegistryCallback() {
                    super(Coordinator.this, jDialog, connectionInfo);
                }

                public synchronized void setRegistry(RegistryPrx registry) {
                    this._registry = registry;
                }

                public synchronized RegistryPrx getRegistry() {
                    return this._registry;
                }

                public synchronized void setCurrentRegistry(RegistryPrx value) {
                    this._currentRegistry = value;
                }

                public synchronized RegistryPrx getCurrentRegistry() {
                    return this._currentRegistry;
                }

                public synchronized void setLocator(LocatorPrx locator) {
                    this._locator = locator;
                }

                public synchronized LocatorPrx getLocator() {
                    return this._locator;
                }
            }
            RegistryCallback cb = new RegistryCallback();
            if (info.getCustomEndpoint() && info.getEndpoint().equals("")) {
                JOptionPane.showMessageDialog(parent, "You need to provide one or more endpoints for the Registry", "Login failed", 0);
                cb.loginFailed();
                return;
            }
            new Thread(() -> {
                Coordinator coordinator = this;
                synchronized (coordinator) {
                    try {
                        LocatorFinderPrx finder = LocatorFinderPrx.uncheckedCast(this._communicator.stringToProxy(finderStr));
                        info.setInstanceName(finder.getLocator().ice_getIdentity().category);
                        info.save();
                        cb.setLocator(LocatorPrx.checkedCast(finder.ice_identity(new Identity("Locator", info.getInstanceName()))));
                        if (cb.getLocator() == null) {
                            SwingUtilities.invokeLater(() -> {
                                JOptionPane.showMessageDialog(parent, "This version of IceGrid GUI requires an IceGrid Registry version 3.3 or higher", "Version Mismatch", 0);
                                cb.loginFailed();
                            });
                            return;
                        }
                        cb.setCurrentRegistry(cb.getLocator().getLocalRegistry());
                        this._communicator.setDefaultLocator(cb.getLocator());
                    }
                    catch (BackingStoreException ex) {
                        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.getMainFrame(), ex.toString(), "Error saving connection", 0));
                        return;
                    }
                    catch (LocalException e) {
                        SwingUtilities.invokeLater(() -> {
                            JOptionPane.showMessageDialog(parent, "Could not create session: " + e.toString(), "Login failed", 0);
                            cb.loginFailed();
                        });
                        return;
                    }
                    cb.setRegistry(cb.getCurrentRegistry());
                    if (info.getConnectToMaster() && !cb.getCurrentRegistry().ice_getIdentity().name.equals("Registry")) {
                        Identity masterRegistryId = new Identity();
                        masterRegistryId.category = info.getInstanceName();
                        masterRegistryId.name = "Registry";
                        cb.setRegistry(RegistryPrx.uncheckedCast(this._communicator.stringToProxy("\"" + this._communicator.identityToString(masterRegistryId) + "\"")));
                    }
                    if (cb.getRegistry().ice_getIdentity().equals(cb.getCurrentRegistry().ice_getIdentity())) {
                        try {
                            ObjectAdapter colloc = this._communicator.createObjectAdapter("");
                            ObjectPrx router = colloc.addWithUUID(new ReuseConnectionRouter(cb.getLocator()));
                            this._communicator.setDefaultRouter(RouterPrx.uncheckedCast(router));
                            cb.setRegistry(cb.getRegistry().ice_router(this._communicator.getDefaultRouter()));
                        }
                        catch (LocalException e) {
                            SwingUtilities.invokeLater(() -> {
                                JOptionPane.showMessageDialog(parent, "Could not create session: " + e.toString(), "Login failed", 0);
                                cb.loginFailed();
                            });
                            return;
                        }
                    }
                    do {
                        try {
                            if (info.getAuth() == SessionKeeper.AuthType.X509CertificateAuthType) {
                                cb.setRegistry(cb.getRegistry().ice_secure(true));
                                cb.setSession(cb.getRegistry().createAdminSessionFromSecureConnection());
                                assert (cb.getSession() != null);
                            } else {
                                cb.setRegistry(cb.getRegistry().ice_preferSecure(true));
                                cb.setSession(cb.getRegistry().createAdminSession(info.getUsername(), info.getPassword() != null ? new String(info.getPassword()) : ""));
                                assert (cb.getSession() != null);
                            }
                            cb.setSessionTimeout(cb.getRegistry().getSessionTimeout());
                            try {
                                cb.setACMTimeout(cb.getRegistry().getACMTimeout());
                            }
                            catch (OperationNotExistException e) {}
                        }
                        catch (PermissionDeniedException e) {
                            SwingUtilities.invokeLater(() -> {
                                String msg = e.reason;
                                if (msg.length() == 0) {
                                    String string = msg = info.getAuth() == SessionKeeper.AuthType.X509CertificateAuthType ? "Invalid credentials" : "Invalid username/password";
                                }
                                if (info.getAuth() == SessionKeeper.AuthType.X509CertificateAuthType) {
                                    JOptionPane.showMessageDialog(parent, "Permission denied: " + e.reason, "Login failed", 0);
                                    cb.loginFailed();
                                } else {
                                    cb.permissionDenied(msg);
                                }
                            });
                            return;
                        }
                        catch (LocalException e) {
                            if (cb.getRegistry().ice_getIdentity().equals(cb.getCurrentRegistry().ice_getIdentity())) {
                                SwingUtilities.invokeLater(() -> {
                                    JOptionPane.showMessageDialog(parent, "Could not create session: " + e.toString(), "Login failed", 0);
                                    cb.loginFailed();
                                });
                                return;
                            }
                            while (true) {
                                try {
                                    SwingUtilities.invokeAndWait(() -> {
                                        if (JOptionPane.showConfirmDialog(parent, "Unable to connect to the Master Registry:\n " + e.toString() + "\n\nDo you want to connect to a Slave Registry?", "Cannot connect to Master Registry", 0, 3) == 0) {
                                            cb.setRegistry(cb.getCurrentRegistry());
                                        } else {
                                            cb.loginFailed();
                                        }
                                    });
                                }
                                catch (InterruptedException router) {
                                    continue;
                                }
                                catch (InvocationTargetException ex) {
                                    cb.loginFailed();
                                }
                                break;
                            }
                            if (!cb.failed()) continue;
                            return;
                        }
                    } while (cb.getSession() == null);
                    SwingUtilities.invokeLater(() -> cb.loginSuccess());
                }
            }).start();
        }
    }

    void destroySession(AdminSessionPrx session, boolean routed) {
        this._liveDeploymentRoot.closeAllShowLogDialogs();
        try {
            if (!routed) {
                session.destroyAsync();
            } else {
                com.zeroc.Glacier2.RouterPrx.uncheckedCast(this._communicator.getDefaultRouter()).destroySessionAsync();
            }
        }
        catch (LocalException localException) {
            // empty catch block
        }
    }

    void showVars() {
        this.substitute(false);
    }

    void substituteVars() {
        this.substitute(true);
    }

    private void substitute(boolean newValue) {
        if (this._substitute != newValue) {
            ApplicationPane app;
            this._substitute = newValue;
            boolean refresh = true;
            if (this.getCurrentTab() instanceof ApplicationPane && !(app = (ApplicationPane)this.getCurrentTab()).applyUpdates(true)) {
                this._substitute = !this._substitute;
                refresh = false;
            }
            if (this._substitute) {
                this._substituteMenuItem.setSelected(true);
                this._substituteTool.setSelected(true);
            } else {
                this._showVarsMenuItem.setSelected(true);
                this._showVarsTool.setSelected(true);
            }
            if (refresh) {
                this.getCurrentTab().refresh();
            }
        }
    }

    public boolean substitute() {
        return this._substitute;
    }

    public AdminPrx getAdmin() {
        return this._sessionKeeper.getAdmin();
    }

    public String getServerAdminCategory() {
        return this._sessionKeeper.getServerAdminCategory();
    }

    public ObjectPrx addCallback(Object servant, String name, String facet) {
        return this._sessionKeeper.addCallback(servant, name, facet);
    }

    public ObjectPrx retrieveCallback(String name, String facet) {
        return this._sessionKeeper.retrieveCallback(name, facet);
    }

    public Object removeCallback(String name, String facet) {
        return this._sessionKeeper.removeCallback(name, facet);
    }

    public StatusBar getStatusBar() {
        return this._statusBar;
    }

    public JFrame getMainFrame() {
        return this._mainFrame;
    }

    public MainPane getMainPane() {
        return this._mainPane;
    }

    public ApplicationDescriptor parseFile(File file) {
        if (this._icegridadminProcess == null) {
            try {
                this._icegridadminProcess = Runtime.getRuntime().exec("icegridadmin --server");
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this._mainFrame, "Failed to start icegridadmin subprocess: " + e.toString(), "IO Exception", 0);
                return null;
            }
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this._icegridadminProcess.getInputStream(), "US-ASCII"));
                String str = reader.readLine();
                reader.close();
                if (str == null || str.length() == 0) {
                    JOptionPane.showMessageDialog(this._mainFrame, "The icegridadmin subprocess failed", "Subprocess failure", 0);
                    this.destroyIceGridAdmin();
                    return null;
                }
                this._fileParser = str;
            }
            catch (UnsupportedEncodingException e) {
                assert (false);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this._mainFrame, "IO Exception: " + e.toString(), "IO Exception", 0);
                this.destroyIceGridAdmin();
                return null;
            }
        }
        try {
            FileParserPrx fileParser = FileParserPrx.checkedCast(this.getCommunicator().stringToProxy(this._fileParser).ice_router(null));
            return fileParser.parse(file.getAbsolutePath(), this._sessionKeeper.getRoutedAdmin());
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog(this._mainFrame, "Failed to parse file '" + file.getAbsolutePath() + "':\n" + e.toString(), "Parse error", 0);
            return null;
        }
        catch (LocalException e) {
            JOptionPane.showMessageDialog(this._mainFrame, "Operation on FileParser failed:\n" + e.toString(), "Communication error", 0);
            this.destroyIceGridAdmin();
            return null;
        }
    }

    private void destroyIceGridAdmin() {
        if (this._icegridadminProcess != null) {
            try {
                this._icegridadminProcess.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._icegridadminProcess = null;
            this._fileParser = null;
        }
    }

    public File saveToFile(boolean ask, com.zeroc.IceGridGUI.Application.Root root, File file) {
        if (ask || file == null) {
            if (file != null) {
                this._saveXMLChooser.setSelectedFile(file);
            } else {
                this._saveXMLChooser.setCurrentDirectory(this._openChooser.getCurrentDirectory());
            }
            int result = this._saveXMLChooser.showSaveDialog(this._mainFrame);
            if (file == null || result == 0) {
                this._openChooser.setCurrentDirectory(this._saveXMLChooser.getCurrentDirectory());
            }
            file = result == 0 ? this._saveXMLChooser.getSelectedFile() : null;
        }
        if (file != null) {
            if (!file.exists() && file.getName().indexOf(46) == -1) {
                file = new File(file.getAbsolutePath() + ".xml");
            }
            try {
                XMLWriter writer = new XMLWriter(file);
                root.write(writer);
                writer.close();
                this._statusBar.setText("Saved application '" + root.getId() + "' to " + file.getAbsolutePath());
            }
            catch (FileNotFoundException e) {
                JOptionPane.showMessageDialog(this._mainFrame, "Cannot use the selected file for writing.", "File Not Found", 0);
                return null;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this._mainFrame, "IO Exception: " + e.toString(), "IO Exception", 0);
                return null;
            }
        }
        return file;
    }

    public JFileChooser getSaveLogFileChooser() {
        return this._saveLogFileChooser;
    }

    public JFileChooser getSaveIceLogChooser() {
        return this._saveIceLogChooser;
    }

    private static Properties createProperties(String[] args, List<String> rArgs) {
        Properties properties = Util.createProperties();
        properties.setProperty("Ice.Override.ConnectTimeout", "5000");
        properties.setProperty("Ice.RetryIntervals", "-1");
        return Util.createProperties(args, properties, rArgs);
    }

    Coordinator(JFrame mainFrame, String[] args, Preferences prefs) {
        this._mainFrame = mainFrame;
        this._prefs = prefs;
        this._initData = new InitializationData();
        this._initData.logger = new Logger(mainFrame);
        ArrayList<String> rArgs = new ArrayList<String>();
        this._initData.properties = Coordinator.createProperties(args, rArgs);
        this._initData.properties.setProperty("Ice.Plugin.IceSSL", "com.zeroc.IceSSL.PluginFactory");
        if (!rArgs.isEmpty()) {
            String msg = "Extra command-line arguments: ";
            for (String arg : rArgs) {
                msg = msg + arg + " ";
            }
            this._initData.logger.warning(msg);
        }
        this._traceObservers = this._initData.properties.getPropertyAsInt("IceGridAdmin.Trace.Observers") > 0;
        this._traceSaveToRegistry = this._initData.properties.getPropertyAsInt("IceGridAdmin.Trace.SaveToRegistry") > 0;
        this._liveDeploymentRoot = new Root(this);
        this._sessionKeeper = new SessionKeeper(this);
        this._shutdownHook = new Thread("Shutdown hook"){

            @Override
            public void run() {
                Coordinator.this.destroyIceGridAdmin();
                Coordinator.this.destroyCommunicator();
            }
        };
        try {
            Runtime.getRuntime().addShutdownHook(this._shutdownHook);
        }
        catch (IllegalStateException msg) {
            // empty catch block
        }
        this._saveXMLChooser = new JFileChooser(this._prefs.get("current directory", null));
        this._saveXMLChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return ".xml files";
            }
        });
        this._openChooser = new JFileChooser(this._saveXMLChooser.getCurrentDirectory());
        this._openChooser.addChoosableFileFilter(this._saveXMLChooser.getChoosableFileFilters()[1]);
        this._saveLogFileChooser = new JFileChooser(this._prefs.get("current directory", null));
        this._saveLogFileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".out") || f.getName().endsWith(".err") || f.getName().endsWith(".log") || f.getName().endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return ".out .err .log .txt files";
            }
        });
        this._saveIceLogChooser = new JFileChooser(this._prefs.get("current directory", null));
        this._saveIceLogChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".csv");
            }

            @Override
            public String getDescription() {
                return ".cvs files";
            }
        });
        UIManager.put("FileChooser.readOnly", Boolean.TRUE);
        int MENU_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this._newApplication = new AbstractAction("Application"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Coordinator.this.newApplication();
            }
        };
        this._newApplicationWithDefaultTemplates = new AbstractAction("Application with Default Templates from Registry"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Coordinator.this.newApplicationWithDefaultTemplates();
            }
        };
        this._newApplicationWithDefaultTemplates.setEnabled(false);
        this._login = new AbstractAction("Login..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                Coordinator.this._sessionKeeper.connectionManager();
            }
        };
        this._login.putValue("ShortDescription", "Log into an IceGrid Registry");
        this._logout = new AbstractAction("Logout"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Coordinator.this._graphViews.size() > 0) {
                    if (0 != JOptionPane.showConfirmDialog(Coordinator.this.getMainFrame(), "Close all open Metrics Graph Views and logout?", "Confirm logout", 0)) {
                        return;
                    }
                    ArrayList views = new ArrayList(Coordinator.this._graphViews);
                    for (IGraphView v : views) {
                        v.close();
                    }
                }
                Coordinator.this._sessionKeeper.logout(true);
                Coordinator.this._statusBar.setText("Logged out");
            }
        };
        this._logout.putValue("ShortDescription", "Logout");
        this._logout.setEnabled(false);
        this._acquireExclusiveWriteAccess = new AbstractAction("Acquire Exclusive Write Access"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Coordinator.this.acquireExclusiveWriteAccess(null);
                    Coordinator.this._releaseExclusiveWriteAccess.setEnabled(true);
                    Coordinator.this._acquireExclusiveWriteAccess.setEnabled(false);
                }
                catch (AccessDeniedException ade) {
                    Coordinator.this.accessDenied(ade);
                }
            }
        };
        this._acquireExclusiveWriteAccess.putValue("ShortDescription", "Acquire exclusive write access on the registry");
        this._acquireExclusiveWriteAccess.setEnabled(false);
        this._releaseExclusiveWriteAccess = new AbstractAction("Release Exclusive Write Access"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Coordinator.this.releaseExclusiveWriteAccess();
                Coordinator.this._acquireExclusiveWriteAccess.setEnabled(true);
                Coordinator.this._releaseExclusiveWriteAccess.setEnabled(false);
            }
        };
        this._releaseExclusiveWriteAccess.putValue("ShortDescription", "Release exclusive write access on the registry");
        this._releaseExclusiveWriteAccess.setEnabled(false);
        this._newGraph = new AbstractAction("Metrics Graph"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Coordinator.this.createGraphView();
            }
        };
        this._newGraph.setEnabled(false);
        this._showLiveDeploymentFilters = new AbstractAction("Filter live deployment"){

            @Override
            public void actionPerformed(ActionEvent e) {
                java.lang.Object[] applicationNames = Coordinator.this._liveDeploymentRoot.getApplicationNames();
                if (applicationNames.length == 0) {
                    JOptionPane.showMessageDialog(Coordinator.this._mainFrame, "The registry does not contain any applications", "Empty registry", 1);
                } else {
                    ArrayList<java.lang.Object> names = new ArrayList<java.lang.Object>();
                    names.add("<All>");
                    names.addAll(Arrays.asList(applicationNames));
                    String appName = (String)JOptionPane.showInputDialog(Coordinator.this._mainFrame, "Which Application do you want to see in the live deployment?", "Filter live deployment", 3, null, names.toArray(), names.get(0));
                    if (appName != null) {
                        if (appName.equals("<All>")) {
                            Coordinator.this._liveDeploymentRoot.setApplicationNameFilter(null);
                        } else {
                            Coordinator.this._liveDeploymentRoot.setApplicationNameFilter(appName);
                        }
                    }
                }
            }
        };
        this._showLiveDeploymentFilters.putValue("ShortDescription", "Filter live deployment");
        this._showLiveDeploymentFilters.setEnabled(false);
        this._openApplicationFromFile = new AbstractAction("Application from File"){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                ApplicationDescriptor desc;
                int result = Coordinator.this._openChooser.showOpenDialog(Coordinator.this._mainFrame);
                if (result == 0 && (desc = Coordinator.this.parseFile(file = Coordinator.this._openChooser.getSelectedFile())) != null) {
                    com.zeroc.IceGridGUI.Application.Root root;
                    try {
                        root = new com.zeroc.IceGridGUI.Application.Root(Coordinator.this, desc, false, file);
                    }
                    catch (UpdateFailedException ex) {
                        JOptionPane.showMessageDialog(Coordinator.this._mainFrame, ex.toString(), "Bad Application Descriptor: Unable to load from file", 0);
                        return;
                    }
                    ApplicationPane app = new ApplicationPane(root);
                    Coordinator.this._mainPane.addApplication(app);
                    Coordinator.this._mainPane.setSelectedComponent(app);
                    root.setSelectedNode(root);
                }
            }
        };
        this._openApplicationFromFile.putValue("ShortDescription", "Open application from file");
        this._openApplicationFromFile.setEnabled(true);
        this._openApplicationFromRegistry = new AbstractAction("Application from Registry"){

            @Override
            public void actionPerformed(ActionEvent e) {
                java.lang.Object[] applicationNames = Coordinator.this._liveDeploymentRoot.getApplicationNames();
                if (applicationNames.length == 0) {
                    JOptionPane.showMessageDialog(Coordinator.this._mainFrame, "The registry does not contain any applications", "Empty registry", 1);
                } else {
                    com.zeroc.IceGridGUI.Application.Root root;
                    ApplicationPane app;
                    String appName = (String)JOptionPane.showInputDialog(Coordinator.this._mainFrame, "Which Application do you want to open?", "Open Application from registry", 3, null, applicationNames, applicationNames[0]);
                    if (appName != null && (app = Coordinator.this.openLiveApplication(appName)) != null && (root = app.getRoot()).getSelectedNode() == null) {
                        root.setSelectedNode(root);
                    }
                }
            }
        };
        this._openApplicationFromRegistry.putValue("ShortDescription", "Open application from registry");
        this._openApplicationFromRegistry.setEnabled(false);
        this._closeApplication = new AbstractAction("Close Application"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Tab tab = Coordinator.this.getCurrentTab();
                if (tab.close()) {
                    String id = ((ApplicationPane)tab).getRoot().getId();
                    Coordinator.this._liveApplications.remove(id);
                }
            }
        };
        this._closeApplication.putValue("ShortDescription", "Close application");
        if (System.getProperty("os.name").startsWith("Mac OS")) {
            this._closeApplication.putValue("AcceleratorKey", KeyStroke.getKeyStroke(87, MENU_MASK));
        } else {
            this._closeApplication.putValue("AcceleratorKey", KeyStroke.getKeyStroke(115, MENU_MASK));
        }
        this._closeApplication.setEnabled(false);
        this._save = new AbstractAction("Save"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Coordinator.this.getCurrentTab().save();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(Coordinator.this._mainFrame, ex.toString(), "Error saving application", 0);
                }
            }
        };
        this._save.setEnabled(false);
        this._save.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, MENU_MASK));
        this._save.putValue("ShortDescription", "Save");
        this._saveToRegistry = new AbstractAction("Save to Registry (Servers may restart)"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Coordinator.this.getCurrentTab().saveToRegistry(true);
            }
        };
        this._saveToRegistry.setEnabled(false);
        this._saveToRegistry.putValue("ShortDescription", "Save to registry (servers may restart)");
        this._saveToRegistryWithoutRestart = new AbstractAction("Save to Registry (No server restart)"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Coordinator.this.getCurrentTab().saveToRegistry(false);
            }
        };
        this._saveToRegistryWithoutRestart.setEnabled(false);
        this._saveToRegistryWithoutRestart.putValue("ShortDescription", "Save to registry (no server restart)");
        this._saveToFile = new AbstractAction("Save to File"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Coordinator.this.getCurrentTab().saveToFile();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(Coordinator.this._mainFrame, ex.toString(), "Error saving application", 0);
                }
            }
        };
        this._saveToFile.setEnabled(false);
        this._saveToFile.putValue("ShortDescription", "Save to file");
        this._discardUpdates = new AbstractAction("Discard Updates"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Coordinator.this.getCurrentTab().discardUpdates();
            }
        };
        this._discardUpdates.setEnabled(false);
        this._discardUpdates.putValue("ShortDescription", "Discard updates and reload application");
        this._certificateManager = new AbstractAction("Certificate Manager..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionKeeper.CertificateManagerDialog d = Coordinator.this._sessionKeeper.certificateManager(Coordinator.this.getMainFrame());
                if (d != null) {
                    d.showDialog();
                }
            }
        };
        this._certificateManager.putValue("ShortDescription", "Manage SSL Certificates");
        this._exit = new AbstractAction("Exit"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Coordinator.this.exit(0);
            }
        };
        this._exit.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt F4"));
        this._back = new AbstractAction("Go Back to the Previous Node"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Coordinator.this.getCurrentTab().back();
            }
        };
        this._back.setEnabled(false);
        this._back.putValue("ShortDescription", "Go back to the previous node");
        this._forward = new AbstractAction("Go to the Next Node"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Coordinator.this.getCurrentTab().forward();
            }
        };
        this._forward.setEnabled(false);
        this._forward.putValue("ShortDescription", "Go to the next node");
        this._helpContents = new AbstractAction("Contents"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Coordinator.this.helpContents();
            }
        };
        this._about = new AbstractAction("About"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Coordinator.this.about();
            }
        };
        this._patchApplication = new AbstractAction("Patch Distribution"){

            @Override
            public void actionPerformed(ActionEvent e) {
                java.lang.Object[] applicationNames = Coordinator.this._liveDeploymentRoot.getPatchableApplicationNames();
                if (applicationNames.length == 0) {
                    JOptionPane.showMessageDialog(Coordinator.this._mainFrame, "No application in this IceGrid registry can be patched", "No application", 1);
                } else {
                    String appName = (String)JOptionPane.showInputDialog(Coordinator.this._mainFrame, "Which application do you want to patch?", "Patch application", 3, null, applicationNames, applicationNames[0]);
                    if (appName != null) {
                        Coordinator.this._liveDeploymentRoot.patch(appName);
                    }
                }
            }
        };
        this._patchApplication.setEnabled(false);
        this._showApplicationDetails = new AbstractAction("Show details"){

            @Override
            public void actionPerformed(ActionEvent e) {
                java.lang.Object[] applicationNames = Coordinator.this._liveDeploymentRoot.getApplicationNames();
                if (applicationNames.length == 0) {
                    JOptionPane.showMessageDialog(Coordinator.this._mainFrame, "There is no application deployed in this IceGrid registry", "No application", 1);
                } else {
                    String appName = Coordinator.this._liveDeploymentRoot.getApplicationNameFilter();
                    if (appName == null) {
                        appName = (String)JOptionPane.showInputDialog(Coordinator.this._mainFrame, "Which application do you to display", "Show details", 3, null, applicationNames, applicationNames[0]);
                    }
                    if (appName != null) {
                        Coordinator.this._liveDeploymentRoot.showApplicationDetails(appName);
                    }
                }
            }
        };
        this._showApplicationDetails.setEnabled(false);
        this._removeApplicationFromRegistry = new AbstractAction("Remove from Registry"){

            @Override
            public void actionPerformed(ActionEvent e) {
                java.lang.Object[] applicationNames = Coordinator.this._liveDeploymentRoot.getApplicationNames();
                if (applicationNames.length == 0) {
                    JOptionPane.showMessageDialog(Coordinator.this._mainFrame, "There is no application deployed in this IceGrid registry", "No application", 1);
                } else {
                    String appName = (String)JOptionPane.showInputDialog(Coordinator.this._mainFrame, "Which application do you want to remove?", "Remove application", 3, null, applicationNames, applicationNames[0]);
                    if (appName != null) {
                        Coordinator.this.removeApplicationFromRegistry(appName);
                    }
                }
            }
        };
        this._removeApplicationFromRegistry.setEnabled(false);
        this._cut = new ActionWrapper("Cut");
        this._cut.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, MENU_MASK));
        this._cut.putValue("ShortDescription", "Cut");
        this._copy = new ActionWrapper("Copy");
        this._copy.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, MENU_MASK));
        this._copy.putValue("ShortDescription", "Copy");
        this._paste = new ActionWrapper("Paste");
        this._paste.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, MENU_MASK));
        this._paste.putValue("ShortDescription", "Paste");
        this._delete = new ActionWrapper("Delete");
        this._delete.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        this._delete.putValue("ShortDescription", "Delete");
        this._moveUp = new ActionWrapper("Move Up");
        this._moveDown = new ActionWrapper("Move Down");
        this._showVarsMenuItem = new JCheckBoxMenuItem(this._appActionsForMenu.get(16));
        this._showVarsTool = new JToggleButton(this._appActionsForMenu.get(16));
        this._showVarsTool.setIcon(Utils.getIcon("/icons/24x24/show_vars.png"));
        this._showVarsTool.setText("");
        this._substituteMenuItem = new JCheckBoxMenuItem(this._appActionsForMenu.get(17));
        this._substituteTool = new JToggleButton(this._appActionsForMenu.get(17));
        this._substituteTool.setIcon(Utils.getIcon("/icons/24x24/substitute.png"));
        this._substituteTool.setText("");
        ButtonGroup group = new ButtonGroup();
        group.add(this._showVarsMenuItem);
        group.add(this._substituteMenuItem);
        group = new ButtonGroup();
        group.add(this._showVarsTool);
        group.add(this._substituteTool);
        this._showVarsMenuItem.setSelected(true);
        this._showVarsTool.setSelected(true);
        this._mainFrame.setJMenuBar(new MenuBar());
        this._mainFrame.getContentPane().add((Component)new ToolBar(), "First");
        this._mainFrame.getContentPane().add((Component)this._statusBar, "Last");
        KeyboardFocusManager kbm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        kbm.addPropertyChangeListener("permanentFocusOwner", new FocusListener());
        this._liveDeploymentPane = new LiveDeploymentPane(this._liveDeploymentRoot);
        this._mainPane = new MainPane(this);
        this._mainFrame.getContentPane().add((Component)this._mainPane, "Center");
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("Pinger");
                return t;
            }
        });
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this._executor = executor;
    }

    public IGraphView createGraphView() {
        IGraphView view = null;
        Class<?> c1 = com.zeroc.IceInternal.Util.findClass("com.zeroc.IceGridGUI.LiveDeployment.GraphView", null);
        if (c1 == null) {
            JOptionPane.showMessageDialog(this._mainFrame, "IceGrid GUI was built without Metrics Graph Support", "IceGrid GUI Info", 1);
        } else if (com.zeroc.IceInternal.Util.findClass("javafx.embed.swing.JFXPanel", null) == null) {
            JOptionPane.showMessageDialog(this._mainFrame, "The Metrics Graph view requires JavaFX 2", "IceGrid GUI Info", 1);
        } else {
            StringBuilder title = new StringBuilder();
            title.append("Metrics Graph");
            if (this._graphViews.size() > 0) {
                title.append(" - ");
                title.append(Integer.toString(this._graphViews.size()));
            }
            try {
                Constructor<?> ctor = c1.getConstructor(Coordinator.class, String.class);
                view = (IGraphView)ctor.newInstance(this, title.toString());
                this._graphViews.add(view);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return view;
    }

    public LiveDeploymentPane getLiveDeploymentPane() {
        return this._liveDeploymentPane;
    }

    public Root getLiveDeploymentRoot() {
        return this._liveDeploymentRoot;
    }

    private void newApplication() {
        ApplicationDescriptor desc = new ApplicationDescriptor("NewApplication", new TreeMap<String, String>(), new LinkedList<ReplicaGroupDescriptor>(), new HashMap<String, TemplateDescriptor>(), new HashMap<String, TemplateDescriptor>(), new HashMap<String, NodeDescriptor>(), new DistributionDescriptor("", new LinkedList<String>()), "", new HashMap<String, PropertySetDescriptor>());
        com.zeroc.IceGridGUI.Application.Root root = new com.zeroc.IceGridGUI.Application.Root(this, desc);
        ApplicationPane app = new ApplicationPane(root);
        this._mainPane.addApplication(app);
        this._mainPane.setSelectedComponent(app);
        root.setSelectedNode(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newApplicationWithDefaultTemplates() {
        this._mainFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            ApplicationDescriptor descriptor = this.getAdmin().getDefaultApplicationDescriptor();
            descriptor.name = "NewApplication";
            com.zeroc.IceGridGUI.Application.Root root = new com.zeroc.IceGridGUI.Application.Root(this, descriptor);
            ApplicationPane app = new ApplicationPane(root);
            this._mainPane.addApplication(app);
            this._mainPane.setSelectedComponent(app);
            root.setSelectedNode(root);
        }
        catch (DeploymentException e) {
            JOptionPane.showMessageDialog(this._mainFrame, "The default application descriptor from the IceGrid registry is invalid:\n" + e.reason, "Deployment Exception", 0);
        }
        catch (LocalException e) {
            JOptionPane.showMessageDialog(this._mainFrame, "Could not retrieve the default application descriptor from the IceGrid registry: \n" + e.toString(), "Trouble with IceGrid registry", 0);
        }
        finally {
            this._mainFrame.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void helpContents() {
        Desktop desktop;
        String version = Util.stringVersion();
        int pos = version.indexOf(97);
        if (pos == -1) {
            pos = version.indexOf(98);
        }
        if (pos != -1) {
            version = version.substring(0, pos);
        }
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(new URI("https://doc.zeroc.com/display/Rel/Ice+" + version + "+IceGrid+Admin"));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Error attempting to launch web browser:\n" + e.getLocalizedMessage());
            }
        } else {
            JOptionPane.showMessageDialog(null, "Launching a browser is not supported on your platform.");
        }
    }

    private void about() {
        String text = "IceGrid GUI version " + Util.stringVersion() + "\nCopyright \u00a9 2005-2017 ZeroC, Inc. All rights reserved.\n";
        JOptionPane.showMessageDialog(this._mainFrame, text, "About - IceGrid GUI", 1);
    }

    public void setClipboard(java.lang.Object copy) {
        this._clipboard = copy;
    }

    public java.lang.Object getClipboard() {
        return this._clipboard;
    }

    void showMainFrame() {
        this._mainFrame.pack();
        Utils.restoreWindowBounds(this._mainFrame, this._prefs, "Window", null);
        this._mainFrame.setVisible(true);
    }

    void exit(int status) {
        File dir;
        if (this._graphViews.size() > 0) {
            if (0 != JOptionPane.showConfirmDialog(this.getMainFrame(), "Close all open windows and exit?", "Confirm exit", 0)) {
                return;
            }
            ArrayList<IGraphView> views = new ArrayList<IGraphView>(this._graphViews);
            for (IGraphView v : views) {
                v.close();
            }
        }
        if (this._openChooser != null && (dir = this._openChooser.getCurrentDirectory()) != null) {
            this._prefs.put("current directory", dir.getAbsolutePath());
        }
        Utils.storeWindowBounds(this._mainFrame, this._prefs.node("Window"));
        this._sessionKeeper.logout(true);
        this.destroyIceGridAdmin();
        this.destroyCommunicator();
        this._executor.shutdown();
        this._executor = null;
        Runtime.getRuntime().removeShutdownHook(this._shutdownHook);
        this._mainFrame.dispose();
        Runtime.getRuntime().exit(status);
    }

    private void destroyCommunicator() {
        if (this._communicator != null) {
            this._communicator.destroy();
            this._communicator = null;
        }
    }

    public AdminSessionPrx getSession() {
        return this._sessionKeeper.getSession();
    }

    public boolean connectedToMaster() {
        return this._sessionKeeper.connectedToMaster();
    }

    public static Preferences getPreferences() {
        return Preferences.userRoot().node("IceGridGUI");
    }

    public LiveActions getLiveActionsForPopup() {
        return this._liveActionsForPopup;
    }

    public LiveActions getLiveActionsForMenu() {
        return this._liveActionsForMenu;
    }

    public ApplicationActions getActionsForMenu() {
        return this._appActionsForMenu;
    }

    public ApplicationActions getActionsForPopup() {
        return this._appActionsForPopup;
    }

    public void showActions(com.zeroc.IceGridGUI.LiveDeployment.TreeNode node) {
        boolean[] availableActions = this._liveActionsForMenu.setTarget(node);
        this._appActionsForMenu.setTarget(null);
        this._newServerMenu.setEnabled(false);
        this._newServiceMenu.setEnabled(false);
        this._newTemplateMenu.setEnabled(false);
        this._appMenu.setEnabled(true);
        this._metricsViewMenu.setEnabled(availableActions[21] || availableActions[22]);
        this._nodeMenu.setEnabled(availableActions[16]);
        this._registryMenu.setEnabled(availableActions[17]);
        this._signalMenu.setEnabled(availableActions[4]);
        this._serverMenu.setEnabled(availableActions[20]);
        this._serviceMenu.setEnabled(node instanceof Service && (availableActions[12] || availableActions[15] || availableActions[0] || availableActions[1]));
    }

    public void showActions(TreeNode node) {
        boolean[] availableActions = this._appActionsForMenu.setTarget(node);
        this._liveActionsForMenu.setTarget(null);
        this._newServerMenu.setEnabled(availableActions[5] || availableActions[6] || availableActions[7]);
        this._newServiceMenu.setEnabled(availableActions[8] || availableActions[9]);
        this._newTemplateMenu.setEnabled(availableActions[10] || availableActions[11] || availableActions[12]);
        this._appMenu.setEnabled(false);
        this._metricsViewMenu.setEnabled(false);
        this._nodeMenu.setEnabled(false);
        this._registryMenu.setEnabled(false);
        this._signalMenu.setEnabled(false);
        this._serverMenu.setEnabled(false);
        this._serviceMenu.setEnabled(false);
        this.enableTreeEditActions();
    }

    public void removeGraphView(IGraphView view) {
        this._graphViews.remove(view);
    }

    public boolean traceObservers() {
        return this._traceObservers;
    }

    public void traceObserver(String message) {
        this.trace("Observers", message);
    }

    public boolean traceSaveToRegistry() {
        return this._traceSaveToRegistry;
    }

    public void traceSaveToRegistry(String message) {
        this.trace("SaveToRegistry", message);
    }

    public void setConnected(boolean connected) {
        this._connected = connected;
        this._statusBar.setConnected(connected);
        this._newGraph.setEnabled(connected);
        if (!connected) {
            this.destroyCommunicator();
        }
    }

    public boolean connected() {
        return this._connected;
    }

    public String getDataDirectory() throws Exception {
        if (this._dataDir == null) {
            if (System.getProperty("os.name").startsWith("Windows")) {
                String regKey = "\"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\"";
                String regQuery = "reg query " + regKey + " /v Personal";
                try {
                    String[] result;
                    int c;
                    Process process = Runtime.getRuntime().exec(regQuery);
                    process.waitFor();
                    if (process.exitValue() != 0) {
                        throw new Exception("Could not read Windows registry key `" + regKey + "'");
                    }
                    InputStream is = process.getInputStream();
                    StringWriter sw = new StringWriter();
                    while ((c = is.read()) != -1) {
                        sw.write(c);
                    }
                    for (String line : result = sw.toString().split("\n")) {
                        int i = line.indexOf("REG_SZ");
                        if (i == -1) continue;
                        this._dataDir = line.substring(i + "REG_SZ".length(), line.length()).trim();
                        break;
                    }
                    if (this._dataDir == null) {
                        throw new Exception("Could not get Documents dir from Windows registry key `" + regKey + "'");
                    }
                    this._dataDir = this._dataDir + File.separator + "ZeroC" + File.separator + "IceGrid Admin" + File.separator + "KeyStore";
                }
                catch (IOException ex) {
                    throw new Exception("Could not read Windows registry key `" + regKey + "'\n" + ex.toString());
                }
                catch (InterruptedException ex) {
                    throw new Exception("Could not read Windows registry key `" + regKey + "'\n" + ex.toString());
                }
            } else {
                this._dataDir = System.getProperty("user.home") + File.separator + ".ZeroC" + File.separator + "IceGrid Admin" + File.separator + "KeyStore";
            }
        }
        if (!new File(this._dataDir).isDirectory()) {
            new File(this._dataDir).mkdirs();
        }
        return this._dataDir;
    }

    public IGraphView[] getGraphViews() {
        return this._graphViews.toArray(new IGraphView[this._graphViews.size()]);
    }

    public ScheduledExecutorService getExecutor() {
        return this._executor;
    }

    public boolean needsSaving() {
        boolean v = false;
        int length = this._mainPane.getTabCount();
        for (int i = 0; i < length; ++i) {
            Component component = this._mainPane.getComponentAt(i);
            if (!(component instanceof ApplicationPane) || !((ApplicationPane)component).getRoot().needsSaving()) continue;
            v = true;
            break;
        }
        return v;
    }

    private void trace(String category, String message) {
        this._initData.logger.trace(category, message);
    }

    static class UntrustedCertificateDialog
    extends JDialog {
        private TrustDecision _decision = TrustDecision.No;
        private static Icon _infoIcon = new ImageIcon(Utils.iconToImage(UIManager.getIcon("OptionPane.informationIcon")).getScaledInstance(16, 16, 4));
        private static Icon _warnIcon = new ImageIcon(Utils.iconToImage(UIManager.getIcon("OptionPane.warningIcon")).getScaledInstance(16, 16, 4));

        public UntrustedCertificateDialog(Window owner, com.zeroc.IceSSL.ConnectionInfo info, boolean validDate, boolean validAlternateName, boolean trustedCA) throws GeneralSecurityException, IOException, InvalidNameException {
            super(owner, "Connection Security Warning - IceGrid GUI");
            this.setDefaultCloseOperation(2);
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            X509Certificate cert = (X509Certificate)info.certs[0];
            DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref", "pref"));
            builder.border(Borders.DIALOG);
            builder.rowGroupingEnabled(true);
            builder.lineGapSize(LayoutStyle.getCurrent().getLinePad());
            builder.append(new JLabel("The validation of the SSL Certificate provided by the server has failed"));
            if (validDate) {
                builder.append(new JLabel("The certificate date is valid.", _infoIcon, 10));
            } else {
                builder.append(new JLabel("The certificate date is invalid.", _warnIcon, 10));
            }
            if (validAlternateName) {
                builder.append(new JLabel("The subject alternate name matches the connection remote address.", _infoIcon, 10));
            } else {
                builder.append(new JLabel("The subject alternate name doesn't match the connection remote address.", _warnIcon, 10));
            }
            if (trustedCA) {
                builder.append(new JLabel("The server certificate is signed by a trusted CA.", _infoIcon, 10));
            } else {
                builder.append(new JLabel("The server certificate is not signed by a trusted CA.", _warnIcon, 10));
            }
            contentPane.add(builder.getPanel());
            contentPane.add(SessionKeeper.getSubjectPanel(cert));
            contentPane.add(SessionKeeper.getSubjectAlternativeNamesPanel(cert));
            contentPane.add(SessionKeeper.getIssuerPanel(cert));
            contentPane.add(SessionKeeper.getValidityPanel(cert));
            contentPane.add(SessionKeeper.getFingerprintPanel(cert));
            JButton yesAlwaysButton = new JButton(new AbstractAction("Yes, Always Trust"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    _decision = TrustDecision.YesAlways;
                    this.dispose();
                }
            });
            JButton yesButton = new JButton(new AbstractAction("Yes, Just This Time"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    _decision = TrustDecision.YesThisTime;
                    this.dispose();
                }
            });
            JButton noButton = new JButton(new AbstractAction("No"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    _decision = TrustDecision.No;
                    this.dispose();
                }
            });
            this.getRootPane().setDefaultButton(noButton);
            JPanel buttonBar = new ButtonBarBuilder().addGlue().addButton(yesAlwaysButton, yesButton, noButton).build();
            buttonBar.setBorder(Borders.DIALOG);
            contentPane.add(buttonBar);
            this.pack();
            this.setResizable(false);
        }

        TrustDecision showDialog() {
            this.setLocationRelativeTo(this.getOwner());
            this.setModal(true);
            this.setVisible(true);
            return this._decision;
        }
    }

    static final class TrustDecision
    extends Enum<TrustDecision> {
        public static final /* enum */ TrustDecision YesAlways = new TrustDecision();
        public static final /* enum */ TrustDecision YesThisTime = new TrustDecision();
        public static final /* enum */ TrustDecision No = new TrustDecision();
        private static final /* synthetic */ TrustDecision[] $VALUES;

        public static TrustDecision[] values() {
            return (TrustDecision[])$VALUES.clone();
        }

        static {
            $VALUES = new TrustDecision[]{YesAlways, YesThisTime, No};
        }
    }

    private static class ReuseConnectionRouter
    implements Router {
        private final ObjectPrx _clientProxy;

        public ReuseConnectionRouter(ObjectPrx proxy) {
            this._clientProxy = proxy;
        }

        @Override
        public Router.GetClientProxyResult getClientProxy(Current current) {
            return new Router.GetClientProxyResult(this._clientProxy, Optional.of(false));
        }

        @Override
        public ObjectPrx getServerProxy(Current current) {
            return null;
        }

        @Override
        public ObjectPrx[] addProxies(ObjectPrx[] proxies, Current current) {
            return new ObjectPrx[0];
        }
    }

    private class ToolBar
    extends JToolBar {
        private ToolBar() {
            this.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
            this.putClientProperty("Plastic.borderStyle", BorderStyle.SEPARATOR);
            this.setFloatable(false);
            this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            JButton button = new JButton(Coordinator.this._login);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/login.png"));
            this.add(button);
            button = new JButton(Coordinator.this._logout);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/logout.png"));
            this.add(button);
            this.addSeparator();
            button = new JButton(Coordinator.this._back);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/back.png"));
            this.add(button);
            button = new JButton(Coordinator.this._forward);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/forward.png"));
            this.add(button);
            this.addSeparator();
            button = new JButton(Coordinator.this._showLiveDeploymentFilters);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/view_filter.png"));
            this.add(button);
            this.addSeparator();
            button = new JButton(Coordinator.this._openApplicationFromRegistry);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/open_from_registry.png"));
            this.add(button);
            button = new JButton(Coordinator.this._openApplicationFromFile);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/open_from_file.png"));
            this.add(button);
            this.addSeparator();
            button = new JButton(Coordinator.this._save);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/save.png"));
            this.add(button);
            button = new JButton(Coordinator.this._saveToRegistry);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/save_to_registry.png"));
            this.add(button);
            button = new JButton(Coordinator.this._saveToRegistryWithoutRestart);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/save_without_restart.png"));
            this.add(button);
            button = new JButton(Coordinator.this._saveToFile);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/save_to_file.png"));
            this.add(button);
            button = new JButton(Coordinator.this._discardUpdates);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/discard.png"));
            this.add(button);
            this.addSeparator();
            button = new JButton(Coordinator.this._copy);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/copy.png"));
            this.add(button);
            button = new JButton(Coordinator.this._paste);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/paste.png"));
            this.add(button);
            button = new JButton(Coordinator.this._delete);
            button.setText(null);
            button.setIcon(Utils.getIcon("/icons/24x24/delete.png"));
            this.add(button);
            this.addSeparator();
            this.add(Coordinator.this._showVarsTool);
            this.add(Coordinator.this._substituteTool);
        }
    }

    private class MenuBar
    extends JMenuBar {
        private MenuBar() {
            this.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
            this.putClientProperty("Plastic.borderStyle", BorderStyle.SEPARATOR);
            JMenu fileMenu = new JMenu("File");
            fileMenu.setMnemonic(70);
            this.add(fileMenu);
            Coordinator.this._newMenu = new JMenu("New");
            fileMenu.add(Coordinator.this._newMenu);
            Coordinator.this._newMenu.add(Coordinator.this._newApplication);
            Coordinator.this._newMenu.add(Coordinator.this._newApplicationWithDefaultTemplates);
            Coordinator.this._newMenu.addSeparator();
            Coordinator.this._newMenu.add(Coordinator.this._appActionsForMenu.get(0));
            Coordinator.this._newMenu.add(Coordinator.this._appActionsForMenu.get(1));
            Coordinator.this._newMenu.add(Coordinator.this._appActionsForMenu.get(2));
            Coordinator.this._newMenu.add(Coordinator.this._appActionsForMenu.get(3));
            Coordinator.this._newMenu.add(Coordinator.this._appActionsForMenu.get(4));
            JMenu openMenu = new JMenu("Open");
            openMenu.add(Coordinator.this._openApplicationFromFile);
            openMenu.add(Coordinator.this._openApplicationFromRegistry);
            Coordinator.this._newServerMenu = new JMenu("Server");
            Coordinator.this._newServerMenu.setEnabled(false);
            Coordinator.this._newMenu.add(Coordinator.this._newServerMenu);
            Coordinator.this._newServerMenu.add(Coordinator.this._appActionsForMenu.get(5));
            Coordinator.this._newServerMenu.add(Coordinator.this._appActionsForMenu.get(6));
            Coordinator.this._newServerMenu.add(Coordinator.this._appActionsForMenu.get(7));
            Coordinator.this._newServiceMenu = new JMenu("Service");
            Coordinator.this._newServiceMenu.setEnabled(false);
            Coordinator.this._newMenu.add(Coordinator.this._newServiceMenu);
            Coordinator.this._newServiceMenu.add(Coordinator.this._appActionsForMenu.get(8));
            Coordinator.this._newServiceMenu.add(Coordinator.this._appActionsForMenu.get(9));
            Coordinator.this._newTemplateMenu = new JMenu("Template");
            Coordinator.this._newTemplateMenu.setEnabled(false);
            Coordinator.this._newMenu.add(Coordinator.this._newTemplateMenu);
            Coordinator.this._newTemplateMenu.add(Coordinator.this._appActionsForMenu.get(10));
            Coordinator.this._newTemplateMenu.add(Coordinator.this._appActionsForMenu.get(11));
            Coordinator.this._newTemplateMenu.add(Coordinator.this._appActionsForMenu.get(12));
            Coordinator.this._newMenu.addSeparator();
            Coordinator.this._newMenu.add(Coordinator.this._newGraph);
            fileMenu.addSeparator();
            fileMenu.add(Coordinator.this._login);
            fileMenu.add(Coordinator.this._logout);
            fileMenu.addSeparator();
            fileMenu.add(Coordinator.this._acquireExclusiveWriteAccess);
            fileMenu.add(Coordinator.this._releaseExclusiveWriteAccess);
            fileMenu.addSeparator();
            fileMenu.add(openMenu);
            fileMenu.add(Coordinator.this._closeApplication);
            fileMenu.add(Coordinator.this._save);
            fileMenu.add(Coordinator.this._saveToFile);
            fileMenu.add(Coordinator.this._saveToRegistry);
            fileMenu.add(Coordinator.this._saveToRegistryWithoutRestart);
            fileMenu.addSeparator();
            fileMenu.add(Coordinator.this._discardUpdates);
            fileMenu.addSeparator();
            fileMenu.add(Coordinator.this._certificateManager);
            if (!System.getProperty("os.name").startsWith("Mac OS")) {
                fileMenu.addSeparator();
                fileMenu.add(Coordinator.this._exit);
            }
            JMenu editMenu = new JMenu("Edit");
            editMenu.setMnemonic(69);
            this.add(editMenu);
            editMenu.add(Coordinator.this._cut);
            editMenu.add(Coordinator.this._copy);
            editMenu.add(Coordinator.this._paste);
            editMenu.add(Coordinator.this._delete);
            editMenu.addSeparator();
            editMenu.add(Coordinator.this._moveUp);
            editMenu.add(Coordinator.this._moveDown);
            JMenu viewMenu = new JMenu("View");
            viewMenu.setMnemonic(86);
            this.add(viewMenu);
            viewMenu.add(Coordinator.this._showVarsMenuItem);
            viewMenu.add(Coordinator.this._substituteMenuItem);
            viewMenu.addSeparator();
            viewMenu.add(Coordinator.this._back);
            viewMenu.add(Coordinator.this._forward);
            JMenu toolsMenu = new JMenu("Tools");
            toolsMenu.setMnemonic(84);
            this.add(toolsMenu);
            Coordinator.this._appMenu = new JMenu("Application");
            Coordinator.this._appMenu.setEnabled(false);
            toolsMenu.add(Coordinator.this._appMenu);
            Coordinator.this._appMenu.add(Coordinator.this._patchApplication);
            Coordinator.this._appMenu.add(Coordinator.this._showApplicationDetails);
            Coordinator.this._appMenu.add(Coordinator.this._showLiveDeploymentFilters);
            Coordinator.this._appMenu.addSeparator();
            Coordinator.this._appMenu.add(Coordinator.this._removeApplicationFromRegistry);
            Coordinator.this._appMenu.setEnabled(false);
            Coordinator.this._metricsViewMenu = new JMenu("Metrics View");
            Coordinator.this._metricsViewMenu.setEnabled(false);
            toolsMenu.add(Coordinator.this._metricsViewMenu);
            Coordinator.this._metricsViewMenu.add(Coordinator.this._liveActionsForMenu.get(21));
            Coordinator.this._metricsViewMenu.add(Coordinator.this._liveActionsForMenu.get(22));
            Coordinator.this._nodeMenu = new JMenu("Node");
            Coordinator.this._nodeMenu.setEnabled(false);
            toolsMenu.add(Coordinator.this._nodeMenu);
            Coordinator.this._nodeMenu.add(Coordinator.this._liveActionsForMenu.get(12));
            Coordinator.this._nodeMenu.add(Coordinator.this._liveActionsForMenu.get(13));
            Coordinator.this._nodeMenu.add(Coordinator.this._liveActionsForMenu.get(14));
            Coordinator.this._nodeMenu.addSeparator();
            Coordinator.this._nodeMenu.add(Coordinator.this._liveActionsForMenu.get(23));
            Coordinator.this._nodeMenu.add(Coordinator.this._liveActionsForMenu.get(24));
            Coordinator.this._nodeMenu.addSeparator();
            Coordinator.this._nodeMenu.add(Coordinator.this._liveActionsForMenu.get(16));
            Coordinator.this._registryMenu = new JMenu("Registry");
            Coordinator.this._registryMenu.setEnabled(false);
            toolsMenu.add(Coordinator.this._registryMenu);
            Coordinator.this._registryMenu.add(Coordinator.this._liveActionsForMenu.get(19));
            Coordinator.this._registryMenu.addSeparator();
            Coordinator.this._registryMenu.add(Coordinator.this._liveActionsForMenu.get(12));
            Coordinator.this._registryMenu.add(Coordinator.this._liveActionsForMenu.get(13));
            Coordinator.this._registryMenu.add(Coordinator.this._liveActionsForMenu.get(14));
            Coordinator.this._registryMenu.addSeparator();
            Coordinator.this._registryMenu.add(Coordinator.this._liveActionsForMenu.get(17));
            Coordinator.this._serverMenu = new JMenu("Server");
            Coordinator.this._serverMenu.setEnabled(false);
            toolsMenu.add(Coordinator.this._serverMenu);
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(0));
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(1));
            Coordinator.this._serverMenu.addSeparator();
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(2));
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(3));
            Coordinator.this._serverMenu.addSeparator();
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(18));
            Coordinator.this._serverMenu.addSeparator();
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(11));
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(12));
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(13));
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(14));
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(15));
            Coordinator.this._serverMenu.addSeparator();
            Coordinator.this._signalMenu = new JMenu("Send Signal");
            Coordinator.this._serverMenu.add(Coordinator.this._signalMenu);
            Coordinator.this._signalMenu.add(Coordinator.this._liveActionsForMenu.get(4));
            Coordinator.this._signalMenu.add(Coordinator.this._liveActionsForMenu.get(5));
            Coordinator.this._signalMenu.add(Coordinator.this._liveActionsForMenu.get(6));
            Coordinator.this._signalMenu.add(Coordinator.this._liveActionsForMenu.get(7));
            Coordinator.this._signalMenu.add(Coordinator.this._liveActionsForMenu.get(8));
            Coordinator.this._signalMenu.add(Coordinator.this._liveActionsForMenu.get(9));
            Coordinator.this._signalMenu.add(Coordinator.this._liveActionsForMenu.get(10));
            Coordinator.this._serverMenu.addSeparator();
            Coordinator.this._serverMenu.add(Coordinator.this._liveActionsForMenu.get(20));
            Coordinator.this._serviceMenu = new JMenu("Service");
            Coordinator.this._serviceMenu.setEnabled(false);
            toolsMenu.add(Coordinator.this._serviceMenu);
            Coordinator.this._serviceMenu.add(Coordinator.this._liveActionsForMenu.get(0));
            Coordinator.this._serviceMenu.add(Coordinator.this._liveActionsForMenu.get(1));
            Coordinator.this._serviceMenu.addSeparator();
            Coordinator.this._serviceMenu.add(Coordinator.this._liveActionsForMenu.get(12));
            Coordinator.this._serviceMenu.add(Coordinator.this._liveActionsForMenu.get(15));
            JMenu helpMenu = new JMenu("Help");
            helpMenu.setMnemonic(72);
            this.add(helpMenu);
            helpMenu.add(Coordinator.this._helpContents);
            if (!System.getProperty("os.name").startsWith("Mac OS")) {
                helpMenu.addSeparator();
                helpMenu.add(Coordinator.this._about);
            }
        }
    }

    private class FocusListener
    implements PropertyChangeListener {
        private FocusListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            java.lang.Object o = e.getNewValue();
            if (o == null) {
                this.unknownTarget();
            } else if (o instanceof JTextComponent) {
                this.enableTextEditActions((JTextComponent)o);
            } else if (o instanceof JTree) {
                JTree tree = (JTree)o;
                if (tree.getModel().getRoot() instanceof com.zeroc.IceGridGUI.Application.Root) {
                    Coordinator.this.enableTreeEditActions();
                } else {
                    this.disableAllEditMenusAndButtons();
                }
            } else {
                this.unknownTarget();
            }
        }

        private void unknownTarget() {
            if (Coordinator.this._copy.getTarget() == Coordinator.this._copyText) {
                this.disableAllEditMenusAndButtons();
            }
        }

        private void disableAllEditMenusAndButtons() {
            Coordinator.this._cut.setTarget(null);
            Coordinator.this._copy.setTarget(null);
            Coordinator.this._paste.setTarget(null);
            Coordinator.this._delete.setTarget(null);
            Coordinator.this._moveUp.setTarget(null);
            Coordinator.this._moveDown.setTarget(null);
        }

        private void enableTextEditActions(JTextComponent target) {
            boolean editable = target.isEditable() && target.isEnabled();
            Coordinator.this._cutText.setEnabled(editable);
            Coordinator.this._copyText.setEnabled(true);
            Coordinator.this._pasteText.setEnabled(editable);
            Coordinator.this._deleteText.setEnabled(editable);
            Coordinator.this._deleteText.setTarget(target);
            if (Coordinator.this._copy.getTarget() != Coordinator.this._copyText) {
                Coordinator.this._cut.setTarget(Coordinator.this._cutText);
                Coordinator.this._copy.setTarget(Coordinator.this._copyText);
                Coordinator.this._paste.setTarget(Coordinator.this._pasteText);
                Coordinator.this._delete.setTarget(Coordinator.this._deleteText);
                Coordinator.this._moveUp.setTarget(null);
                Coordinator.this._moveDown.setTarget(null);
            }
        }
    }

    private class DeleteTextAction
    extends AbstractAction {
        private JTextComponent _target;

        public DeleteTextAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Action a;
            if (this._target != null && (a = this._target.getActionMap().get("delete-next")) != null) {
                a.actionPerformed(new ActionEvent(this._target, 1001, null));
            }
        }

        void setTarget(JTextComponent t) {
            this._target = t;
        }
    }

    private class ActionWrapper
    extends AbstractAction
    implements PropertyChangeListener {
        private Action _target;

        public ActionWrapper(String name) {
            super(name);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this._target != null) {
                this._target.actionPerformed(e);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            for (PropertyChangeListener l : this.getPropertyChangeListeners()) {
                l.propertyChange(e);
            }
        }

        void setTarget(Action t) {
            if (this._target != null) {
                this._target.removePropertyChangeListener(this);
            }
            this._target = t;
            if (this._target != null) {
                this._target.addPropertyChangeListener(this);
                this.setEnabled(this._target.isEnabled());
            } else {
                this.setEnabled(false);
            }
        }

        Action getTarget() {
            return this._target;
        }
    }

    private class StatusBarI
    extends JPanel
    implements StatusBar {
        JLabel _connectedLabel;
        JLabel _text;

        StatusBarI() {
            super(new BorderLayout());
            this.setBorder(new EmptyBorder(0, 13, 10, 13));
            this._text = new JLabel();
            this._text.setHorizontalAlignment(2);
            this.add((Component)this._text, "Before");
            this._connectedLabel = new JLabel("Working Offline");
            this._connectedLabel.setHorizontalAlignment(4);
            this.add((Component)this._connectedLabel, "After");
        }

        @Override
        public void setText(String text) {
            this._text.setText(text);
        }

        @Override
        public void setConnected(boolean connected) {
            if (connected) {
                this._connectedLabel.setText("Working Online");
            } else {
                this._connectedLabel.setText("Working Offline");
            }
        }
    }

    public static interface IGraphView {
        public void close();

        public void addSeries(MetricsViewEditor.MetricsViewTransferableData var1);

        public String getTitle();
    }
}

