/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Languages;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.RuleMatchesAsJsonSerializer;

public class RuleMatchesAsJsonSerializerTest {
    private final RuleMatchesAsJsonSerializer serializer = new RuleMatchesAsJsonSerializer();
    private final List<RuleMatch> matches = Arrays.asList(new RuleMatch((Rule)new FakeRule(), 1, 3, "My Message, use <suggestion>foo</suggestion> instead", "short message"));

    @Test
    public void testJson() {
        String json = this.serializer.ruleMatchesToJson(this.matches, "This is an text.", 5, Languages.getLanguageForShortCode((String)"xx-XX"));
        Assert.assertTrue((boolean)json.contains("\"LanguageTool\""));
        Assert.assertTrue((boolean)json.contains("3.8"));
        Assert.assertTrue((boolean)json.contains("\"Testlanguage\""));
        Assert.assertTrue((boolean)json.contains("\"xx-XX\""));
        Assert.assertTrue((boolean)json.contains("\"My Message, use \\\"foo\\\" instead\""));
        Assert.assertTrue((boolean)json.contains("\"My rule description\""));
        Assert.assertTrue((boolean)json.contains("\"FAKE_ID\""));
        Assert.assertTrue((boolean)json.contains("\"This is ...\""));
        Assert.assertTrue((boolean)json.contains("\"http://foobar.org/blah\""));
        Assert.assertTrue((boolean)json.contains("\"addition\""));
        Assert.assertTrue((boolean)json.contains("\"short message\""));
    }

    @Test
    public void testJsonWithUnixLinebreak() {
        String json = this.serializer.ruleMatchesToJson(this.matches, "This\nis an text.", 5, Languages.getLanguageForShortCode((String)"xx-XX"));
        Assert.assertTrue((boolean)json.contains("This is ..."));
    }

    @Test
    public void testJsonWithWindowsLinebreak() {
        String json = this.serializer.ruleMatchesToJson(this.matches, "This\ris an text.", 5, Languages.getLanguageForShortCode((String)"xx-XX"));
        Assert.assertTrue((boolean)json.contains("This\\ris ..."));
    }

    static class FakeRule
    extends Rule {
        FakeRule() {
            this.setLocQualityIssueType(ITSIssueType.Addition);
            try {
                this.setUrl(new URL("http://foobar.org/blah"));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        public String getId() {
            return "FAKE_ID";
        }

        public String getDescription() {
            return "My rule description";
        }

        public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
            throw new RuntimeException("not implemented");
        }
    }
}

