#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tls
version: 1.4.0
id: tls-1.4.0-3vJa0ZMui2cIeZpfzEU1mu
key: tls-1.4.0-3vJa0ZMui2cIeZpfzEU1mu
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability: experimental
homepage: http://github.com/vincenthz/hs-tls
synopsis: TLS/SSL protocol native implementation (Server and Client)
description:
    Native Haskell TLS and SSL protocol implementation for server and client.
    .
    This provides a high-level implementation of a sensitive security protocol,
    eliminating a common set of security issues through the use of the advanced
    type system, high level constructions and common Haskell features.
    .
    Currently implement the SSL3.0, TLS1.0, TLS1.1 and TLS1.2 protocol,
    and support RSA and Ephemeral (Elliptic curve and regular) Diffie Hellman key exchanges,
    and many extensions.
    .
    Some debug tools linked with tls, are available through the
    <http://hackage.haskell.org/package/tls-debug/>.
category: Network
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
indefinite: False
exposed-modules:
    Network.TLS Network.TLS.Cipher Network.TLS.Compression
    Network.TLS.Extra Network.TLS.Extra.Cipher Network.TLS.Extra.FFDHE
    Network.TLS.Internal
hidden-modules: Network.TLS.Cap Network.TLS.Struct Network.TLS.Core
                Network.TLS.Context Network.TLS.Context.Internal
                Network.TLS.Credentials Network.TLS.Backend Network.TLS.Crypto
                Network.TLS.Crypto.DH Network.TLS.Crypto.IES
                Network.TLS.Crypto.Types Network.TLS.ErrT Network.TLS.Extension
                Network.TLS.Handshake Network.TLS.Handshake.Common
                Network.TLS.Handshake.Certificate Network.TLS.Handshake.Key
                Network.TLS.Handshake.Client Network.TLS.Handshake.Server
                Network.TLS.Handshake.Process Network.TLS.Handshake.Signature
                Network.TLS.Handshake.State Network.TLS.Hooks Network.TLS.IO
                Network.TLS.Imports Network.TLS.MAC Network.TLS.Measurement
                Network.TLS.Packet Network.TLS.Parameters Network.TLS.Record
                Network.TLS.Record.Types Network.TLS.Record.Engage
                Network.TLS.Record.Disengage Network.TLS.Record.State
                Network.TLS.RNG Network.TLS.State Network.TLS.Session
                Network.TLS.Sending Network.TLS.Receiving Network.TLS.Util
                Network.TLS.Util.ASN1 Network.TLS.Util.Serialization
                Network.TLS.Types Network.TLS.Wire Network.TLS.X509
abi: d7f534a4eb670857ea5e7a8bd1f65063
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/tls-1.4.0
library-dirs: /usr/lib/ghc-8.2.1/site-local/tls-1.4.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/tls-1.4.0
hs-libraries: HStls-1.4.0-3vJa0ZMui2cIeZpfzEU1mu
depends:
    base-4.10.0.0 mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3 transformers-0.5.2.0
    cereal-0.5.4.0-AV9aAoAC3OtC6kJvAolohE bytestring-0.10.8.2
    data-default-class-0.1.2.0-K0O6u0ifzTuLE4f7kBhgzp
    memory-0.14.8-KR3LQmPtL0V2hu8SCUEPxQ
    cryptonite-0.24-BP2rZy1LSzS3gXEkLCrB05
    asn1-types-0.3.2-Cp1wdTJG2wtISDf5jp8dcb
    asn1-encoding-0.9.5-3Bn1hocdFrVJ4IbVdDcoyr
    x509-1.7.2-FjM2bTRO7uwAW5ouaoXSGI
    x509-store-1.6.5-11LtgGa0CKeHhJysULg5yB
    x509-validation-1.6.9-EGeoxWVnTVOzvHz13QhV5
    async-2.1.1.1-2NW8RVpRWiC9M88FM7mCHc
    network-2.6.3.2-8o5F7G3DMrLGgmHkPzZYJx
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             mtl-2.2.1-19EL8AGBsN3DnnOhrC9xY3=5531911f09693672654e6de645ce55e7
             transformers-0.5.2.0=9705988bf0172d3bbbcdcaf65e1d842a
             cereal-0.5.4.0-AV9aAoAC3OtC6kJvAolohE=7bc02437e77f59917ed10938dea3d025
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             data-default-class-0.1.2.0-K0O6u0ifzTuLE4f7kBhgzp=cbc023a13af0b49e672a5936ee9b18d1
             memory-0.14.8-KR3LQmPtL0V2hu8SCUEPxQ=043e6b9ae4cdf12a535e82e4b354e645
             cryptonite-0.24-BP2rZy1LSzS3gXEkLCrB05=e50fee5376f84eba6e3440d0d6cc6f31
             asn1-types-0.3.2-Cp1wdTJG2wtISDf5jp8dcb=258a3fd5c56efea77c4f3a1d0a0d1045
             asn1-encoding-0.9.5-3Bn1hocdFrVJ4IbVdDcoyr=8af4fc27d65764603534b50ed2e1f4d8
             x509-1.7.2-FjM2bTRO7uwAW5ouaoXSGI=a11790c529c12c0f31fab3b1dc38e938
             x509-store-1.6.5-11LtgGa0CKeHhJysULg5yB=39bc1fabde1afd5a87c3a8ca9da9339e
             x509-validation-1.6.9-EGeoxWVnTVOzvHz13QhV5=78b206bd58dfd880058e673751a700fe
             async-2.1.1.1-2NW8RVpRWiC9M88FM7mCHc=4ad1a36fd79247fdbaa53c120c46b6d7
             network-2.6.3.2-8o5F7G3DMrLGgmHkPzZYJx=ef2cd2ee3956583f4f4dc001b18e6763
haddock-interfaces: /usr/share/doc/haskell-tls/html/tls.haddock
haddock-html: /usr/share/doc/haskell-tls/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

