/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.PageManager;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jnr.ffi.Runtime;
import jnr.ffi.provider.jffi.AllocatedDirectMemoryIO;
import jnr.ffi.provider.jffi.DirectMemoryIO;
import jnr.ffi.provider.jffi.NativeFinalizer;
import jnr.ffi.util.ref.FinalizablePhantomReference;
import jnr.ffi.util.ref.FinalizableReferenceQueue;

public class TransientNativeMemory
extends DirectMemoryIO {
    private static final Map<Magazine, Boolean> referenceSet = new ConcurrentHashMap<Magazine, Boolean>();
    private static final ThreadLocal<Magazine> currentMagazine = new ThreadLocal();
    private static final int PAGES_PER_MAGAZINE = 2;
    private final Sentinel sentinel;
    private final int size;

    public static DirectMemoryIO allocate(Runtime runtime, int size2, int align, boolean clear2) {
        long address2;
        Sentinel sentinel;
        if (size2 < 0) {
            throw new IllegalArgumentException("negative size: " + size2);
        }
        if (size2 > 256) {
            return new AllocatedDirectMemoryIO(runtime, size2, clear2);
        }
        Magazine magazine = currentMagazine.get();
        Sentinel sentinel2 = sentinel = magazine != null ? magazine.sentinel() : null;
        if (sentinel == null || (address2 = magazine.allocate(size2, align)) == 0L) {
            long memory;
            PageManager pm = PageManager.getInstance();
            while ((memory = pm.allocatePages(2, 3)) == 0L || memory == -1L) {
                System.gc();
                FinalizableReferenceQueue.cleanUpAll();
            }
            sentinel = new Sentinel();
            magazine = new Magazine(sentinel, pm, memory, 2);
            referenceSet.put(magazine, Boolean.TRUE);
            currentMagazine.set(magazine);
            address2 = magazine.allocate(size2, align);
        }
        return new TransientNativeMemory(runtime, sentinel, address2, size2);
    }

    TransientNativeMemory(Runtime runtime, Sentinel sentinel, long address2, int size2) {
        super(runtime, address2);
        this.sentinel = sentinel;
        this.size = size2;
    }

    private static long align(long offset2, long align) {
        return offset2 + align - 1L & (align - 1L ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof TransientNativeMemory) {
            TransientNativeMemory mem = (TransientNativeMemory)obj;
            return mem.size == this.size && mem.address() == this.address();
        }
        return super.equals(obj);
    }

    public final void dispose() {
    }

    private static final class Magazine
    extends FinalizablePhantomReference<Sentinel> {
        private final Reference<Sentinel> sentinelReference;
        private final PageManager pm;
        private final long page;
        private final long end;
        private final int pageCount;
        private long memory;

        Magazine(Sentinel sentinel, PageManager pm, long page, int pageCount) {
            super(sentinel, NativeFinalizer.getInstance().getFinalizerQueue());
            this.sentinelReference = new WeakReference<Sentinel>(sentinel);
            this.pm = pm;
            this.memory = this.page = page;
            this.pageCount = pageCount;
            this.end = this.memory + (long)pageCount * pm.pageSize();
        }

        Sentinel sentinel() {
            return this.sentinelReference.get();
        }

        long allocate(int size2, int align) {
            long address2 = TransientNativeMemory.align(this.memory, align);
            if (address2 + (long)size2 <= this.end) {
                this.memory = address2 + (long)size2;
                return address2;
            }
            return 0L;
        }

        @Override
        public final void finalizeReferent() {
            this.pm.freePages(this.page, this.pageCount);
            referenceSet.remove(this);
        }
    }

    private static final class Sentinel {
        private Sentinel() {
        }
    }
}

