/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.event.EventListenerList;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.TransferEvent;
import org.apache.ivy.plugins.repository.TransferListener;

public abstract class AbstractRepository
implements Repository {
    private EventListenerList listeners = new EventListenerList();
    private String name;
    private TransferEvent evt;

    @Override
    public void addTransferListener(TransferListener transferListener) {
        this.listeners.add(TransferListener.class, transferListener);
    }

    @Override
    public void removeTransferListener(TransferListener transferListener) {
        this.listeners.remove(TransferListener.class, transferListener);
    }

    @Override
    public boolean hasTransferListener(TransferListener transferListener) {
        return Arrays.asList(this.listeners.getListeners(TransferListener.class)).contains(transferListener);
    }

    protected void fireTransferInitiated(Resource resource, int n) {
        this.evt = new TransferEvent((Repository)this, resource, 0, n);
        this.fireTransferEvent(this.evt);
    }

    protected void fireTransferStarted() {
        this.evt.setEventType(1);
        this.fireTransferEvent(this.evt);
    }

    protected void fireTransferStarted(long l) {
        this.evt.setEventType(1);
        this.evt.setTotalLength(l);
        this.evt.setTotalLengthSet(true);
        this.fireTransferEvent(this.evt);
    }

    protected void fireTransferProgress(long l) {
        this.evt.setEventType(3);
        this.evt.setLength(l);
        if (!this.evt.isTotalLengthSet()) {
            this.evt.setTotalLength(this.evt.getTotalLength() + l);
        }
        this.fireTransferEvent(this.evt);
    }

    protected void fireTransferCompleted() {
        this.evt.setEventType(2);
        if (this.evt.getTotalLength() > 0L && !this.evt.isTotalLengthSet()) {
            this.evt.setTotalLengthSet(true);
        }
        this.fireTransferEvent(this.evt);
    }

    protected void fireTransferCompleted(long l) {
        this.evt.setEventType(2);
        this.evt.setTotalLength(l);
        this.evt.setTotalLengthSet(true);
        this.fireTransferEvent(this.evt);
    }

    protected void fireTransferError() {
        this.evt.setEventType(4);
        this.fireTransferEvent(this.evt);
    }

    protected void fireTransferError(Exception exception) {
        this.evt.setEventType(4);
        this.evt.setException(exception);
        this.fireTransferEvent(this.evt);
    }

    protected void fireTransferEvent(TransferEvent transferEvent) {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TransferListener.class) continue;
            ((TransferListener)objectArray[i + 1]).transferProgress(transferEvent);
        }
    }

    @Override
    public String getFileSeparator() {
        return "/";
    }

    @Override
    public String standardize(String string) {
        return string.replace('\\', '/');
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void put(Artifact artifact, File file, String string, boolean bl) throws IOException {
        this.put(file, string, bl);
    }

    protected void put(File file, String string, boolean bl) throws IOException {
        throw new UnsupportedOperationException("put in not supported by " + this.getName());
    }
}

