/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.tagging.ac;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionItem;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionPriority;

public class AutoCompletionSet
extends TreeSet<AutoCompletionItem> {
    @Override
    public boolean add(AutoCompletionItem e) {
        Optional<AutoCompletionItem> result = this.stream().filter(i -> i.getValue().equals(e.getValue())).findFirst();
        if (result.isPresent()) {
            AutoCompletionItem item = result.get();
            AutoCompletionPriority newPriority = item.getPriority().mergeWith(e.getPriority());
            if (!item.getPriority().equals(newPriority)) {
                this.remove(item);
                item.setPriority(newPriority);
                return this.add(item);
            }
            return false;
        }
        return super.add(e);
    }

    public boolean addAll(Collection<String> values, AutoCompletionPriority priority) {
        return this.addAll(values.stream().filter(Objects::nonNull).map(v -> new AutoCompletionItem((String)v, priority)).collect(Collectors.toList()));
    }

    public boolean addUserInput(Collection<String> values) {
        int i = 0;
        boolean modified = false;
        for (String value : values) {
            if (value == null || !this.add(new AutoCompletionItem(value, new AutoCompletionPriority(false, false, false, i++)))) continue;
            modified = true;
        }
        return modified;
    }

    public boolean contains(String value) {
        return this.stream().anyMatch(i -> i.getValue().equals(value));
    }

    public boolean remove(String key) {
        return this.removeIf(i -> i.getValue().equals(key));
    }
}

