/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AbstractRelationEditorAction;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class EditAction
extends AbstractRelationEditorAction {
    public EditAction(MemberTable memberTable, MemberTableModel memberTableModel, OsmDataLayer layer) {
        super(memberTable, memberTableModel, null, layer, null);
        this.putValue("ShortDescription", I18n.tr("Edit the relation the currently selected relation member refers to", new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
        this.updateEnabledState();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.memberTable.getSelectedRowCount() == 1 && this.memberTableModel.isEditableRelation(this.memberTable.getSelectedRow()));
    }

    protected Collection<RelationMember> getMembersForCurrentSelection(Relation r) {
        HashSet<RelationMember> members = new HashSet<RelationMember>();
        Collection<OsmPrimitive> selection = this.layer.data.getSelected();
        for (RelationMember member : r.getMembers()) {
            if (!selection.contains(member.getMember())) continue;
            members.add(member);
        }
        return members;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        int idx = this.memberTable.getSelectedRow();
        if (idx < 0) {
            return;
        }
        OsmPrimitive primitive = this.memberTableModel.getReferredPrimitive(idx);
        if (!(primitive instanceof Relation)) {
            return;
        }
        Relation r = (Relation)primitive;
        if (r.isIncomplete()) {
            return;
        }
        RelationEditor.getEditor(this.layer, r, this.getMembersForCurrentSelection(r)).setVisible(true);
    }
}

