/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Enumeration;
import java.util.regex.Pattern;
import jnr.constants.platform.AddressFamily;
import jnr.constants.platform.INAddr;
import jnr.constants.platform.IPProto;
import jnr.constants.platform.NameInfo;
import jnr.constants.platform.ProtocolFamily;
import jnr.constants.platform.Shutdown;
import jnr.constants.platform.Sock;
import jnr.constants.platform.SocketLevel;
import jnr.constants.platform.SocketOption;
import jnr.constants.platform.TCP;
import jnr.netdb.Protocol;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.socket.Addrinfo;
import org.jruby.ext.socket.Ifaddr;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.ext.socket.RubyUDPSocket;
import org.jruby.ext.socket.SocketType;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ChannelFD;
import org.jruby.util.io.Sockaddr;

@JRubyClass(name={"Socket"}, parent="BasicSocket", include={"Socket::Constants"})
public class RubySocket
extends RubyBasicSocket {
    private static ObjectAllocator SOCKET_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubySocket(runtime, klass);
        }
    };
    private static final Pattern ALREADY_BOUND_PATTERN = Pattern.compile("[Aa]lready.*bound");
    private static final Pattern ADDR_NOT_AVAIL_PATTERN = Pattern.compile("assign.*address");
    public static final int MSG_OOB = 1;
    public static final int MSG_PEEK = 2;
    public static final int MSG_DONTROUTE = 4;
    public static final int MSG_WAITALL = 256;
    protected AddressFamily soDomain;
    protected ProtocolFamily soProtocolFamily;
    protected Sock soType;
    protected Protocol soProtocol = Protocol.getProtocolByNumber(0);
    private static final String JRUBY_SERVER_SOCKET_ERROR = "use ServerSocket for servers (http://wiki.jruby.org/ServerSocket)";

    static void createSocket(Ruby runtime) {
        RubyClass rb_cSocket = runtime.defineClass("Socket", runtime.getClass("BasicSocket"), SOCKET_ALLOCATOR);
        RubyModule rb_mConstants = rb_cSocket.defineModuleUnder("Constants");
        runtime.loadConstantSet(rb_mConstants, Sock.class);
        runtime.loadConstantSet(rb_mConstants, SocketOption.class);
        runtime.loadConstantSet(rb_mConstants, SocketLevel.class);
        runtime.loadConstantSet(rb_mConstants, ProtocolFamily.class);
        runtime.loadConstantSet(rb_mConstants, AddressFamily.class);
        runtime.loadConstantSet(rb_mConstants, INAddr.class);
        runtime.loadConstantSet(rb_mConstants, IPProto.class);
        runtime.loadConstantSet(rb_mConstants, Shutdown.class);
        runtime.loadConstantSet(rb_mConstants, TCP.class);
        runtime.loadConstantSet(rb_mConstants, NameInfo.class);
        rb_mConstants.setConstant("SOMAXCONN", RubyFixnum.newFixnum(runtime, 128L));
        rb_mConstants.setConstant("MSG_OOB", runtime.newFixnum(1));
        rb_mConstants.setConstant("MSG_PEEK", runtime.newFixnum(2));
        rb_mConstants.setConstant("MSG_DONTROUTE", runtime.newFixnum(4));
        rb_mConstants.setConstant("MSG_WAITALL", runtime.newFixnum(256));
        rb_mConstants.setConstant("AI_PASSIVE", runtime.newFixnum(1));
        rb_mConstants.setConstant("AI_CANONNAME", runtime.newFixnum(2));
        rb_mConstants.setConstant("AI_NUMERICHOST", runtime.newFixnum(4));
        rb_mConstants.setConstant("AI_ALL", runtime.newFixnum(256));
        rb_mConstants.setConstant("AI_V4MAPPED_CFG", runtime.newFixnum(512));
        rb_mConstants.setConstant("AI_ADDRCONFIG", runtime.newFixnum(1024));
        rb_mConstants.setConstant("AI_V4MAPPED", runtime.newFixnum(2048));
        rb_mConstants.setConstant("AI_NUMERICSERV", runtime.newFixnum(4096));
        rb_mConstants.setConstant("AI_DEFAULT", runtime.newFixnum(1536));
        rb_mConstants.setConstant("AI_MASK", runtime.newFixnum(5127));
        rb_mConstants.setConstant("IP_MULTICAST_TTL", runtime.newFixnum(10));
        rb_mConstants.setConstant("IP_MULTICAST_LOOP", runtime.newFixnum(11));
        rb_mConstants.setConstant("IP_ADD_MEMBERSHIP", runtime.newFixnum(12));
        rb_mConstants.setConstant("IP_MAX_MEMBERSHIPS", runtime.newFixnum(20));
        rb_mConstants.setConstant("IP_DEFAULT_MULTICAST_LOOP", runtime.newFixnum(1));
        rb_mConstants.setConstant("IP_DEFAULT_MULTICAST_TTL", runtime.newFixnum(1));
        rb_cSocket.includeModule(rb_mConstants);
        rb_cSocket.defineAnnotatedMethods(RubySocket.class);
    }

    public RubySocket(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject for_fd(ThreadContext context, IRubyObject socketClass, IRubyObject _fd) {
        Ruby runtime = context.runtime;
        if (_fd instanceof RubyFixnum) {
            int intFD = (int)((RubyFixnum)_fd).getLongValue();
            ChannelFD fd = runtime.getFilenoUtil().getWrapperFromFileno(intFD);
            if (fd == null) {
                throw runtime.newErrnoEBADFError();
            }
            RubySocket socket2 = (RubySocket)((RubyClass)socketClass).allocate();
            socket2.initFieldsFromDescriptor(runtime, fd);
            socket2.initSocket(fd);
            return socket2;
        }
        throw runtime.newTypeError(_fd, context.runtime.getFixnum());
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject domain, IRubyObject type2) {
        Ruby runtime = context.runtime;
        this.initFromArgs(runtime, domain, type2);
        return this;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject domain, IRubyObject type2, IRubyObject protocol2) {
        Ruby runtime = context.runtime;
        this.initFromArgs(runtime, domain, type2, protocol2);
        return this;
    }

    @JRubyMethod
    public IRubyObject connect_nonblock(ThreadContext context, IRubyObject arg2) {
        return this.connect_nonblock(context, arg2, context.nil);
    }

    @JRubyMethod
    public IRubyObject connect_nonblock(ThreadContext context, IRubyObject arg2, IRubyObject opts) {
        Ruby runtime = context.runtime;
        SocketAddress addr2 = this.addressForChannel(context, arg2);
        boolean exception2 = ArgsUtil.extractKeywordArg(context, "exception", opts) != runtime.getFalse();
        return this.doConnectNonblock(context, addr2, exception2);
    }

    @JRubyMethod
    public IRubyObject connect(ThreadContext context, IRubyObject arg2) {
        SocketAddress addr2 = this.addressForChannel(context, arg2);
        return this.doConnect(context, addr2, true);
    }

    @JRubyMethod
    public IRubyObject bind(ThreadContext context, IRubyObject arg2) {
        SocketAddress sockaddr;
        if (arg2 instanceof Addrinfo) {
            Addrinfo addr2 = (Addrinfo)arg2;
            sockaddr = addr2.getSocketAddress();
        } else {
            sockaddr = Sockaddr.addressFromSockaddr(context, arg2);
        }
        this.doBind(context, sockaddr);
        return RubyFixnum.zero(context.runtime);
    }

    @JRubyMethod
    public IRubyObject recvfrom(ThreadContext context, IRubyObject _length) {
        return RubyUDPSocket.recvfrom(this, context, _length);
    }

    @JRubyMethod
    public IRubyObject recvfrom(ThreadContext context, IRubyObject _length, IRubyObject _flags) {
        return this.recvfrom(context, _length);
    }

    @JRubyMethod(required=1, optional=3)
    public IRubyObject recvfrom_nonblock(ThreadContext context, IRubyObject[] args2) {
        if (this.getOpenFile() == null) {
            throw context.runtime.newErrnoENOTCONNError("socket is not connected");
        }
        return RubyUDPSocket.recvfrom_nonblock(this, context, args2);
    }

    @JRubyMethod(notImplemented=true)
    public IRubyObject listen(ThreadContext context, IRubyObject backlog) {
        throw SocketUtils.sockerr(context.runtime, JRUBY_SERVER_SOCKET_ERROR);
    }

    @JRubyMethod(notImplemented=true)
    public IRubyObject accept(ThreadContext context) {
        throw SocketUtils.sockerr(context.runtime, JRUBY_SERVER_SOCKET_ERROR);
    }

    @JRubyMethod(notImplemented=true, optional=1)
    public IRubyObject accept_nonblock(ThreadContext context, IRubyObject[] args2) {
        throw SocketUtils.sockerr(context.runtime, JRUBY_SERVER_SOCKET_ERROR);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject gethostname(ThreadContext context, IRubyObject recv2) {
        return SocketUtils.gethostname(context);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject getifaddrs(ThreadContext context, IRubyObject recv2) {
        RubyArray list2 = RubyArray.newArray(context.runtime);
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            RubyClass Ifaddr2 = (RubyClass)context.runtime.getClassFromPath("Socket::Ifaddr");
            while (en.hasMoreElements()) {
                NetworkInterface ni = en.nextElement();
                list2.append(new Ifaddr(context.runtime, Ifaddr2, ni));
                for (InterfaceAddress ia : ni.getInterfaceAddresses()) {
                    list2.append(new Ifaddr(context.runtime, Ifaddr2, ni, ia));
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof RaiseException) {
                throw (RaiseException)ex;
            }
            throw SocketUtils.sockerr_with_trace(context.runtime, "getifaddrs: " + ex.toString(), ex.getStackTrace());
        }
        return list2;
    }

    @JRubyMethod(required=1, rest=true, meta=true)
    public static IRubyObject gethostbyaddr(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return SocketUtils.gethostbyaddr(context, args2);
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject getservbyname(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return SocketUtils.getservbyname(context, args2);
    }

    @JRubyMethod(name={"pack_sockaddr_in", "sockaddr_in"}, meta=true)
    public static IRubyObject pack_sockaddr_in(ThreadContext context, IRubyObject recv2, IRubyObject port, IRubyObject host) {
        return Sockaddr.pack_sockaddr_in(context, port, host);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject unpack_sockaddr_in(ThreadContext context, IRubyObject recv2, IRubyObject addr2) {
        return Sockaddr.unpack_sockaddr_in(context, addr2);
    }

    @JRubyMethod(name={"pack_sockaddr_un", "sockaddr_un"}, meta=true)
    public static IRubyObject pack_sockaddr_un(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        String path2 = filename2.convertToString().asJavaString();
        return Sockaddr.pack_sockaddr_un(context, path2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject unpack_sockaddr_un(ThreadContext context, IRubyObject recv2, IRubyObject addr2) {
        return Sockaddr.unpack_sockaddr_un(context, addr2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject gethostbyname(ThreadContext context, IRubyObject recv2, IRubyObject hostname) {
        return SocketUtils.gethostbyname(context, hostname);
    }

    @JRubyMethod(required=2, optional=5, meta=true)
    public static IRubyObject getaddrinfo(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return SocketUtils.getaddrinfo(context, args2);
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject getnameinfo(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return SocketUtils.getnameinfo(context, args2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject ip_address_list(ThreadContext context, IRubyObject self2) {
        return SocketUtils.ip_address_list(context);
    }

    @JRubyMethod(name={"socketpair", "pair"}, meta=true)
    public static IRubyObject socketpair(ThreadContext context, IRubyObject recv2, IRubyObject domain, IRubyObject type2, IRubyObject protocol2) {
        ProtocolFamily pf = SocketUtils.protocolFamilyFromArg(protocol2);
        if (pf == null) {
            pf = ProtocolFamily.PF_UNIX;
        }
        if (pf != ProtocolFamily.PF_UNIX && pf.ordinal() != 0) {
            throw context.runtime.newErrnoEOPNOTSUPPError("Socket.socketpair only supports streaming UNIX sockets");
        }
        return RubySocket.socketpair(context, recv2, domain, type2);
    }

    @JRubyMethod(name={"socketpair", "pair"}, meta=true)
    public static IRubyObject socketpair(ThreadContext context, IRubyObject recv2, IRubyObject domain, IRubyObject type2) {
        Sock s2;
        AddressFamily af = SocketUtils.addressFamilyFromArg(domain);
        if (af == null) {
            af = AddressFamily.AF_UNIX;
        }
        if ((s2 = SocketUtils.sockFromArg(type2)) == null) {
            s2 = Sock.SOCK_STREAM;
        }
        if (af != AddressFamily.AF_UNIX || s2 != Sock.SOCK_STREAM) {
            throw context.runtime.newErrnoEOPNOTSUPPError("Socket.socketpair only supports streaming UNIX sockets");
        }
        Ruby runtime = context.runtime;
        try {
            UnixSocketChannel[] sp = UnixSocketChannel.pair();
            RubyClass socketClass = runtime.getClass("Socket");
            RubySocket sock0 = new RubySocket(runtime, socketClass);
            ChannelFD fd0 = RubySocket.newChannelFD(runtime, sp[0]);
            sock0.initFieldsFromDescriptor(runtime, fd0);
            sock0.initSocket(fd0);
            RubySocket sock1 = new RubySocket(runtime, socketClass);
            ChannelFD fd1 = RubySocket.newChannelFD(runtime, sp[1]);
            sock1.initFieldsFromDescriptor(runtime, fd1);
            sock1.initSocket(fd1);
            return runtime.newArray((IRubyObject)sock0, (IRubyObject)sock1);
        }
        catch (IOException ioe) {
            throw runtime.newIOErrorFromException(ioe);
        }
    }

    private void initFieldsFromDescriptor(Ruby runtime, ChannelFD fd) {
        Channel mainChannel = fd.ch;
        if (mainChannel instanceof SocketChannel) {
            this.soDomain = AddressFamily.AF_INET;
            this.soType = Sock.SOCK_STREAM;
            this.soProtocolFamily = ProtocolFamily.PF_INET;
            this.soProtocol = Protocol.getProtocolByName("tcp");
        } else if (mainChannel instanceof UnixSocketChannel) {
            this.soDomain = AddressFamily.AF_UNIX;
            this.soType = Sock.SOCK_STREAM;
            this.soProtocolFamily = ProtocolFamily.PF_UNIX;
        } else if (mainChannel instanceof DatagramChannel) {
            this.soDomain = AddressFamily.AF_INET;
            this.soType = Sock.SOCK_DGRAM;
            this.soProtocolFamily = ProtocolFamily.PF_INET;
        } else {
            throw runtime.newErrnoENOTSOCKError("can't Socket.new/for_fd against a non-socket");
        }
    }

    private void initFromArgs(Ruby runtime, IRubyObject domain, IRubyObject type2, IRubyObject protocol2) {
        this.setProtocol(protocol2);
        this.initFromArgs(runtime, domain, type2);
    }

    private void initFromArgs(Ruby runtime, IRubyObject domain, IRubyObject type2) {
        this.setDomain(runtime, domain);
        this.setType(runtime, type2);
        ChannelFD fd = this.initChannelFD(runtime);
        this.initSocket(fd);
    }

    protected void initFromServer(Ruby runtime, RubySocket serverSocket, SocketChannel socketChannel) {
        this.soDomain = serverSocket.soDomain;
        this.soType = serverSocket.soType;
        this.soProtocol = serverSocket.soProtocol;
        this.initSocket(RubySocket.newChannelFD(runtime, socketChannel));
    }

    protected ChannelFD initChannelFD(Ruby runtime) {
        try {
            AbstractSelectableChannel channel;
            switch (this.soType) {
                case SOCK_STREAM: {
                    if (this.soProtocolFamily == ProtocolFamily.PF_UNIX || this.soProtocolFamily == ProtocolFamily.PF_LOCAL) {
                        channel = UnixSocketChannel.open();
                        break;
                    }
                    if (this.soProtocolFamily == ProtocolFamily.PF_INET || this.soProtocolFamily == ProtocolFamily.PF_INET6 || this.soProtocolFamily == ProtocolFamily.PF_UNSPEC) {
                        channel = SocketChannel.open();
                        break;
                    }
                    throw runtime.newArgumentError("unsupported protocol family `" + this.soProtocolFamily + "'");
                }
                case SOCK_DGRAM: {
                    channel = DatagramChannel.open();
                    break;
                }
                default: {
                    throw runtime.newArgumentError("unsupported socket type `" + this.soType + "'");
                }
            }
            return RubySocket.newChannelFD(runtime, channel);
        }
        catch (IOException e) {
            throw RubySocket.sockerr(runtime, "initialize: " + e.toString(), e);
        }
    }

    private void setProtocol(IRubyObject protocol2) {
        this.soProtocol = SocketUtils.protocolFromArg(protocol2);
    }

    private void setType(Ruby runtime, IRubyObject type2) {
        Sock sockType = SocketUtils.sockFromArg(type2);
        if (sockType == null) {
            throw SocketUtils.sockerr(runtime, "unknown socket type " + type2);
        }
        this.soType = sockType;
    }

    private void setDomain(Ruby runtime, IRubyObject domain) {
        AddressFamily family2 = SocketUtils.addressFamilyFromArg(domain);
        if (family2 == null) {
            throw SocketUtils.sockerr(runtime, "unknown socket domain " + domain);
        }
        this.soDomain = family2;
        String name2 = this.soDomain.name();
        if (name2.startsWith("pseudo_")) {
            name2 = name2.substring(7);
        }
        this.soProtocolFamily = ProtocolFamily.valueOf("PF" + name2.substring(2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject doConnectNonblock(ThreadContext context, SocketAddress addr2, boolean ex) {
        Channel channel = this.getChannel();
        if (!(channel instanceof SelectableChannel)) {
            throw context.runtime.newErrnoENOPROTOOPTError();
        }
        SelectableChannel selectable = (SelectableChannel)channel;
        Object object = selectable.blockingLock();
        synchronized (object) {
            IRubyObject iRubyObject;
            boolean oldBlocking = selectable.isBlocking();
            selectable.configureBlocking(false);
            try {
                iRubyObject = this.doConnect(context, addr2, ex);
            }
            catch (Throwable throwable) {
                try {
                    selectable.configureBlocking(oldBlocking);
                    throw throwable;
                }
                catch (ClosedChannelException e) {
                    throw context.runtime.newErrnoECONNREFUSEDError();
                }
                catch (IOException e) {
                    throw RubySocket.sockerr(context.runtime, "connect(2): name or service not known", e);
                }
            }
            selectable.configureBlocking(oldBlocking);
            return iRubyObject;
        }
    }

    protected IRubyObject doConnect(ThreadContext context, SocketAddress addr2, boolean ex) {
        Ruby runtime = context.runtime;
        Channel channel = this.getChannel();
        try {
            boolean result2 = true;
            if (channel instanceof SocketChannel) {
                SocketChannel socket2 = (SocketChannel)channel;
                result2 = socket2.isConnectionPending() ? socket2.finishConnect() : socket2.connect(addr2);
            } else if (channel instanceof UnixSocketChannel) {
                result2 = ((UnixSocketChannel)channel).connect((UnixSocketAddress)addr2);
            } else if (channel instanceof DatagramChannel) {
                ((DatagramChannel)channel).connect(addr2);
            } else {
                throw runtime.newErrnoENOPROTOOPTError();
            }
            if (!result2) {
                if (!ex) {
                    return runtime.newSymbol("wait_writable");
                }
                throw runtime.newErrnoEINPROGRESSWritableError();
            }
        }
        catch (AlreadyConnectedException e) {
            if (!ex) {
                return runtime.newFixnum(0);
            }
            throw runtime.newErrnoEISCONNError();
        }
        catch (ConnectionPendingException e) {
            throw runtime.newErrnoEINPROGRESSWritableError();
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime, "connect(2): unknown host");
        }
        catch (SocketException e) {
            RubySocket.handleSocketException(runtime, e, "connect(2)", addr2);
        }
        catch (IOException e) {
            throw RubySocket.sockerr(runtime, "connect(2): name or service not known", e);
        }
        catch (IllegalArgumentException e) {
            throw RubySocket.sockerr(runtime, e.getMessage(), e);
        }
        return runtime.newFixnum(0);
    }

    protected void doBind(ThreadContext context, SocketAddress iaddr) {
        block7: {
            Ruby runtime = context.runtime;
            Channel channel = this.getChannel();
            try {
                if (channel instanceof SocketChannel) {
                    Socket socket2 = ((SocketChannel)channel).socket();
                    socket2.bind(iaddr);
                    break block7;
                }
                if (channel instanceof UnixSocketChannel) break block7;
                if (channel instanceof DatagramChannel) {
                    DatagramSocket socket3 = ((DatagramChannel)channel).socket();
                    socket3.bind(iaddr);
                    break block7;
                }
                throw runtime.newErrnoENOPROTOOPTError();
            }
            catch (UnknownHostException e) {
                throw SocketUtils.sockerr(runtime, "bind(2): unknown host");
            }
            catch (SocketException e) {
                RubySocket.handleSocketException(runtime, e, "bind(2)", iaddr);
            }
            catch (IOException e) {
                throw RubySocket.sockerr(runtime, "bind(2): name or service not known", e);
            }
            catch (IllegalArgumentException e) {
                throw RubySocket.sockerr(runtime, e.getMessage(), e);
            }
        }
    }

    static void handleSocketException(Ruby runtime, SocketException ex, String caller, SocketAddress addr2) {
        String message2 = ex.getMessage();
        if (message2 != null) {
            switch (message2) {
                case "permission denied": 
                case "Permission denied": {
                    if (addr2 == null) {
                        throw runtime.newErrnoEACCESError(caller + " - " + message2);
                    }
                    throw runtime.newErrnoEACCESError("Address already in use - " + caller + " for " + RubySocket.formatAddress(addr2));
                }
                case "Address already in use": {
                    throw runtime.newErrnoEADDRINUSEError(caller + " for " + RubySocket.formatAddress(addr2));
                }
            }
            if (ALREADY_BOUND_PATTERN.matcher(message2).find()) {
                throw runtime.newErrnoEINVALError(caller + " - " + message2);
            }
            if (ADDR_NOT_AVAIL_PATTERN.matcher(message2).find()) {
                throw runtime.newErrnoEADDRNOTAVAILError(caller + " - " + message2);
            }
        }
        throw runtime.newErrnoEADDRINUSEError(caller + " - " + message2);
    }

    private static CharSequence formatAddress(SocketAddress addr2) {
        if (addr2 == null) {
            return null;
        }
        String str = addr2.toString();
        if (str.length() > 0 && str.charAt(0) == '/') {
            return str.substring(1);
        }
        return str;
    }

    private SocketAddress addressForChannel(ThreadContext context, IRubyObject arg2) {
        if (arg2 instanceof Addrinfo) {
            return ((Addrinfo)arg2).getSocketAddress();
        }
        switch (this.soProtocolFamily) {
            case PF_UNIX: 
            case PF_LOCAL: {
                return Sockaddr.addressFromSockaddr_un(context, arg2);
            }
            case PF_INET: 
            case PF_INET6: 
            case PF_UNSPEC: {
                return Sockaddr.addressFromSockaddr_in(context, arg2);
            }
        }
        throw context.runtime.newArgumentError("unsupported protocol family `" + this.soProtocolFamily + "'");
    }

    @Override
    protected IRubyObject addrFor(ThreadContext context, InetSocketAddress addr2, boolean reverse2) {
        Ruby runtime = context.runtime;
        return new Addrinfo(runtime, runtime.getClass("Addrinfo"), addr2.getAddress(), addr2.getPort(), Sock.SOCK_DGRAM);
    }

    @Override
    @JRubyMethod
    public IRubyObject close() {
        if (this.getOpenFile() != null) {
            Ruby runtime = this.getRuntime();
            if (this.isClosed()) {
                return runtime.getNil();
            }
            this.openFile.checkClosed();
            return this.rbIoClose(runtime);
        }
        return this.getRuntime().getNil();
    }

    @Override
    public RubyBoolean closed_p(ThreadContext context) {
        if (this.getOpenFile() == null) {
            return context.runtime.getFalse();
        }
        return super.closed_p(context);
    }

    @Override
    protected SocketAddress getSocketAddress() {
        Channel channel = this.getChannel();
        return SocketType.forChannel(channel).getLocalSocketAddress(channel);
    }

    @Deprecated
    public static RuntimeException sockerr(Ruby runtime, String msg) {
        return SocketUtils.sockerr(runtime, msg);
    }
}

